/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ChunkStatusTasks {
    private static boolean isLighted(ChunkAccess p_330524_) {
        return p_330524_.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT) && p_330524_.isLightCorrect();
    }

    static CompletableFuture<ChunkAccess> passThrough(WorldGenContext p_347652_, ChunkStep p_347508_, StaticCache2D<GenerationChunkHolder> p_347686_, ChunkAccess p_347612_) {
        return CompletableFuture.completedFuture(p_347612_);
    }

    static CompletableFuture<ChunkAccess> generateStructureStarts(WorldGenContext p_331607_, ChunkStep p_347505_, StaticCache2D<GenerationChunkHolder> p_347639_, ChunkAccess p_330224_) {
        ServerLevel $$4 = p_331607_.level();
        if ($$4.getServer().getWorldData().worldGenOptions().generateStructures()) {
            p_331607_.generator().createStructures($$4.registryAccess(), $$4.getChunkSource().getGeneratorState(), $$4.structureManager(), p_330224_, p_331607_.structureManager());
        }
        $$4.onStructureStartsAvailable(p_330224_);
        return CompletableFuture.completedFuture(p_330224_);
    }

    static CompletableFuture<ChunkAccess> loadStructureStarts(WorldGenContext p_331337_, ChunkStep p_347700_, StaticCache2D<GenerationChunkHolder> p_347697_, ChunkAccess p_331647_) {
        p_331337_.level().onStructureStartsAvailable(p_331647_);
        return CompletableFuture.completedFuture(p_331647_);
    }

    static CompletableFuture<ChunkAccess> generateStructureReferences(WorldGenContext p_331037_, ChunkStep p_347588_, StaticCache2D<GenerationChunkHolder> p_347555_, ChunkAccess p_331453_) {
        ServerLevel $$4 = p_331037_.level();
        WorldGenRegion $$5 = new WorldGenRegion($$4, p_347555_, p_347588_, p_331453_);
        p_331037_.generator().createReferences($$5, $$4.structureManager().forWorldGenRegion($$5), p_331453_);
        return CompletableFuture.completedFuture(p_331453_);
    }

    static CompletableFuture<ChunkAccess> generateBiomes(WorldGenContext p_331619_, ChunkStep p_347659_, StaticCache2D<GenerationChunkHolder> p_347729_, ChunkAccess p_332054_) {
        ServerLevel $$4 = p_331619_.level();
        WorldGenRegion $$5 = new WorldGenRegion($$4, p_347729_, p_347659_, p_332054_);
        return p_331619_.generator().createBiomes($$4.getChunkSource().randomState(), Blender.of($$5), $$4.structureManager().forWorldGenRegion($$5), p_332054_);
    }

    static CompletableFuture<ChunkAccess> generateNoise(WorldGenContext p_331452_, ChunkStep p_347576_, StaticCache2D<GenerationChunkHolder> p_347613_, ChunkAccess p_330927_) {
        ServerLevel $$4 = p_331452_.level();
        WorldGenRegion $$5 = new WorldGenRegion($$4, p_347613_, p_347576_, p_330927_);
        return p_331452_.generator().fillFromNoise(Blender.of($$5), $$4.getChunkSource().randomState(), $$4.structureManager().forWorldGenRegion($$5), p_330927_).thenApply(p_330442_ -> {
            ProtoChunk $$1;
            BelowZeroRetrogen $$2;
            if (p_330442_ instanceof ProtoChunk && ($$2 = ($$1 = (ProtoChunk)p_330442_).getBelowZeroRetrogen()) != null) {
                BelowZeroRetrogen.replaceOldBedrock($$1);
                if ($$2.hasBedrockHoles()) {
                    $$2.applyBedrockMask($$1);
                }
            }
            return p_330442_;
        });
    }

    static CompletableFuture<ChunkAccess> generateSurface(WorldGenContext p_331468_, ChunkStep p_347720_, StaticCache2D<GenerationChunkHolder> p_347636_, ChunkAccess p_331100_) {
        ServerLevel $$4 = p_331468_.level();
        WorldGenRegion $$5 = new WorldGenRegion($$4, p_347636_, p_347720_, p_331100_);
        p_331468_.generator().buildSurface($$5, $$4.structureManager().forWorldGenRegion($$5), $$4.getChunkSource().randomState(), p_331100_);
        return CompletableFuture.completedFuture(p_331100_);
    }

    static CompletableFuture<ChunkAccess> generateCarvers(WorldGenContext p_331858_, ChunkStep p_347728_, StaticCache2D<GenerationChunkHolder> p_347581_, ChunkAccess p_330818_) {
        ServerLevel $$4 = p_331858_.level();
        WorldGenRegion $$5 = new WorldGenRegion($$4, p_347581_, p_347728_, p_330818_);
        if (p_330818_ instanceof ProtoChunk) {
            ProtoChunk $$6 = (ProtoChunk)p_330818_;
            Blender.addAroundOldChunksCarvingMaskFilter($$5, $$6);
        }
        p_331858_.generator().applyCarvers($$5, $$4.getSeed(), $$4.getChunkSource().randomState(), $$4.getBiomeManager(), $$4.structureManager().forWorldGenRegion($$5), p_330818_);
        return CompletableFuture.completedFuture(p_330818_);
    }

    static CompletableFuture<ChunkAccess> generateFeatures(WorldGenContext p_330280_, ChunkStep p_347560_, StaticCache2D<GenerationChunkHolder> p_347674_, ChunkAccess p_332040_) {
        ServerLevel $$4 = p_330280_.level();
        Heightmap.primeHeightmaps(p_332040_, EnumSet.of(Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE));
        WorldGenRegion $$5 = new WorldGenRegion($$4, p_347674_, p_347560_, p_332040_);
        p_330280_.generator().applyBiomeDecoration($$5, p_332040_, $$4.structureManager().forWorldGenRegion($$5));
        Blender.generateBorderTicks($$5, p_332040_);
        return CompletableFuture.completedFuture(p_332040_);
    }

    static CompletableFuture<ChunkAccess> initializeLight(WorldGenContext p_347725_, ChunkStep p_347727_, StaticCache2D<GenerationChunkHolder> p_347486_, ChunkAccess p_331196_) {
        ThreadedLevelLightEngine $$4 = p_347725_.lightEngine();
        p_331196_.initializeLightSources();
        ((ProtoChunk)p_331196_).setLightEngine($$4);
        boolean $$5 = ChunkStatusTasks.isLighted(p_331196_);
        return $$4.initializeLight(p_331196_, $$5);
    }

    static CompletableFuture<ChunkAccess> light(WorldGenContext p_347668_, ChunkStep p_347535_, StaticCache2D<GenerationChunkHolder> p_347456_, ChunkAccess p_347599_) {
        boolean $$4 = ChunkStatusTasks.isLighted(p_347599_);
        return p_347668_.lightEngine().lightChunk(p_347599_, $$4);
    }

    static CompletableFuture<ChunkAccess> generateSpawn(WorldGenContext p_330441_, ChunkStep p_347702_, StaticCache2D<GenerationChunkHolder> p_347488_, ChunkAccess p_331907_) {
        if (!p_331907_.isUpgrading()) {
            p_330441_.generator().spawnOriginalMobs(new WorldGenRegion(p_330441_.level(), p_347488_, p_347702_, p_331907_));
        }
        return CompletableFuture.completedFuture(p_331907_);
    }

    static CompletableFuture<ChunkAccess> full(WorldGenContext p_347565_, ChunkStep p_347455_, StaticCache2D<GenerationChunkHolder> p_347586_, ChunkAccess p_347656_) {
        ChunkPos $$4 = p_347656_.getPos();
        GenerationChunkHolder $$5 = p_347586_.get($$4.x, $$4.z);
        return CompletableFuture.supplyAsync(() -> {
            LevelChunk $$7;
            ProtoChunk $$3 = (ProtoChunk)p_347656_;
            ServerLevel $$4 = p_347565_.level();
            if ($$3 instanceof ImposterProtoChunk) {
                ImposterProtoChunk $$5 = (ImposterProtoChunk)$$3;
                LevelChunk $$6 = $$5.getWrapped();
            } else {
                $$7 = new LevelChunk($$4, $$3, p_347400_ -> ChunkStatusTasks.postLoadProtoChunk($$4, $$3.getEntities()));
                $$5.replaceProtoChunk(new ImposterProtoChunk($$7, false));
            }
            $$7.setFullStatus($$5::getFullStatus);
            $$7.runPostLoad();
            $$7.setLoaded(true);
            $$7.registerAllBlockEntitiesAfterLevelLoad();
            $$7.registerTickContainerInLevel($$4);
            $$7.setUnsavedListener(p_347565_.unsavedListener());
            return $$7;
        }, p_347565_.mainThreadExecutor());
    }

    private static void postLoadProtoChunk(ServerLevel p_347492_, List<CompoundTag> p_347609_) {
        if (!p_347609_.isEmpty()) {
            p_347492_.addWorldGenChunkEntities(EntityType.loadEntitiesRecursive(p_347609_, p_347492_, EntitySpawnReason.LOAD));
        }
    }
}

