/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.util.Unit;
import net.minecraft.util.thread.PriorityConsecutiveExecutor;
import net.minecraft.util.thread.StrictQueue;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.slf4j.Logger;

public class IOWorker
implements ChunkScanAccess,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final PriorityConsecutiveExecutor consecutiveExecutor;
    private final RegionFileStorage storage;
    private final SequencedMap<ChunkPos, PendingStore> pendingWrites = new LinkedHashMap<ChunkPos, PendingStore>();
    private final Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> regionCacheForBlender = new Long2ObjectLinkedOpenHashMap();
    private static final int REGION_CACHE_SIZE = 1024;

    protected IOWorker(RegionStorageInfo p_325953_, Path p_196930_, boolean p_196931_) {
        this.storage = new RegionFileStorage(p_325953_, p_196930_, p_196931_);
        this.consecutiveExecutor = new PriorityConsecutiveExecutor(Priority.values().length, (Executor)Util.ioPool(), "IOWorker-" + p_325953_.type());
    }

    public boolean isOldChunkAround(ChunkPos p_223472_, int p_223473_) {
        ChunkPos $$2 = new ChunkPos(p_223472_.x - p_223473_, p_223472_.z - p_223473_);
        ChunkPos $$3 = new ChunkPos(p_223472_.x + p_223473_, p_223472_.z + p_223473_);
        for (int $$4 = $$2.getRegionX(); $$4 <= $$3.getRegionX(); ++$$4) {
            for (int $$5 = $$2.getRegionZ(); $$5 <= $$3.getRegionZ(); ++$$5) {
                BitSet $$6 = this.getOrCreateOldDataForRegion($$4, $$5).join();
                if ($$6.isEmpty()) continue;
                ChunkPos $$7 = ChunkPos.minFromRegion($$4, $$5);
                int $$8 = Math.max($$2.x - $$7.x, 0);
                int $$9 = Math.max($$2.z - $$7.z, 0);
                int $$10 = Math.min($$3.x - $$7.x, 31);
                int $$11 = Math.min($$3.z - $$7.z, 31);
                for (int $$12 = $$8; $$12 <= $$10; ++$$12) {
                    for (int $$13 = $$9; $$13 <= $$11; ++$$13) {
                        int $$14 = $$13 * 32 + $$12;
                        if (!$$6.get($$14)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<BitSet> getOrCreateOldDataForRegion(int p_223464_, int p_223465_) {
        long $$2 = ChunkPos.asLong(p_223464_, p_223465_);
        Long2ObjectLinkedOpenHashMap<CompletableFuture<BitSet>> long2ObjectLinkedOpenHashMap = this.regionCacheForBlender;
        synchronized (long2ObjectLinkedOpenHashMap) {
            CompletableFuture<BitSet> $$3 = (CompletableFuture<BitSet>)this.regionCacheForBlender.getAndMoveToFirst($$2);
            if ($$3 == null) {
                $$3 = this.createOldDataForRegion(p_223464_, p_223465_);
                this.regionCacheForBlender.putAndMoveToFirst($$2, $$3);
                if (this.regionCacheForBlender.size() > 1024) {
                    this.regionCacheForBlender.removeLast();
                }
            }
            return $$3;
        }
    }

    private CompletableFuture<BitSet> createOldDataForRegion(int p_223490_, int p_223491_) {
        return CompletableFuture.supplyAsync(() -> {
            ChunkPos $$2 = ChunkPos.minFromRegion(p_223490_, p_223491_);
            ChunkPos $$3 = ChunkPos.maxFromRegion(p_223490_, p_223491_);
            BitSet $$4 = new BitSet();
            ChunkPos.rangeClosed($$2, $$3).forEach(p_223480_ -> {
                CompoundTag $$5;
                CollectFields $$2 = new CollectFields(new FieldSelector(IntTag.TYPE, "DataVersion"), new FieldSelector(CompoundTag.TYPE, "blending_data"));
                try {
                    this.scanChunk((ChunkPos)p_223480_, $$2).join();
                }
                catch (Exception $$3) {
                    LOGGER.warn("Failed to scan chunk {}", p_223480_, (Object)$$3);
                    return;
                }
                Tag $$4 = $$2.getResult();
                if ($$4 instanceof CompoundTag && this.isOldChunk($$5 = (CompoundTag)$$4)) {
                    int $$6 = p_223480_.getRegionLocalZ() * 32 + p_223480_.getRegionLocalX();
                    $$4.set($$6);
                }
            });
            return $$4;
        }, Util.backgroundExecutor());
    }

    private boolean isOldChunk(CompoundTag p_223485_) {
        if (!p_223485_.contains("DataVersion", 99) || p_223485_.getInt("DataVersion") < 3441) {
            return true;
        }
        return p_223485_.contains("blending_data", 10);
    }

    public CompletableFuture<Void> store(ChunkPos p_63539_, @Nullable CompoundTag p_63540_) {
        return this.store(p_63539_, () -> p_63540_);
    }

    public CompletableFuture<Void> store(ChunkPos p_360728_, Supplier<CompoundTag> p_361805_) {
        return this.submitTask(() -> {
            CompoundTag $$2 = (CompoundTag)p_361805_.get();
            PendingStore $$3 = this.pendingWrites.computeIfAbsent(p_360728_, p_223488_ -> new PendingStore($$2));
            $$3.data = $$2;
            return $$3.result;
        }).thenCompose(Function.identity());
    }

    public CompletableFuture<Optional<CompoundTag>> loadAsync(ChunkPos p_156588_) {
        return this.submitThrowingTask(() -> {
            PendingStore $$1 = (PendingStore)this.pendingWrites.get(p_156588_);
            if ($$1 != null) {
                return Optional.ofNullable($$1.copyData());
            }
            try {
                CompoundTag $$2 = this.storage.read(p_156588_);
                return Optional.ofNullable($$2);
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to read chunk {}", (Object)p_156588_, (Object)$$3);
                throw $$3;
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean p_182499_) {
        CompletionStage $$1 = this.submitTask(() -> CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(p_223475_ -> p_223475_.result).toArray(CompletableFuture[]::new))).thenCompose(Function.identity());
        if (p_182499_) {
            return ((CompletableFuture)$$1).thenCompose(p_371174_ -> this.submitThrowingTask(() -> {
                try {
                    this.storage.flush();
                    return null;
                }
                catch (Exception $$0) {
                    LOGGER.warn("Failed to synchronize chunks", (Throwable)$$0);
                    throw $$0;
                }
            }));
        }
        return ((CompletableFuture)$$1).thenCompose(p_223477_ -> this.submitTask(() -> null));
    }

    @Override
    public CompletableFuture<Void> scanChunk(ChunkPos p_196939_, StreamTagVisitor p_196940_) {
        return this.submitThrowingTask(() -> {
            try {
                PendingStore $$2 = (PendingStore)this.pendingWrites.get(p_196939_);
                if ($$2 != null) {
                    if ($$2.data != null) {
                        $$2.data.acceptAsRoot(p_196940_);
                    }
                } else {
                    this.storage.scanChunk(p_196939_, p_196940_);
                }
                return null;
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to bulk scan chunk {}", (Object)p_196939_, (Object)$$3);
                throw $$3;
            }
        });
    }

    private <T> CompletableFuture<T> submitThrowingTask(ThrowingSupplier<T> p_371938_) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), p_371168_ -> {
            if (!this.shutdownRequested.get()) {
                try {
                    p_371168_.complete(p_371938_.get());
                }
                catch (Exception $$2) {
                    p_371168_.completeExceptionally($$2);
                }
            }
            this.tellStorePending();
        });
    }

    private <T> CompletableFuture<T> submitTask(Supplier<T> p_63546_) {
        return this.consecutiveExecutor.scheduleWithResult(Priority.FOREGROUND.ordinal(), p_371173_ -> {
            if (!this.shutdownRequested.get()) {
                p_371173_.complete(p_63546_.get());
            }
            this.tellStorePending();
        });
    }

    private void storePendingChunk() {
        Map.Entry<ChunkPos, PendingStore> $$0 = this.pendingWrites.pollFirstEntry();
        if ($$0 == null) {
            return;
        }
        this.runStore($$0.getKey(), $$0.getValue());
        this.tellStorePending();
    }

    private void tellStorePending() {
        this.consecutiveExecutor.schedule(new StrictQueue.RunnableWithPriority(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(ChunkPos p_63536_, PendingStore p_63537_) {
        try {
            this.storage.write(p_63536_, p_63537_.data);
            p_63537_.result.complete(null);
        }
        catch (Exception $$2) {
            LOGGER.error("Failed to store chunk {}", (Object)p_63536_, (Object)$$2);
            p_63537_.result.completeExceptionally($$2);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.shutdownRequested.compareAndSet(false, true)) {
            return;
        }
        this.waitForShutdown();
        this.consecutiveExecutor.close();
        try {
            this.storage.close();
        }
        catch (Exception $$0) {
            LOGGER.error("Failed to close storage", (Throwable)$$0);
        }
    }

    private void waitForShutdown() {
        this.consecutiveExecutor.scheduleWithResult(Priority.SHUTDOWN.ordinal(), p_371169_ -> p_371169_.complete(Unit.INSTANCE)).join();
    }

    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    @FunctionalInterface
    static interface ThrowingSupplier<T> {
        @Nullable
        public T get() throws Exception;
    }

    static class PendingStore {
        @Nullable
        CompoundTag data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable CompoundTag p_63568_) {
            this.data = p_63568_;
        }

        @Nullable
        CompoundTag copyData() {
            CompoundTag $$0 = this.data;
            return $$0 == null ? null : $$0.copy();
        }
    }
}

