/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class FeatureCountTracker {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LoadingCache<ServerLevel, LevelData> data = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ServerLevel, LevelData>(){

        public LevelData load(ServerLevel p_190902_) {
            return new LevelData((Object2IntMap<FeatureData>)Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap()), new MutableInt(0));
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((ServerLevel)object);
        }
    });

    public static void chunkDecorated(ServerLevel p_190882_) {
        try {
            ((LevelData)data.get((Object)p_190882_)).chunksWithFeatures().increment();
        }
        catch (Exception $$1) {
            LOGGER.error("Failed to increment chunk count", (Throwable)$$1);
        }
    }

    public static void featurePlaced(ServerLevel p_190884_, ConfiguredFeature<?, ?> p_190885_, Optional<PlacedFeature> p_190886_) {
        try {
            ((LevelData)data.get((Object)p_190884_)).featureData().computeInt((Object)new FeatureData(p_190885_, p_190886_), (p_190891_, p_190892_) -> p_190892_ == null ? 1 : p_190892_ + 1);
        }
        catch (Exception $$3) {
            LOGGER.error("Failed to increment feature count", (Throwable)$$3);
        }
    }

    public static void clearCounts() {
        data.invalidateAll();
        LOGGER.debug("Cleared feature counts");
    }

    public static void logCounts() {
        LOGGER.debug("Logging feature counts:");
        data.asMap().forEach((p_190888_, p_190889_) -> {
            String $$2 = p_190888_.dimension().location().toString();
            boolean $$3 = p_190888_.getServer().isRunning();
            HolderLookup.RegistryLookup $$4 = p_190888_.registryAccess().lookupOrThrow(Registries.PLACED_FEATURE);
            String $$5 = ($$3 ? "running" : "dead") + " " + $$2;
            Integer $$6 = p_190889_.chunksWithFeatures().getValue();
            LOGGER.debug($$5 + " total_chunks: " + $$6);
            p_190889_.featureData().forEach((arg_0, arg_1) -> FeatureCountTracker.lambda$logCounts$1($$5, $$6, (Registry)$$4, arg_0, arg_1));
        });
    }

    private static /* synthetic */ void lambda$logCounts$1(String p_339547_, Integer p_339548_, Registry p_339549_, FeatureData p_339550_, Integer p_339551_) {
        LOGGER.debug(p_339547_ + " " + String.format(Locale.ROOT, "%10d ", p_339551_) + String.format(Locale.ROOT, "%10f ", (double)p_339551_.intValue() / (double)p_339548_.intValue()) + String.valueOf(p_339550_.topFeature().flatMap(p_339549_::getResourceKey).map(ResourceKey::location)) + " " + String.valueOf(p_339550_.feature().feature()) + " " + String.valueOf(p_339550_.feature()));
    }

    record LevelData(Object2IntMap<FeatureData> featureData, MutableInt chunksWithFeatures) {
    }

    record FeatureData(ConfiguredFeature<?, ?> feature, Optional<PlacedFeature> topFeature) {
    }
}

