/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CreakingHeartDecorator
extends TreeDecorator {
    public static final MapCodec<CreakingHeartDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CreakingHeartDecorator::new, p_379513_ -> Float.valueOf(p_379513_.probability));
    private final float probability;

    public CreakingHeartDecorator(float p_379887_) {
        this.probability = p_379887_;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.CREAKING_HEART;
    }

    @Override
    public void place(TreeDecorator.Context p_379637_) {
        RandomSource $$1 = p_379637_.random();
        ObjectArrayList<BlockPos> $$2 = p_379637_.logs();
        if ($$2.isEmpty()) {
            return;
        }
        if ($$1.nextFloat() >= this.probability) {
            return;
        }
        ArrayList<BlockPos> $$3 = new ArrayList<BlockPos>((Collection<BlockPos>)$$2);
        Util.shuffle($$3, $$1);
        Optional<BlockPos> $$4 = $$3.stream().filter(p_380105_ -> {
            for (Direction $$2 : Direction.values()) {
                if (p_379637_.checkBlock(p_380105_.relative($$2), p_379435_ -> p_379435_.is(BlockTags.LOGS))) continue;
                return false;
            }
            return true;
        }).findFirst();
        if ($$4.isEmpty()) {
            return;
        }
        p_379637_.setBlock($$4.get(), (BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue(CreakingHeartBlock.CREAKING, CreakingHeartBlock.CreakingHeartState.DORMANT));
    }
}

