/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HangingMossBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends TreeDecorator {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec(p_379602_ -> p_379602_.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter(p_379568_ -> Float.valueOf(p_379568_.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter(p_379338_ -> Float.valueOf(p_379338_.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter(p_379346_ -> Float.valueOf(p_379346_.groundProbability))).apply((Applicative)p_379602_, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.PALE_MOSS;
    }

    public PaleMossDecorator(float p_379816_, float p_379583_, float p_380313_) {
        this.leavesProbability = p_379816_;
        this.trunkProbability = p_379583_;
        this.groundProbability = p_380313_;
    }

    @Override
    public void place(TreeDecorator.Context p_379317_) {
        RandomSource $$1 = p_379317_.random();
        WorldGenLevel $$2 = (WorldGenLevel)p_379317_.level();
        List<BlockPos> $$3 = Util.shuffledCopy(p_379317_.logs(), $$1);
        if ($$3.isEmpty()) {
            return;
        }
        MutableObject $$4 = new MutableObject((Object)$$3.getFirst());
        $$3.forEach(arg_0 -> PaleMossDecorator.lambda$place$4((Mutable)$$4, arg_0));
        BlockPos $$5 = (BlockPos)$$4.getValue();
        if ($$1.nextFloat() < this.groundProbability) {
            $$2.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(p_380195_ -> p_380195_.get(VegetationFeatures.PALE_MOSS_PATCH_BONEMEAL)).ifPresent(p_380064_ -> ((ConfiguredFeature)p_380064_.value()).place($$2, $$2.getLevel().getChunkSource().getGenerator(), $$1, $$5.above()));
        }
        p_379317_.logs().forEach(p_380391_ -> {
            BlockPos $$4;
            BlockPos $$3;
            if ($$1.nextFloat() < this.trunkProbability && p_379317_.isAir($$3 = p_380391_.below())) {
                PaleMossDecorator.addMossHanger($$3, p_379317_);
            }
            if ($$1.nextFloat() < this.trunkProbability && p_379317_.isAir($$4 = p_380391_.above())) {
                MossyCarpetBlock.placeAt((WorldGenLevel)p_379317_.level(), $$4, p_379317_.random(), 3);
            }
        });
        p_379317_.leaves().forEach(p_380012_ -> {
            BlockPos $$3;
            if ($$1.nextFloat() < this.leavesProbability && p_379317_.isAir($$3 = p_380012_.below())) {
                PaleMossDecorator.addMossHanger($$3, p_379317_);
            }
        });
    }

    private static void addMossHanger(BlockPos p_379694_, TreeDecorator.Context p_379973_) {
        while (p_379973_.isAir(p_379694_.below()) && !((double)p_379973_.random().nextFloat() < 0.5)) {
            p_379973_.setBlock(p_379694_, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, false));
            p_379694_ = p_379694_.below();
        }
        p_379973_.setBlock(p_379694_, (BlockState)Blocks.PALE_HANGING_MOSS.defaultBlockState().setValue(HangingMossBlock.TIP, true));
    }

    private static /* synthetic */ void lambda$place$4(Mutable p_379980_, BlockPos p_379657_) {
        if (p_379657_.getY() < ((BlockPos)p_379980_.getValue()).getY()) {
            p_379980_.setValue((Object)p_379657_);
        }
    }
}

