/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class NetherFortressPieces {
    private static final int MAX_DEPTH = 30;
    private static final int LOWEST_Y_POSITION = 10;
    public static final int MAGIC_START_Y = 64;
    static final PieceWeight[] BRIDGE_PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(BridgeStraight.class, 30, 0, true), new PieceWeight(BridgeCrossing.class, 10, 4), new PieceWeight(RoomCrossing.class, 10, 4), new PieceWeight(StairsRoom.class, 10, 3), new PieceWeight(MonsterThrone.class, 5, 2), new PieceWeight(CastleEntrance.class, 5, 1)};
    static final PieceWeight[] CASTLE_PIECE_WEIGHTS = new PieceWeight[]{new PieceWeight(CastleSmallCorridorPiece.class, 25, 0, true), new PieceWeight(CastleSmallCorridorCrossingPiece.class, 15, 5), new PieceWeight(CastleSmallCorridorRightTurnPiece.class, 5, 10), new PieceWeight(CastleSmallCorridorLeftTurnPiece.class, 5, 10), new PieceWeight(CastleCorridorStairsPiece.class, 10, 3, true), new PieceWeight(CastleCorridorTBalconyPiece.class, 7, 2), new PieceWeight(CastleStalkRoom.class, 5, 2)};

    static NetherBridgePiece findAndCreateBridgePieceFactory(PieceWeight p_228008_, StructurePieceAccessor p_228009_, RandomSource p_228010_, int p_228011_, int p_228012_, int p_228013_, Direction p_228014_, int p_228015_) {
        Class<? extends NetherBridgePiece> $$8 = p_228008_.pieceClass;
        NetherBridgePiece $$9 = null;
        if ($$8 == BridgeStraight.class) {
            $$9 = BridgeStraight.createPiece(p_228009_, p_228010_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == BridgeCrossing.class) {
            $$9 = BridgeCrossing.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == RoomCrossing.class) {
            $$9 = RoomCrossing.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == StairsRoom.class) {
            $$9 = StairsRoom.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228015_, p_228014_);
        } else if ($$8 == MonsterThrone.class) {
            $$9 = MonsterThrone.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228015_, p_228014_);
        } else if ($$8 == CastleEntrance.class) {
            $$9 = CastleEntrance.createPiece(p_228009_, p_228010_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == CastleSmallCorridorPiece.class) {
            $$9 = CastleSmallCorridorPiece.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == CastleSmallCorridorRightTurnPiece.class) {
            $$9 = CastleSmallCorridorRightTurnPiece.createPiece(p_228009_, p_228010_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == CastleSmallCorridorLeftTurnPiece.class) {
            $$9 = CastleSmallCorridorLeftTurnPiece.createPiece(p_228009_, p_228010_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == CastleCorridorStairsPiece.class) {
            $$9 = CastleCorridorStairsPiece.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == CastleCorridorTBalconyPiece.class) {
            $$9 = CastleCorridorTBalconyPiece.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == CastleSmallCorridorCrossingPiece.class) {
            $$9 = CastleSmallCorridorCrossingPiece.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        } else if ($$8 == CastleStalkRoom.class) {
            $$9 = CastleStalkRoom.createPiece(p_228009_, p_228011_, p_228012_, p_228013_, p_228014_, p_228015_);
        }
        return $$9;
    }

    static class PieceWeight {
        public final Class<? extends NetherBridgePiece> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;
        public final boolean allowInRow;

        public PieceWeight(Class<? extends NetherBridgePiece> p_228444_, int p_228445_, int p_228446_, boolean p_228447_) {
            this.pieceClass = p_228444_;
            this.weight = p_228445_;
            this.maxPlaceCount = p_228446_;
            this.allowInRow = p_228447_;
        }

        public PieceWeight(Class<? extends NetherBridgePiece> p_228440_, int p_228441_, int p_228442_) {
            this(p_228440_, p_228441_, p_228442_, false);
        }

        public boolean doPlace(int p_228450_) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class BridgeStraight
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public BridgeStraight(int p_228087_, RandomSource p_228088_, BoundingBox p_228089_, Direction p_228090_) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, p_228087_, p_228089_);
            this.setOrientation(p_228090_);
        }

        public BridgeStraight(CompoundTag p_228092_) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, p_228092_);
        }

        @Override
        public void addChildren(StructurePiece p_228102_, StructurePieceAccessor p_228103_, RandomSource p_228104_) {
            this.generateChildForward((StartPiece)p_228102_, p_228103_, p_228104_, 1, 3, false);
        }

        public static BridgeStraight createPiece(StructurePieceAccessor p_228106_, RandomSource p_228107_, int p_228108_, int p_228109_, int p_228110_, Direction p_228111_, int p_228112_) {
            BoundingBox $$7 = BoundingBox.orientBox(p_228108_, p_228109_, p_228110_, -1, -3, 0, 5, 10, 19, p_228111_);
            if (!BridgeStraight.isOkBox($$7) || p_228106_.findCollisionPiece($$7) != null) {
                return null;
            }
            return new BridgeStraight(p_228112_, p_228107_, $$7, p_228111_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228094_, StructureManager p_228095_, ChunkGenerator p_228096_, RandomSource p_228097_, BoundingBox p_228098_, ChunkPos p_228099_, BlockPos p_228100_) {
            this.generateBox(p_228094_, p_228098_, 0, 3, 0, 4, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228094_, p_228098_, 1, 5, 0, 3, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228094_, p_228098_, 0, 5, 0, 0, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228094_, p_228098_, 4, 5, 0, 4, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228094_, p_228098_, 0, 2, 0, 4, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228094_, p_228098_, 0, 2, 13, 4, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228094_, p_228098_, 0, 0, 0, 4, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228094_, p_228098_, 0, 0, 15, 4, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$7 = 0; $$7 <= 4; ++$$7) {
                for (int $$8 = 0; $$8 <= 2; ++$$8) {
                    this.fillColumnDown(p_228094_, Blocks.NETHER_BRICKS.defaultBlockState(), $$7, -1, $$8, p_228098_);
                    this.fillColumnDown(p_228094_, Blocks.NETHER_BRICKS.defaultBlockState(), $$7, -1, 18 - $$8, p_228098_);
                }
            }
            BlockState $$9 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            BlockState $$10 = (BlockState)$$9.setValue(FenceBlock.EAST, true);
            BlockState $$11 = (BlockState)$$9.setValue(FenceBlock.WEST, true);
            this.generateBox(p_228094_, p_228098_, 0, 1, 1, 0, 4, 1, $$10, $$10, false);
            this.generateBox(p_228094_, p_228098_, 0, 3, 4, 0, 4, 4, $$10, $$10, false);
            this.generateBox(p_228094_, p_228098_, 0, 3, 14, 0, 4, 14, $$10, $$10, false);
            this.generateBox(p_228094_, p_228098_, 0, 1, 17, 0, 4, 17, $$10, $$10, false);
            this.generateBox(p_228094_, p_228098_, 4, 1, 1, 4, 4, 1, $$11, $$11, false);
            this.generateBox(p_228094_, p_228098_, 4, 3, 4, 4, 4, 4, $$11, $$11, false);
            this.generateBox(p_228094_, p_228098_, 4, 3, 14, 4, 4, 14, $$11, $$11, false);
            this.generateBox(p_228094_, p_228098_, 4, 1, 17, 4, 4, 17, $$11, $$11, false);
        }
    }

    public static class BridgeCrossing
    extends NetherBridgePiece {
        private static final int WIDTH = 19;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public BridgeCrossing(int p_228026_, BoundingBox p_228027_, Direction p_228028_) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, p_228026_, p_228027_);
            this.setOrientation(p_228028_);
        }

        protected BridgeCrossing(int p_228022_, int p_228023_, Direction p_228024_) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, 0, StructurePiece.makeBoundingBox(p_228022_, 64, p_228023_, p_228024_, 19, 10, 19));
            this.setOrientation(p_228024_);
        }

        protected BridgeCrossing(StructurePieceType p_228030_, CompoundTag p_228031_) {
            super(p_228030_, p_228031_);
        }

        public BridgeCrossing(CompoundTag p_228033_) {
            this(StructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, p_228033_);
        }

        @Override
        public void addChildren(StructurePiece p_228043_, StructurePieceAccessor p_228044_, RandomSource p_228045_) {
            this.generateChildForward((StartPiece)p_228043_, p_228044_, p_228045_, 8, 3, false);
            this.generateChildLeft((StartPiece)p_228043_, p_228044_, p_228045_, 3, 8, false);
            this.generateChildRight((StartPiece)p_228043_, p_228044_, p_228045_, 3, 8, false);
        }

        public static BridgeCrossing createPiece(StructurePieceAccessor p_228047_, int p_228048_, int p_228049_, int p_228050_, Direction p_228051_, int p_228052_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228048_, p_228049_, p_228050_, -8, -3, 0, 19, 10, 19, p_228051_);
            if (!BridgeCrossing.isOkBox($$6) || p_228047_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new BridgeCrossing(p_228052_, $$6, p_228051_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228035_, StructureManager p_228036_, ChunkGenerator p_228037_, RandomSource p_228038_, BoundingBox p_228039_, ChunkPos p_228040_, BlockPos p_228041_) {
            this.generateBox(p_228035_, p_228039_, 7, 3, 0, 11, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 0, 3, 7, 18, 4, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 8, 5, 0, 10, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 0, 5, 8, 18, 7, 10, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 7, 5, 0, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 7, 5, 11, 7, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 11, 5, 0, 11, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 11, 5, 11, 11, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 0, 5, 7, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 11, 5, 7, 18, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 0, 5, 11, 7, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 11, 5, 11, 18, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 7, 2, 0, 11, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 7, 2, 13, 11, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 7, 0, 0, 11, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 7, 0, 15, 11, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$7 = 7; $$7 <= 11; ++$$7) {
                for (int $$8 = 0; $$8 <= 2; ++$$8) {
                    this.fillColumnDown(p_228035_, Blocks.NETHER_BRICKS.defaultBlockState(), $$7, -1, $$8, p_228039_);
                    this.fillColumnDown(p_228035_, Blocks.NETHER_BRICKS.defaultBlockState(), $$7, -1, 18 - $$8, p_228039_);
                }
            }
            this.generateBox(p_228035_, p_228039_, 0, 2, 7, 5, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 13, 2, 7, 18, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 0, 0, 7, 3, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228035_, p_228039_, 15, 0, 7, 18, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$9 = 0; $$9 <= 2; ++$$9) {
                for (int $$10 = 7; $$10 <= 11; ++$$10) {
                    this.fillColumnDown(p_228035_, Blocks.NETHER_BRICKS.defaultBlockState(), $$9, -1, $$10, p_228039_);
                    this.fillColumnDown(p_228035_, Blocks.NETHER_BRICKS.defaultBlockState(), 18 - $$9, -1, $$10, p_228039_);
                }
            }
        }
    }

    public static class RoomCrossing
    extends NetherBridgePiece {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 9;
        private static final int DEPTH = 7;

        public RoomCrossing(int p_228455_, BoundingBox p_228456_, Direction p_228457_) {
            super(StructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, p_228455_, p_228456_);
            this.setOrientation(p_228457_);
        }

        public RoomCrossing(CompoundTag p_228459_) {
            super(StructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, p_228459_);
        }

        @Override
        public void addChildren(StructurePiece p_228469_, StructurePieceAccessor p_228470_, RandomSource p_228471_) {
            this.generateChildForward((StartPiece)p_228469_, p_228470_, p_228471_, 2, 0, false);
            this.generateChildLeft((StartPiece)p_228469_, p_228470_, p_228471_, 0, 2, false);
            this.generateChildRight((StartPiece)p_228469_, p_228470_, p_228471_, 0, 2, false);
        }

        public static RoomCrossing createPiece(StructurePieceAccessor p_228473_, int p_228474_, int p_228475_, int p_228476_, Direction p_228477_, int p_228478_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228474_, p_228475_, p_228476_, -2, 0, 0, 7, 9, 7, p_228477_);
            if (!RoomCrossing.isOkBox($$6) || p_228473_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new RoomCrossing(p_228478_, $$6, p_228477_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228461_, StructureManager p_228462_, ChunkGenerator p_228463_, RandomSource p_228464_, BoundingBox p_228465_, ChunkPos p_228466_, BlockPos p_228467_) {
            this.generateBox(p_228461_, p_228465_, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 0, 2, 0, 6, 7, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 0, 2, 0, 1, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 0, 2, 6, 1, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 5, 2, 0, 6, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 5, 2, 6, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 0, 2, 0, 0, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 0, 2, 5, 0, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 6, 2, 0, 6, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 6, 2, 5, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(p_228461_, p_228465_, 2, 6, 0, 4, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 2, 5, 0, 4, 5, 0, $$7, $$7, false);
            this.generateBox(p_228461_, p_228465_, 2, 6, 6, 4, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 2, 5, 6, 4, 5, 6, $$7, $$7, false);
            this.generateBox(p_228461_, p_228465_, 0, 6, 2, 0, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 0, 5, 2, 0, 5, 4, $$8, $$8, false);
            this.generateBox(p_228461_, p_228465_, 6, 6, 2, 6, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228461_, p_228465_, 6, 5, 2, 6, 5, 4, $$8, $$8, false);
            for (int $$9 = 0; $$9 <= 6; ++$$9) {
                for (int $$10 = 0; $$10 <= 6; ++$$10) {
                    this.fillColumnDown(p_228461_, Blocks.NETHER_BRICKS.defaultBlockState(), $$9, -1, $$10, p_228465_);
                }
            }
        }
    }

    public static class StairsRoom
    extends NetherBridgePiece {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 7;

        public StairsRoom(int p_228483_, BoundingBox p_228484_, Direction p_228485_) {
            super(StructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, p_228483_, p_228484_);
            this.setOrientation(p_228485_);
        }

        public StairsRoom(CompoundTag p_228487_) {
            super(StructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, p_228487_);
        }

        @Override
        public void addChildren(StructurePiece p_228497_, StructurePieceAccessor p_228498_, RandomSource p_228499_) {
            this.generateChildRight((StartPiece)p_228497_, p_228498_, p_228499_, 6, 2, false);
        }

        public static StairsRoom createPiece(StructurePieceAccessor p_228501_, int p_228502_, int p_228503_, int p_228504_, int p_228505_, Direction p_228506_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228502_, p_228503_, p_228504_, -2, 0, 0, 7, 11, 7, p_228506_);
            if (!StairsRoom.isOkBox($$6) || p_228501_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new StairsRoom(p_228505_, $$6, p_228506_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228489_, StructureManager p_228490_, ChunkGenerator p_228491_, RandomSource p_228492_, BoundingBox p_228493_, ChunkPos p_228494_, BlockPos p_228495_) {
            this.generateBox(p_228489_, p_228493_, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 0, 2, 0, 6, 10, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 0, 2, 0, 1, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 5, 2, 0, 6, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 0, 2, 1, 0, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 6, 2, 1, 6, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 1, 2, 6, 5, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(p_228489_, p_228493_, 0, 3, 2, 0, 5, 4, $$8, $$8, false);
            this.generateBox(p_228489_, p_228493_, 6, 3, 2, 6, 5, 2, $$8, $$8, false);
            this.generateBox(p_228489_, p_228493_, 6, 3, 4, 6, 5, 4, $$8, $$8, false);
            this.placeBlock(p_228489_, Blocks.NETHER_BRICKS.defaultBlockState(), 5, 2, 5, p_228493_);
            this.generateBox(p_228489_, p_228493_, 4, 2, 5, 4, 3, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 3, 2, 5, 3, 4, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 2, 2, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 1, 2, 5, 1, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 1, 7, 1, 5, 7, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 6, 8, 2, 6, 8, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 2, 6, 0, 4, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228489_, p_228493_, 2, 5, 0, 4, 5, 0, $$7, $$7, false);
            for (int $$9 = 0; $$9 <= 6; ++$$9) {
                for (int $$10 = 0; $$10 <= 6; ++$$10) {
                    this.fillColumnDown(p_228489_, Blocks.NETHER_BRICKS.defaultBlockState(), $$9, -1, $$10, p_228493_);
                }
            }
        }
    }

    public static class MonsterThrone
    extends NetherBridgePiece {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 8;
        private static final int DEPTH = 9;
        private boolean hasPlacedSpawner;

        public MonsterThrone(int p_228356_, BoundingBox p_228357_, Direction p_228358_) {
            super(StructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, p_228356_, p_228357_);
            this.setOrientation(p_228358_);
        }

        public MonsterThrone(CompoundTag p_228360_) {
            super(StructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, p_228360_);
            this.hasPlacedSpawner = p_228360_.getBoolean("Mob");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_228377_, CompoundTag p_228378_) {
            super.addAdditionalSaveData(p_228377_, p_228378_);
            p_228378_.putBoolean("Mob", this.hasPlacedSpawner);
        }

        public static MonsterThrone createPiece(StructurePieceAccessor p_228370_, int p_228371_, int p_228372_, int p_228373_, int p_228374_, Direction p_228375_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228371_, p_228372_, p_228373_, -2, 0, 0, 7, 8, 9, p_228375_);
            if (!MonsterThrone.isOkBox($$6) || p_228370_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new MonsterThrone(p_228374_, $$6, p_228375_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228362_, StructureManager p_228363_, ChunkGenerator p_228364_, RandomSource p_228365_, BoundingBox p_228366_, ChunkPos p_228367_, BlockPos p_228368_) {
            BlockPos.MutableBlockPos $$9;
            this.generateBox(p_228362_, p_228366_, 0, 2, 0, 6, 7, 7, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 1, 0, 0, 5, 1, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 1, 2, 1, 5, 2, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 1, 3, 2, 5, 3, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 1, 4, 3, 5, 4, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 1, 2, 0, 1, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 5, 2, 0, 5, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 1, 5, 2, 1, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 5, 5, 2, 5, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 0, 5, 3, 0, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 6, 5, 3, 6, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228362_, p_228366_, 1, 5, 8, 5, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.placeBlock(p_228362_, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true), 1, 6, 3, p_228366_);
            this.placeBlock(p_228362_, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true), 5, 6, 3, p_228366_);
            this.placeBlock(p_228362_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true)).setValue(FenceBlock.NORTH, true), 0, 6, 3, p_228366_);
            this.placeBlock(p_228362_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.NORTH, true), 6, 6, 3, p_228366_);
            this.generateBox(p_228362_, p_228366_, 0, 6, 4, 0, 6, 7, $$8, $$8, false);
            this.generateBox(p_228362_, p_228366_, 6, 6, 4, 6, 6, 7, $$8, $$8, false);
            this.placeBlock(p_228362_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true)).setValue(FenceBlock.SOUTH, true), 0, 6, 8, p_228366_);
            this.placeBlock(p_228362_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.SOUTH, true), 6, 6, 8, p_228366_);
            this.generateBox(p_228362_, p_228366_, 1, 6, 8, 5, 6, 8, $$7, $$7, false);
            this.placeBlock(p_228362_, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true), 1, 7, 8, p_228366_);
            this.generateBox(p_228362_, p_228366_, 2, 7, 8, 4, 7, 8, $$7, $$7, false);
            this.placeBlock(p_228362_, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true), 5, 7, 8, p_228366_);
            this.placeBlock(p_228362_, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true), 2, 8, 8, p_228366_);
            this.placeBlock(p_228362_, $$7, 3, 8, 8, p_228366_);
            this.placeBlock(p_228362_, (BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true), 4, 8, 8, p_228366_);
            if (!this.hasPlacedSpawner && p_228366_.isInside($$9 = this.getWorldPos(3, 5, 5))) {
                this.hasPlacedSpawner = true;
                p_228362_.setBlock($$9, Blocks.SPAWNER.defaultBlockState(), 2);
                BlockEntity $$10 = p_228362_.getBlockEntity($$9);
                if ($$10 instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity $$11 = (SpawnerBlockEntity)$$10;
                    $$11.setEntityId(EntityType.BLAZE, p_228365_);
                }
            }
            for (int $$12 = 0; $$12 <= 6; ++$$12) {
                for (int $$13 = 0; $$13 <= 6; ++$$13) {
                    this.fillColumnDown(p_228362_, Blocks.NETHER_BRICKS.defaultBlockState(), $$12, -1, $$13, p_228366_);
                }
            }
        }
    }

    public static class CastleEntrance
    extends NetherBridgePiece {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public CastleEntrance(int p_228173_, RandomSource p_228174_, BoundingBox p_228175_, Direction p_228176_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, p_228173_, p_228175_);
            this.setOrientation(p_228176_);
        }

        public CastleEntrance(CompoundTag p_228178_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, p_228178_);
        }

        @Override
        public void addChildren(StructurePiece p_228188_, StructurePieceAccessor p_228189_, RandomSource p_228190_) {
            this.generateChildForward((StartPiece)p_228188_, p_228189_, p_228190_, 5, 3, true);
        }

        public static CastleEntrance createPiece(StructurePieceAccessor p_228192_, RandomSource p_228193_, int p_228194_, int p_228195_, int p_228196_, Direction p_228197_, int p_228198_) {
            BoundingBox $$7 = BoundingBox.orientBox(p_228194_, p_228195_, p_228196_, -5, -3, 0, 13, 14, 13, p_228197_);
            if (!CastleEntrance.isOkBox($$7) || p_228192_.findCollisionPiece($$7) != null) {
                return null;
            }
            return new CastleEntrance(p_228198_, p_228193_, $$7, p_228197_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228180_, StructureManager p_228181_, ChunkGenerator p_228182_, RandomSource p_228183_, BoundingBox p_228184_, ChunkPos p_228185_, BlockPos p_228186_) {
            this.generateBox(p_228180_, p_228184_, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 5, 8, 0, 7, 8, 0, Blocks.NETHER_BRICK_FENCE.defaultBlockState(), Blocks.NETHER_BRICK_FENCE.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            for (int $$9 = 1; $$9 <= 11; $$9 += 2) {
                this.generateBox(p_228180_, p_228184_, $$9, 10, 0, $$9, 11, 0, $$7, $$7, false);
                this.generateBox(p_228180_, p_228184_, $$9, 10, 12, $$9, 11, 12, $$7, $$7, false);
                this.generateBox(p_228180_, p_228184_, 0, 10, $$9, 0, 11, $$9, $$8, $$8, false);
                this.generateBox(p_228180_, p_228184_, 12, 10, $$9, 12, 11, $$9, $$8, $$8, false);
                this.placeBlock(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), $$9, 13, 0, p_228184_);
                this.placeBlock(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), $$9, 13, 12, p_228184_);
                this.placeBlock(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, $$9, p_228184_);
                this.placeBlock(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, $$9, p_228184_);
                if ($$9 == 11) continue;
                this.placeBlock(p_228180_, $$7, $$9 + 1, 13, 0, p_228184_);
                this.placeBlock(p_228180_, $$7, $$9 + 1, 13, 12, p_228184_);
                this.placeBlock(p_228180_, $$8, 0, 13, $$9 + 1, p_228184_);
                this.placeBlock(p_228180_, $$8, 12, 13, $$9 + 1, p_228184_);
            }
            this.placeBlock(p_228180_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 0, p_228184_);
            this.placeBlock(p_228180_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 12, p_228184_);
            this.placeBlock(p_228180_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 12, p_228184_);
            this.placeBlock(p_228180_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 0, p_228184_);
            for (int $$10 = 3; $$10 <= 9; $$10 += 2) {
                this.generateBox(p_228180_, p_228184_, 1, 7, $$10, 1, 8, $$10, (BlockState)$$8.setValue(FenceBlock.WEST, true), (BlockState)$$8.setValue(FenceBlock.WEST, true), false);
                this.generateBox(p_228180_, p_228184_, 11, 7, $$10, 11, 8, $$10, (BlockState)$$8.setValue(FenceBlock.EAST, true), (BlockState)$$8.setValue(FenceBlock.EAST, true), false);
            }
            this.generateBox(p_228180_, p_228184_, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$11 = 4; $$11 <= 8; ++$$11) {
                for (int $$12 = 0; $$12 <= 2; ++$$12) {
                    this.fillColumnDown(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), $$11, -1, $$12, p_228184_);
                    this.fillColumnDown(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), $$11, -1, 12 - $$12, p_228184_);
                }
            }
            for (int $$13 = 0; $$13 <= 2; ++$$13) {
                for (int $$14 = 4; $$14 <= 8; ++$$14) {
                    this.fillColumnDown(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), $$13, -1, $$14, p_228184_);
                    this.fillColumnDown(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - $$13, -1, $$14, p_228184_);
                }
            }
            this.generateBox(p_228180_, p_228184_, 5, 5, 5, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228180_, p_228184_, 6, 1, 6, 6, 4, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.placeBlock(p_228180_, Blocks.NETHER_BRICKS.defaultBlockState(), 6, 0, 6, p_228184_);
            this.placeBlock(p_228180_, Blocks.LAVA.defaultBlockState(), 6, 5, 6, p_228184_);
            BlockPos.MutableBlockPos $$15 = this.getWorldPos(6, 5, 6);
            if (p_228184_.isInside($$15)) {
                p_228180_.scheduleTick((BlockPos)$$15, Fluids.LAVA, 0);
            }
        }
    }

    public static class CastleSmallCorridorPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public CastleSmallCorridorPiece(int p_228265_, BoundingBox p_228266_, Direction p_228267_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, p_228265_, p_228266_);
            this.setOrientation(p_228267_);
        }

        public CastleSmallCorridorPiece(CompoundTag p_228269_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, p_228269_);
        }

        @Override
        public void addChildren(StructurePiece p_228279_, StructurePieceAccessor p_228280_, RandomSource p_228281_) {
            this.generateChildForward((StartPiece)p_228279_, p_228280_, p_228281_, 1, 0, true);
        }

        public static CastleSmallCorridorPiece createPiece(StructurePieceAccessor p_228283_, int p_228284_, int p_228285_, int p_228286_, Direction p_228287_, int p_228288_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228284_, p_228285_, p_228286_, -1, 0, 0, 5, 7, 5, p_228287_);
            if (!CastleSmallCorridorPiece.isOkBox($$6) || p_228283_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new CastleSmallCorridorPiece(p_228288_, $$6, p_228287_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228271_, StructureManager p_228272_, ChunkGenerator p_228273_, RandomSource p_228274_, BoundingBox p_228275_, ChunkPos p_228276_, BlockPos p_228277_) {
            this.generateBox(p_228271_, p_228275_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228271_, p_228275_, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(p_228271_, p_228275_, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228271_, p_228275_, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228271_, p_228275_, 0, 3, 1, 0, 4, 1, $$7, $$7, false);
            this.generateBox(p_228271_, p_228275_, 0, 3, 3, 0, 4, 3, $$7, $$7, false);
            this.generateBox(p_228271_, p_228275_, 4, 3, 1, 4, 4, 1, $$7, $$7, false);
            this.generateBox(p_228271_, p_228275_, 4, 3, 3, 4, 4, 3, $$7, $$7, false);
            this.generateBox(p_228271_, p_228275_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$8 = 0; $$8 <= 4; ++$$8) {
                for (int $$9 = 0; $$9 <= 4; ++$$9) {
                    this.fillColumnDown(p_228271_, Blocks.NETHER_BRICKS.defaultBlockState(), $$8, -1, $$9, p_228275_);
                }
            }
        }
    }

    public static class CastleSmallCorridorRightTurnPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public CastleSmallCorridorRightTurnPiece(int p_228294_, RandomSource p_228295_, BoundingBox p_228296_, Direction p_228297_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, p_228294_, p_228296_);
            this.setOrientation(p_228297_);
            this.isNeedingChest = p_228295_.nextInt(3) == 0;
        }

        public CastleSmallCorridorRightTurnPiece(CompoundTag p_228299_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, p_228299_);
            this.isNeedingChest = p_228299_.getBoolean("Chest");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_228321_, CompoundTag p_228322_) {
            super.addAdditionalSaveData(p_228321_, p_228322_);
            p_228322_.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece p_228309_, StructurePieceAccessor p_228310_, RandomSource p_228311_) {
            this.generateChildRight((StartPiece)p_228309_, p_228310_, p_228311_, 0, 1, true);
        }

        public static CastleSmallCorridorRightTurnPiece createPiece(StructurePieceAccessor p_228313_, RandomSource p_228314_, int p_228315_, int p_228316_, int p_228317_, Direction p_228318_, int p_228319_) {
            BoundingBox $$7 = BoundingBox.orientBox(p_228315_, p_228316_, p_228317_, -1, 0, 0, 5, 7, 5, p_228318_);
            if (!CastleSmallCorridorRightTurnPiece.isOkBox($$7) || p_228313_.findCollisionPiece($$7) != null) {
                return null;
            }
            return new CastleSmallCorridorRightTurnPiece(p_228319_, p_228314_, $$7, p_228318_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228301_, StructureManager p_228302_, ChunkGenerator p_228303_, RandomSource p_228304_, BoundingBox p_228305_, ChunkPos p_228306_, BlockPos p_228307_) {
            this.generateBox(p_228301_, p_228305_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228301_, p_228305_, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(p_228301_, p_228305_, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228301_, p_228305_, 0, 3, 1, 0, 4, 1, $$8, $$8, false);
            this.generateBox(p_228301_, p_228305_, 0, 3, 3, 0, 4, 3, $$8, $$8, false);
            this.generateBox(p_228301_, p_228305_, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228301_, p_228305_, 1, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228301_, p_228305_, 1, 3, 4, 1, 4, 4, $$7, $$7, false);
            this.generateBox(p_228301_, p_228305_, 3, 3, 4, 3, 4, 4, $$7, $$7, false);
            if (this.isNeedingChest && p_228305_.isInside(this.getWorldPos(1, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(p_228301_, p_228305_, p_228304_, 1, 2, 3, BuiltInLootTables.NETHER_BRIDGE);
            }
            this.generateBox(p_228301_, p_228305_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$9 = 0; $$9 <= 4; ++$$9) {
                for (int $$10 = 0; $$10 <= 4; ++$$10) {
                    this.fillColumnDown(p_228301_, Blocks.NETHER_BRICKS.defaultBlockState(), $$9, -1, $$10, p_228305_);
                }
            }
        }
    }

    public static class CastleSmallCorridorLeftTurnPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public CastleSmallCorridorLeftTurnPiece(int p_228232_, RandomSource p_228233_, BoundingBox p_228234_, Direction p_228235_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, p_228232_, p_228234_);
            this.setOrientation(p_228235_);
            this.isNeedingChest = p_228233_.nextInt(3) == 0;
        }

        public CastleSmallCorridorLeftTurnPiece(CompoundTag p_228237_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, p_228237_);
            this.isNeedingChest = p_228237_.getBoolean("Chest");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_228259_, CompoundTag p_228260_) {
            super.addAdditionalSaveData(p_228259_, p_228260_);
            p_228260_.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece p_228247_, StructurePieceAccessor p_228248_, RandomSource p_228249_) {
            this.generateChildLeft((StartPiece)p_228247_, p_228248_, p_228249_, 0, 1, true);
        }

        public static CastleSmallCorridorLeftTurnPiece createPiece(StructurePieceAccessor p_228251_, RandomSource p_228252_, int p_228253_, int p_228254_, int p_228255_, Direction p_228256_, int p_228257_) {
            BoundingBox $$7 = BoundingBox.orientBox(p_228253_, p_228254_, p_228255_, -1, 0, 0, 5, 7, 5, p_228256_);
            if (!CastleSmallCorridorLeftTurnPiece.isOkBox($$7) || p_228251_.findCollisionPiece($$7) != null) {
                return null;
            }
            return new CastleSmallCorridorLeftTurnPiece(p_228257_, p_228252_, $$7, p_228256_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228239_, StructureManager p_228240_, ChunkGenerator p_228241_, RandomSource p_228242_, BoundingBox p_228243_, ChunkPos p_228244_, BlockPos p_228245_) {
            this.generateBox(p_228239_, p_228243_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228239_, p_228243_, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            this.generateBox(p_228239_, p_228243_, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228239_, p_228243_, 4, 3, 1, 4, 4, 1, $$8, $$8, false);
            this.generateBox(p_228239_, p_228243_, 4, 3, 3, 4, 4, 3, $$8, $$8, false);
            this.generateBox(p_228239_, p_228243_, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228239_, p_228243_, 0, 2, 4, 3, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228239_, p_228243_, 1, 3, 4, 1, 4, 4, $$7, $$7, false);
            this.generateBox(p_228239_, p_228243_, 3, 3, 4, 3, 4, 4, $$7, $$7, false);
            if (this.isNeedingChest && p_228243_.isInside(this.getWorldPos(3, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(p_228239_, p_228243_, p_228242_, 3, 2, 3, BuiltInLootTables.NETHER_BRIDGE);
            }
            this.generateBox(p_228239_, p_228243_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$9 = 0; $$9 <= 4; ++$$9) {
                for (int $$10 = 0; $$10 <= 4; ++$$10) {
                    this.fillColumnDown(p_228239_, Blocks.NETHER_BRICKS.defaultBlockState(), $$9, -1, $$10, p_228243_);
                }
            }
        }
    }

    public static class CastleCorridorStairsPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 10;

        public CastleCorridorStairsPiece(int p_228117_, BoundingBox p_228118_, Direction p_228119_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, p_228117_, p_228118_);
            this.setOrientation(p_228119_);
        }

        public CastleCorridorStairsPiece(CompoundTag p_228121_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, p_228121_);
        }

        @Override
        public void addChildren(StructurePiece p_228131_, StructurePieceAccessor p_228132_, RandomSource p_228133_) {
            this.generateChildForward((StartPiece)p_228131_, p_228132_, p_228133_, 1, 0, true);
        }

        public static CastleCorridorStairsPiece createPiece(StructurePieceAccessor p_228135_, int p_228136_, int p_228137_, int p_228138_, Direction p_228139_, int p_228140_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228136_, p_228137_, p_228138_, -1, -7, 0, 5, 14, 10, p_228139_);
            if (!CastleCorridorStairsPiece.isOkBox($$6) || p_228135_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new CastleCorridorStairsPiece(p_228140_, $$6, p_228139_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228123_, StructureManager p_228124_, ChunkGenerator p_228125_, RandomSource p_228126_, BoundingBox p_228127_, ChunkPos p_228128_, BlockPos p_228129_) {
            BlockState $$7 = (BlockState)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.SOUTH);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            for (int $$9 = 0; $$9 <= 9; ++$$9) {
                int $$10 = Math.max(1, 7 - $$9);
                int $$11 = Math.min(Math.max($$10 + 5, 14 - $$9), 13);
                int $$12 = $$9;
                this.generateBox(p_228123_, p_228127_, 0, 0, $$12, 4, $$10, $$12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(p_228123_, p_228127_, 1, $$10 + 1, $$12, 3, $$11 - 1, $$12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
                if ($$9 <= 6) {
                    this.placeBlock(p_228123_, $$7, 1, $$10 + 1, $$12, p_228127_);
                    this.placeBlock(p_228123_, $$7, 2, $$10 + 1, $$12, p_228127_);
                    this.placeBlock(p_228123_, $$7, 3, $$10 + 1, $$12, p_228127_);
                }
                this.generateBox(p_228123_, p_228127_, 0, $$11, $$12, 4, $$11, $$12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(p_228123_, p_228127_, 0, $$10 + 1, $$12, 0, $$11 - 1, $$12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(p_228123_, p_228127_, 4, $$10 + 1, $$12, 4, $$11 - 1, $$12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                if (($$9 & 1) == 0) {
                    this.generateBox(p_228123_, p_228127_, 0, $$10 + 2, $$12, 0, $$10 + 3, $$12, $$8, $$8, false);
                    this.generateBox(p_228123_, p_228127_, 4, $$10 + 2, $$12, 4, $$10 + 3, $$12, $$8, $$8, false);
                }
                for (int $$13 = 0; $$13 <= 4; ++$$13) {
                    this.fillColumnDown(p_228123_, Blocks.NETHER_BRICKS.defaultBlockState(), $$13, -1, $$12, p_228127_);
                }
            }
        }
    }

    public static class CastleCorridorTBalconyPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 9;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 9;

        public CastleCorridorTBalconyPiece(int p_228145_, BoundingBox p_228146_, Direction p_228147_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, p_228145_, p_228146_);
            this.setOrientation(p_228147_);
        }

        public CastleCorridorTBalconyPiece(CompoundTag p_228149_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, p_228149_);
        }

        @Override
        public void addChildren(StructurePiece p_228159_, StructurePieceAccessor p_228160_, RandomSource p_228161_) {
            int $$3 = 1;
            Direction $$4 = this.getOrientation();
            if ($$4 == Direction.WEST || $$4 == Direction.NORTH) {
                $$3 = 5;
            }
            this.generateChildLeft((StartPiece)p_228159_, p_228160_, p_228161_, 0, $$3, p_228161_.nextInt(8) > 0);
            this.generateChildRight((StartPiece)p_228159_, p_228160_, p_228161_, 0, $$3, p_228161_.nextInt(8) > 0);
        }

        public static CastleCorridorTBalconyPiece createPiece(StructurePieceAccessor p_228163_, int p_228164_, int p_228165_, int p_228166_, Direction p_228167_, int p_228168_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228164_, p_228165_, p_228166_, -3, 0, 0, 9, 7, 9, p_228167_);
            if (!CastleCorridorTBalconyPiece.isOkBox($$6) || p_228163_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new CastleCorridorTBalconyPiece(p_228168_, $$6, p_228167_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228151_, StructureManager p_228152_, ChunkGenerator p_228153_, RandomSource p_228154_, BoundingBox p_228155_, ChunkPos p_228156_, BlockPos p_228157_) {
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            this.generateBox(p_228151_, p_228155_, 0, 0, 0, 8, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 0, 2, 0, 8, 5, 8, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 0, 6, 0, 8, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 0, 2, 0, 2, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 6, 2, 0, 8, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 1, 3, 0, 1, 4, 0, $$8, $$8, false);
            this.generateBox(p_228151_, p_228155_, 7, 3, 0, 7, 4, 0, $$8, $$8, false);
            this.generateBox(p_228151_, p_228155_, 0, 2, 4, 8, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 1, 1, 4, 2, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 6, 1, 4, 7, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 1, 3, 8, 7, 3, 8, $$8, $$8, false);
            this.placeBlock(p_228151_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.EAST, true)).setValue(FenceBlock.SOUTH, true), 0, 3, 8, p_228155_);
            this.placeBlock(p_228151_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.SOUTH, true), 8, 3, 8, p_228155_);
            this.generateBox(p_228151_, p_228155_, 0, 3, 6, 0, 3, 7, $$7, $$7, false);
            this.generateBox(p_228151_, p_228155_, 8, 3, 6, 8, 3, 7, $$7, $$7, false);
            this.generateBox(p_228151_, p_228155_, 0, 3, 4, 0, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 8, 3, 4, 8, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 1, 3, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 6, 3, 5, 7, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228151_, p_228155_, 1, 4, 5, 1, 5, 5, $$8, $$8, false);
            this.generateBox(p_228151_, p_228155_, 7, 4, 5, 7, 5, 5, $$8, $$8, false);
            for (int $$9 = 0; $$9 <= 5; ++$$9) {
                for (int $$10 = 0; $$10 <= 8; ++$$10) {
                    this.fillColumnDown(p_228151_, Blocks.NETHER_BRICKS.defaultBlockState(), $$10, -1, $$9, p_228155_);
                }
            }
        }
    }

    public static class CastleSmallCorridorCrossingPiece
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public CastleSmallCorridorCrossingPiece(int p_228203_, BoundingBox p_228204_, Direction p_228205_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, p_228203_, p_228204_);
            this.setOrientation(p_228205_);
        }

        public CastleSmallCorridorCrossingPiece(CompoundTag p_228207_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, p_228207_);
        }

        @Override
        public void addChildren(StructurePiece p_228217_, StructurePieceAccessor p_228218_, RandomSource p_228219_) {
            this.generateChildForward((StartPiece)p_228217_, p_228218_, p_228219_, 1, 0, true);
            this.generateChildLeft((StartPiece)p_228217_, p_228218_, p_228219_, 0, 1, true);
            this.generateChildRight((StartPiece)p_228217_, p_228218_, p_228219_, 0, 1, true);
        }

        public static CastleSmallCorridorCrossingPiece createPiece(StructurePieceAccessor p_228221_, int p_228222_, int p_228223_, int p_228224_, Direction p_228225_, int p_228226_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228222_, p_228223_, p_228224_, -1, 0, 0, 5, 7, 5, p_228225_);
            if (!CastleSmallCorridorCrossingPiece.isOkBox($$6) || p_228221_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new CastleSmallCorridorCrossingPiece(p_228226_, $$6, p_228225_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228209_, StructureManager p_228210_, ChunkGenerator p_228211_, RandomSource p_228212_, BoundingBox p_228213_, ChunkPos p_228214_, BlockPos p_228215_) {
            this.generateBox(p_228209_, p_228213_, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228209_, p_228213_, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228209_, p_228213_, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228209_, p_228213_, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228209_, p_228213_, 0, 2, 4, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228209_, p_228213_, 4, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228209_, p_228213_, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$7 = 0; $$7 <= 4; ++$$7) {
                for (int $$8 = 0; $$8 <= 4; ++$$8) {
                    this.fillColumnDown(p_228209_, Blocks.NETHER_BRICKS.defaultBlockState(), $$7, -1, $$8, p_228213_);
                }
            }
        }
    }

    public static class CastleStalkRoom
    extends NetherBridgePiece {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public CastleStalkRoom(int p_228327_, BoundingBox p_228328_, Direction p_228329_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, p_228327_, p_228328_);
            this.setOrientation(p_228329_);
        }

        public CastleStalkRoom(CompoundTag p_228331_) {
            super(StructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, p_228331_);
        }

        @Override
        public void addChildren(StructurePiece p_228341_, StructurePieceAccessor p_228342_, RandomSource p_228343_) {
            this.generateChildForward((StartPiece)p_228341_, p_228342_, p_228343_, 5, 3, true);
            this.generateChildForward((StartPiece)p_228341_, p_228342_, p_228343_, 5, 11, true);
        }

        public static CastleStalkRoom createPiece(StructurePieceAccessor p_228345_, int p_228346_, int p_228347_, int p_228348_, Direction p_228349_, int p_228350_) {
            BoundingBox $$6 = BoundingBox.orientBox(p_228346_, p_228347_, p_228348_, -5, -3, 0, 13, 14, 13, p_228349_);
            if (!CastleStalkRoom.isOkBox($$6) || p_228345_.findCollisionPiece($$6) != null) {
                return null;
            }
            return new CastleStalkRoom(p_228350_, $$6, p_228349_);
        }

        @Override
        public void postProcess(WorldGenLevel p_228333_, StructureManager p_228334_, ChunkGenerator p_228335_, RandomSource p_228336_, BoundingBox p_228337_, ChunkPos p_228338_, BlockPos p_228339_) {
            this.generateBox(p_228333_, p_228337_, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState $$7 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.WEST, true)).setValue(FenceBlock.EAST, true);
            BlockState $$8 = (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.SOUTH, true);
            BlockState $$9 = (BlockState)$$8.setValue(FenceBlock.WEST, true);
            BlockState $$10 = (BlockState)$$8.setValue(FenceBlock.EAST, true);
            for (int $$11 = 1; $$11 <= 11; $$11 += 2) {
                this.generateBox(p_228333_, p_228337_, $$11, 10, 0, $$11, 11, 0, $$7, $$7, false);
                this.generateBox(p_228333_, p_228337_, $$11, 10, 12, $$11, 11, 12, $$7, $$7, false);
                this.generateBox(p_228333_, p_228337_, 0, 10, $$11, 0, 11, $$11, $$8, $$8, false);
                this.generateBox(p_228333_, p_228337_, 12, 10, $$11, 12, 11, $$11, $$8, $$8, false);
                this.placeBlock(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), $$11, 13, 0, p_228337_);
                this.placeBlock(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), $$11, 13, 12, p_228337_);
                this.placeBlock(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, $$11, p_228337_);
                this.placeBlock(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, $$11, p_228337_);
                if ($$11 == 11) continue;
                this.placeBlock(p_228333_, $$7, $$11 + 1, 13, 0, p_228337_);
                this.placeBlock(p_228333_, $$7, $$11 + 1, 13, 12, p_228337_);
                this.placeBlock(p_228333_, $$8, 0, 13, $$11 + 1, p_228337_);
                this.placeBlock(p_228333_, $$8, 12, 13, $$11 + 1, p_228337_);
            }
            this.placeBlock(p_228333_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 0, p_228337_);
            this.placeBlock(p_228333_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.EAST, true), 0, 13, 12, p_228337_);
            this.placeBlock(p_228333_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.SOUTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 12, p_228337_);
            this.placeBlock(p_228333_, (BlockState)((BlockState)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(FenceBlock.NORTH, true)).setValue(FenceBlock.WEST, true), 12, 13, 0, p_228337_);
            for (int $$12 = 3; $$12 <= 9; $$12 += 2) {
                this.generateBox(p_228333_, p_228337_, 1, 7, $$12, 1, 8, $$12, $$9, $$9, false);
                this.generateBox(p_228333_, p_228337_, 11, 7, $$12, 11, 8, $$12, $$10, $$10, false);
            }
            BlockState $$13 = (BlockState)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(StairBlock.FACING, Direction.NORTH);
            for (int $$14 = 0; $$14 <= 6; ++$$14) {
                int $$15 = $$14 + 4;
                for (int $$16 = 5; $$16 <= 7; ++$$16) {
                    this.placeBlock(p_228333_, $$13, $$16, 5 + $$14, $$15, p_228337_);
                }
                if ($$15 >= 5 && $$15 <= 8) {
                    this.generateBox(p_228333_, p_228337_, 5, 5, $$15, 7, $$14 + 4, $$15, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                } else if ($$15 >= 9 && $$15 <= 10) {
                    this.generateBox(p_228333_, p_228337_, 5, 8, $$15, 7, $$14 + 4, $$15, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
                if ($$14 < 1) continue;
                this.generateBox(p_228333_, p_228337_, 5, 6 + $$14, $$15, 7, 9 + $$14, $$15, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            }
            for (int $$17 = 5; $$17 <= 7; ++$$17) {
                this.placeBlock(p_228333_, $$13, $$17, 12, 11, p_228337_);
            }
            this.generateBox(p_228333_, p_228337_, 5, 6, 7, 5, 7, 7, $$10, $$10, false);
            this.generateBox(p_228333_, p_228337_, 7, 6, 7, 7, 7, 7, $$9, $$9, false);
            this.generateBox(p_228333_, p_228337_, 5, 13, 12, 7, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 2, 5, 2, 3, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 2, 5, 9, 3, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 2, 5, 4, 2, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 9, 5, 2, 10, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 9, 5, 9, 10, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 10, 5, 4, 10, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            BlockState $$18 = (BlockState)$$13.setValue(StairBlock.FACING, Direction.EAST);
            BlockState $$19 = (BlockState)$$13.setValue(StairBlock.FACING, Direction.WEST);
            this.placeBlock(p_228333_, $$19, 4, 5, 2, p_228337_);
            this.placeBlock(p_228333_, $$19, 4, 5, 3, p_228337_);
            this.placeBlock(p_228333_, $$19, 4, 5, 9, p_228337_);
            this.placeBlock(p_228333_, $$19, 4, 5, 10, p_228337_);
            this.placeBlock(p_228333_, $$18, 8, 5, 2, p_228337_);
            this.placeBlock(p_228333_, $$18, 8, 5, 3, p_228337_);
            this.placeBlock(p_228333_, $$18, 8, 5, 9, p_228337_);
            this.placeBlock(p_228333_, $$18, 8, 5, 10, p_228337_);
            this.generateBox(p_228333_, p_228337_, 3, 4, 4, 4, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 8, 4, 4, 9, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 3, 5, 4, 4, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 8, 5, 4, 9, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(p_228333_, p_228337_, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$20 = 4; $$20 <= 8; ++$$20) {
                for (int $$21 = 0; $$21 <= 2; ++$$21) {
                    this.fillColumnDown(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), $$20, -1, $$21, p_228337_);
                    this.fillColumnDown(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), $$20, -1, 12 - $$21, p_228337_);
                }
            }
            for (int $$22 = 0; $$22 <= 2; ++$$22) {
                for (int $$23 = 4; $$23 <= 8; ++$$23) {
                    this.fillColumnDown(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), $$22, -1, $$23, p_228337_);
                    this.fillColumnDown(p_228333_, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - $$22, -1, $$23, p_228337_);
                }
            }
        }
    }

    public static class BridgeEndFiller
    extends NetherBridgePiece {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 8;
        private final int selfSeed;

        public BridgeEndFiller(int p_228058_, RandomSource p_228059_, BoundingBox p_228060_, Direction p_228061_) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, p_228058_, p_228060_);
            this.setOrientation(p_228061_);
            this.selfSeed = p_228059_.nextInt();
        }

        public BridgeEndFiller(CompoundTag p_228063_) {
            super(StructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, p_228063_);
            this.selfSeed = p_228063_.getInt("Seed");
        }

        public static BridgeEndFiller createPiece(StructurePieceAccessor p_228073_, RandomSource p_228074_, int p_228075_, int p_228076_, int p_228077_, Direction p_228078_, int p_228079_) {
            BoundingBox $$7 = BoundingBox.orientBox(p_228075_, p_228076_, p_228077_, -1, -3, 0, 5, 10, 8, p_228078_);
            if (!BridgeEndFiller.isOkBox($$7) || p_228073_.findCollisionPiece($$7) != null) {
                return null;
            }
            return new BridgeEndFiller(p_228079_, p_228074_, $$7, p_228078_);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_228081_, CompoundTag p_228082_) {
            super.addAdditionalSaveData(p_228081_, p_228082_);
            p_228082_.putInt("Seed", this.selfSeed);
        }

        @Override
        public void postProcess(WorldGenLevel p_228065_, StructureManager p_228066_, ChunkGenerator p_228067_, RandomSource p_228068_, BoundingBox p_228069_, ChunkPos p_228070_, BlockPos p_228071_) {
            RandomSource $$7 = RandomSource.create(this.selfSeed);
            for (int $$8 = 0; $$8 <= 4; ++$$8) {
                for (int $$9 = 3; $$9 <= 4; ++$$9) {
                    int $$10 = $$7.nextInt(8);
                    this.generateBox(p_228065_, p_228069_, $$8, $$9, 0, $$8, $$9, $$10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
            int $$11 = $$7.nextInt(8);
            this.generateBox(p_228065_, p_228069_, 0, 5, 0, 0, 5, $$11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            int $$12 = $$7.nextInt(8);
            this.generateBox(p_228065_, p_228069_, 4, 5, 0, 4, 5, $$12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int $$13 = 0; $$13 <= 4; ++$$13) {
                int $$14 = $$7.nextInt(5);
                this.generateBox(p_228065_, p_228069_, $$13, 2, 0, $$13, 2, $$14, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            }
            for (int $$15 = 0; $$15 <= 4; ++$$15) {
                for (int $$16 = 0; $$16 <= 1; ++$$16) {
                    int $$17 = $$7.nextInt(3);
                    this.generateBox(p_228065_, p_228069_, $$15, $$16, 0, $$15, $$16, $$17, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
        }
    }

    public static class StartPiece
    extends BridgeCrossing {
        public PieceWeight previousPiece;
        public List<PieceWeight> availableBridgePieces;
        public List<PieceWeight> availableCastlePieces;
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public StartPiece(RandomSource p_228512_, int p_228513_, int p_228514_) {
            super(p_228513_, p_228514_, StartPiece.getRandomHorizontalDirection(p_228512_));
            this.availableBridgePieces = Lists.newArrayList();
            for (PieceWeight $$3 : BRIDGE_PIECE_WEIGHTS) {
                $$3.placeCount = 0;
                this.availableBridgePieces.add($$3);
            }
            this.availableCastlePieces = Lists.newArrayList();
            for (PieceWeight $$4 : CASTLE_PIECE_WEIGHTS) {
                $$4.placeCount = 0;
                this.availableCastlePieces.add($$4);
            }
        }

        public StartPiece(CompoundTag p_228516_) {
            super(StructurePieceType.NETHER_FORTRESS_START, p_228516_);
        }
    }

    static abstract class NetherBridgePiece
    extends StructurePiece {
        protected NetherBridgePiece(StructurePieceType p_228380_, int p_228381_, BoundingBox p_228382_) {
            super(p_228380_, p_228381_, p_228382_);
        }

        public NetherBridgePiece(StructurePieceType p_228384_, CompoundTag p_228385_) {
            super(p_228384_, p_228385_);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext p_228389_, CompoundTag p_228390_) {
        }

        private int updatePieceWeight(List<PieceWeight> p_228419_) {
            boolean $$1 = false;
            int $$2 = 0;
            for (PieceWeight $$3 : p_228419_) {
                if ($$3.maxPlaceCount > 0 && $$3.placeCount < $$3.maxPlaceCount) {
                    $$1 = true;
                }
                $$2 += $$3.weight;
            }
            return $$1 ? $$2 : -1;
        }

        private NetherBridgePiece generatePiece(StartPiece p_228409_, List<PieceWeight> p_228410_, StructurePieceAccessor p_228411_, RandomSource p_228412_, int p_228413_, int p_228414_, int p_228415_, Direction p_228416_, int p_228417_) {
            int $$9 = this.updatePieceWeight(p_228410_);
            boolean $$10 = $$9 > 0 && p_228417_ <= 30;
            int $$11 = 0;
            block0: while ($$11 < 5 && $$10) {
                ++$$11;
                int $$12 = p_228412_.nextInt($$9);
                for (PieceWeight $$13 : p_228410_) {
                    if (($$12 -= $$13.weight) >= 0) continue;
                    if (!$$13.doPlace(p_228417_) || $$13 == p_228409_.previousPiece && !$$13.allowInRow) continue block0;
                    NetherBridgePiece $$14 = NetherFortressPieces.findAndCreateBridgePieceFactory($$13, p_228411_, p_228412_, p_228413_, p_228414_, p_228415_, p_228416_, p_228417_);
                    if ($$14 == null) continue;
                    ++$$13.placeCount;
                    p_228409_.previousPiece = $$13;
                    if (!$$13.isValid()) {
                        p_228410_.remove($$13);
                    }
                    return $$14;
                }
            }
            return BridgeEndFiller.createPiece(p_228411_, p_228412_, p_228413_, p_228414_, p_228415_, p_228416_, p_228417_);
        }

        private StructurePiece generateAndAddPiece(StartPiece p_228392_, StructurePieceAccessor p_228393_, RandomSource p_228394_, int p_228395_, int p_228396_, int p_228397_, @Nullable Direction p_228398_, int p_228399_, boolean p_228400_) {
            NetherBridgePiece $$10;
            if (Math.abs(p_228395_ - p_228392_.getBoundingBox().minX()) > 112 || Math.abs(p_228397_ - p_228392_.getBoundingBox().minZ()) > 112) {
                return BridgeEndFiller.createPiece(p_228393_, p_228394_, p_228395_, p_228396_, p_228397_, p_228398_, p_228399_);
            }
            List<PieceWeight> $$9 = p_228392_.availableBridgePieces;
            if (p_228400_) {
                $$9 = p_228392_.availableCastlePieces;
            }
            if (($$10 = this.generatePiece(p_228392_, $$9, p_228393_, p_228394_, p_228395_, p_228396_, p_228397_, p_228398_, p_228399_ + 1)) != null) {
                p_228393_.addPiece($$10);
                p_228392_.pendingChildren.add($$10);
            }
            return $$10;
        }

        @Nullable
        protected StructurePiece generateChildForward(StartPiece p_228402_, StructurePieceAccessor p_228403_, RandomSource p_228404_, int p_228405_, int p_228406_, boolean p_228407_) {
            Direction $$6 = this.getOrientation();
            if ($$6 != null) {
                switch ($$6) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_228402_, p_228403_, p_228404_, this.boundingBox.minX() + p_228405_, this.boundingBox.minY() + p_228406_, this.boundingBox.minZ() - 1, $$6, this.getGenDepth(), p_228407_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_228402_, p_228403_, p_228404_, this.boundingBox.minX() + p_228405_, this.boundingBox.minY() + p_228406_, this.boundingBox.maxZ() + 1, $$6, this.getGenDepth(), p_228407_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_228402_, p_228403_, p_228404_, this.boundingBox.minX() - 1, this.boundingBox.minY() + p_228406_, this.boundingBox.minZ() + p_228405_, $$6, this.getGenDepth(), p_228407_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_228402_, p_228403_, p_228404_, this.boundingBox.maxX() + 1, this.boundingBox.minY() + p_228406_, this.boundingBox.minZ() + p_228405_, $$6, this.getGenDepth(), p_228407_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateChildLeft(StartPiece p_228421_, StructurePieceAccessor p_228422_, RandomSource p_228423_, int p_228424_, int p_228425_, boolean p_228426_) {
            Direction $$6 = this.getOrientation();
            if ($$6 != null) {
                switch ($$6) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_228421_, p_228422_, p_228423_, this.boundingBox.minX() - 1, this.boundingBox.minY() + p_228424_, this.boundingBox.minZ() + p_228425_, Direction.WEST, this.getGenDepth(), p_228426_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_228421_, p_228422_, p_228423_, this.boundingBox.minX() - 1, this.boundingBox.minY() + p_228424_, this.boundingBox.minZ() + p_228425_, Direction.WEST, this.getGenDepth(), p_228426_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_228421_, p_228422_, p_228423_, this.boundingBox.minX() + p_228425_, this.boundingBox.minY() + p_228424_, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth(), p_228426_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_228421_, p_228422_, p_228423_, this.boundingBox.minX() + p_228425_, this.boundingBox.minY() + p_228424_, this.boundingBox.minZ() - 1, Direction.NORTH, this.getGenDepth(), p_228426_);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece generateChildRight(StartPiece p_228428_, StructurePieceAccessor p_228429_, RandomSource p_228430_, int p_228431_, int p_228432_, boolean p_228433_) {
            Direction $$6 = this.getOrientation();
            if ($$6 != null) {
                switch ($$6) {
                    case NORTH: {
                        return this.generateAndAddPiece(p_228428_, p_228429_, p_228430_, this.boundingBox.maxX() + 1, this.boundingBox.minY() + p_228431_, this.boundingBox.minZ() + p_228432_, Direction.EAST, this.getGenDepth(), p_228433_);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(p_228428_, p_228429_, p_228430_, this.boundingBox.maxX() + 1, this.boundingBox.minY() + p_228431_, this.boundingBox.minZ() + p_228432_, Direction.EAST, this.getGenDepth(), p_228433_);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(p_228428_, p_228429_, p_228430_, this.boundingBox.minX() + p_228432_, this.boundingBox.minY() + p_228431_, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth(), p_228433_);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(p_228428_, p_228429_, p_228430_, this.boundingBox.minX() + p_228432_, this.boundingBox.minY() + p_228431_, this.boundingBox.maxZ() + 1, Direction.SOUTH, this.getGenDepth(), p_228433_);
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(BoundingBox p_228387_) {
            return p_228387_ != null && p_228387_.minY() > 10;
        }
    }
}

