/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.SkyLightSectionStorage;
import org.jetbrains.annotations.VisibleForTesting;

public final class SkyLightEngine
extends LightEngine<SkyLightSectionStorage.SkyDataLayerStorageMap, SkyLightSectionStorage> {
    private static final long REMOVE_TOP_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.decreaseAllDirections(15);
    private static final long REMOVE_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.decreaseSkipOneDirection(15, Direction.UP);
    private static final long ADD_SKY_SOURCE_ENTRY = LightEngine.QueueEntry.increaseSkipOneDirection(15, false, Direction.UP);
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final ChunkSkyLightSources emptyChunkSources;

    public SkyLightEngine(LightChunkGetter p_75843_) {
        this(p_75843_, new SkyLightSectionStorage(p_75843_));
    }

    @VisibleForTesting
    protected SkyLightEngine(LightChunkGetter p_282215_, SkyLightSectionStorage p_282341_) {
        super(p_282215_, p_282341_);
        this.emptyChunkSources = new ChunkSkyLightSources(p_282215_.getLevel());
    }

    private static boolean isSourceLevel(int p_285004_) {
        return p_285004_ == 15;
    }

    private int getLowestSourceY(int p_285058_, int p_285191_, int p_285111_) {
        ChunkSkyLightSources $$3 = this.getChunkSources(SectionPos.blockToSectionCoord(p_285058_), SectionPos.blockToSectionCoord(p_285191_));
        if ($$3 == null) {
            return p_285111_;
        }
        return $$3.getLowestSourceY(SectionPos.sectionRelative(p_285058_), SectionPos.sectionRelative(p_285191_));
    }

    @Nullable
    private ChunkSkyLightSources getChunkSources(int p_285270_, int p_285307_) {
        LightChunk $$2 = this.chunkSource.getChunkForLighting(p_285270_, p_285307_);
        return $$2 != null ? $$2.getSkyLightSources() : null;
    }

    @Override
    protected void checkNode(long p_75859_) {
        boolean $$6;
        int $$5;
        int $$1 = BlockPos.getX(p_75859_);
        int $$2 = BlockPos.getY(p_75859_);
        int $$3 = BlockPos.getZ(p_75859_);
        long $$4 = SectionPos.blockToSection(p_75859_);
        int n = $$5 = ((SkyLightSectionStorage)this.storage).lightOnInSection($$4) ? this.getLowestSourceY($$1, $$3, Integer.MAX_VALUE) : Integer.MAX_VALUE;
        if ($$5 != Integer.MAX_VALUE) {
            this.updateSourcesInColumn($$1, $$3, $$5);
        }
        if (!((SkyLightSectionStorage)this.storage).storingLightForSection($$4)) {
            return;
        }
        boolean bl = $$6 = $$2 >= $$5;
        if ($$6) {
            this.enqueueDecrease(p_75859_, REMOVE_SKY_SOURCE_ENTRY);
            this.enqueueIncrease(p_75859_, ADD_SKY_SOURCE_ENTRY);
        } else {
            int $$7 = ((SkyLightSectionStorage)this.storage).getStoredLevel(p_75859_);
            if ($$7 > 0) {
                ((SkyLightSectionStorage)this.storage).setStoredLevel(p_75859_, 0);
                this.enqueueDecrease(p_75859_, LightEngine.QueueEntry.decreaseAllDirections($$7));
            } else {
                this.enqueueDecrease(p_75859_, PULL_LIGHT_IN_ENTRY);
            }
        }
    }

    private void updateSourcesInColumn(int p_285053_, int p_285140_, int p_285337_) {
        int $$3 = SectionPos.sectionToBlockCoord(((SkyLightSectionStorage)this.storage).getBottomSectionY());
        this.removeSourcesBelow(p_285053_, p_285140_, p_285337_, $$3);
        this.addSourcesAbove(p_285053_, p_285140_, p_285337_, $$3);
    }

    private void removeSourcesBelow(int p_285475_, int p_285138_, int p_285130_, int p_285112_) {
        if (p_285130_ <= p_285112_) {
            return;
        }
        int $$4 = SectionPos.blockToSectionCoord(p_285475_);
        int $$5 = SectionPos.blockToSectionCoord(p_285138_);
        int $$6 = p_285130_ - 1;
        int $$7 = SectionPos.blockToSectionCoord($$6);
        while (((SkyLightSectionStorage)this.storage).hasLightDataAtOrBelow($$7)) {
            if (((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.asLong($$4, $$7, $$5))) {
                int $$8 = SectionPos.sectionToBlockCoord($$7);
                int $$9 = $$8 + 15;
                for (int $$10 = Math.min($$9, $$6); $$10 >= $$8; --$$10) {
                    long $$11 = BlockPos.asLong(p_285475_, $$10, p_285138_);
                    if (!SkyLightEngine.isSourceLevel(((SkyLightSectionStorage)this.storage).getStoredLevel($$11))) {
                        return;
                    }
                    ((SkyLightSectionStorage)this.storage).setStoredLevel($$11, 0);
                    this.enqueueDecrease($$11, $$10 == p_285130_ - 1 ? REMOVE_TOP_SKY_SOURCE_ENTRY : REMOVE_SKY_SOURCE_ENTRY);
                }
            }
            --$$7;
        }
    }

    private void addSourcesAbove(int p_285241_, int p_285212_, int p_284972_, int p_285134_) {
        int $$4 = SectionPos.blockToSectionCoord(p_285241_);
        int $$5 = SectionPos.blockToSectionCoord(p_285212_);
        int $$6 = Math.max(Math.max(this.getLowestSourceY(p_285241_ - 1, p_285212_, Integer.MIN_VALUE), this.getLowestSourceY(p_285241_ + 1, p_285212_, Integer.MIN_VALUE)), Math.max(this.getLowestSourceY(p_285241_, p_285212_ - 1, Integer.MIN_VALUE), this.getLowestSourceY(p_285241_, p_285212_ + 1, Integer.MIN_VALUE)));
        int $$7 = Math.max(p_284972_, p_285134_);
        long $$8 = SectionPos.asLong($$4, SectionPos.blockToSectionCoord($$7), $$5);
        while (!((SkyLightSectionStorage)this.storage).isAboveData($$8)) {
            if (((SkyLightSectionStorage)this.storage).storingLightForSection($$8)) {
                int $$9 = SectionPos.sectionToBlockCoord(SectionPos.y($$8));
                int $$10 = $$9 + 15;
                for (int $$11 = Math.max($$9, $$7); $$11 <= $$10; ++$$11) {
                    long $$12 = BlockPos.asLong(p_285241_, $$11, p_285212_);
                    if (SkyLightEngine.isSourceLevel(((SkyLightSectionStorage)this.storage).getStoredLevel($$12))) {
                        return;
                    }
                    ((SkyLightSectionStorage)this.storage).setStoredLevel($$12, 15);
                    if ($$11 >= $$6 && $$11 != p_284972_) continue;
                    this.enqueueIncrease($$12, ADD_SKY_SOURCE_ENTRY);
                }
            }
            $$8 = SectionPos.offset($$8, Direction.UP);
        }
    }

    @Override
    protected void propagateIncrease(long p_285341_, long p_285204_, int p_285003_) {
        BlockState $$3 = null;
        int $$4 = this.countEmptySectionsBelowIfAtBorder(p_285341_);
        for (Direction $$5 : PROPAGATION_DIRECTIONS) {
            int $$7;
            int $$8;
            long $$6;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(p_285204_, $$5) || !((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection($$6 = BlockPos.offset(p_285341_, $$5))) || ($$8 = p_285003_ - 1) <= ($$7 = ((SkyLightSectionStorage)this.storage).getStoredLevel($$6))) continue;
            this.mutablePos.set($$6);
            BlockState $$9 = this.getState(this.mutablePos);
            int $$10 = p_285003_ - this.getOpacity($$9);
            if ($$10 <= $$7) continue;
            if ($$3 == null) {
                BlockState blockState = $$3 = LightEngine.QueueEntry.isFromEmptyShape(p_285204_) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(p_285341_));
            }
            if (this.shapeOccludes($$3, $$9, $$5)) continue;
            ((SkyLightSectionStorage)this.storage).setStoredLevel($$6, $$10);
            if ($$10 > 1) {
                this.enqueueIncrease($$6, LightEngine.QueueEntry.increaseSkipOneDirection($$10, SkyLightEngine.isEmptyShape($$9), $$5.getOpposite()));
            }
            this.propagateFromEmptySections($$6, $$5, $$10, true, $$4);
        }
    }

    @Override
    protected void propagateDecrease(long p_285015_, long p_285395_) {
        int $$2 = this.countEmptySectionsBelowIfAtBorder(p_285015_);
        int $$3 = LightEngine.QueueEntry.getFromLevel(p_285395_);
        for (Direction $$4 : PROPAGATION_DIRECTIONS) {
            int $$6;
            long $$5;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(p_285395_, $$4) || !((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection($$5 = BlockPos.offset(p_285015_, $$4))) || ($$6 = ((SkyLightSectionStorage)this.storage).getStoredLevel($$5)) == 0) continue;
            if ($$6 <= $$3 - 1) {
                ((SkyLightSectionStorage)this.storage).setStoredLevel($$5, 0);
                this.enqueueDecrease($$5, LightEngine.QueueEntry.decreaseSkipOneDirection($$6, $$4.getOpposite()));
                this.propagateFromEmptySections($$5, $$4, $$6, false, $$2);
                continue;
            }
            this.enqueueIncrease($$5, LightEngine.QueueEntry.increaseOnlyOneDirection($$6, false, $$4.getOpposite()));
        }
    }

    private int countEmptySectionsBelowIfAtBorder(long p_285356_) {
        int $$1 = BlockPos.getY(p_285356_);
        int $$2 = SectionPos.sectionRelative($$1);
        if ($$2 != 0) {
            return 0;
        }
        int $$3 = BlockPos.getX(p_285356_);
        int $$4 = BlockPos.getZ(p_285356_);
        int $$5 = SectionPos.sectionRelative($$3);
        int $$6 = SectionPos.sectionRelative($$4);
        if ($$5 == 0 || $$5 == 15 || $$6 == 0 || $$6 == 15) {
            int $$7 = SectionPos.blockToSectionCoord($$3);
            int $$8 = SectionPos.blockToSectionCoord($$1);
            int $$9 = SectionPos.blockToSectionCoord($$4);
            int $$10 = 0;
            while (!((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.asLong($$7, $$8 - $$10 - 1, $$9)) && ((SkyLightSectionStorage)this.storage).hasLightDataAtOrBelow($$8 - $$10 - 1)) {
                ++$$10;
            }
            return $$10;
        }
        return 0;
    }

    private void propagateFromEmptySections(long p_284965_, Direction p_285308_, int p_284977_, boolean p_285001_, int p_285052_) {
        if (p_285052_ == 0) {
            return;
        }
        int $$5 = BlockPos.getX(p_284965_);
        int $$6 = BlockPos.getZ(p_284965_);
        if (!SkyLightEngine.crossedSectionEdge(p_285308_, SectionPos.sectionRelative($$5), SectionPos.sectionRelative($$6))) {
            return;
        }
        int $$7 = BlockPos.getY(p_284965_);
        int $$8 = SectionPos.blockToSectionCoord($$5);
        int $$9 = SectionPos.blockToSectionCoord($$6);
        int $$10 = SectionPos.blockToSectionCoord($$7) - 1;
        int $$11 = $$10 - p_285052_ + 1;
        while ($$10 >= $$11) {
            if (!((SkyLightSectionStorage)this.storage).storingLightForSection(SectionPos.asLong($$8, $$10, $$9))) {
                --$$10;
                continue;
            }
            int $$12 = SectionPos.sectionToBlockCoord($$10);
            for (int $$13 = 15; $$13 >= 0; --$$13) {
                long $$14 = BlockPos.asLong($$5, $$12 + $$13, $$6);
                if (p_285001_) {
                    ((SkyLightSectionStorage)this.storage).setStoredLevel($$14, p_284977_);
                    if (p_284977_ <= 1) continue;
                    this.enqueueIncrease($$14, LightEngine.QueueEntry.increaseSkipOneDirection(p_284977_, true, p_285308_.getOpposite()));
                    continue;
                }
                ((SkyLightSectionStorage)this.storage).setStoredLevel($$14, 0);
                this.enqueueDecrease($$14, LightEngine.QueueEntry.decreaseSkipOneDirection(p_284977_, p_285308_.getOpposite()));
            }
            --$$10;
        }
    }

    private static boolean crossedSectionEdge(Direction p_285014_, int p_284991_, int p_285468_) {
        return switch (p_285014_) {
            case Direction.NORTH -> {
                if (p_285468_ == 15) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (p_285468_ == 0) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (p_284991_ == 15) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (p_284991_ == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void setLightEnabled(ChunkPos p_285459_, boolean p_285013_) {
        super.setLightEnabled(p_285459_, p_285013_);
        if (p_285013_) {
            ChunkSkyLightSources $$2 = Objects.requireNonNullElse(this.getChunkSources(p_285459_.x, p_285459_.z), this.emptyChunkSources);
            int $$3 = $$2.getHighestLowestSourceY() - 1;
            int $$4 = SectionPos.blockToSectionCoord($$3) + 1;
            long $$5 = SectionPos.getZeroNode(p_285459_.x, p_285459_.z);
            int $$6 = ((SkyLightSectionStorage)this.storage).getTopSectionY($$5);
            int $$7 = Math.max(((SkyLightSectionStorage)this.storage).getBottomSectionY(), $$4);
            for (int $$8 = $$6 - 1; $$8 >= $$7; --$$8) {
                DataLayer $$9 = ((SkyLightSectionStorage)this.storage).getDataLayerToWrite(SectionPos.asLong(p_285459_.x, $$8, p_285459_.z));
                if ($$9 == null || !$$9.isEmpty()) continue;
                $$9.fill(15);
            }
        }
    }

    @Override
    public void propagateLightSources(ChunkPos p_285333_) {
        long $$1 = SectionPos.getZeroNode(p_285333_.x, p_285333_.z);
        ((SkyLightSectionStorage)this.storage).setLightEnabled($$1, true);
        ChunkSkyLightSources $$2 = Objects.requireNonNullElse(this.getChunkSources(p_285333_.x, p_285333_.z), this.emptyChunkSources);
        ChunkSkyLightSources $$3 = Objects.requireNonNullElse(this.getChunkSources(p_285333_.x, p_285333_.z - 1), this.emptyChunkSources);
        ChunkSkyLightSources $$4 = Objects.requireNonNullElse(this.getChunkSources(p_285333_.x, p_285333_.z + 1), this.emptyChunkSources);
        ChunkSkyLightSources $$5 = Objects.requireNonNullElse(this.getChunkSources(p_285333_.x - 1, p_285333_.z), this.emptyChunkSources);
        ChunkSkyLightSources $$6 = Objects.requireNonNullElse(this.getChunkSources(p_285333_.x + 1, p_285333_.z), this.emptyChunkSources);
        int $$7 = ((SkyLightSectionStorage)this.storage).getTopSectionY($$1);
        int $$8 = ((SkyLightSectionStorage)this.storage).getBottomSectionY();
        int $$9 = SectionPos.sectionToBlockCoord(p_285333_.x);
        int $$10 = SectionPos.sectionToBlockCoord(p_285333_.z);
        for (int $$11 = $$7 - 1; $$11 >= $$8; --$$11) {
            long $$12 = SectionPos.asLong(p_285333_.x, $$11, p_285333_.z);
            DataLayer $$13 = ((SkyLightSectionStorage)this.storage).getDataLayerToWrite($$12);
            if ($$13 == null) continue;
            int $$14 = SectionPos.sectionToBlockCoord($$11);
            int $$15 = $$14 + 15;
            boolean $$16 = false;
            for (int $$17 = 0; $$17 < 16; ++$$17) {
                for (int $$18 = 0; $$18 < 16; ++$$18) {
                    int $$19 = $$2.getLowestSourceY($$18, $$17);
                    if ($$19 > $$15) continue;
                    int $$20 = $$17 == 0 ? $$3.getLowestSourceY($$18, 15) : $$2.getLowestSourceY($$18, $$17 - 1);
                    int $$21 = $$17 == 15 ? $$4.getLowestSourceY($$18, 0) : $$2.getLowestSourceY($$18, $$17 + 1);
                    int $$22 = $$18 == 0 ? $$5.getLowestSourceY(15, $$17) : $$2.getLowestSourceY($$18 - 1, $$17);
                    int $$23 = $$18 == 15 ? $$6.getLowestSourceY(0, $$17) : $$2.getLowestSourceY($$18 + 1, $$17);
                    int $$24 = Math.max(Math.max($$20, $$21), Math.max($$22, $$23));
                    for (int $$25 = $$15; $$25 >= Math.max($$14, $$19); --$$25) {
                        $$13.set($$18, SectionPos.sectionRelative($$25), $$17, 15);
                        if ($$25 != $$19 && $$25 >= $$24) continue;
                        long $$26 = BlockPos.asLong($$9 + $$18, $$25, $$10 + $$17);
                        this.enqueueIncrease($$26, LightEngine.QueueEntry.increaseSkySourceInDirections($$25 == $$19, $$25 < $$20, $$25 < $$21, $$25 < $$22, $$25 < $$23));
                    }
                    if ($$19 >= $$14) continue;
                    $$16 = true;
                }
            }
            if (!$$16) break;
        }
    }
}

