/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, Optional<SavedData>> cache = new HashMap<String, Optional<SavedData>>();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(Path p_362421_, DataFixer p_78150_, HolderLookup.Provider p_324180_) {
        this.fixerUpper = p_78150_;
        this.dataFolder = p_362421_;
        this.registries = p_324180_;
    }

    private Path getDataFile(String p_78157_) {
        return this.dataFolder.resolve(p_78157_ + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedData.Factory<T> p_294124_, String p_164864_) {
        T $$2 = this.get(p_294124_, p_164864_);
        if ($$2 != null) {
            return $$2;
        }
        SavedData $$3 = (SavedData)p_294124_.constructor().get();
        this.set(p_164864_, $$3);
        return (T)$$3;
    }

    @Nullable
    public <T extends SavedData> T get(SavedData.Factory<T> p_295091_, String p_164860_) {
        Optional<SavedData> $$2 = this.cache.get(p_164860_);
        if ($$2 == null) {
            $$2 = Optional.ofNullable(this.readSavedData(p_295091_.deserializer(), p_295091_.type(), p_164860_));
            this.cache.put(p_164860_, $$2);
        }
        return (T)((SavedData)$$2.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(BiFunction<CompoundTag, HolderLookup.Provider, T> p_324609_, DataFixTypes p_295832_, String p_164870_) {
        try {
            Path $$3 = this.getDataFile(p_164870_);
            if (Files.exists($$3, new LinkOption[0])) {
                CompoundTag $$4 = this.readTagFromDisk(p_164870_, p_295832_, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((SavedData)p_324609_.apply($$4.getCompound("data"), this.registries));
            }
        }
        catch (Exception $$5) {
            LOGGER.error("Error loading saved data: {}", (Object)p_164870_, (Object)$$5);
        }
        return null;
    }

    public void set(String p_164856_, SavedData p_164857_) {
        this.cache.put(p_164856_, Optional.of(p_164857_));
        p_164857_.setDirty();
    }

    /*
     * WARNING - void declaration
     */
    public CompoundTag readTagFromDisk(String p_78159_, DataFixTypes p_295038_, int p_78160_) throws IOException {
        try (InputStream $$3 = Files.newInputStream(this.getDataFile(p_78159_), new OpenOption[0]);){
            CompoundTag compoundTag;
            try (PushbackInputStream $$4 = new PushbackInputStream(new FastBufferedInputStream($$3), 2);){
                void $$8;
                if (this.isGzip($$4)) {
                    CompoundTag $$5 = NbtIo.readCompressed($$4, NbtAccounter.unlimitedHeap());
                } else {
                    try (DataInputStream $$6 = new DataInputStream($$4);){
                        CompoundTag $$7 = NbtIo.read($$6);
                    }
                }
                int $$9 = NbtUtils.getDataVersion((CompoundTag)$$8, 1343);
                compoundTag = p_295038_.update(this.fixerUpper, (CompoundTag)$$8, $$9, p_78160_);
            }
            return compoundTag;
        }
    }

    private boolean isGzip(PushbackInputStream p_78155_) throws IOException {
        int $$4;
        byte[] $$1 = new byte[2];
        boolean $$2 = false;
        int $$3 = p_78155_.read($$1, 0, 2);
        if ($$3 == 2 && ($$4 = ($$1[1] & 0xFF) << 8 | $$1[0] & 0xFF) == 35615) {
            $$2 = true;
        }
        if ($$3 != 0) {
            p_78155_.unread($$1, 0, $$3);
        }
        return $$2;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<Path, CompoundTag> $$0 = this.collectDirtyTagsToSave();
        if ($$0.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        this.pendingWriteFuture = this.pendingWriteFuture.thenCompose(p_360267_ -> CompletableFuture.allOf((CompletableFuture[])$$0.entrySet().stream().map(p_360262_ -> DimensionDataStorage.tryWriteAsync((Path)p_360262_.getKey(), (CompoundTag)p_360262_.getValue())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<Path, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap $$0 = new Object2ObjectArrayMap();
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$4((Map)$$0, arg_0, arg_1));
        return $$0;
    }

    private static CompletableFuture<Void> tryWriteAsync(Path p_364583_, CompoundTag p_363128_) {
        return CompletableFuture.runAsync(() -> {
            try {
                NbtIo.writeCompressed(p_363128_, p_364583_);
            }
            catch (IOException $$2) {
                LOGGER.error("Could not save data to {}", (Object)p_364583_.getFileName(), (Object)$$2);
            }
        }, Util.ioPool());
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$4(Map p_360263_, String p_360264_, Optional p_360265_) {
        p_360265_.filter(SavedData::isDirty).ifPresent(p_360261_ -> p_360263_.put(this.getDataFile(p_360264_), p_360261_.save(this.registries)));
    }
}

