/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();
    public static final String TAG_DATA = "Data";
    private static final PathMatcher NO_SYMLINKS_ALLOWED = p_294087_ -> false;
    public static final String ALLOWED_SYMLINKS_CONFIG_NAME = "allowed_symlinks.txt";
    private static final int UNCOMPRESSED_NBT_QUOTA = 0x6400000;
    private static final int DISK_SPACE_WARNING_THRESHOLD = 0x4000000;
    private final Path baseDir;
    private final Path backupDir;
    final DataFixer fixerUpper;
    private final DirectoryValidator worldDirValidator;

    public LevelStorageSource(Path p_289985_, Path p_289978_, DirectoryValidator p_289922_, DataFixer p_289940_) {
        this.fixerUpper = p_289940_;
        try {
            FileUtil.createDirectoriesSafe(p_289985_);
        }
        catch (IOException $$4) {
            throw new UncheckedIOException($$4);
        }
        this.baseDir = p_289985_;
        this.backupDir = p_289978_;
        this.worldDirValidator = p_289922_;
    }

    public static DirectoryValidator parseValidator(Path p_289968_) {
        if (Files.exists(p_289968_, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader $$1 = Files.newBufferedReader(p_289968_);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.readPlain($$1));
                    if ($$1 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if ($$1 != null) {
                            try {
                                $$1.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception $$2) {
                        LOGGER.error("Failed to parse {}, disallowing all symbolic links", (Object)ALLOWED_SYMLINKS_CONFIG_NAME, (Object)$$2);
                    }
                }
                $$1.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(NO_SYMLINKS_ALLOWED);
    }

    public static LevelStorageSource createDefault(Path p_78243_) {
        DirectoryValidator $$1 = LevelStorageSource.parseValidator(p_78243_.resolve(ALLOWED_SYMLINKS_CONFIG_NAME));
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), $$1, DataFixers.getDataFixer());
    }

    public static WorldDataConfiguration readDataConfig(Dynamic<?> p_250884_) {
        return WorldDataConfiguration.CODEC.parse(p_250884_).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(WorldDataConfiguration.DEFAULT);
    }

    public static WorldLoader.PackConfig getPackConfig(Dynamic<?> p_307282_, PackRepository p_307421_, boolean p_307393_) {
        return new WorldLoader.PackConfig(p_307421_, LevelStorageSource.readDataConfig(p_307282_), p_307393_, false);
    }

    public static LevelDataAndDimensions getLevelDataAndDimensions(Dynamic<?> p_307313_, WorldDataConfiguration p_307486_, Registry<LevelStem> p_307597_, HolderLookup.Provider p_362036_) {
        Dynamic<?> $$4 = RegistryOps.injectRegistryContext(p_307313_, p_362036_);
        Dynamic $$5 = $$4.get("WorldGenSettings").orElseEmptyMap();
        WorldGenSettings $$6 = (WorldGenSettings)WorldGenSettings.CODEC.parse($$5).getOrThrow();
        LevelSettings $$7 = LevelSettings.parse($$4, p_307486_);
        WorldDimensions.Complete $$8 = $$6.dimensions().bake(p_307597_);
        Lifecycle $$9 = $$8.lifecycle().add(p_362036_.allRegistriesLifecycle());
        PrimaryLevelData $$10 = PrimaryLevelData.parse($$4, $$7, $$8.specialWorldProperty(), $$6.options(), $$9);
        return new LevelDataAndDimensions($$10, $$8);
    }

    public String getName() {
        return "Anvil";
    }

    public LevelCandidates findLevelCandidates() throws LevelStorageException {
        LevelCandidates levelCandidates;
        block9: {
            if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
                throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
            }
            Stream<Path> $$0 = Files.list(this.baseDir);
            try {
                List<LevelDirectory> $$1 = $$0.filter(p_230839_ -> Files.isDirectory(p_230839_, new LinkOption[0])).map(LevelDirectory::new).filter(p_230835_ -> Files.isRegularFile(p_230835_.dataFile(), new LinkOption[0]) || Files.isRegularFile(p_230835_.oldDataFile(), new LinkOption[0])).toList();
                levelCandidates = new LevelCandidates($$1);
                if ($$0 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if ($$0 != null) {
                        try {
                            $$0.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException $$2) {
                    throw new LevelStorageException(Component.translatable("selectWorld.load_folder_access"));
                }
            }
            $$0.close();
        }
        return levelCandidates;
    }

    public CompletableFuture<List<LevelSummary>> loadLevelSummaries(LevelCandidates p_230814_) {
        ArrayList<CompletableFuture<LevelSummary>> $$1 = new ArrayList<CompletableFuture<LevelSummary>>(p_230814_.levels.size());
        for (LevelDirectory $$2 : p_230814_.levels) {
            $$1.add(CompletableFuture.supplyAsync(() -> {
                try {
                    boolean $$1 = DirectoryLock.isLocked($$2.path());
                }
                catch (Exception $$2) {
                    LOGGER.warn("Failed to read {} lock", (Object)$$2.path(), (Object)$$2);
                    return null;
                }
                try {
                    void $$3;
                    return this.readLevelSummary($$2, (boolean)$$3);
                }
                catch (OutOfMemoryError $$4) {
                    MemoryReserve.release();
                    String $$5 = "Ran out of memory trying to read summary of world folder \"" + $$2.directoryName() + "\"";
                    LOGGER.error(LogUtils.FATAL_MARKER, $$5);
                    OutOfMemoryError $$6 = new OutOfMemoryError("Ran out of memory reading level data");
                    $$6.initCause($$4);
                    CrashReport $$7 = CrashReport.forThrowable($$6, $$5);
                    CrashReportCategory $$8 = $$7.addCategory("World details");
                    $$8.setDetail("Folder Name", $$2.directoryName());
                    try {
                        long $$9 = Files.size($$2.dataFile());
                        $$8.setDetail("level.dat size", $$9);
                    }
                    catch (IOException $$10) {
                        $$8.setDetailError("level.dat size", $$10);
                    }
                    throw new ReportedException($$7);
                }
            }, Util.backgroundExecutor().forName("loadLevelSummaries")));
        }
        return Util.sequenceFailFastAndCancel($$1).thenApply(p_230832_ -> p_230832_.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int getStorageVersion() {
        return 19133;
    }

    static CompoundTag readLevelDataTagRaw(Path p_307408_) throws IOException {
        return NbtIo.readCompressed(p_307408_, NbtAccounter.create(0x6400000L));
    }

    static Dynamic<?> readLevelDataTagFixed(Path p_307371_, DataFixer p_307468_) throws IOException {
        CompoundTag $$2 = LevelStorageSource.readLevelDataTagRaw(p_307371_);
        CompoundTag $$3 = $$2.getCompound(TAG_DATA);
        int $$4 = NbtUtils.getDataVersion($$3, -1);
        Dynamic $$5 = DataFixTypes.LEVEL.updateToCurrentVersion(p_307468_, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$3), $$4);
        $$5 = $$5.update("Player", p_341581_ -> DataFixTypes.PLAYER.updateToCurrentVersion(p_307468_, p_341581_, $$4));
        $$5 = $$5.update("WorldGenSettings", p_341584_ -> DataFixTypes.WORLD_GEN_SETTINGS.updateToCurrentVersion(p_307468_, p_341584_, $$4));
        return $$5;
    }

    private LevelSummary readLevelSummary(LevelDirectory p_307237_, boolean p_307368_) {
        Path $$2 = p_307237_.dataFile();
        if (Files.exists($$2, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> $$3;
                if (Files.isSymbolicLink($$2) && !($$3 = this.worldDirValidator.validateSymlink($$2)).isEmpty()) {
                    LOGGER.warn("{}", (Object)ContentValidationException.getMessage($$2, $$3));
                    return new LevelSummary.SymlinkLevelSummary(p_307237_.directoryName(), p_307237_.iconFile());
                }
                Tag $$4 = LevelStorageSource.readLightweightData($$2);
                if ($$4 instanceof CompoundTag) {
                    CompoundTag $$5 = (CompoundTag)$$4;
                    CompoundTag $$6 = $$5.getCompound(TAG_DATA);
                    int $$7 = NbtUtils.getDataVersion($$6, -1);
                    Dynamic $$8 = DataFixTypes.LEVEL.updateToCurrentVersion(this.fixerUpper, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$6), $$7);
                    return this.makeLevelSummary($$8, p_307237_, p_307368_);
                }
                LOGGER.warn("Invalid root tag in {}", (Object)$$2);
            }
            catch (Exception $$9) {
                LOGGER.error("Exception reading {}", (Object)$$2, (Object)$$9);
            }
        }
        return new LevelSummary.CorruptedLevelSummary(p_307237_.directoryName(), p_307237_.iconFile(), LevelStorageSource.getFileModificationTime(p_307237_));
    }

    private static long getFileModificationTime(LevelDirectory p_307642_) {
        Instant $$1 = LevelStorageSource.getFileModificationTime(p_307642_.dataFile());
        if ($$1 == null) {
            $$1 = LevelStorageSource.getFileModificationTime(p_307642_.oldDataFile());
        }
        return $$1 == null ? -1L : $$1.toEpochMilli();
    }

    @Nullable
    static Instant getFileModificationTime(Path p_307529_) {
        try {
            return Files.getLastModifiedTime(p_307529_, new LinkOption[0]).toInstant();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    LevelSummary makeLevelSummary(Dynamic<?> p_307300_, LevelDirectory p_307426_, boolean p_307364_) {
        LevelVersion $$3 = LevelVersion.parse(p_307300_);
        int $$4 = $$3.levelDataVersion();
        if ($$4 == 19132 || $$4 == 19133) {
            boolean $$5 = $$4 != this.getStorageVersion();
            Path $$6 = p_307426_.iconFile();
            WorldDataConfiguration $$7 = LevelStorageSource.readDataConfig(p_307300_);
            LevelSettings $$8 = LevelSettings.parse(p_307300_, $$7);
            FeatureFlagSet $$9 = LevelStorageSource.parseFeatureFlagsFromSummary(p_307300_);
            boolean $$10 = FeatureFlags.isExperimental($$9);
            return new LevelSummary($$8, $$3, p_307426_.directoryName(), $$5, p_307364_, $$10, $$6);
        }
        throw new NbtFormatException("Unknown data version: " + Integer.toHexString($$4));
    }

    private static FeatureFlagSet parseFeatureFlagsFromSummary(Dynamic<?> p_249466_) {
        Set<ResourceLocation> $$1 = p_249466_.get("enabled_features").asStream().flatMap(p_338115_ -> p_338115_.asString().result().map(ResourceLocation::tryParse).stream()).collect(Collectors.toSet());
        return FeatureFlags.REGISTRY.fromNames($$1, p_248503_ -> {});
    }

    @Nullable
    private static Tag readLightweightData(Path p_230837_) throws IOException {
        SkipFields $$1 = new SkipFields(new FieldSelector(TAG_DATA, CompoundTag.TYPE, "Player"), new FieldSelector(TAG_DATA, CompoundTag.TYPE, "WorldGenSettings"));
        NbtIo.parseCompressed(p_230837_, (StreamTagVisitor)$$1, NbtAccounter.create(0x6400000L));
        return $$1.getResult();
    }

    public boolean isNewLevelIdAcceptable(String p_78241_) {
        try {
            Path $$1 = this.getLevelPath(p_78241_);
            Files.createDirectory($$1, new FileAttribute[0]);
            Files.deleteIfExists($$1);
            return true;
        }
        catch (IOException $$2) {
            return false;
        }
    }

    public boolean levelExists(String p_78256_) {
        try {
            return Files.isDirectory(this.getLevelPath(p_78256_), new LinkOption[0]);
        }
        catch (InvalidPathException $$1) {
            return false;
        }
    }

    public Path getLevelPath(String p_289974_) {
        return this.baseDir.resolve(p_289974_);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBackupPath() {
        return this.backupDir;
    }

    public LevelStorageAccess validateAndCreateAccess(String p_289980_) throws IOException, ContentValidationException {
        Path $$1 = this.getLevelPath(p_289980_);
        List<ForbiddenSymlinkInfo> $$2 = this.worldDirValidator.validateDirectory($$1, true);
        if (!$$2.isEmpty()) {
            throw new ContentValidationException($$1, $$2);
        }
        return new LevelStorageAccess(p_289980_, $$1);
    }

    public LevelStorageAccess createAccess(String p_78261_) throws IOException {
        Path $$1 = this.getLevelPath(p_78261_);
        return new LevelStorageAccess(p_78261_, $$1);
    }

    public DirectoryValidator getWorldDirValidator() {
        return this.worldDirValidator;
    }

    public record LevelCandidates(List<LevelDirectory> levels) implements Iterable<LevelDirectory>
    {
        public boolean isEmpty() {
            return this.levels.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.levels.iterator();
        }
    }

    public record LevelDirectory(Path path) {
        public String directoryName() {
            return this.path.getFileName().toString();
        }

        public Path dataFile() {
            return this.resourcePath(LevelResource.LEVEL_DATA_FILE);
        }

        public Path oldDataFile() {
            return this.resourcePath(LevelResource.OLD_LEVEL_DATA_FILE);
        }

        public Path corruptedDataFile(LocalDateTime p_230857_) {
            return this.path.resolve(LevelResource.LEVEL_DATA_FILE.getId() + "_corrupted_" + p_230857_.format(FORMATTER));
        }

        public Path rawDataFile(LocalDateTime p_307373_) {
            return this.path.resolve(LevelResource.LEVEL_DATA_FILE.getId() + "_raw_" + p_307373_.format(FORMATTER));
        }

        public Path iconFile() {
            return this.resourcePath(LevelResource.ICON_FILE);
        }

        public Path lockFile() {
            return this.resourcePath(LevelResource.LOCK_FILE);
        }

        public Path resourcePath(LevelResource p_230855_) {
            return this.path.resolve(p_230855_.getId());
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock lock;
        final LevelDirectory levelDirectory;
        private final String levelId;
        private final Map<LevelResource, Path> resources = Maps.newHashMap();

        LevelStorageAccess(String p_289967_, Path p_289988_) throws IOException {
            this.levelId = p_289967_;
            this.levelDirectory = new LevelDirectory(p_289988_);
            this.lock = DirectoryLock.create(p_289988_);
        }

        public long estimateDiskSpace() {
            try {
                return Files.getFileStore(this.levelDirectory.path).getUsableSpace();
            }
            catch (Exception $$0) {
                return Long.MAX_VALUE;
            }
        }

        public boolean checkForLowDiskSpace() {
            return this.estimateDiskSpace() < 0x4000000L;
        }

        public void safeClose() {
            try {
                this.close();
            }
            catch (IOException $$0) {
                LOGGER.warn("Failed to unlock access to level {}", (Object)this.getLevelId(), (Object)$$0);
            }
        }

        public LevelStorageSource parent() {
            return LevelStorageSource.this;
        }

        public LevelDirectory getLevelDirectory() {
            return this.levelDirectory;
        }

        public String getLevelId() {
            return this.levelId;
        }

        public Path getLevelPath(LevelResource p_78284_) {
            return this.resources.computeIfAbsent(p_78284_, this.levelDirectory::resourcePath);
        }

        public Path getDimensionPath(ResourceKey<Level> p_197395_) {
            return DimensionType.getStorageFolder(p_197395_, this.levelDirectory.path());
        }

        private void checkLock() {
            if (!this.lock.isValid()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage createPlayerStorage() {
            this.checkLock();
            return new PlayerDataStorage(this, LevelStorageSource.this.fixerUpper);
        }

        public LevelSummary getSummary(Dynamic<?> p_307314_) {
            this.checkLock();
            return LevelStorageSource.this.makeLevelSummary(p_307314_, this.levelDirectory, false);
        }

        public Dynamic<?> getDataTag() throws IOException {
            return this.getDataTag(false);
        }

        public Dynamic<?> getDataTagFallback() throws IOException {
            return this.getDataTag(true);
        }

        private Dynamic<?> getDataTag(boolean p_307503_) throws IOException {
            this.checkLock();
            return LevelStorageSource.readLevelDataTagFixed(p_307503_ ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile(), LevelStorageSource.this.fixerUpper);
        }

        public void saveDataTag(RegistryAccess p_78288_, WorldData p_78289_) {
            this.saveDataTag(p_78288_, p_78289_, null);
        }

        public void saveDataTag(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            CompoundTag $$3 = p_78292_.createTag(p_78291_, p_78293_);
            CompoundTag $$4 = new CompoundTag();
            $$4.put(LevelStorageSource.TAG_DATA, $$3);
            this.saveLevelData($$4);
        }

        private void saveLevelData(CompoundTag p_307262_) {
            Path $$1 = this.levelDirectory.path();
            try {
                Path $$2 = Files.createTempFile($$1, "level", ".dat", new FileAttribute[0]);
                NbtIo.writeCompressed(p_307262_, $$2);
                Path $$3 = this.levelDirectory.oldDataFile();
                Path $$4 = this.levelDirectory.dataFile();
                Util.safeReplaceFile($$4, $$2, $$3);
            }
            catch (Exception $$5) {
                LOGGER.error("Failed to save level {}", (Object)$$1, (Object)$$5);
            }
        }

        public Optional<Path> getIconFile() {
            if (!this.lock.isValid()) {
                return Optional.empty();
            }
            return Optional.of(this.levelDirectory.iconFile());
        }

        public void deleteLevel() throws IOException {
            this.checkLock();
            final Path $$0 = this.levelDirectory.lockFile();
            LOGGER.info("Deleting level {}", (Object)this.levelId);
            for (int $$1 = 1; $$1 <= 5; ++$$1) {
                LOGGER.info("Attempt {}...", (Object)$$1);
                try {
                    Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals($$0)) {
                                LOGGER.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, @Nullable IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.levelDirectory.path())) {
                                LevelStorageAccess.this.lock.close();
                                Files.deleteIfExists($$0);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, @Nullable IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException $$2) {
                    if ($$1 < 5) {
                        LOGGER.warn("Failed to delete {}", (Object)this.levelDirectory.path(), (Object)$$2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw $$2;
                }
            }
        }

        public void renameLevel(String p_78298_) throws IOException {
            this.modifyLevelDataWithoutDatafix(p_307270_ -> p_307270_.putString("LevelName", p_78298_.trim()));
        }

        public void renameAndDropPlayer(String p_307319_) throws IOException {
            this.modifyLevelDataWithoutDatafix(p_307287_ -> {
                p_307287_.putString("LevelName", p_307319_.trim());
                p_307287_.remove("Player");
            });
        }

        private void modifyLevelDataWithoutDatafix(Consumer<CompoundTag> p_307346_) throws IOException {
            this.checkLock();
            CompoundTag $$1 = LevelStorageSource.readLevelDataTagRaw(this.levelDirectory.dataFile());
            p_307346_.accept($$1.getCompound(LevelStorageSource.TAG_DATA));
            this.saveLevelData($$1);
        }

        public long makeWorldBackup() throws IOException {
            this.checkLock();
            String $$0 = LocalDateTime.now().format(FORMATTER) + "_" + this.levelId;
            Path $$1 = LevelStorageSource.this.getBackupPath();
            try {
                FileUtil.createDirectoriesSafe($$1);
            }
            catch (IOException $$2) {
                throw new RuntimeException($$2);
            }
            Path $$3 = $$1.resolve(FileUtil.findAvailableName($$1, $$0, ".zip"));
            try (final ZipOutputStream $$4 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream($$3, new OpenOption[0])));){
                final Path $$5 = Paths.get(this.levelId, new String[0]);
                Files.walkFileTree(this.levelDirectory.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String $$2 = $$5.resolve(LevelStorageAccess.this.levelDirectory.path().relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry $$3 = new ZipEntry($$2);
                        $$4.putNextEntry($$3);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)$$4);
                        $$4.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size($$3);
        }

        public boolean hasWorldData() {
            return Files.exists(this.levelDirectory.dataFile(), new LinkOption[0]) || Files.exists(this.levelDirectory.oldDataFile(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.lock.close();
        }

        public boolean restoreLevelDataFromOld() {
            return Util.safeReplaceOrMoveFile(this.levelDirectory.dataFile(), this.levelDirectory.oldDataFile(), this.levelDirectory.corruptedDataFile(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant getFileModificationTime(boolean p_307470_) {
            return LevelStorageSource.getFileModificationTime(p_307470_ ? this.levelDirectory.oldDataFile() : this.levelDirectory.dataFile());
        }
    }
}

