/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;

public class PlayerDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess p_78430_, DataFixer p_78431_) {
        this.fixerUpper = p_78431_;
        this.playerDir = p_78430_.getLevelPath(LevelResource.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(Player p_78434_) {
        try {
            CompoundTag $$1 = p_78434_.saveWithoutId(new CompoundTag());
            Path $$2 = this.playerDir.toPath();
            Path $$3 = Files.createTempFile($$2, p_78434_.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            NbtIo.writeCompressed($$1, $$3);
            Path $$4 = $$2.resolve(p_78434_.getStringUUID() + ".dat");
            Path $$5 = $$2.resolve(p_78434_.getStringUUID() + ".dat_old");
            Util.safeReplaceFile($$4, $$3, $$5);
        }
        catch (Exception $$6) {
            LOGGER.warn("Failed to save player data for {}", (Object)p_78434_.getName().getString());
        }
    }

    private void backup(Player p_316529_, String p_316776_) {
        Path $$2 = this.playerDir.toPath();
        Path $$3 = $$2.resolve(p_316529_.getStringUUID() + p_316776_);
        Path $$4 = $$2.resolve(p_316529_.getStringUUID() + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + p_316776_);
        if (!Files.isRegularFile($$3, new LinkOption[0])) {
            return;
        }
        try {
            Files.copy($$3, $$4, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception $$5) {
            LOGGER.warn("Failed to copy the player.dat file for {}", (Object)p_316529_.getName().getString(), (Object)$$5);
        }
    }

    private Optional<CompoundTag> load(Player p_316534_, String p_316666_) {
        File $$2 = new File(this.playerDir, p_316534_.getStringUUID() + p_316666_);
        if ($$2.exists() && $$2.isFile()) {
            try {
                return Optional.of(NbtIo.readCompressed($$2.toPath(), NbtAccounter.unlimitedHeap()));
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to load player data for {}", (Object)p_316534_.getName().getString());
            }
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> load(Player p_78436_) {
        Optional<CompoundTag> $$1 = this.load(p_78436_, ".dat");
        if ($$1.isEmpty()) {
            this.backup(p_78436_, ".dat");
        }
        return $$1.or(() -> this.load(p_78436_, ".dat_old")).map(p_316252_ -> {
            int $$2 = NbtUtils.getDataVersion(p_316252_, -1);
            p_316252_ = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (CompoundTag)p_316252_, $$2);
            p_78436_.load((CompoundTag)p_316252_);
            return p_316252_;
        });
    }
}

