/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootTable EMPTY = new LootTable(LootContextParamSets.EMPTY, Optional.empty(), List.of(), List.of());
    public static final ContextKeySet DEFAULT_PARAM_SET = LootContextParamSets.ALL_PARAMS;
    public static final long RANDOMIZE_SEED = 0L;
    public static final Codec<LootTable> DIRECT_CODEC = RecordCodecBuilder.create(p_380905_ -> p_380905_.group((App)LootContextParamSets.CODEC.lenientOptionalFieldOf("type", (Object)DEFAULT_PARAM_SET).forGetter(p_380906_ -> p_380906_.paramSet), (App)ResourceLocation.CODEC.optionalFieldOf("random_sequence").forGetter(p_297998_ -> p_297998_.randomSequence), (App)LootPool.CODEC.listOf().optionalFieldOf("pools", List.of()).forGetter(p_298002_ -> p_298002_.pools), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(p_298000_ -> p_298000_.functions)).apply((Applicative)p_380905_, LootTable::new));
    public static final Codec<Holder<LootTable>> CODEC = RegistryFileCodec.create(Registries.LOOT_TABLE, DIRECT_CODEC);
    private final ContextKeySet paramSet;
    private final Optional<ResourceLocation> randomSequence;
    private final List<LootPool> pools;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;

    LootTable(ContextKeySet p_380952_, Optional<ResourceLocation> p_299055_, List<LootPool> p_298390_, List<LootItemFunction> p_298775_) {
        this.paramSet = p_380952_;
        this.randomSequence = p_299055_;
        this.pools = p_298390_;
        this.functions = p_298775_;
        this.compositeFunction = LootItemFunctions.compose(p_298775_);
    }

    public static Consumer<ItemStack> createStackSplitter(ServerLevel p_287765_, Consumer<ItemStack> p_251308_) {
        return p_287570_ -> {
            if (!p_287570_.isItemEnabled(p_287765_.enabledFeatures())) {
                return;
            }
            if (p_287570_.getCount() < p_287570_.getMaxStackSize()) {
                p_251308_.accept((ItemStack)p_287570_);
            } else {
                ItemStack $$4;
                for (int $$3 = p_287570_.getCount(); $$3 > 0; $$3 -= $$4.getCount()) {
                    $$4 = p_287570_.copyWithCount(Math.min(p_287570_.getMaxStackSize(), $$3));
                    p_251308_.accept($$4);
                }
            }
        };
    }

    public void getRandomItemsRaw(LootParams p_287669_, Consumer<ItemStack> p_287781_) {
        this.getRandomItemsRaw(new LootContext.Builder(p_287669_).create(this.randomSequence), p_287781_);
    }

    public void getRandomItemsRaw(LootContext p_79132_, Consumer<ItemStack> p_79133_) {
        LootContext.VisitedEntry<LootTable> $$2 = LootContext.createVisitedEntry(this);
        if (p_79132_.pushVisitedElement($$2)) {
            Consumer<ItemStack> $$3 = LootItemFunction.decorate(this.compositeFunction, p_79133_, p_79132_);
            for (LootPool $$4 : this.pools) {
                $$4.addRandomItems($$3, p_79132_);
            }
            p_79132_.popVisitedElement($$2);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
    }

    public void getRandomItems(LootParams p_287748_, long p_287729_, Consumer<ItemStack> p_287583_) {
        this.getRandomItemsRaw(new LootContext.Builder(p_287748_).withOptionalRandomSeed(p_287729_).create(this.randomSequence), LootTable.createStackSplitter(p_287748_.getLevel(), p_287583_));
    }

    public void getRandomItems(LootParams p_287704_, Consumer<ItemStack> p_287617_) {
        this.getRandomItemsRaw(p_287704_, LootTable.createStackSplitter(p_287704_.getLevel(), p_287617_));
    }

    public void getRandomItems(LootContext p_79149_, Consumer<ItemStack> p_79150_) {
        this.getRandomItemsRaw(p_79149_, LootTable.createStackSplitter(p_79149_.getLevel(), p_79150_));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams p_347545_, RandomSource p_347680_) {
        return this.getRandomItems(new LootContext.Builder(p_347545_).withOptionalRandomSource(p_347680_).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams p_287574_, long p_287773_) {
        return this.getRandomItems(new LootContext.Builder(p_287574_).withOptionalRandomSeed(p_287773_).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams p_287616_) {
        return this.getRandomItems(new LootContext.Builder(p_287616_).create(this.randomSequence));
    }

    private ObjectArrayList<ItemStack> getRandomItems(LootContext p_230923_) {
        ObjectArrayList $$1 = new ObjectArrayList();
        this.getRandomItems(p_230923_, arg_0 -> ((ObjectArrayList)$$1).add(arg_0));
        return $$1;
    }

    public ContextKeySet getParamSet() {
        return this.paramSet;
    }

    public void validate(ValidationContext p_79137_) {
        for (int $$1 = 0; $$1 < this.pools.size(); ++$$1) {
            this.pools.get($$1).validate(p_79137_.forChild(".pools[" + $$1 + "]"));
        }
        for (int $$2 = 0; $$2 < this.functions.size(); ++$$2) {
            this.functions.get($$2).validate(p_79137_.forChild(".functions[" + $$2 + "]"));
        }
    }

    public void fill(Container p_287662_, LootParams p_287743_, long p_287585_) {
        LootContext $$3 = new LootContext.Builder(p_287743_).withOptionalRandomSeed(p_287585_).create(this.randomSequence);
        ObjectArrayList<ItemStack> $$4 = this.getRandomItems($$3);
        RandomSource $$5 = $$3.getRandom();
        List<Integer> $$6 = this.getAvailableSlots(p_287662_, $$5);
        this.shuffleAndSplitItems($$4, $$6.size(), $$5);
        for (ItemStack $$7 : $$4) {
            if ($$6.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if ($$7.isEmpty()) {
                p_287662_.setItem($$6.remove($$6.size() - 1), ItemStack.EMPTY);
                continue;
            }
            p_287662_.setItem($$6.remove($$6.size() - 1), $$7);
        }
    }

    private void shuffleAndSplitItems(ObjectArrayList<ItemStack> p_230925_, int p_230926_, RandomSource p_230927_) {
        ArrayList $$3 = Lists.newArrayList();
        ObjectListIterator $$4 = p_230925_.iterator();
        while ($$4.hasNext()) {
            ItemStack $$5 = (ItemStack)$$4.next();
            if ($$5.isEmpty()) {
                $$4.remove();
                continue;
            }
            if ($$5.getCount() <= 1) continue;
            $$3.add($$5);
            $$4.remove();
        }
        while (p_230926_ - p_230925_.size() - $$3.size() > 0 && !$$3.isEmpty()) {
            ItemStack $$6 = (ItemStack)$$3.remove(Mth.nextInt(p_230927_, 0, $$3.size() - 1));
            int $$7 = Mth.nextInt(p_230927_, 1, $$6.getCount() / 2);
            ItemStack $$8 = $$6.split($$7);
            if ($$6.getCount() > 1 && p_230927_.nextBoolean()) {
                $$3.add($$6);
            } else {
                p_230925_.add((Object)$$6);
            }
            if ($$8.getCount() > 1 && p_230927_.nextBoolean()) {
                $$3.add($$8);
                continue;
            }
            p_230925_.add((Object)$$8);
        }
        p_230925_.addAll((Collection)$$3);
        Util.shuffle(p_230925_, p_230927_);
    }

    private List<Integer> getAvailableSlots(Container p_230920_, RandomSource p_230921_) {
        ObjectArrayList $$2 = new ObjectArrayList();
        for (int $$3 = 0; $$3 < p_230920_.getContainerSize(); ++$$3) {
            if (!p_230920_.getItem($$3).isEmpty()) continue;
            $$2.add((Object)$$3);
        }
        Util.shuffle($$2, p_230921_);
        return $$2;
    }

    public static Builder lootTable() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPool> pools = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private ContextKeySet paramSet = DEFAULT_PARAM_SET;
        private Optional<ResourceLocation> randomSequence = Optional.empty();

        public Builder withPool(LootPool.Builder p_79162_) {
            this.pools.add((Object)p_79162_.build());
            return this;
        }

        public Builder setParamSet(ContextKeySet p_381150_) {
            this.paramSet = p_381150_;
            return this;
        }

        public Builder setRandomSequence(ResourceLocation p_287667_) {
            this.randomSequence = Optional.of(p_287667_);
            return this;
        }

        @Override
        public Builder apply(LootItemFunction.Builder p_79164_) {
            this.functions.add((Object)p_79164_.build());
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public LootTable build() {
            return new LootTable(this.paramSet, this.randomSequence, (List<LootPool>)this.pools.build(), (List<LootItemFunction>)this.functions.build());
        }

        @Override
        public /* synthetic */ FunctionUserBuilder unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ FunctionUserBuilder apply(LootItemFunction.Builder builder) {
            return this.apply(builder);
        }
    }
}

