/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class SetAttributesFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetAttributesFunction> CODEC = RecordCodecBuilder.mapCodec(p_347439_ -> SetAttributesFunction.commonFields(p_347439_).and(p_347439_.group((App)Modifier.CODEC.listOf().fieldOf("modifiers").forGetter(p_298099_ -> p_298099_.modifiers), (App)Codec.BOOL.optionalFieldOf("replace", (Object)true).forGetter(p_339576_ -> p_339576_.replace))).apply((Applicative)p_347439_, SetAttributesFunction::new));
    private final List<Modifier> modifiers;
    private final boolean replace;

    SetAttributesFunction(List<LootItemCondition> p_80834_, List<Modifier> p_298646_, boolean p_339689_) {
        super(p_80834_);
        this.modifiers = List.copyOf(p_298646_);
        this.replace = p_339689_;
    }

    public LootItemFunctionType<SetAttributesFunction> getType() {
        return LootItemFunctions.SET_ATTRIBUTES;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return (Set)this.modifiers.stream().flatMap(p_279080_ -> p_279080_.amount.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack p_80840_, LootContext p_80841_) {
        if (this.replace) {
            p_80840_.set(DataComponents.ATTRIBUTE_MODIFIERS, this.updateModifiers(p_80841_, ItemAttributeModifiers.EMPTY));
        } else {
            p_80840_.update(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY, p_371180_ -> this.updateModifiers(p_80841_, (ItemAttributeModifiers)p_371180_));
        }
        return p_80840_;
    }

    private ItemAttributeModifiers updateModifiers(LootContext p_339627_, ItemAttributeModifiers p_339590_) {
        RandomSource $$2 = p_339627_.getRandom();
        for (Modifier $$3 : this.modifiers) {
            EquipmentSlotGroup $$4 = Util.getRandom($$3.slots, $$2);
            p_339590_ = p_339590_.withModifierAdded($$3.attribute, new AttributeModifier($$3.id, $$3.amount.getFloat(p_339627_), $$3.operation), $$4);
        }
        return p_339590_;
    }

    public static ModifierBuilder modifier(ResourceLocation p_350454_, Holder<Attribute> p_298306_, AttributeModifier.Operation p_165238_, NumberProvider p_165239_) {
        return new ModifierBuilder(p_350454_, p_298306_, p_165238_, p_165239_);
    }

    public static Builder setAttributes() {
        return new Builder();
    }

    record Modifier(ResourceLocation id, Holder<Attribute> attribute, AttributeModifier.Operation operation, NumberProvider amount, List<EquipmentSlotGroup> slots) {
        private static final Codec<List<EquipmentSlotGroup>> SLOTS_CODEC = ExtraCodecs.nonEmptyList(Codec.either(EquipmentSlotGroup.CODEC, (Codec)EquipmentSlotGroup.CODEC.listOf()).xmap(p_298227_ -> (List)p_298227_.map(List::of, Function.identity()), p_339577_ -> p_339577_.size() == 1 ? Either.left((Object)((EquipmentSlotGroup)p_339577_.getFirst())) : Either.right((Object)p_339577_)));
        public static final Codec<Modifier> CODEC = RecordCodecBuilder.create(p_350260_ -> p_350260_.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(Modifier::id), (App)Attribute.CODEC.fieldOf("attribute").forGetter(Modifier::attribute), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(Modifier::operation), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(Modifier::amount), (App)SLOTS_CODEC.fieldOf("slot").forGetter(Modifier::slots)).apply((Applicative)p_350260_, Modifier::new));
    }

    public static class ModifierBuilder {
        private final ResourceLocation id;
        private final Holder<Attribute> attribute;
        private final AttributeModifier.Operation operation;
        private final NumberProvider amount;
        private final Set<EquipmentSlotGroup> slots = EnumSet.noneOf(EquipmentSlotGroup.class);

        public ModifierBuilder(ResourceLocation p_350927_, Holder<Attribute> p_298853_, AttributeModifier.Operation p_165265_, NumberProvider p_165266_) {
            this.id = p_350927_;
            this.attribute = p_298853_;
            this.operation = p_165265_;
            this.amount = p_165266_;
        }

        public ModifierBuilder forSlot(EquipmentSlotGroup p_332133_) {
            this.slots.add(p_332133_);
            return this;
        }

        public Modifier build() {
            return new Modifier(this.id, this.attribute, this.operation, this.amount, List.copyOf(this.slots));
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final boolean replace;
        private final List<Modifier> modifiers = Lists.newArrayList();

        public Builder(boolean p_339611_) {
            this.replace = p_339611_;
        }

        public Builder() {
            this(false);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withModifier(ModifierBuilder p_165246_) {
            this.modifiers.add(p_165246_.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetAttributesFunction(this.getConditions(), this.modifiers, this.replace);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

