/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ToggleTooltips
extends LootItemConditionalFunction {
    private static final Map<DataComponentType<?>, ComponentToggle<?>> TOGGLES = Stream.of(new ComponentToggle<ArmorTrim>(DataComponents.TRIM, ArmorTrim::withTooltip), new ComponentToggle<DyedItemColor>(DataComponents.DYED_COLOR, DyedItemColor::withTooltip), new ComponentToggle<ItemEnchantments>(DataComponents.ENCHANTMENTS, ItemEnchantments::withTooltip), new ComponentToggle<ItemEnchantments>(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments::withTooltip), new ComponentToggle<Unbreakable>(DataComponents.UNBREAKABLE, Unbreakable::withTooltip), new ComponentToggle<AdventureModePredicate>(DataComponents.CAN_BREAK, AdventureModePredicate::withTooltip), new ComponentToggle<AdventureModePredicate>(DataComponents.CAN_PLACE_ON, AdventureModePredicate::withTooltip), new ComponentToggle<ItemAttributeModifiers>(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers::withTooltip), new ComponentToggle<JukeboxPlayable>(DataComponents.JUKEBOX_PLAYABLE, JukeboxPlayable::withTooltip)).collect(Collectors.toMap(ComponentToggle::type, p_335612_ -> p_335612_));
    private static final Codec<ComponentToggle<?>> TOGGLE_CODEC = BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().comapFlatMap(p_336140_ -> {
        ComponentToggle<?> $$1 = TOGGLES.get(p_336140_);
        return $$1 != null ? DataResult.success($$1) : DataResult.error(() -> "Can't toggle tooltip visiblity for " + String.valueOf(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((DataComponentType<?>)p_336140_)));
    }, ComponentToggle::type);
    public static final MapCodec<ToggleTooltips> CODEC = RecordCodecBuilder.mapCodec(p_335794_ -> ToggleTooltips.commonFields(p_335794_).and((App)Codec.unboundedMap(TOGGLE_CODEC, (Codec)Codec.BOOL).fieldOf("toggles").forGetter(p_335699_ -> p_335699_.values)).apply((Applicative)p_335794_, ToggleTooltips::new));
    private final Map<ComponentToggle<?>, Boolean> values;

    private ToggleTooltips(List<LootItemCondition> p_335479_, Map<ComponentToggle<?>, Boolean> p_336164_) {
        super(p_335479_);
        this.values = p_336164_;
    }

    @Override
    protected ItemStack run(ItemStack p_335844_, LootContext p_335764_) {
        this.values.forEach((p_336152_, p_335653_) -> p_336152_.applyIfPresent(p_335844_, (boolean)p_335653_));
        return p_335844_;
    }

    public LootItemFunctionType<ToggleTooltips> getType() {
        return LootItemFunctions.TOGGLE_TOOLTIPS;
    }

    record ComponentToggle<T>(DataComponentType<T> type, TooltipWither<T> setter) {
        public void applyIfPresent(ItemStack p_335390_, boolean p_335686_) {
            T $$2 = p_335390_.get(this.type);
            if ($$2 != null) {
                p_335390_.set(this.type, this.setter.withTooltip($$2, p_335686_));
            }
        }
    }

    @FunctionalInterface
    static interface TooltipWither<T> {
        public T withTooltip(T var1, boolean var2);
    }
}

