/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.ContextScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;

public record ScoreboardValue(ScoreboardNameProvider target, String score, float scale) implements NumberProvider
{
    public static final MapCodec<ScoreboardValue> CODEC = RecordCodecBuilder.mapCodec(p_298582_ -> p_298582_.group((App)ScoreboardNameProviders.CODEC.fieldOf("target").forGetter(ScoreboardValue::target), (App)Codec.STRING.fieldOf("score").forGetter(ScoreboardValue::score), (App)Codec.FLOAT.fieldOf("scale").orElse((Object)Float.valueOf(1.0f)).forGetter(ScoreboardValue::scale)).apply((Applicative)p_298582_, ScoreboardValue::new));

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.SCORE;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.target.getReferencedContextParams();
    }

    public static ScoreboardValue fromScoreboard(LootContext.EntityTarget p_165750_, String p_165751_) {
        return ScoreboardValue.fromScoreboard(p_165750_, p_165751_, 1.0f);
    }

    public static ScoreboardValue fromScoreboard(LootContext.EntityTarget p_165753_, String p_165754_, float p_165755_) {
        return new ScoreboardValue(ContextScoreboardNameProvider.forTarget(p_165753_), p_165754_, p_165755_);
    }

    @Override
    public float getFloat(LootContext p_165758_) {
        ScoreHolder $$1 = this.target.getScoreHolder(p_165758_);
        if ($$1 == null) {
            return 0.0f;
        }
        ServerScoreboard $$2 = p_165758_.getLevel().getScoreboard();
        Objective $$3 = $$2.getObjective(this.score);
        if ($$3 == null) {
            return 0.0f;
        }
        ReadOnlyScoreInfo $$4 = $$2.getPlayerScoreInfo($$1, $$3);
        if ($$4 == null) {
            return 0.0f;
        }
        return (float)$$4.value() * this.scale;
    }
}

