/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public record SavedTick<T>(T type, BlockPos pos, int delay, TickPriority priority) {
    private static final String TAG_ID = "i";
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final String TAG_DELAY = "t";
    private static final String TAG_PRIORITY = "p";
    public static final Hash.Strategy<SavedTick<?>> UNIQUE_TICK_HASH = new Hash.Strategy<SavedTick<?>>(){

        public int hashCode(SavedTick<?> p_193364_) {
            return 31 * p_193364_.pos().hashCode() + p_193364_.type().hashCode();
        }

        public boolean equals(@Nullable SavedTick<?> p_193366_, @Nullable SavedTick<?> p_193367_) {
            if (p_193366_ == p_193367_) {
                return true;
            }
            if (p_193366_ == null || p_193367_ == null) {
                return false;
            }
            return p_193366_.type() == p_193367_.type() && p_193366_.pos().equals(p_193367_.pos());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.equals((SavedTick)object, (SavedTick)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.hashCode((SavedTick)object);
        }
    };

    public static <T> List<SavedTick<T>> loadTickList(ListTag p_193351_, Function<String, Optional<T>> p_193352_, ChunkPos p_193353_) {
        ArrayList $$3 = new ArrayList(p_193351_.size());
        long $$4 = p_193353_.toLong();
        for (int $$5 = 0; $$5 < p_193351_.size(); ++$$5) {
            CompoundTag $$6 = p_193351_.getCompound($$5);
            SavedTick.loadTick($$6, p_193352_).ifPresent(p_360276_ -> {
                if (ChunkPos.asLong(p_360276_.pos()) == $$4) {
                    $$3.add((SavedTick)p_360276_);
                }
            });
        }
        return $$3;
    }

    public static <T> Optional<SavedTick<T>> loadTick(CompoundTag p_210670_, Function<String, Optional<T>> p_210671_) {
        return p_210671_.apply(p_210670_.getString(TAG_ID)).map(p_210668_ -> {
            BlockPos $$2 = new BlockPos(p_210670_.getInt(TAG_X), p_210670_.getInt(TAG_Y), p_210670_.getInt(TAG_Z));
            return new SavedTick<Object>(p_210668_, $$2, p_210670_.getInt(TAG_DELAY), TickPriority.byValue(p_210670_.getInt(TAG_PRIORITY)));
        });
    }

    private static CompoundTag saveTick(String p_193339_, BlockPos p_193340_, int p_193341_, TickPriority p_193342_) {
        CompoundTag $$4 = new CompoundTag();
        $$4.putString(TAG_ID, p_193339_);
        $$4.putInt(TAG_X, p_193340_.getX());
        $$4.putInt(TAG_Y, p_193340_.getY());
        $$4.putInt(TAG_Z, p_193340_.getZ());
        $$4.putInt(TAG_DELAY, p_193341_);
        $$4.putInt(TAG_PRIORITY, p_193342_.getValue());
        return $$4;
    }

    public CompoundTag save(Function<T, String> p_193344_) {
        return SavedTick.saveTick(p_193344_.apply(this.type), this.pos, this.delay, this.priority);
    }

    public ScheduledTick<T> unpack(long p_193329_, long p_193330_) {
        return new ScheduledTick<T>(this.type, this.pos, p_193329_ + (long)this.delay, this.priority, p_193330_);
    }

    public static <T> SavedTick<T> probe(T p_193336_, BlockPos p_193337_) {
        return new SavedTick<T>(p_193336_, p_193337_, 0, TickPriority.NORMAL);
    }
}

