/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.attachment;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class AttachmentType<T> {
    final Function<IAttachmentHolder, T> defaultValueSupplier;
    @Nullable
    final IAttachmentSerializer<?, T> serializer;
    final boolean copyOnDeath;
    final IAttachmentCopyHandler<T> copyHandler;

    private AttachmentType(Builder<T> builder) {
        this.defaultValueSupplier = builder.defaultValueSupplier;
        this.serializer = builder.serializer;
        this.copyOnDeath = builder.copyOnDeath;
        this.copyHandler = builder.copyHandler != null ? builder.copyHandler : AttachmentType.defaultCopyHandler(this.serializer);
    }

    private static <T, H extends Tag> IAttachmentCopyHandler<T> defaultCopyHandler(@Nullable IAttachmentSerializer<H, T> serializer) {
        if (serializer == null) {
            return (attachment, holder, provider) -> {
                throw new UnsupportedOperationException("Cannot copy non-serializable attachments");
            };
        }
        return (attachment, holder, provider) -> {
            Object serialized = serializer.write(attachment, provider);
            if (serialized != null) {
                return serializer.read(holder, serialized, provider);
            }
            return null;
        };
    }

    public static <T> Builder<T> builder(Supplier<T> defaultValueSupplier) {
        return AttachmentType.builder((IAttachmentHolder holder) -> defaultValueSupplier.get());
    }

    public static <T> Builder<T> builder(Function<IAttachmentHolder, T> defaultValueConstructor) {
        return new Builder<T>(defaultValueConstructor);
    }

    public static <S extends Tag, T extends INBTSerializable<S>> Builder<T> serializable(Supplier<T> defaultValueSupplier) {
        return AttachmentType.serializable((IAttachmentHolder holder) -> (INBTSerializable)defaultValueSupplier.get());
    }

    public static <S extends Tag, T extends INBTSerializable<S>> Builder<T> serializable(final Function<IAttachmentHolder, T> defaultValueConstructor) {
        return AttachmentType.builder(defaultValueConstructor).serialize(new IAttachmentSerializer<S, T>(){

            @Override
            public T read(IAttachmentHolder holder, S tag, HolderLookup.Provider provider) {
                INBTSerializable ret = (INBTSerializable)defaultValueConstructor.apply(holder);
                ret.deserializeNBT(provider, tag);
                return ret;
            }

            @Override
            @Nullable
            public S write(T attachment, HolderLookup.Provider provider) {
                return attachment.serializeNBT(provider);
            }
        });
    }

    public static class Builder<T> {
        private final Function<IAttachmentHolder, T> defaultValueSupplier;
        @Nullable
        private IAttachmentSerializer<?, T> serializer;
        private boolean copyOnDeath;
        @Nullable
        private IAttachmentCopyHandler<T> copyHandler;

        private Builder(Function<IAttachmentHolder, T> defaultValueSupplier) {
            this.defaultValueSupplier = defaultValueSupplier;
        }

        public Builder<T> serialize(IAttachmentSerializer<?, T> serializer) {
            Objects.requireNonNull(serializer);
            if (this.serializer != null) {
                throw new IllegalStateException("Serializer already set");
            }
            this.serializer = serializer;
            return this;
        }

        public Builder<T> serialize(Codec<T> codec) {
            return this.serialize(codec, (Predicate<? super T>)Predicates.alwaysTrue());
        }

        public Builder<T> serialize(final Codec<T> codec, final Predicate<? super T> shouldSerialize) {
            Objects.requireNonNull(codec);
            return this.serialize(new IAttachmentSerializer<Tag, T>(this){

                @Override
                public T read(IAttachmentHolder holder, Tag tag, HolderLookup.Provider provider) {
                    return codec.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().get();
                }

                @Override
                @Nullable
                public Tag write(T attachment, HolderLookup.Provider provider) {
                    return shouldSerialize.test(attachment) ? (Tag)codec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), attachment).result().get() : null;
                }
            });
        }

        public Builder<T> copyOnDeath() {
            if (this.serializer == null) {
                throw new IllegalStateException("copyOnDeath requires a serializer");
            }
            this.copyOnDeath = true;
            return this;
        }

        public Builder<T> copyHandler(IAttachmentCopyHandler<T> cloner) {
            Objects.requireNonNull(cloner);
            if (this.serializer == null) {
                throw new IllegalStateException("copyHandler requires a serializer");
            }
            this.copyHandler = cloner;
            return this;
        }

        public AttachmentType<T> build() {
            return new AttachmentType(this);
        }
    }
}

