/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.event;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class EntityRenderersEvent
extends Event
implements IModBusEvent {
    @ApiStatus.Internal
    protected EntityRenderersEvent() {
    }

    public static class CreateSkullModels
    extends EntityRenderersEvent {
        private final ImmutableMap.Builder<SkullBlock.Type, SkullModelBase> builder;
        private final EntityModelSet entityModelSet;

        @ApiStatus.Internal
        public CreateSkullModels(ImmutableMap.Builder<SkullBlock.Type, SkullModelBase> builder, EntityModelSet entityModelSet) {
            this.builder = builder;
            this.entityModelSet = entityModelSet;
        }

        public EntityModelSet getEntityModelSet() {
            return this.entityModelSet;
        }

        public void registerSkullModel(SkullBlock.Type type, SkullModelBase model) {
            this.builder.put((Object)type, (Object)model);
        }
    }

    public static class AddLayers
    extends EntityRenderersEvent {
        private final Map<EntityType<?>, EntityRenderer<?, ?>> renderers;
        private final Map<PlayerSkin.Model, EntityRenderer<? extends Player, ?>> skinMap;
        private final EntityRendererProvider.Context context;

        @ApiStatus.Internal
        public AddLayers(Map<EntityType<?>, EntityRenderer<?, ?>> renderers, Map<PlayerSkin.Model, EntityRenderer<? extends Player, ?>> playerRenderers, EntityRendererProvider.Context context) {
            this.renderers = renderers;
            this.skinMap = playerRenderers;
            this.context = context;
        }

        public Set<PlayerSkin.Model> getSkins() {
            return this.skinMap.keySet();
        }

        @Nullable
        public <R extends EntityRenderer<? extends Player, ?>> R getSkin(PlayerSkin.Model skinModel) {
            return (R)this.skinMap.get(skinModel);
        }

        public Set<EntityType<?>> getEntityTypes() {
            return this.renderers.keySet();
        }

        @Nullable
        public <T extends Entity, R extends EntityRenderer<T, ?>> R getRenderer(EntityType<? extends T> entityType) {
            return (R)this.renderers.get(entityType);
        }

        public EntityModelSet getEntityModels() {
            return this.context.getModelSet();
        }

        public EntityRendererProvider.Context getContext() {
            return this.context;
        }
    }

    public static class RegisterRenderers
    extends EntityRenderersEvent {
        @ApiStatus.Internal
        public RegisterRenderers() {
        }

        public <T extends Entity> void registerEntityRenderer(EntityType<? extends T> entityType, EntityRendererProvider<T> entityRendererProvider) {
            EntityRenderers.register(entityType, entityRendererProvider);
        }

        public <T extends BlockEntity> void registerBlockEntityRenderer(BlockEntityType<? extends T> blockEntityType, BlockEntityRendererProvider<T> blockEntityRendererProvider) {
            BlockEntityRenderers.register(blockEntityType, blockEntityRendererProvider);
        }
    }

    public static class RegisterLayerDefinitions
    extends EntityRenderersEvent {
        @ApiStatus.Internal
        public RegisterLayerDefinitions() {
        }

        public void registerLayerDefinition(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
            ClientHooks.registerLayerDefinition(layerLocation, supplier);
        }
    }
}

