/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.client.model.data;

import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MultipartModelData {
    private static final ModelProperty<Map<BakedModel, ModelData>> PROPERTY = new ModelProperty();

    public static ModelData resolve(ModelData modelData, BakedModel model) {
        Map<BakedModel, ModelData> multipartData = modelData.get(PROPERTY);
        if (multipartData == null) {
            return modelData;
        }
        ModelData partData = multipartData.get(model);
        return partData != null ? partData : modelData;
    }

    public static ModelData create(List<MultiPartBakedModel.Selector> selectors, BitSet bitset, BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData tileModelData) {
        IdentityHashMap<BakedModel, ModelData> dataMap = null;
        for (int i = 0; i < bitset.length(); ++i) {
            BakedModel model;
            ModelData data;
            if (!bitset.get(i) || (data = (model = selectors.get(i).model()).getModelData(level, pos, state, tileModelData)) == tileModelData) continue;
            if (dataMap == null) {
                dataMap = new IdentityHashMap<BakedModel, ModelData>();
            }
            dataMap.put(model, data);
        }
        return dataMap == null ? tileModelData : tileModelData.derive().with(PROPERTY, dataMap).build();
    }
}

