/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.common.data.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.PlayerInteractTrigger;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.advancements.packs.VanillaHusbandryAdvancements;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.advancements.critereon.ItemAbilityPredicate;
import net.neoforged.neoforge.common.advancements.critereon.PiglinCurrencyItemPredicate;
import net.neoforged.neoforge.common.advancements.critereon.PiglinNeutralArmorEntityPredicate;
import net.neoforged.neoforge.common.advancements.critereon.SnowBootsEntityPredicate;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class NeoForgeAdvancementProvider
extends AdvancementProvider {
    public NeoForgeAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, NeoForgeAdvancementProvider.getVanillaAdvancementProviders(output, registries));
    }

    private static List<AdvancementProvider.AdvancementGenerator> getVanillaAdvancementProviders(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        ArrayList criteriaReplacers = new ArrayList();
        criteriaReplacers.add(NeoForgeAdvancementProvider.replaceMatchToolCriteria(ItemAbilities.AXE_WAX_OFF, (ItemLike[])NeoForgeAdvancementProvider.getPrivateValue(VanillaHusbandryAdvancements.class, null, "WAX_SCRAPING_TOOLS")));
        criteriaReplacers.add(NeoForgeAdvancementProvider.replaceInteractCriteria(ItemPredicate.Builder.item().withSubPredicate(ItemAbilityPredicate.TYPE, (ItemSubPredicate)new ItemAbilityPredicate(ItemAbilities.SHEARS_REMOVE_ARMOR)).build(), new ItemLike[]{Items.SHEARS}));
        criteriaReplacers.add(NeoForgeAdvancementProvider.replaceInteractCriteria(ItemPredicate.Builder.item().withSubPredicate(PiglinCurrencyItemPredicate.TYPE, (ItemSubPredicate)PiglinCurrencyItemPredicate.INSTANCE).build(), new ItemLike[]{PiglinAi.BARTERING_ITEM}));
        criteriaReplacers.add(NeoForgeAdvancementProvider.replaceWearingPredicate(PiglinNeutralArmorEntityPredicate.INSTANCE, predicate -> {
            if (predicate.head().filter(item -> NeoForgeAdvancementProvider.predicateMatches(item, (TagKey<Item>)ItemTags.PIGLIN_SAFE_ARMOR)).isPresent()) {
                return true;
            }
            if (predicate.chest().filter(item -> NeoForgeAdvancementProvider.predicateMatches(item, (TagKey<Item>)ItemTags.PIGLIN_SAFE_ARMOR)).isPresent()) {
                return true;
            }
            if (predicate.legs().filter(item -> NeoForgeAdvancementProvider.predicateMatches(item, (TagKey<Item>)ItemTags.PIGLIN_SAFE_ARMOR)).isPresent()) {
                return true;
            }
            return predicate.feet().filter(item -> NeoForgeAdvancementProvider.predicateMatches(item, (TagKey<Item>)ItemTags.PIGLIN_SAFE_ARMOR)).isPresent();
        }));
        criteriaReplacers.add(NeoForgeAdvancementProvider.replaceWearingPredicate(SnowBootsEntityPredicate.INSTANCE, predicate -> predicate.feet().filter(item -> NeoForgeAdvancementProvider.predicateMatches(item, new ItemLike[]{Items.LEATHER_BOOTS})).isPresent()));
        List subProviders = (List)NeoForgeAdvancementProvider.getPrivateValue(net.minecraft.data.advancements.AdvancementProvider.class, VanillaAdvancementProvider.create((PackOutput)output, registries), "subProviders");
        return subProviders.stream().map(vanillaProvider -> new NeoForgeAdvancementGenerator((AdvancementSubProvider)vanillaProvider, criteriaReplacers)).toList();
    }

    private static BiFunction<Criterion<?>, HolderLookup.Provider, Criterion<?>> replaceMatchToolCriteria(ItemAbility itemAbility, ItemLike ... targetItem) {
        UnaryOperator replacer = condition -> {
            MatchTool toolMatch;
            if (condition instanceof MatchTool && (toolMatch = (MatchTool)condition).predicate().filter(predicate -> NeoForgeAdvancementProvider.predicateMatches(predicate, targetItem)).isPresent()) {
                return new MatchTool(Optional.of(ItemPredicate.Builder.item().withSubPredicate(ItemAbilityPredicate.TYPE, (ItemSubPredicate)new ItemAbilityPredicate(itemAbility)).build()));
            }
            return null;
        };
        return (criterion, registries) -> {
            CriterionTrigger patt0$temp = criterion.trigger();
            if (patt0$temp instanceof ItemUsedOnLocationTrigger) {
                ItemUsedOnLocationTrigger.TriggerInstance instance;
                ContextAwarePredicate newLocation;
                ItemUsedOnLocationTrigger trigger = (ItemUsedOnLocationTrigger)patt0$temp;
                CriterionTriggerInstance patt1$temp = criterion.triggerInstance();
                if (patt1$temp instanceof ItemUsedOnLocationTrigger.TriggerInstance && (newLocation = NeoForgeAdvancementProvider.replaceConditions((instance = (ItemUsedOnLocationTrigger.TriggerInstance)patt1$temp).location().orElse(null), replacer, condition -> false)) != null) {
                    return new Criterion((CriterionTrigger)trigger, (CriterionTriggerInstance)new ItemUsedOnLocationTrigger.TriggerInstance(instance.player(), Optional.of(newLocation)));
                }
            }
            return null;
        };
    }

    private static BiFunction<Criterion<?>, HolderLookup.Provider, Criterion<?>> replaceInteractCriteria(ItemPredicate replacement, ItemLike ... targetItem) {
        return (criterion, registries) -> {
            CriterionTrigger patt0$temp = criterion.trigger();
            if (patt0$temp instanceof PlayerInteractTrigger) {
                PlayerInteractTrigger.TriggerInstance instance;
                PlayerInteractTrigger trigger = (PlayerInteractTrigger)patt0$temp;
                CriterionTriggerInstance patt1$temp = criterion.triggerInstance();
                if (patt1$temp instanceof PlayerInteractTrigger.TriggerInstance && (instance = (PlayerInteractTrigger.TriggerInstance)patt1$temp).item().filter(predicate -> NeoForgeAdvancementProvider.predicateMatches(predicate, targetItem)).isPresent()) {
                    return new Criterion((CriterionTrigger)trigger, (CriterionTriggerInstance)new PlayerInteractTrigger.TriggerInstance(instance.player(), Optional.of(replacement), instance.entity()));
                }
            }
            return null;
        };
    }

    private static boolean predicateMatches(ItemPredicate predicate, ItemLike ... targets) {
        Optional items = predicate.items();
        if (items.isEmpty()) {
            return false;
        }
        HolderSet holders = (HolderSet)items.get();
        for (ItemLike target : targets) {
            if (holders.contains((Holder)target.asItem().builtInRegistryHolder())) continue;
            return false;
        }
        return true;
    }

    private static boolean predicateMatches(ItemPredicate predicate, TagKey<Item> tagKey) {
        return predicate.items().orElse(HolderSet.empty()).unwrapKey().map(k -> k == tagKey).orElse(false);
    }

    private static BiFunction<Criterion<?>, HolderLookup.Provider, Criterion<?>> replaceWearingPredicate(EntitySubPredicate subPredicate, Predicate<EntityEquipmentPredicate> shouldReplace) {
        return NeoForgeAdvancementProvider.replacePlayerPredicate(condition -> {
            EntityPredicate entityPredicate;
            LootItemEntityPropertyCondition entityPropertyCondition;
            Optional predicate;
            boolean invert = false;
            if (condition instanceof InvertedLootItemCondition) {
                InvertedLootItemCondition inverted = (InvertedLootItemCondition)condition;
                condition = inverted.term();
                invert = true;
            }
            if (condition instanceof LootItemEntityPropertyCondition && (predicate = (entityPropertyCondition = (LootItemEntityPropertyCondition)condition).predicate()).isPresent() && (entityPredicate = (EntityPredicate)predicate.get()).equipment().filter(shouldReplace).isPresent()) {
                if (entityPredicate.subPredicate().isPresent()) {
                    throw new IllegalStateException("Attempting to replace an entity predicate that already has a sub predicate");
                }
                EntityPredicate replacement = new EntityPredicate(entityPredicate.entityType(), entityPredicate.distanceToPlayer(), entityPredicate.movement(), entityPredicate.location(), entityPredicate.effects(), entityPredicate.nbt(), entityPredicate.flags(), Optional.empty(), Optional.of(subPredicate), entityPredicate.periodicTick(), entityPredicate.vehicle(), entityPredicate.passenger(), entityPredicate.targetedEntity(), entityPredicate.team(), entityPredicate.slots());
                LootItemCondition.Builder conditionBuilder = LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)entityPropertyCondition.entityTarget(), (EntityPredicate)replacement);
                if (invert) {
                    return conditionBuilder.invert().build();
                }
                return conditionBuilder.build();
            }
            return null;
        }, condition -> true);
    }

    private static BiFunction<Criterion<?>, HolderLookup.Provider, Criterion<?>> replacePlayerPredicate(UnaryOperator<LootItemCondition> replacer, Predicate<LootItemCondition> shouldSkipReplacement) {
        return (criterion, registries) -> {
            SimpleCriterionTrigger.SimpleInstance simpleInstance;
            ContextAwarePredicate newPlayer;
            CriterionTriggerInstance patt0$temp = criterion.triggerInstance();
            if (patt0$temp instanceof SimpleCriterionTrigger.SimpleInstance && (newPlayer = NeoForgeAdvancementProvider.replaceConditions((simpleInstance = (SimpleCriterionTrigger.SimpleInstance)patt0$temp).player().orElse(null), replacer, shouldSkipReplacement)) != null) {
                return NeoForgeAdvancementProvider.replacePlayerPredicate(criterion, newPlayer, registries);
            }
            return null;
        };
    }

    private static <T extends SimpleCriterionTrigger.SimpleInstance> Criterion<T> replacePlayerPredicate(Criterion<T> old, ContextAwarePredicate newPlayer, HolderLookup.Provider registries) {
        Codec codec = old.trigger().codec();
        RegistryOps registryops = registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        return (Criterion)codec.encodeStart((DynamicOps)registryops, (Object)((SimpleCriterionTrigger.SimpleInstance)old.triggerInstance())).flatMap(element -> {
            JsonObject object;
            if (element instanceof JsonObject && (object = (JsonObject)element).has("player")) {
                object.add("player", (JsonElement)ContextAwarePredicate.CODEC.encodeStart((DynamicOps)registryops, (Object)newPlayer).getOrThrow(error -> new IllegalStateException("Unable to serialize new player predicate")));
                return codec.parse((DynamicOps)registryops, (Object)object);
            }
            return DataResult.error(() -> "Serialized instance does not contain a 'player' element");
        }).map(arg_0 -> ((CriterionTrigger)old.trigger()).createCriterion(arg_0)).getOrThrow(error -> new IllegalStateException("Unable to convert criterion serialization and replacement: " + error));
    }

    @Nullable
    private static ContextAwarePredicate replaceConditions(@Nullable ContextAwarePredicate basePredicate, UnaryOperator<LootItemCondition> replacer, Predicate<LootItemCondition> shouldSkipReplacement) {
        if (basePredicate == null) {
            return null;
        }
        List conditions = (List)NeoForgeAdvancementProvider.getPrivateValue(ContextAwarePredicate.class, basePredicate, "conditions");
        if (!conditions.isEmpty()) {
            boolean shouldReplace = false;
            ArrayList<LootItemCondition> clonedConditions = new ArrayList<LootItemCondition>(conditions.size());
            for (LootItemCondition condition : conditions) {
                LootItemCondition replacement = (LootItemCondition)replacer.apply(condition);
                if (replacement != null) {
                    if (shouldReplace && shouldSkipReplacement.test(replacement)) continue;
                    shouldReplace = true;
                    condition = replacement;
                }
                clonedConditions.add(condition);
            }
            if (shouldReplace) {
                return ContextAwarePredicate.create((LootItemCondition[])((LootItemCondition[])clonedConditions.toArray(LootItemCondition[]::new)));
            }
        }
        return null;
    }

    private static <T, C> T getPrivateValue(Class<C> clazz, @Nullable C inst, String name) {
        Object value = ObfuscationReflectionHelper.getPrivateValue(clazz, inst, (String)name);
        if (value == null) {
            throw new IllegalStateException(clazz.getName() + " is missing field " + name);
        }
        return (T)value;
    }

    private record NeoForgeAdvancementGenerator(AdvancementSubProvider vanillaProvider, List<BiFunction<Criterion<?>, HolderLookup.Provider, Criterion<?>>> criteriaReplacers) implements AdvancementProvider.AdvancementGenerator
    {
        @Override
        public void generate(final HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
            HolderLookup.Provider registriesWithAnyTag = new HolderLookup.Provider(){

                public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                    return registries.listRegistryKeys();
                }

                public <T> Optional<? extends HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> p_256285_) {
                    return registries.lookup(p_256285_);
                }

                public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> p_326817_) {
                    return RegistryOps.create(p_326817_, (RegistryOps.RegistryInfoLookup)new RegistryOps.RegistryInfoLookup(){

                        public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> registry) {
                            Registry builtInRegistry = (Registry)BuiltInRegistries.REGISTRY.getValue(registry.location());
                            return registries.lookup(registry).map(lookup -> new RegistryOps.RegistryInfo((HolderOwner)builtInRegistry, (HolderGetter)new HolderLookup.RegistryLookup.Delegate<T>(this, (HolderLookup.RegistryLookup)lookup){
                                final /* synthetic */ HolderLookup.RegistryLookup val$lookup;
                                {
                                    this.val$lookup = registryLookup;
                                }

                                public HolderLookup.RegistryLookup<T> parent() {
                                    return this.val$lookup;
                                }

                                public boolean canSerializeIn(HolderOwner<T> p_255875_) {
                                    return this.parent().canSerializeIn(p_255875_);
                                }

                                public Optional<HolderSet.Named<T>> get(TagKey<T> tagKey) {
                                    Optional<HolderSet.Named> ret = super.get(tagKey);
                                    if (ret.isEmpty()) {
                                        ret = Optional.of(HolderSet.emptyNamed((HolderOwner)this.val$lookup, tagKey));
                                    }
                                    return ret;
                                }
                            }, lookup.registryLifecycle()));
                        }
                    });
                }
            };
            this.vanillaProvider.generate(registriesWithAnyTag, arg_0 -> this.lambda$generate$0(registriesWithAnyTag, saver, existingFileHelper, arg_0));
        }

        @Nullable
        private Advancement.Builder findAndReplaceInHolder(AdvancementHolder advancementHolder, HolderLookup.Provider registries) {
            Advancement advancement = advancementHolder.value();
            Advancement.Builder builder = Advancement.Builder.advancement();
            boolean hasReplaced = false;
            for (Map.Entry entry : advancement.criteria().entrySet()) {
                Criterion<?> criterion = (Criterion<?>)entry.getValue();
                for (BiFunction<Criterion<?>, HolderLookup.Provider, Criterion<?>> criteriaReplacer : this.criteriaReplacers) {
                    Criterion<?> replacedCriterion = criteriaReplacer.apply(criterion, registries);
                    if (replacedCriterion == null) continue;
                    hasReplaced = true;
                    criterion = replacedCriterion;
                }
                builder.addCriterion((String)entry.getKey(), (Criterion)criterion);
            }
            if (!hasReplaced) {
                return null;
            }
            advancement.parent().ifPresent(arg_0 -> ((Advancement.Builder)builder).parent(arg_0));
            advancement.display().ifPresent(arg_0 -> ((Advancement.Builder)builder).display(arg_0));
            builder.rewards(advancement.rewards());
            builder.requirements(advancement.requirements());
            if (advancement.sendsTelemetryEvent()) {
                builder.sendsTelemetryEvent();
            }
            return builder;
        }

        private /* synthetic */ void lambda$generate$0(1 registriesWithAnyTag, Consumer saver, ExistingFileHelper existingFileHelper, AdvancementHolder advancementHolder) {
            Advancement.Builder newBuilder = this.findAndReplaceInHolder(advancementHolder, registriesWithAnyTag);
            if (newBuilder != null) {
                newBuilder.save(saver, advancementHolder.id(), existingFileHelper);
            }
        }
    }
}

