/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.fluids.crafting.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.display.ForFluidStacks;

public record FluidStackSlotDisplay(FluidStack stack) implements SlotDisplay
{
    public static final MapCodec<FluidStackSlotDisplay> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(FluidStackSlotDisplay::stack)).apply((Applicative)instance, FluidStackSlotDisplay::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidStackSlotDisplay> STREAM_CODEC = StreamCodec.composite(FluidStack.STREAM_CODEC, FluidStackSlotDisplay::stack, FluidStackSlotDisplay::new);

    public SlotDisplay.Type<FluidStackSlotDisplay> type() {
        return NeoForgeMod.FLUID_STACK_SLOT_DISPLAY.get();
    }

    public <T> Stream<T> resolve(ContextMap context, DisplayContentsFactory<T> factory) {
        DisplayContentsFactory<T> displayContentsFactory = factory;
        Objects.requireNonNull(displayContentsFactory);
        DisplayContentsFactory<T> displayContentsFactory2 = displayContentsFactory;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ForFluidStacks.class}, displayContentsFactory2, n)) {
            case 0 -> {
                ForFluidStacks fluids = (ForFluidStacks)displayContentsFactory2;
                yield Stream.of(fluids.forStack(this.stack));
            }
            default -> Stream.empty();
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FluidStackSlotDisplay)) return false;
        FluidStackSlotDisplay fluidStackDisplay = (FluidStackSlotDisplay)other;
        if (!FluidStack.matches(this.stack, fluidStackDisplay.stack)) return false;
        return true;
    }
}

