/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.TargetType;
import net.neoforged.accesstransformer.parser.AccessTransformerFiles;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import org.objectweb.asm.Type;

public class AccessTransformerList {
    private final AccessTransformerFiles atFiles = new AccessTransformerFiles();

    public void loadFromResource(String resourceName) throws URISyntaxException, IOException {
        this.atFiles.loadFromResource(resourceName);
    }

    public void loadFromPath(Path path) throws IOException {
        this.atFiles.loadFromPath(path);
    }

    public void loadAT(Reader reader, String originName) throws IOException {
        this.atFiles.loadAT(reader, originName);
    }

    public Map<String, List<AccessTransformer<?>>> getAccessTransformers() {
        return this.atFiles.getAccessTransformers().entrySet().stream().collect(Collectors.groupingBy(e -> ((Target)e.getKey()).className(), HashMap::new, Collectors.mapping(e -> AccessTransformer.of((Target)e.getKey(), (Transformation)e.getValue()), Collectors.toList())));
    }

    public boolean containsClassTarget(Type type) {
        return this.atFiles.containsClassTarget(type.getClassName());
    }

    public Set<Type> getTargets() {
        return this.atFiles.getTargets().stream().map(s -> Type.getObjectType((String)s.replace('.', '/'))).collect(Collectors.toSet());
    }

    public Map<TargetType, Map<String, AccessTransformer<?>>> getTransformersForTarget(Type type) {
        return this.atFiles.getAccessTransformers().entrySet().stream().filter(e -> type.getClassName().equals(((Target)e.getKey()).className())).map(e -> AccessTransformer.of((Target)e.getKey(), (Transformation)e.getValue())).collect(Collectors.groupingBy(AccessTransformer::getType, HashMap::new, Collectors.toMap(AccessTransformer::targetName, Function.identity())));
    }
}

