/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.accesstransformer;

import java.util.Set;
import net.neoforged.accesstransformer.AccessTransformer;
import net.neoforged.accesstransformer.parser.Target;
import net.neoforged.accesstransformer.parser.Transformation;
import org.objectweb.asm.tree.ClassNode;

public class InnerClassAccessTransformer
extends AccessTransformer<ClassNode> {
    private final String innerName;

    public InnerClassAccessTransformer(Target.InnerClassTarget target, Transformation transformation) {
        super((Target)target, transformation);
        this.innerName = target.innerName();
    }

    @Override
    public String targetName() {
        return this.innerName;
    }

    @Override
    protected void apply(ClassNode node, Set<String> privateChanged) {
        node.innerClasses.stream().filter(c -> c.name.equals(this.innerName)).forEach(inner -> {
            inner.access = InnerClassAccessTransformer.mergeWith(inner.access, this.getTransformation().modifier(), this.getTransformation().finalState());
        });
    }
}

