/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.NamedPath;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public final class ModuleLayerHandler
implements IModuleLayerManager {
    private final EnumMap<IModuleLayerManager.Layer, List<PathOrJar>> layers = new EnumMap(IModuleLayerManager.Layer.class);
    private final EnumMap<IModuleLayerManager.Layer, LayerInfo> completedLayers = new EnumMap(IModuleLayerManager.Layer.class);

    ModuleLayerHandler() {
        ModuleClassLoader moduleCl;
        ClassLoader classLoader = this.getClass().getClassLoader();
        ModuleClassLoader cl = classLoader instanceof ModuleClassLoader ? (moduleCl = (ModuleClassLoader)classLoader) : new ModuleClassLoader("BOOT", ModuleLayer.boot().configuration(), List.of());
        this.completedLayers.put(IModuleLayerManager.Layer.BOOT, new LayerInfo(this.getClass().getModule().getLayer(), cl));
    }

    void addToLayer(IModuleLayerManager.Layer layer, SecureJar jar) {
        if (this.completedLayers.containsKey((Object)layer)) {
            throw new IllegalStateException("Layer already populated");
        }
        this.layers.computeIfAbsent(layer, l -> new ArrayList()).add(PathOrJar.from(jar));
    }

    void addToLayer(IModuleLayerManager.Layer layer, NamedPath namedPath) {
        if (this.completedLayers.containsKey((Object)layer)) {
            throw new IllegalStateException("Layer already populated");
        }
        this.layers.computeIfAbsent(layer, l -> new ArrayList()).add(PathOrJar.from(namedPath));
    }

    public LayerInfo buildLayer(IModuleLayerManager.Layer layer, BiFunction<Configuration, List<ModuleLayer>, ModuleClassLoader> classLoaderSupplier) {
        SecureJar[] finder = (SecureJar[])this.layers.getOrDefault((Object)layer, List.of()).stream().map(PathOrJar::build).toArray(SecureJar[]::new);
        List<String> targets = Arrays.stream(finder).map(SecureJar::name).toList();
        Configuration newConf = Configuration.resolveAndBind((ModuleFinder)JarModuleFinder.of((SecureJar[])finder), Arrays.stream(layer.getParent()).map(this.completedLayers::get).map(li -> li.layer().configuration()).toList(), ModuleFinder.of(new Path[0]), targets);
        List allParents = Arrays.stream(layer.getParent()).map(this.completedLayers::get).map(LayerInfo::layer).mapMulti((moduleLayer, comp) -> {
            comp.accept(moduleLayer);
            moduleLayer.parents().forEach(comp);
        }).toList();
        ModuleClassLoader classLoader = classLoaderSupplier.apply(newConf, allParents);
        ModuleLayer.Controller modController = ModuleLayer.defineModules(newConf, Arrays.stream(layer.getParent()).map(this.completedLayers::get).map(LayerInfo::layer).toList(), f -> classLoader);
        this.completedLayers.put(layer, new LayerInfo(modController.layer(), classLoader));
        classLoader.setFallbackClassLoader((ClassLoader)this.completedLayers.get((Object)IModuleLayerManager.Layer.BOOT).cl());
        return new LayerInfo(modController.layer(), classLoader);
    }

    public LayerInfo buildLayer(IModuleLayerManager.Layer layer) {
        return this.buildLayer(layer, (cf, p) -> new ModuleClassLoader("LAYER " + layer.name(), cf, p));
    }

    @Override
    public Optional<ModuleLayer> getLayer(IModuleLayerManager.Layer layer) {
        return Optional.ofNullable(this.completedLayers.get((Object)layer)).map(LayerInfo::layer);
    }

    public void updateLayer(IModuleLayerManager.Layer layer, Consumer<LayerInfo> action) {
        action.accept(this.completedLayers.get((Object)layer));
    }

    record LayerInfo(ModuleLayer layer, ModuleClassLoader cl) {
    }

    private record PathOrJar(NamedPath path, SecureJar jar) {
        static PathOrJar from(SecureJar jar) {
            return new PathOrJar(null, jar);
        }

        static PathOrJar from(NamedPath path) {
            return new PathOrJar(path, null);
        }

        SecureJar build() {
            return this.jar != null ? this.jar : SecureJar.from((Path[])this.path.paths());
        }
    }
}

