/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.TracyFrameCapture;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.MacosUtil;
import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public final class Window
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int BASE_WIDTH = 320;
    public static final int BASE_HEIGHT = 240;
    private final GLFWErrorCallback defaultErrorCallback = GLFWErrorCallback.create(this::defaultErrorCallback);
    private final WindowEventHandler eventHandler;
    private final ScreenManager screenManager;
    private final long window;
    private int windowedX;
    private int windowedY;
    private int windowedWidth;
    private int windowedHeight;
    private Optional<VideoMode> preferredFullscreenVideoMode;
    private boolean fullscreen;
    private boolean actuallyFullscreen;
    private int x;
    private int y;
    private int width;
    private int height;
    private int framebufferWidth;
    private int framebufferHeight;
    private int guiScaledWidth;
    private int guiScaledHeight;
    private double guiScale;
    private String errorSection = "";
    private boolean dirty;
    private boolean vsync;
    private boolean iconified;

    public Window(WindowEventHandler p_85372_, ScreenManager p_85373_, DisplayData p_85374_, @Nullable String p_85375_, String p_85376_) {
        this.screenManager = p_85373_;
        this.setBootErrorCallback();
        this.setErrorSection("Pre startup");
        this.eventHandler = p_85372_;
        Optional<Object> optional = VideoMode.read((String)p_85375_);
        this.preferredFullscreenVideoMode = optional.isPresent() ? optional : (p_85374_.fullscreenWidth.isPresent() && p_85374_.fullscreenHeight.isPresent() ? Optional.of(new VideoMode(p_85374_.fullscreenWidth.getAsInt(), p_85374_.fullscreenHeight.getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.actuallyFullscreen = this.fullscreen = p_85374_.isFullscreen;
        Monitor monitor = p_85373_.getMonitor(GLFW.glfwGetPrimaryMonitor());
        this.width = p_85374_.width > 0 ? p_85374_.width : 1;
        this.windowedWidth = this.width;
        this.height = p_85374_.height > 0 ? p_85374_.height : 1;
        this.windowedHeight = this.height;
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        this.window = ImmediateWindowHandler.setupMinecraftWindow(() -> this.width, () -> this.height, () -> p_85376_, () -> this.fullscreen && monitor != null ? monitor.getMonitor() : 0L);
        if (!ImmediateWindowHandler.positionWindow(Optional.ofNullable(monitor), w -> {
            this.width = this.windowedWidth = w;
        }, h -> {
            this.height = this.windowedHeight = h;
        }, x -> {
            this.x = this.windowedX = x;
        }, y -> {
            this.y = this.windowedY = y;
        })) {
            if (monitor != null) {
                VideoMode videomode = monitor.getPreferredVidMode(this.fullscreen ? this.preferredFullscreenVideoMode : Optional.empty());
                this.windowedX = this.x = monitor.getX() + videomode.getWidth() / 2 - this.width / 2;
                this.windowedY = this.y = monitor.getY() + videomode.getHeight() / 2 - this.height / 2;
            } else {
                int[] aint1 = new int[1];
                int[] aint = new int[1];
                GLFW.glfwGetWindowPos((long)this.window, (int[])aint1, (int[])aint);
                this.windowedX = this.x = aint1[0];
                this.windowedY = this.y = aint[0];
            }
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
        GL.createCapabilities();
        int i = RenderSystem.maxSupportedTextureSize();
        GLFW.glfwSetWindowSizeLimits((long)this.window, (int)-1, (int)-1, (int)i, (int)i);
        this.setMode();
        this.refreshFramebufferSize();
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, this::onFramebufferResize);
        GLFW.glfwSetWindowPosCallback((long)this.window, this::onMove);
        GLFW.glfwSetWindowSizeCallback((long)this.window, this::onResize);
        GLFW.glfwSetWindowFocusCallback((long)this.window, this::onFocus);
        GLFW.glfwSetCursorEnterCallback((long)this.window, this::onEnter);
        GLFW.glfwSetWindowIconifyCallback((long)this.window, this::onIconify);
    }

    public static String getPlatform() {
        int i = GLFW.glfwGetPlatform();
        return switch (i) {
            case 0 -> "<error>";
            case 393217 -> "win32";
            case 393218 -> "cocoa";
            case 393219 -> "wayland";
            case 393220 -> "x11";
            case 393221 -> "null";
            default -> String.format(Locale.ROOT, "unknown (%08X)", i);
        };
    }

    public int getRefreshRate() {
        RenderSystem.assertOnRenderThread();
        return GLX._getRefreshRate((Window)this);
    }

    public boolean shouldClose() {
        return GLX._shouldClose((Window)this);
    }

    public static void checkGlfwError(BiConsumer<Integer, String> p_85408_) {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int i = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (i != 0) {
                long j = pointerbuffer.get();
                String s = j == 0L ? "" : MemoryUtil.memUTF8((long)j);
                p_85408_.accept(i, s);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIcon(PackResources p_281860_, IconSet p_282155_) throws IOException {
        int i = GLFW.glfwGetPlatform();
        switch (i) {
            case 393217: 
            case 393220: {
                List list = p_282155_.getStandardIcons(p_281860_);
                ArrayList<ByteBuffer> list1 = new ArrayList<ByteBuffer>(list.size());
                try {
                    try (MemoryStack memorystack = MemoryStack.stackPush();){
                        GLFWImage.Buffer buffer = GLFWImage.malloc((int)list.size(), (MemoryStack)memorystack);
                        for (int j = 0; j < list.size(); ++j) {
                            try (NativeImage nativeimage = NativeImage.read((InputStream)((InputStream)((IoSupplier)list.get(j)).get()));){
                                ByteBuffer bytebuffer = MemoryUtil.memAlloc((int)(nativeimage.getWidth() * nativeimage.getHeight() * 4));
                                list1.add(bytebuffer);
                                bytebuffer.asIntBuffer().put(nativeimage.getPixelsABGR());
                                buffer.position(j);
                                buffer.width(nativeimage.getWidth());
                                buffer.height(nativeimage.getHeight());
                                buffer.pixels(bytebuffer);
                                continue;
                            }
                        }
                        GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)((GLFWImage.Buffer)buffer.position(0)));
                        if (memorystack == null) return;
                    }
                    return;
                }
                finally {
                    list1.forEach(MemoryUtil::memFree);
                }
            }
            case 393218: {
                MacosUtil.loadIcon((IoSupplier)p_282155_.getMacIcon(p_281860_));
            }
            case 393219: 
            case 393221: {
                return;
            }
            default: {
                LOGGER.warn("Not setting icon for unrecognized platform: {}", (Object)i);
            }
        }
    }

    public void setErrorSection(String p_85404_) {
        this.errorSection = p_85404_;
    }

    private void setBootErrorCallback() {
        GLFW.glfwSetErrorCallback(Window::bootCrash);
    }

    private static void bootCrash(int p_85413_, long p_85414_) {
        String s = "GLFW error " + p_85413_ + ": " + MemoryUtil.memUTF8((long)p_85414_);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(s + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new WindowInitFailed(s);
    }

    public void defaultErrorCallback(int p_85383_, long p_85384_) {
        RenderSystem.assertOnRenderThread();
        String s = MemoryUtil.memUTF8((long)p_85384_);
        LOGGER.error("########## GL ERROR ##########");
        LOGGER.error("@ {}", (Object)this.errorSection);
        LOGGER.error("{}: {}", (Object)p_85383_, (Object)s);
    }

    public void setDefaultErrorCallback() {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.defaultErrorCallback);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
    }

    public void updateVsync(boolean p_85410_) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.vsync = p_85410_;
        GLFW.glfwSwapInterval((int)(p_85410_ ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.assertOnRenderThread();
        Callbacks.glfwFreeCallbacks((long)this.window);
        this.defaultErrorCallback.close();
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
    }

    private void onMove(long p_85389_, int p_85390_, int p_85391_) {
        this.x = p_85390_;
        this.y = p_85391_;
    }

    private void onFramebufferResize(long p_85416_, int p_85417_, int p_85418_) {
        if (p_85416_ == this.window) {
            int i = this.getWidth();
            int j = this.getHeight();
            if (p_85417_ != 0 && p_85418_ != 0) {
                this.framebufferWidth = p_85417_;
                this.framebufferHeight = p_85418_;
                if (this.getWidth() != i || this.getHeight() != j) {
                    try {
                        this.eventHandler.resizeDisplay();
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.forThrowable(exception, "Window resize");
                        CrashReportCategory crashreportcategory = crashreport.addCategory("Window Dimensions");
                        crashreportcategory.setDetail("Old", i + "x" + j);
                        crashreportcategory.setDetail("New", p_85417_ + "x" + p_85418_);
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    private void refreshFramebufferSize() {
        int[] aint = new int[1];
        int[] aint1 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.window, (int[])aint, (int[])aint1);
        this.framebufferWidth = aint[0] > 0 ? aint[0] : 1;
        int n = this.framebufferHeight = aint1[0] > 0 ? aint1[0] : 1;
        if (this.framebufferHeight == 0 || this.framebufferWidth == 0) {
            ImmediateWindowHandler.updateFBSize(w -> {
                this.framebufferWidth = w;
            }, h -> {
                this.framebufferHeight = h;
            });
        }
    }

    private void onResize(long p_85428_, int p_85429_, int p_85430_) {
        this.width = p_85429_;
        this.height = p_85430_;
    }

    private void onFocus(long p_85393_, boolean p_85394_) {
        if (p_85393_ == this.window) {
            this.eventHandler.setWindowActive(p_85394_);
        }
    }

    private void onEnter(long p_85420_, boolean p_85421_) {
        if (p_85421_) {
            this.eventHandler.cursorEntered();
        }
    }

    private void onIconify(long p_361196_, boolean p_363700_) {
        this.iconified = p_363700_;
    }

    public void updateDisplay(@Nullable TracyFrameCapture p_373098_) {
        RenderSystem.flipFrame(this.window, p_373098_);
        if (this.fullscreen != this.actuallyFullscreen) {
            this.actuallyFullscreen = this.fullscreen;
            this.updateFullscreen(this.vsync, p_373098_);
        }
    }

    public Optional<VideoMode> getPreferredFullscreenVideoMode() {
        return this.preferredFullscreenVideoMode;
    }

    public void setPreferredFullscreenVideoMode(Optional<VideoMode> p_85406_) {
        boolean flag = !p_85406_.equals(this.preferredFullscreenVideoMode);
        this.preferredFullscreenVideoMode = p_85406_;
        if (flag) {
            this.dirty = true;
        }
    }

    public void changeFullscreenVideoMode() {
        if (this.fullscreen && this.dirty) {
            this.dirty = false;
            this.setMode();
            this.eventHandler.resizeDisplay();
        }
    }

    private void setMode() {
        boolean flag;
        boolean bl = flag = GLFW.glfwGetWindowMonitor((long)this.window) != 0L;
        if (this.fullscreen) {
            Monitor monitor = this.screenManager.findBestMonitor(this);
            if (monitor == null) {
                LOGGER.warn("Failed to find suitable monitor for fullscreen mode");
                this.fullscreen = false;
            } else {
                if (MacosUtil.IS_MACOS) {
                    MacosUtil.exitNativeFullscreen((long)this.window);
                }
                VideoMode videomode = monitor.getPreferredVidMode(this.preferredFullscreenVideoMode);
                if (!flag) {
                    this.windowedX = this.x;
                    this.windowedY = this.y;
                    this.windowedWidth = this.width;
                    this.windowedHeight = this.height;
                }
                this.x = 0;
                this.y = 0;
                this.width = videomode.getWidth();
                this.height = videomode.getHeight();
                GLFW.glfwSetWindowMonitor((long)this.window, (long)monitor.getMonitor(), (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)videomode.getRefreshRate());
                if (MacosUtil.IS_MACOS) {
                    MacosUtil.clearResizableBit((long)this.window);
                }
            }
        } else {
            this.x = this.windowedX;
            this.y = this.windowedY;
            this.width = this.windowedWidth;
            this.height = this.windowedHeight;
            GLFW.glfwSetWindowMonitor((long)this.window, (long)0L, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)-1);
        }
    }

    public void toggleFullScreen() {
        this.fullscreen = !this.fullscreen;
    }

    public void setWindowed(int p_166448_, int p_166449_) {
        this.windowedWidth = p_166448_;
        this.windowedHeight = p_166449_;
        this.fullscreen = false;
        this.setMode();
    }

    private void updateFullscreen(boolean p_85432_, @Nullable TracyFrameCapture p_373070_) {
        RenderSystem.assertOnRenderThread();
        try {
            this.setMode();
            this.eventHandler.resizeDisplay();
            this.updateVsync(p_85432_);
            this.updateDisplay(p_373070_);
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public int calculateScale(int p_85386_, boolean p_85387_) {
        int i;
        for (i = 1; i != p_85386_ && i < this.framebufferWidth && i < this.framebufferHeight && this.framebufferWidth / (i + 1) >= 320 && this.framebufferHeight / (i + 1) >= 240; ++i) {
        }
        if (p_85387_ && i % 2 != 0) {
            ++i;
        }
        return i;
    }

    public void setGuiScale(double p_85379_) {
        this.guiScale = p_85379_;
        int i = (int)((double)this.framebufferWidth / p_85379_);
        this.guiScaledWidth = (double)this.framebufferWidth / p_85379_ > (double)i ? i + 1 : i;
        int j = (int)((double)this.framebufferHeight / p_85379_);
        this.guiScaledHeight = (double)this.framebufferHeight / p_85379_ > (double)j ? j + 1 : j;
    }

    public void setTitle(String p_85423_) {
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)p_85423_);
    }

    public long getWindow() {
        return this.window;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean isIconified() {
        return this.iconified;
    }

    public int getWidth() {
        return this.framebufferWidth;
    }

    public int getHeight() {
        return this.framebufferHeight;
    }

    public void setWidth(int p_166451_) {
        this.framebufferWidth = p_166451_;
    }

    public void setHeight(int p_166453_) {
        this.framebufferHeight = p_166453_;
    }

    public int getScreenWidth() {
        return this.width;
    }

    public int getScreenHeight() {
        return this.height;
    }

    public int getGuiScaledWidth() {
        return this.guiScaledWidth;
    }

    public int getGuiScaledHeight() {
        return this.guiScaledHeight;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getGuiScale() {
        return this.guiScale;
    }

    @Nullable
    public Monitor findBestMonitor() {
        return this.screenManager.findBestMonitor(this);
    }

    public void updateRawMouseInput(boolean p_85425_) {
        InputConstants.updateRawMouseInput((long)this.window, (boolean)p_85425_);
    }

    public void setWindowCloseCallback(Runnable p_361232_) {
        GLFWWindowCloseCallback glfwwindowclosecallback = GLFW.glfwSetWindowCloseCallback((long)this.window, p_365115_ -> p_361232_.run());
        if (glfwwindowclosecallback != null) {
            glfwwindowclosecallback.free();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WindowInitFailed
    extends SilentInitException {
        WindowInitFailed(String p_85455_) {
            super(p_85455_);
        }
    }
}

