/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;

@OnlyIn(value=Dist.CLIENT)
public class ToastManager {
    private static final int SLOT_COUNT = 5;
    private static final int ALL_SLOTS_OCCUPIED = -1;
    final Minecraft minecraft;
    private final List<ToastInstance<?>> visibleToasts = new ArrayList();
    private final BitSet occupiedSlots = new BitSet(5);
    private final Deque<Toast> queued = Queues.newArrayDeque();

    public ToastManager(Minecraft p_361363_) {
        this.minecraft = p_361363_;
    }

    public void update() {
        this.visibleToasts.removeIf(p_364777_ -> {
            p_364777_.update();
            if (p_364777_.hasFinishedRendering()) {
                this.occupiedSlots.clear(p_364777_.firstSlotIndex, p_364777_.firstSlotIndex + p_364777_.occupiedSlotCount);
                return true;
            }
            return false;
        });
        if (!this.queued.isEmpty() && this.freeSlotCount() > 0) {
            this.queued.removeIf(p_362428_ -> {
                int i = p_362428_.occcupiedSlotCount();
                int j = this.findFreeSlotsIndex(i);
                if (j == -1) {
                    return false;
                }
                this.visibleToasts.add(new ToastInstance(this, p_362428_, j, i));
                this.occupiedSlots.set(j, j + i);
                return true;
            });
        }
    }

    public void render(GuiGraphics p_362571_) {
        if (!this.minecraft.options.hideGui) {
            int i = p_362571_.guiWidth();
            for (ToastInstance<?> toastinstance : this.visibleToasts) {
                toastinstance.render(p_362571_, i);
            }
        }
    }

    private int findFreeSlotsIndex(int p_362291_) {
        if (this.freeSlotCount() >= p_362291_) {
            int i = 0;
            for (int j = 0; j < 5; ++j) {
                if (this.occupiedSlots.get(j)) {
                    i = 0;
                    continue;
                }
                if (++i != p_362291_) continue;
                return j + 1 - i;
            }
        }
        return -1;
    }

    private int freeSlotCount() {
        return 5 - this.occupiedSlots.cardinality();
    }

    @Nullable
    public <T extends Toast> T getToast(Class<? extends T> p_361311_, Object p_361989_) {
        for (ToastInstance<?> toastinstance : this.visibleToasts) {
            if (toastinstance == null || !p_361311_.isAssignableFrom(toastinstance.getToast().getClass()) || !toastinstance.getToast().getToken().equals(p_361989_)) continue;
            return (T)toastinstance.getToast();
        }
        for (Toast toast : this.queued) {
            if (!p_361311_.isAssignableFrom(toast.getClass()) || !toast.getToken().equals(p_361989_)) continue;
            return (T)toast;
        }
        return null;
    }

    public void clear() {
        this.occupiedSlots.clear();
        this.visibleToasts.clear();
        this.queued.clear();
    }

    public void addToast(Toast p_362712_) {
        if (ClientHooks.onToastAdd((Toast)p_362712_)) {
            return;
        }
        this.queued.add(p_362712_);
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public double getNotificationDisplayTimeMultiplier() {
        return (Double)this.minecraft.options.notificationDisplayTime().get();
    }

    @OnlyIn(value=Dist.CLIENT)
    class ToastInstance<T extends Toast> {
        private static final long SLIDE_ANIMATION_DURATION_MS = 600L;
        private final T toast;
        final int firstSlotIndex;
        final int occupiedSlotCount;
        private long animationStartTime = -1L;
        private long becameFullyVisibleAt = -1L;
        private Toast.Visibility visibility = Toast.Visibility.SHOW;
        private long fullyVisibleFor;
        private float visiblePortion;
        private boolean hasFinishedRendering;
        final /* synthetic */ ToastManager this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        ToastInstance(T p_365175_, int p_365347_, int p_361399_) {
            this.this$0 = (ToastManager)this$0;
            this.toast = p_365175_;
            this.firstSlotIndex = p_365347_;
            this.occupiedSlotCount = p_361399_;
        }

        public T getToast() {
            return this.toast;
        }

        public boolean hasFinishedRendering() {
            return this.hasFinishedRendering;
        }

        private void calculateVisiblePortion(long p_362492_) {
            float f = Mth.clamp((float)((float)(p_362492_ - this.animationStartTime) / 600.0f), (float)0.0f, (float)1.0f);
            f *= f;
            this.visiblePortion = this.visibility == Toast.Visibility.HIDE ? 1.0f - f : f;
        }

        public void update() {
            long i = Util.getMillis();
            if (this.animationStartTime == -1L) {
                this.animationStartTime = i;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            if (this.visibility == Toast.Visibility.SHOW && i - this.animationStartTime <= 600L) {
                this.becameFullyVisibleAt = i;
            }
            this.fullyVisibleFor = i - this.becameFullyVisibleAt;
            this.calculateVisiblePortion(i);
            this.toast.update(this.this$0, this.fullyVisibleFor);
            Toast.Visibility toast$visibility = this.toast.getWantedVisibility();
            if (toast$visibility != this.visibility) {
                this.animationStartTime = i - (long)((int)((1.0f - this.visiblePortion) * 600.0f));
                this.visibility = toast$visibility;
                this.visibility.playSound(this.this$0.minecraft.getSoundManager());
            }
            this.hasFinishedRendering = this.visibility == Toast.Visibility.HIDE && i - this.animationStartTime > 600L;
        }

        public void render(GuiGraphics p_362825_, int p_361934_) {
            p_362825_.pose().pushPose();
            p_362825_.pose().translate((float)p_361934_ - (float)this.toast.width() * this.visiblePortion, this.firstSlotIndex * 32, 800.0f);
            this.toast.render(p_362825_, this.this$0.minecraft.font, this.fullyVisibleFor);
            p_362825_.pose().popPose();
        }
    }
}

