/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.screens.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screens.CreateFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface PresetEditor {
    @Deprecated
    public static final Map<Optional<ResourceKey<WorldPreset>>, PresetEditor> EDITORS = Map.of(Optional.of(WorldPresets.FLAT), (p_232974_, p_232975_) -> {
        ChunkGenerator chunkgenerator = p_232975_.selectedDimensions().overworld();
        RegistryAccess.Frozen registryaccess = p_232975_.worldgenLoadContext();
        Registry holdergetter = registryaccess.lookupOrThrow(Registries.BIOME);
        Registry holdergetter1 = registryaccess.lookupOrThrow(Registries.STRUCTURE_SET);
        Registry holdergetter2 = registryaccess.lookupOrThrow(Registries.PLACED_FEATURE);
        return new CreateFlatWorldScreen(p_232974_, p_267859_ -> p_232974_.getUiState().updateDimensions(PresetEditor.flatWorldConfigurator(p_267859_)), chunkgenerator instanceof FlatLevelSource ? ((FlatLevelSource)chunkgenerator).settings() : FlatLevelGeneratorSettings.getDefault((HolderGetter)holdergetter, (HolderGetter)holdergetter1, (HolderGetter)holdergetter2));
    }, Optional.of(WorldPresets.SINGLE_BIOME_SURFACE), (p_232962_, p_232963_) -> new CreateBuffetWorldScreen((Screen)p_232962_, p_232963_, p_267861_ -> p_232962_.getUiState().updateDimensions(PresetEditor.fixedBiomeConfigurator(p_267861_))));

    public Screen createEditScreen(CreateWorldScreen var1, WorldCreationContext var2);

    public static WorldCreationContext.DimensionsUpdater flatWorldConfigurator(FlatLevelGeneratorSettings p_250871_) {
        return (p_359110_, p_359111_) -> {
            FlatLevelSource chunkgenerator = new FlatLevelSource(p_250871_);
            return p_359111_.replaceOverworldGenerator((HolderLookup.Provider)p_359110_, (ChunkGenerator)chunkgenerator);
        };
    }

    private static WorldCreationContext.DimensionsUpdater fixedBiomeConfigurator(Holder<Biome> p_248835_) {
        return (p_367763_, p_367764_) -> {
            Registry registry = p_367763_.lookupOrThrow(Registries.NOISE_SETTINGS);
            Holder.Reference holder = registry.getOrThrow(NoiseGeneratorSettings.OVERWORLD);
            FixedBiomeSource biomesource = new FixedBiomeSource(p_248835_);
            NoiseBasedChunkGenerator chunkgenerator = new NoiseBasedChunkGenerator((BiomeSource)biomesource, (Holder)holder);
            return p_367764_.replaceOverworldGenerator((HolderLookup.Provider)p_367763_, (ChunkGenerator)chunkgenerator);
        };
    }
}

