/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.fml.common.asm.enumextension.ReservedConstructor;
import net.neoforged.neoforge.client.IArmPoseTransformer;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HumanoidModel<T extends HumanoidRenderState>
extends EntityModel<T>
implements ArmedModel,
HeadedModel {
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 16.0f, 0.0f, 2.0f, 2.0f, 24.0f, Set.of("head"));
    public static final float OVERLAY_SCALE = 0.25f;
    public static final float HAT_OVERLAY_SCALE = 0.5f;
    public static final float LEGGINGS_OVERLAY_SCALE = -0.1f;
    private static final float DUCK_WALK_ROTATION = 0.005f;
    private static final float SPYGLASS_ARM_ROT_Y = 0.2617994f;
    private static final float SPYGLASS_ARM_ROT_X = 1.9198622f;
    private static final float SPYGLASS_ARM_CROUCH_ROT_X = 0.2617994f;
    private static final float HIGHEST_SHIELD_BLOCKING_ANGLE = -1.3962634f;
    private static final float LOWEST_SHIELD_BLOCKING_ANGLE = 0.43633232f;
    private static final float HORIZONTAL_SHIELD_MOVEMENT_LIMIT = 0.5235988f;
    public static final float TOOT_HORN_XROT_BASE = 1.4835298f;
    public static final float TOOT_HORN_YROT_BASE = 0.5235988f;
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;

    public HumanoidModel(ModelPart p_170677_) {
        this(p_170677_, RenderType::entityCutoutNoCull);
    }

    public HumanoidModel(ModelPart p_170679_, Function<ResourceLocation, RenderType> p_170680_) {
        super(p_170679_, p_170680_);
        this.head = p_170679_.getChild("head");
        this.hat = this.head.getChild("hat");
        this.body = p_170679_.getChild("body");
        this.rightArm = p_170679_.getChild("right_arm");
        this.leftArm = p_170679_.getChild("left_arm");
        this.rightLeg = p_170679_.getChild("right_leg");
        this.leftLeg = p_170679_.getChild("left_leg");
    }

    public static MeshDefinition createMesh(CubeDeformation p_170682_, float p_170683_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_), PartPose.offset((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition1.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_.extend(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)0.0f, (float)(0.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)-5.0f, (float)(2.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)5.0f, (float)(2.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)-1.9f, (float)(12.0f + p_170683_), (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset((float)1.9f, (float)(12.0f + p_170683_), (float)0.0f));
        return meshdefinition;
    }

    protected ArmPose getArmPose(T p_362195_, HumanoidArm p_363496_) {
        return ArmPose.EMPTY;
    }

    public void setupAnim(T p_361833_) {
        boolean flag1;
        super.setupAnim(p_361833_);
        ArmPose humanoidmodel$armpose = this.getArmPose(p_361833_, HumanoidArm.LEFT);
        ArmPose humanoidmodel$armpose1 = this.getArmPose(p_361833_, HumanoidArm.RIGHT);
        float f = ((HumanoidRenderState)p_361833_).swimAmount;
        boolean flag = ((HumanoidRenderState)p_361833_).isFallFlying;
        this.head.xRot = ((HumanoidRenderState)p_361833_).xRot * ((float)Math.PI / 180);
        this.head.yRot = ((HumanoidRenderState)p_361833_).yRot * ((float)Math.PI / 180);
        if (flag) {
            this.head.xRot = -0.7853982f;
        } else if (f > 0.0f) {
            this.head.xRot = Mth.rotLerpRad((float)f, (float)this.head.xRot, (float)-0.7853982f);
        }
        float f1 = ((HumanoidRenderState)p_361833_).walkAnimationPos;
        float f2 = ((HumanoidRenderState)p_361833_).walkAnimationSpeed;
        this.rightArm.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 2.0f * f2 * 0.5f / ((HumanoidRenderState)p_361833_).speedValue;
        this.leftArm.xRot = Mth.cos((float)(f1 * 0.6662f)) * 2.0f * f2 * 0.5f / ((HumanoidRenderState)p_361833_).speedValue;
        this.rightLeg.xRot = Mth.cos((float)(f1 * 0.6662f)) * 1.4f * f2 / ((HumanoidRenderState)p_361833_).speedValue;
        this.leftLeg.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 1.4f * f2 / ((HumanoidRenderState)p_361833_).speedValue;
        this.rightLeg.yRot = 0.005f;
        this.leftLeg.yRot = -0.005f;
        this.rightLeg.zRot = 0.005f;
        this.leftLeg.zRot = -0.005f;
        if (((HumanoidRenderState)p_361833_).isPassenger) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        boolean bl = flag1 = ((HumanoidRenderState)p_361833_).mainArm == HumanoidArm.RIGHT;
        if (((HumanoidRenderState)p_361833_).isUsingItem) {
            boolean flag2;
            boolean bl2 = flag2 = ((HumanoidRenderState)p_361833_).useItemHand == InteractionHand.MAIN_HAND;
            if (flag2 == flag1) {
                this.poseRightArm(p_361833_, humanoidmodel$armpose1);
            } else {
                this.poseLeftArm(p_361833_, humanoidmodel$armpose);
            }
        } else {
            boolean flag3;
            boolean bl3 = flag3 = flag1 ? humanoidmodel$armpose.isTwoHanded() : humanoidmodel$armpose1.isTwoHanded();
            if (flag1 != flag3) {
                this.poseLeftArm(p_361833_, humanoidmodel$armpose);
                this.poseRightArm(p_361833_, humanoidmodel$armpose1);
            } else {
                this.poseRightArm(p_361833_, humanoidmodel$armpose1);
                this.poseLeftArm(p_361833_, humanoidmodel$armpose);
            }
        }
        this.setupAttackAnimation(p_361833_, ((HumanoidRenderState)p_361833_).ageInTicks);
        if (((HumanoidRenderState)p_361833_).isCrouching) {
            this.body.xRot = 0.5f;
            this.rightArm.xRot += 0.4f;
            this.leftArm.xRot += 0.4f;
            this.rightLeg.z += 4.0f;
            this.leftLeg.z += 4.0f;
            this.head.y += 4.2f;
            this.body.y += 3.2f;
            this.leftArm.y += 3.2f;
            this.rightArm.y += 3.2f;
        }
        if (humanoidmodel$armpose1 != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.rightArm, (float)((HumanoidRenderState)p_361833_).ageInTicks, (float)1.0f);
        }
        if (humanoidmodel$armpose != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart((ModelPart)this.leftArm, (float)((HumanoidRenderState)p_361833_).ageInTicks, (float)-1.0f);
        }
        if (f > 0.0f) {
            float f4;
            float f7 = f1 % 26.0f;
            HumanoidArm humanoidarm = ((HumanoidRenderState)p_361833_).attackArm;
            float f3 = humanoidarm == HumanoidArm.RIGHT && ((HumanoidRenderState)p_361833_).attackTime > 0.0f ? 0.0f : f;
            float f5 = f4 = humanoidarm == HumanoidArm.LEFT && ((HumanoidRenderState)p_361833_).attackTime > 0.0f ? 0.0f : f;
            if (!((HumanoidRenderState)p_361833_).isUsingItem) {
                if (f7 < 14.0f) {
                    this.leftArm.xRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.xRot, (float)0.0f);
                    this.rightArm.xRot = Mth.lerp((float)f3, (float)this.rightArm.xRot, (float)0.0f);
                    this.leftArm.yRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.yRot, (float)((float)Math.PI));
                    this.rightArm.yRot = Mth.lerp((float)f3, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.zRot, (float)((float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f7) / this.quadraticArmUpdate(14.0f)));
                    this.rightArm.zRot = Mth.lerp((float)f3, (float)this.rightArm.zRot, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f7) / this.quadraticArmUpdate(14.0f)));
                } else if (f7 >= 14.0f && f7 < 22.0f) {
                    float f8 = (f7 - 14.0f) / 8.0f;
                    this.leftArm.xRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.xRot, (float)(1.5707964f * f8));
                    this.rightArm.xRot = Mth.lerp((float)f3, (float)this.rightArm.xRot, (float)(1.5707964f * f8));
                    this.leftArm.yRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.yRot, (float)((float)Math.PI));
                    this.rightArm.yRot = Mth.lerp((float)f3, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.zRot, (float)(5.012389f - 1.8707964f * f8));
                    this.rightArm.zRot = Mth.lerp((float)f3, (float)this.rightArm.zRot, (float)(1.2707963f + 1.8707964f * f8));
                } else if (f7 >= 22.0f && f7 < 26.0f) {
                    float f52 = (f7 - 22.0f) / 4.0f;
                    this.leftArm.xRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.xRot, (float)(1.5707964f - 1.5707964f * f52));
                    this.rightArm.xRot = Mth.lerp((float)f3, (float)this.rightArm.xRot, (float)(1.5707964f - 1.5707964f * f52));
                    this.leftArm.yRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.yRot, (float)((float)Math.PI));
                    this.rightArm.yRot = Mth.lerp((float)f3, (float)this.rightArm.yRot, (float)((float)Math.PI));
                    this.leftArm.zRot = Mth.rotLerpRad((float)f4, (float)this.leftArm.zRot, (float)((float)Math.PI));
                    this.rightArm.zRot = Mth.lerp((float)f3, (float)this.rightArm.zRot, (float)((float)Math.PI));
                }
            }
            float f9 = 0.3f;
            float f6 = 0.33333334f;
            this.leftLeg.xRot = Mth.lerp((float)f, (float)this.leftLeg.xRot, (float)(0.3f * Mth.cos((float)(f1 * 0.33333334f + (float)Math.PI))));
            this.rightLeg.xRot = Mth.lerp((float)f, (float)this.rightLeg.xRot, (float)(0.3f * Mth.cos((float)(f1 * 0.33333334f))));
        }
    }

    private void poseRightArm(T p_364666_, ArmPose p_362238_) {
        switch (p_362238_.ordinal()) {
            case 0: {
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 1: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 2: {
                this.poseBlockingArm(this.rightArm, true);
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot;
                this.leftArm.yRot = 0.1f + this.head.yRot + 0.4f;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 4: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case 5: {
                AnimationUtils.animateCrossbowCharge((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)((HumanoidRenderState)p_364666_).maxCrossbowChargeDuration, (int)((HumanoidRenderState)p_364666_).ticksUsingItem, (boolean)true);
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
                break;
            }
            case 7: {
                this.rightArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (((HumanoidRenderState)p_364666_).isCrouching ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
                break;
            }
            case 8: {
                this.rightArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.rightArm.yRot = this.head.yRot - 0.5235988f;
                break;
            }
            case 9: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.62831855f;
                this.rightArm.yRot = 0.0f;
            }
            default: {
                p_362238_.applyTransform(this, p_364666_, HumanoidArm.RIGHT);
            }
        }
    }

    private void poseLeftArm(T p_361741_, ArmPose p_361463_) {
        switch (p_361463_.ordinal()) {
            case 0: {
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 1: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 2: {
                this.poseBlockingArm(this.leftArm, false);
                break;
            }
            case 3: {
                this.rightArm.yRot = -0.1f + this.head.yRot - 0.4f;
                this.leftArm.yRot = 0.1f + this.head.yRot;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case 4: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case 5: {
                AnimationUtils.animateCrossbowCharge((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)((HumanoidRenderState)p_361741_).maxCrossbowChargeDuration, (int)((HumanoidRenderState)p_361741_).ticksUsingItem, (boolean)false);
                break;
            }
            case 6: {
                AnimationUtils.animateCrossbowHold((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)false);
                break;
            }
            case 7: {
                this.leftArm.xRot = Mth.clamp((float)(this.head.xRot - 1.9198622f - (((HumanoidRenderState)p_361741_).isCrouching ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
                break;
            }
            case 8: {
                this.leftArm.xRot = Mth.clamp((float)this.head.xRot, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.leftArm.yRot = this.head.yRot + 0.5235988f;
                break;
            }
            case 9: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.62831855f;
                this.leftArm.yRot = 0.0f;
            }
            default: {
                p_361463_.applyTransform(this, p_361741_, HumanoidArm.LEFT);
            }
        }
    }

    private void poseBlockingArm(ModelPart p_304530_, boolean p_304416_) {
        p_304530_.xRot = p_304530_.xRot * 0.5f - 0.9424779f + Mth.clamp((float)this.head.xRot, (float)-1.3962634f, (float)0.43633232f);
        p_304530_.yRot = (p_304416_ ? -30.0f : 30.0f) * ((float)Math.PI / 180) + Mth.clamp((float)this.head.yRot, (float)-0.5235988f, (float)0.5235988f);
    }

    protected void setupAttackAnimation(T p_361366_, float p_102859_) {
        float f = ((HumanoidRenderState)p_361366_).attackTime;
        if (!(f <= 0.0f)) {
            HumanoidArm humanoidarm = ((HumanoidRenderState)p_361366_).attackArm;
            ModelPart modelpart = this.getArm(humanoidarm);
            this.body.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.yRot *= -1.0f;
            }
            float f2 = ((HumanoidRenderState)p_361366_).ageScale;
            this.rightArm.z = Mth.sin((float)this.body.yRot) * 5.0f * f2;
            this.rightArm.x = -Mth.cos((float)this.body.yRot) * 5.0f * f2;
            this.leftArm.z = -Mth.sin((float)this.body.yRot) * 5.0f * f2;
            this.leftArm.x = Mth.cos((float)this.body.yRot) * 5.0f * f2;
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            float $$5 = 1.0f - f;
            $$5 *= $$5;
            $$5 *= $$5;
            $$5 = 1.0f - $$5;
            float f3 = Mth.sin((float)($$5 * (float)Math.PI));
            float f4 = Mth.sin((float)(f * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f3 * 1.2f + f4;
            modelpart.yRot += this.body.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(f * (float)Math.PI)) * -0.4f;
        }
    }

    private float quadraticArmUpdate(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }

    public void copyPropertiesTo(HumanoidModel<T> p_372920_) {
        p_372920_.head.copyFrom(this.head);
        p_372920_.body.copyFrom(this.body);
        p_372920_.rightArm.copyFrom(this.rightArm);
        p_372920_.leftArm.copyFrom(this.leftArm);
        p_372920_.rightLeg.copyFrom(this.rightLeg);
        p_372920_.leftLeg.copyFrom(this.leftLeg);
    }

    public void setAllVisible(boolean p_102880_) {
        this.head.visible = p_102880_;
        this.hat.visible = p_102880_;
        this.body.visible = p_102880_;
        this.rightArm.visible = p_102880_;
        this.leftArm.visible = p_102880_;
        this.rightLeg.visible = p_102880_;
        this.leftLeg.visible = p_102880_;
    }

    public void translateToHand(HumanoidArm p_102854_, PoseStack p_102855_) {
        this.root.translateAndRotate(p_102855_);
        this.getArm(p_102854_).translateAndRotate(p_102855_);
    }

    protected ModelPart getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose implements IExtensibleEnum
    {
        EMPTY(false),
        ITEM(false),
        BLOCK(false),
        BOW_AND_ARROW(true),
        THROW_SPEAR(false),
        CROSSBOW_CHARGE(true),
        CROSSBOW_HOLD(true),
        SPYGLASS(false),
        TOOT_HORN(false),
        BRUSH(false);

        private final boolean twoHanded;
        @Nullable
        private final IArmPoseTransformer forgeArmPose;

        @ReservedConstructor
        private ArmPose(boolean p_102896_) {
            this.twoHanded = p_102896_;
            this.forgeArmPose = null;
        }

        private ArmPose(boolean twoHanded, IArmPoseTransformer forgeArmPose) {
            this.twoHanded = twoHanded;
            Preconditions.checkNotNull((Object)forgeArmPose, (Object)"Cannot create new ArmPose with null transformer!");
            this.forgeArmPose = forgeArmPose;
        }

        public boolean isTwoHanded() {
            return this.twoHanded;
        }

        public <T extends HumanoidRenderState> void applyTransform(HumanoidModel<T> model, T entity, HumanoidArm arm) {
            if (this.forgeArmPose != null) {
                this.forgeArmPose.applyTransform(model, entity, arm);
            }
        }

        public static ExtensionInfo getExtensionInfo() {
            return ExtensionInfo.nonExtended(ArmPose.class);
        }
    }
}

