/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;

@OnlyIn(value=Dist.CLIENT)
public class LevelEventHandler {
    private final Minecraft minecraft;
    private final Level level;
    private final LevelRenderer levelRenderer;
    private final Map<BlockPos, SoundInstance> playingJukeboxSongs = new HashMap<BlockPos, SoundInstance>();

    public LevelEventHandler(Minecraft p_365160_, Level p_362367_, LevelRenderer p_361552_) {
        this.minecraft = p_365160_;
        this.level = p_362367_;
        this.levelRenderer = p_361552_;
    }

    public void globalLevelEvent(int p_361814_, BlockPos p_361734_, int p_365242_) {
        switch (p_361814_) {
            case 1023: 
            case 1028: 
            case 1038: {
                Camera camera = this.minecraft.gameRenderer.getMainCamera();
                if (!camera.isInitialized()) break;
                Vec3 vec3 = Vec3.atCenterOf((Vec3i)p_361734_).subtract(camera.getPosition()).normalize();
                Vec3 vec31 = camera.getPosition().add(vec3.scale(2.0));
                if (p_361814_ == 1023) {
                    this.level.playLocalSound(vec31.x, vec31.y, vec31.z, SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (p_361814_ == 1038) {
                    this.level.playLocalSound(vec31.x, vec31.y, vec31.z, SoundEvents.END_PORTAL_SPAWN, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.level.playLocalSound(vec31.x, vec31.y, vec31.z, SoundEvents.ENDER_DRAGON_DEATH, SoundSource.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void levelEvent(int p_364986_, BlockPos p_362181_, int p_360434_) {
        RandomSource randomsource = this.level.random;
        switch (p_364986_) {
            case 1000: {
                this.level.playLocalSound(p_362181_, SoundEvents.DISPENSER_DISPENSE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1001: {
                this.level.playLocalSound(p_362181_, SoundEvents.DISPENSER_FAIL, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.level.playLocalSound(p_362181_, SoundEvents.DISPENSER_LAUNCH, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1004: {
                this.level.playLocalSound(p_362181_, SoundEvents.FIREWORK_ROCKET_SHOOT, SoundSource.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1009: {
                if (p_360434_ == 0) {
                    this.level.playLocalSound(p_362181_, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (randomsource.nextFloat() - randomsource.nextFloat()) * 0.8f, false);
                    break;
                }
                if (p_360434_ != 1) break;
                this.level.playLocalSound(p_362181_, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.7f, 1.6f + (randomsource.nextFloat() - randomsource.nextFloat()) * 0.4f, false);
                break;
            }
            case 1010: {
                this.level.registryAccess().lookupOrThrow(Registries.JUKEBOX_SONG).get(p_360434_).ifPresent(p_360383_ -> this.playJukeboxSong((Holder<JukeboxSong>)p_360383_, p_362181_));
                break;
            }
            case 1011: {
                this.stopJukeboxSongAndNotifyNearby(p_362181_);
                break;
            }
            case 1015: {
                this.level.playLocalSound(p_362181_, SoundEvents.GHAST_WARN, SoundSource.HOSTILE, 10.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.level.playLocalSound(p_362181_, SoundEvents.GHAST_SHOOT, SoundSource.HOSTILE, 10.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.level.playLocalSound(p_362181_, SoundEvents.ENDER_DRAGON_SHOOT, SoundSource.HOSTILE, 10.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.level.playLocalSound(p_362181_, SoundEvents.BLAZE_SHOOT, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_ATTACK_WOODEN_DOOR, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.level.playLocalSound(p_362181_, SoundEvents.WITHER_BREAK_BLOCK, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.level.playLocalSound(p_362181_, SoundEvents.WITHER_SHOOT, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.level.playLocalSound(p_362181_, SoundEvents.BAT_TAKEOFF, SoundSource.NEUTRAL, 0.05f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_INFECT, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1029: {
                this.level.playLocalSound(p_362181_, SoundEvents.ANVIL_DESTROY, SoundSource.BLOCKS, 1.0f, randomsource.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.level.playLocalSound(p_362181_, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, randomsource.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.level.playLocalSound(p_362181_, SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 0.3f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1032: {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.PORTAL_TRAVEL, (float)(randomsource.nextFloat() * 0.4f + 0.8f), (float)0.25f));
                break;
            }
            case 1033: {
                this.level.playLocalSound(p_362181_, SoundEvents.CHORUS_FLOWER_GROW, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.level.playLocalSound(p_362181_, SoundEvents.CHORUS_FLOWER_DEATH, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1035: {
                this.level.playLocalSound(p_362181_, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1039: {
                this.level.playLocalSound(p_362181_, SoundEvents.PHANTOM_BITE, SoundSource.HOSTILE, 0.3f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1040: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_CONVERTED_TO_DROWNED, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                this.level.playLocalSound(p_362181_, SoundEvents.HUSK_CONVERTED_TO_ZOMBIE, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1042: {
                this.level.playLocalSound(p_362181_, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1043: {
                this.level.playLocalSound(p_362181_, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1044: {
                this.level.playLocalSound(p_362181_, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1045: {
                this.level.playLocalSound(p_362181_, SoundEvents.POINTED_DRIPSTONE_LAND, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1046: {
                this.level.playLocalSound(p_362181_, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1047: {
                this.level.playLocalSound(p_362181_, SoundEvents.POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1048: {
                this.level.playLocalSound(p_362181_, SoundEvents.SKELETON_CONVERTED_TO_STRAY, SoundSource.HOSTILE, 2.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1049: {
                this.level.playLocalSound(p_362181_, SoundEvents.CRAFTER_CRAFT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1050: {
                this.level.playLocalSound(p_362181_, SoundEvents.CRAFTER_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1051: {
                this.level.playLocalSound(p_362181_, SoundEvents.WIND_CHARGE_THROW, SoundSource.BLOCKS, 0.5f, 0.4f / (this.level.getRandom().nextFloat() * 0.4f + 0.8f), false);
                break;
            }
            case 1500: {
                ComposterBlock.handleFill(this.level, p_362181_, p_360434_ > 0);
                break;
            }
            case 1501: {
                this.level.playLocalSound(p_362181_, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (randomsource.nextFloat() - randomsource.nextFloat()) * 0.8f, false);
                for (int l2 = 0; l2 < 8; ++l2) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)p_362181_.getX() + randomsource.nextDouble(), (double)p_362181_.getY() + 1.2, (double)p_362181_.getZ() + randomsource.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1502: {
                this.level.playLocalSound(p_362181_, SoundEvents.REDSTONE_TORCH_BURNOUT, SoundSource.BLOCKS, 0.5f, 2.6f + (randomsource.nextFloat() - randomsource.nextFloat()) * 0.8f, false);
                for (int k2 = 0; k2 < 5; ++k2) {
                    double d12 = (double)p_362181_.getX() + randomsource.nextDouble() * 0.6 + 0.2;
                    double d17 = (double)p_362181_.getY() + randomsource.nextDouble() * 0.6 + 0.2;
                    double d22 = (double)p_362181_.getZ() + randomsource.nextDouble() * 0.6 + 0.2;
                    this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d12, d17, d22, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1503: {
                this.level.playLocalSound(p_362181_, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                for (int j2 = 0; j2 < 16; ++j2) {
                    double d11 = (double)p_362181_.getX() + (5.0 + randomsource.nextDouble() * 6.0) / 16.0;
                    double d16 = (double)p_362181_.getY() + 0.8125;
                    double d21 = (double)p_362181_.getZ() + (5.0 + randomsource.nextDouble() * 6.0) / 16.0;
                    this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d11, d16, d21, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1504: {
                PointedDripstoneBlock.spawnDripParticle(this.level, p_362181_, this.level.getBlockState(p_362181_));
                break;
            }
            case 1505: {
                BoneMealItem.addGrowthParticles(this.level, p_362181_, p_360434_);
                this.level.playLocalSound(p_362181_, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 2000: {
                this.shootParticles(p_360434_, p_362181_, randomsource, ParticleTypes.SMOKE);
                break;
            }
            case 2001: {
                BlockState blockstate1 = Block.stateById(p_360434_);
                if (!blockstate1.isAir() && !IClientBlockExtensions.of((BlockState)blockstate1).playBreakSound(blockstate1, this.level, p_362181_)) {
                    SoundType soundtype = blockstate1.getSoundType((LevelReader)((Object)this.level), p_362181_, null);
                    this.level.playLocalSound(p_362181_, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f, false);
                }
                this.level.addDestroyBlockEffect(p_362181_, blockstate1);
                break;
            }
            case 2002: 
            case 2007: {
                Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)p_362181_);
                for (int j = 0; j < 8; ++j) {
                    this.levelRenderer.addParticle(new ItemParticleOption((ParticleType<ItemParticleOption>)ParticleTypes.ITEM, new ItemStack(Items.SPLASH_POTION)), vec3.x, vec3.y, vec3.z, randomsource.nextGaussian() * 0.15, randomsource.nextDouble() * 0.2, randomsource.nextGaussian() * 0.15);
                }
                float f2 = (float)(p_360434_ >> 16 & 0xFF) / 255.0f;
                float f3 = (float)(p_360434_ >> 8 & 0xFF) / 255.0f;
                float f5 = (float)(p_360434_ >> 0 & 0xFF) / 255.0f;
                SimpleParticleType particleoptions = p_364986_ == 2007 ? ParticleTypes.INSTANT_EFFECT : ParticleTypes.EFFECT;
                for (int i2 = 0; i2 < 100; ++i2) {
                    double d10 = randomsource.nextDouble() * 4.0;
                    double d15 = randomsource.nextDouble() * Math.PI * 2.0;
                    double d20 = Math.cos(d15) * d10;
                    double d24 = 0.01 + randomsource.nextDouble() * 0.5;
                    double d25 = Math.sin(d15) * d10;
                    Particle particle1 = this.levelRenderer.addParticleInternal((ParticleOptions)particleoptions, particleoptions.getType().getOverrideLimiter(), vec3.x + d20 * 0.1, vec3.y + 0.3, vec3.z + d25 * 0.1, d20, d24, d25);
                    if (particle1 == null) continue;
                    float f1 = 0.75f + randomsource.nextFloat() * 0.25f;
                    particle1.setColor(f2 * f1, f3 * f1, f5 * f1);
                    particle1.setPower((float)d10);
                }
                this.level.playLocalSound(p_362181_, SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, randomsource.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2003: {
                double d0 = (double)p_362181_.getX() + 0.5;
                double d5 = p_362181_.getY();
                double d7 = (double)p_362181_.getZ() + 0.5;
                for (int i3 = 0; i3 < 8; ++i3) {
                    this.levelRenderer.addParticle(new ItemParticleOption((ParticleType<ItemParticleOption>)ParticleTypes.ITEM, new ItemStack(Items.ENDER_EYE)), d0, d5, d7, randomsource.nextGaussian() * 0.15, randomsource.nextDouble() * 0.2, randomsource.nextGaussian() * 0.15);
                }
                for (double d9 = 0.0; d9 < Math.PI * 2; d9 += 0.15707963267948966) {
                    this.levelRenderer.addParticle(ParticleTypes.PORTAL, d0 + Math.cos(d9) * 5.0, d5 - 0.4, d7 + Math.sin(d9) * 5.0, Math.cos(d9) * -5.0, 0.0, Math.sin(d9) * -5.0);
                    this.levelRenderer.addParticle(ParticleTypes.PORTAL, d0 + Math.cos(d9) * 5.0, d5 - 0.4, d7 + Math.sin(d9) * 5.0, Math.cos(d9) * -7.0, 0.0, Math.sin(d9) * -7.0);
                }
                break;
            }
            case 2004: {
                for (int l = 0; l < 20; ++l) {
                    double d6 = (double)p_362181_.getX() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
                    double d8 = (double)p_362181_.getY() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
                    double d13 = (double)p_362181_.getZ() + 0.5 + (randomsource.nextDouble() - 0.5) * 2.0;
                    this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d6, d8, d13, 0.0, 0.0, 0.0);
                    this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, d6, d8, d13, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2006: {
                for (int l1 = 0; l1 < 200; ++l1) {
                    float f10 = randomsource.nextFloat() * 4.0f;
                    float f11 = randomsource.nextFloat() * ((float)Math.PI * 2);
                    double d14 = Mth.cos((float)f11) * f10;
                    double d19 = 0.01 + randomsource.nextDouble() * 0.5;
                    double d23 = Mth.sin((float)f11) * f10;
                    Particle particle = this.levelRenderer.addParticleInternal((ParticleOptions)ParticleTypes.DRAGON_BREATH, false, (double)p_362181_.getX() + d14 * 0.1, (double)p_362181_.getY() + 0.3, (double)p_362181_.getZ() + d23 * 0.1, d14, d19, d23);
                    if (particle == null) continue;
                    particle.setPower(f10);
                }
                if (p_360434_ != 1) break;
                this.level.playLocalSound(p_362181_, SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.HOSTILE, 1.0f, randomsource.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2008: {
                this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + 0.5, (double)p_362181_.getZ() + 0.5, 0.0, 0.0, 0.0);
                break;
            }
            case 2009: {
                for (int k1 = 0; k1 < 8; ++k1) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)p_362181_.getX() + randomsource.nextDouble(), (double)p_362181_.getY() + 1.2, (double)p_362181_.getZ() + randomsource.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2010: {
                this.shootParticles(p_360434_, p_362181_, randomsource, ParticleTypes.WHITE_SMOKE);
                break;
            }
            case 2011: {
                ParticleUtils.spawnParticleInBlock((LevelAccessor)this.level, (BlockPos)p_362181_, (int)p_360434_, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                break;
            }
            case 2012: {
                ParticleUtils.spawnParticleInBlock((LevelAccessor)this.level, (BlockPos)p_362181_, (int)p_360434_, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
                break;
            }
            case 2013: {
                ParticleUtils.spawnSmashAttackParticles((LevelAccessor)this.level, (BlockPos)p_362181_, (int)p_360434_);
                break;
            }
            case 3000: {
                this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, true, (double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + 0.5, (double)p_362181_.getZ() + 0.5, 0.0, 0.0, 0.0);
                this.level.playLocalSound(p_362181_, SoundEvents.END_GATEWAY_SPAWN, SoundSource.BLOCKS, 10.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.level.playLocalSound(p_362181_, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.HOSTILE, 64.0f, 0.8f + this.level.random.nextFloat() * 0.3f, false);
                break;
            }
            case 3002: {
                if (p_360434_ >= 0 && p_360434_ < Direction.Axis.VALUES.length) {
                    ParticleUtils.spawnParticlesAlongAxis((Direction.Axis)Direction.Axis.VALUES[p_360434_], (Level)this.level, (BlockPos)p_362181_, (double)0.125, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (UniformInt)UniformInt.of((int)10, (int)19));
                    break;
                }
                ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (IntProvider)UniformInt.of((int)3, (int)5));
                break;
            }
            case 3003: {
                ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                this.level.playLocalSound(p_362181_, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 3004: {
                ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)ParticleTypes.WAX_OFF, (IntProvider)UniformInt.of((int)3, (int)5));
                break;
            }
            case 3005: {
                ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)ParticleTypes.SCRAPE, (IntProvider)UniformInt.of((int)3, (int)5));
                break;
            }
            case 3006: {
                int k = p_360434_ >> 6;
                if (k > 0) {
                    if (randomsource.nextFloat() < 0.3f + (float)k * 0.1f) {
                        float f4 = 0.15f + 0.02f * (float)k * (float)k * randomsource.nextFloat();
                        float f6 = 0.4f + 0.3f * (float)k * randomsource.nextFloat();
                        this.level.playLocalSound(p_362181_, SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.BLOCKS, f4, f6, false);
                    }
                    byte b0 = (byte)(p_360434_ & 0x3F);
                    UniformInt intprovider = UniformInt.of((int)0, (int)k);
                    float f7 = 0.005f;
                    Supplier<Vec3> supplier = () -> new Vec3(Mth.nextDouble((RandomSource)randomsource, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)randomsource, (double)-0.005f, (double)0.005f), Mth.nextDouble((RandomSource)randomsource, (double)-0.005f, (double)0.005f));
                    if (b0 == 0) {
                        for (Direction direction : Direction.values()) {
                            float f = direction == Direction.DOWN ? (float)Math.PI : 0.0f;
                            double d4 = direction.getAxis() == Direction.Axis.Y ? 0.65 : 0.57;
                            ParticleUtils.spawnParticlesOnBlockFace((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)new SculkChargeParticleOptions(f), (IntProvider)intprovider, (Direction)direction, supplier, (double)d4);
                        }
                    } else {
                        for (Direction direction1 : MultifaceBlock.unpack((byte)b0)) {
                            float f13 = direction1 == Direction.UP ? (float)Math.PI : 0.0f;
                            double d18 = 0.35;
                            ParticleUtils.spawnParticlesOnBlockFace((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)new SculkChargeParticleOptions(f13), (IntProvider)intprovider, (Direction)direction1, supplier, (double)0.35);
                        }
                    }
                } else {
                    this.level.playLocalSound(p_362181_, SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    boolean flag1 = this.level.getBlockState(p_362181_).isCollisionShapeFullBlock((BlockGetter)((Object)this.level), p_362181_);
                    int j1 = flag1 ? 40 : 20;
                    float f8 = flag1 ? 0.45f : 0.25f;
                    float f9 = 0.07f;
                    for (int j3 = 0; j3 < j1; ++j3) {
                        float f12 = 2.0f * randomsource.nextFloat() - 1.0f;
                        float f14 = 2.0f * randomsource.nextFloat() - 1.0f;
                        float f15 = 2.0f * randomsource.nextFloat() - 1.0f;
                        this.level.addParticle((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, (double)p_362181_.getX() + 0.5 + (double)(f12 * f8), (double)p_362181_.getY() + 0.5 + (double)(f14 * f8), (double)p_362181_.getZ() + 0.5 + (double)(f15 * f8), f12 * 0.07f, f14 * 0.07f, f15 * 0.07f);
                    }
                }
                break;
            }
            case 3007: {
                boolean flag;
                for (int i1 = 0; i1 < 10; ++i1) {
                    this.level.addParticle((ParticleOptions)new ShriekParticleOption(i1 * 5), false, (double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + SculkShriekerBlock.TOP_Y, (double)p_362181_.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
                BlockState blockstate2 = this.level.getBlockState(p_362181_);
                boolean bl = flag = blockstate2.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockstate2.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
                if (flag) break;
                this.level.playLocalSound((double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + SculkShriekerBlock.TOP_Y, (double)p_362181_.getZ() + 0.5, SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.BLOCKS, 2.0f, 0.6f + this.level.random.nextFloat() * 0.4f, false);
                break;
            }
            case 3008: {
                BlockState blockstate = Block.stateById(p_360434_);
                Block j3 = blockstate.getBlock();
                if (j3 instanceof BrushableBlock) {
                    BrushableBlock brushableblock = (BrushableBlock)j3;
                    this.level.playLocalSound(p_362181_, brushableblock.getBrushCompletedSound(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
                this.level.addDestroyBlockEffect(p_362181_, blockstate);
                break;
            }
            case 3009: {
                ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)ParticleTypes.EGG_CRACK, (IntProvider)UniformInt.of((int)3, (int)6));
                break;
            }
            case 3011: {
                TrialSpawner.addSpawnParticles(this.level, p_362181_, randomsource, TrialSpawner.FlameParticle.decode((int)p_360434_).particleType);
                break;
            }
            case 3012: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addSpawnParticles(this.level, p_362181_, randomsource, TrialSpawner.FlameParticle.decode((int)p_360434_).particleType);
                break;
            }
            case 3013: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_362181_, randomsource, p_360434_, (ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER);
                break;
            }
            case 3014: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_EJECT_ITEM, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addEjectItemParticles(this.level, p_362181_, randomsource);
                break;
            }
            case 3015: {
                BlockEntity j3 = this.level.getBlockEntity(p_362181_);
                if (!(j3 instanceof VaultBlockEntity)) break;
                VaultBlockEntity vaultblockentity = (VaultBlockEntity)j3;
                VaultBlockEntity.Client.emitActivationParticles((Level)this.level, (BlockPos)vaultblockentity.getBlockPos(), (BlockState)vaultblockentity.getBlockState(), (VaultSharedData)vaultblockentity.getSharedData(), (ParticleOptions)(p_360434_ == 0 ? ParticleTypes.SMALL_FLAME : ParticleTypes.SOUL_FIRE_FLAME));
                this.level.playLocalSound(p_362181_, SoundEvents.VAULT_ACTIVATE, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 3016: {
                VaultBlockEntity.Client.emitDeactivationParticles((Level)this.level, (BlockPos)p_362181_, (ParticleOptions)(p_360434_ == 0 ? ParticleTypes.SMALL_FLAME : ParticleTypes.SOUL_FIRE_FLAME));
                this.level.playLocalSound(p_362181_, SoundEvents.VAULT_DEACTIVATE, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 3017: {
                TrialSpawner.addEjectItemParticles(this.level, p_362181_, randomsource);
                break;
            }
            case 3018: {
                for (int i = 0; i < 10; ++i) {
                    double d1 = randomsource.nextGaussian() * 0.02;
                    double d2 = randomsource.nextGaussian() * 0.02;
                    double d3 = randomsource.nextGaussian() * 0.02;
                    this.level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)p_362181_.getX() + randomsource.nextDouble(), (double)p_362181_.getY() + randomsource.nextDouble(), (double)p_362181_.getZ() + randomsource.nextDouble(), d1, d2, d3);
                }
                this.level.playLocalSound(p_362181_, SoundEvents.COBWEB_PLACE, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 3019: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_362181_, randomsource, p_360434_, (ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS);
                break;
            }
            case 3020: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, p_360434_ == 0 ? 0.3f : 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_362181_, randomsource, 0, (ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS);
                TrialSpawner.addBecomeOminousParticles(this.level, p_362181_, randomsource);
                break;
            }
            case 3021: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_SPAWN_ITEM, SoundSource.BLOCKS, 1.0f, (randomsource.nextFloat() - randomsource.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addSpawnParticles(this.level, p_362181_, randomsource, TrialSpawner.FlameParticle.decode((int)p_360434_).particleType);
            }
        }
    }

    private void shootParticles(int p_365183_, BlockPos p_360425_, RandomSource p_363511_, SimpleParticleType p_363016_) {
        Direction direction = Direction.from3DDataValue((int)p_365183_);
        int i = direction.getStepX();
        int j = direction.getStepY();
        int k = direction.getStepZ();
        for (int l = 0; l < 10; ++l) {
            double d0 = p_363511_.nextDouble() * 0.2 + 0.01;
            double d1 = (double)p_360425_.getX() + (double)i * 0.6 + 0.5 + (double)i * 0.01 + (p_363511_.nextDouble() - 0.5) * (double)k * 0.5;
            double d2 = (double)p_360425_.getY() + (double)j * 0.6 + 0.5 + (double)j * 0.01 + (p_363511_.nextDouble() - 0.5) * (double)j * 0.5;
            double d3 = (double)p_360425_.getZ() + (double)k * 0.6 + 0.5 + (double)k * 0.01 + (p_363511_.nextDouble() - 0.5) * (double)i * 0.5;
            double d4 = (double)i * d0 + p_363511_.nextGaussian() * 0.01;
            double d5 = (double)j * d0 + p_363511_.nextGaussian() * 0.01;
            double d6 = (double)k * d0 + p_363511_.nextGaussian() * 0.01;
            this.levelRenderer.addParticle(p_363016_, d1, d2, d3, d4, d5, d6);
        }
    }

    private void playJukeboxSong(Holder<JukeboxSong> p_362746_, BlockPos p_364603_) {
        this.stopJukeboxSong(p_364603_);
        JukeboxSong jukeboxsong = p_362746_.value();
        SoundEvent soundevent = (SoundEvent)jukeboxsong.soundEvent().value();
        SimpleSoundInstance soundinstance = SimpleSoundInstance.forJukeboxSong((SoundEvent)soundevent, (Vec3)Vec3.atCenterOf((Vec3i)p_364603_));
        this.playingJukeboxSongs.put(p_364603_, (SoundInstance)soundinstance);
        this.minecraft.getSoundManager().play((SoundInstance)soundinstance);
        this.minecraft.gui.setNowPlaying(jukeboxsong.description());
        this.notifyNearbyEntities(this.level, p_364603_, true);
    }

    private void stopJukeboxSong(BlockPos p_360572_) {
        SoundInstance soundinstance = this.playingJukeboxSongs.remove(p_360572_);
        if (soundinstance != null) {
            this.minecraft.getSoundManager().stop(soundinstance);
        }
    }

    private void stopJukeboxSongAndNotifyNearby(BlockPos p_364810_) {
        this.stopJukeboxSong(p_364810_);
        this.notifyNearbyEntities(this.level, p_364810_, false);
    }

    private void notifyNearbyEntities(Level p_365258_, BlockPos p_363364_, boolean p_360693_) {
        for (LivingEntity livingentity : p_365258_.getEntitiesOfClass(LivingEntity.class, new AABB(p_363364_).inflate(3.0))) {
            livingentity.setRecordPlayingNearby(p_363364_, p_360693_);
        }
    }
}

