/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.CompiledShader;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.renderer.CompiledShaderProgram;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostChainConfig;
import net.minecraft.client.renderer.ShaderDefines;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.ShaderProgramConfig;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.CoreShaderManager;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ShaderManager
extends SimplePreparableReloadListener<Configs>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final String SHADER_PATH = "shaders";
    public static final String SHADER_INCLUDE_PATH = "shaders/include/";
    private static final FileToIdConverter PROGRAM_ID_CONVERTER = FileToIdConverter.json("shaders");
    private static final FileToIdConverter POST_CHAIN_ID_CONVERTER = FileToIdConverter.json("post_effect");
    public static final int MAX_LOG_LENGTH = 32768;
    final TextureManager textureManager;
    private final Consumer<Exception> recoveryHandler;
    private CompilationCache compilationCache = new CompilationCache(Configs.EMPTY);

    public ShaderManager(TextureManager p_366478_, Consumer<Exception> p_368560_) {
        this.textureManager = p_366478_;
        this.recoveryHandler = p_368560_;
    }

    @Override
    protected Configs prepare(ResourceManager p_366761_, ProfilerFiller p_366562_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap.Builder builder1 = ImmutableMap.builder();
        Map map = p_366761_.listResources(SHADER_PATH, p_366504_ -> ShaderManager.isProgram(p_366504_) || ShaderManager.isShader(p_366504_));
        for (Map.Entry entry : map.entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            CompiledShader.Type compiledshader$type = CompiledShader.Type.byLocation((ResourceLocation)resourcelocation);
            if (compiledshader$type != null) {
                ShaderManager.loadShader(resourcelocation, (Resource)entry.getValue(), compiledshader$type, map, (ImmutableMap.Builder<ShaderSourceKey, String>)builder1);
                continue;
            }
            if (!ShaderManager.isProgram(resourcelocation)) continue;
            ShaderManager.loadProgram(resourcelocation, (Resource)entry.getValue(), (ImmutableMap.Builder<ResourceLocation, ShaderProgramConfig>)builder);
        }
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, Resource> entry1 : POST_CHAIN_ID_CONVERTER.listMatchingResources(p_366761_).entrySet()) {
            ShaderManager.loadPostChain(entry1.getKey(), entry1.getValue(), (ImmutableMap.Builder<ResourceLocation, PostChainConfig>)builder2);
        }
        return new Configs((Map<ResourceLocation, ShaderProgramConfig>)builder.build(), (Map<ShaderSourceKey, String>)builder1.build(), (Map<ResourceLocation, PostChainConfig>)builder2.build());
    }

    private static void loadShader(ResourceLocation p_366513_, Resource p_366763_, CompiledShader.Type p_366461_, Map<ResourceLocation, Resource> p_366725_, ImmutableMap.Builder<ShaderSourceKey, String> p_366733_) {
        ResourceLocation resourcelocation = p_366461_.idConverter().fileToId(p_366513_);
        GlslPreprocessor glslpreprocessor = ShaderManager.createPreprocessor(p_366725_, p_366513_);
        try (BufferedReader reader = p_366763_.openAsReader();){
            String s = IOUtils.toString((Reader)reader);
            p_366733_.put((Object)new ShaderSourceKey(resourcelocation, p_366461_), (Object)String.join((CharSequence)"", glslpreprocessor.process(s)));
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to load shader source at {}", (Object)p_366513_, (Object)ioexception);
        }
    }

    private static GlslPreprocessor createPreprocessor(final Map<ResourceLocation, Resource> p_366891_, ResourceLocation p_366860_) {
        final ResourceLocation resourcelocation = p_366860_.withPath(FileUtil::getFullResourcePath);
        return new GlslPreprocessor(){
            private final Set<ResourceLocation> importedLocations = new ObjectArraySet();

            public String applyImport(boolean p_366551_, String p_366739_) {
                ResourceLocation resourcelocation1;
                try {
                    resourcelocation1 = p_366551_ ? resourcelocation.withPath(p_366623_ -> FileUtil.normalizeResourcePath(p_366623_ + p_366739_)) : ResourceLocation.parse(p_366739_).withPrefix(ShaderManager.SHADER_INCLUDE_PATH);
                }
                catch (ResourceLocationException resourcelocationexception) {
                    LOGGER.error("Malformed GLSL import {}: {}", (Object)p_366739_, (Object)resourcelocationexception.getMessage());
                    return "#error " + resourcelocationexception.getMessage();
                }
                if (!this.importedLocations.add(resourcelocation1)) {
                    return null;
                }
                try {
                    String s;
                    try (BufferedReader reader = ((Resource)p_366891_.get(resourcelocation1)).openAsReader();){
                        s = IOUtils.toString((Reader)reader);
                    }
                    return s;
                }
                catch (IOException ioexception) {
                    LOGGER.error("Could not open GLSL import {}: {}", (Object)resourcelocation1, (Object)ioexception.getMessage());
                    return "#error " + ioexception.getMessage();
                }
            }
        };
    }

    private static void loadProgram(ResourceLocation p_366422_, Resource p_366602_, ImmutableMap.Builder<ResourceLocation, ShaderProgramConfig> p_366850_) {
        ResourceLocation resourcelocation = PROGRAM_ID_CONVERTER.fileToId(p_366422_);
        try (BufferedReader reader = p_366602_.openAsReader();){
            JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
            ShaderProgramConfig shaderprogramconfig = (ShaderProgramConfig)ShaderProgramConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonSyntaxException::new);
            p_366850_.put((Object)resourcelocation, (Object)shaderprogramconfig);
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.error("Failed to parse shader config at {}", (Object)p_366422_, (Object)ioexception);
        }
    }

    private static void loadPostChain(ResourceLocation p_366838_, Resource p_366558_, ImmutableMap.Builder<ResourceLocation, PostChainConfig> p_366892_) {
        ResourceLocation resourcelocation = POST_CHAIN_ID_CONVERTER.fileToId(p_366838_);
        try (BufferedReader reader = p_366558_.openAsReader();){
            JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
            p_366892_.put((Object)resourcelocation, (Object)((PostChainConfig)PostChainConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonSyntaxException::new)));
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.error("Failed to parse post chain at {}", (Object)p_366838_, (Object)ioexception);
        }
    }

    private static boolean isProgram(ResourceLocation p_366404_) {
        return p_366404_.getPath().endsWith(".json");
    }

    private static boolean isShader(ResourceLocation p_366565_) {
        return CompiledShader.Type.byLocation((ResourceLocation)p_366565_) != null || p_366565_.getPath().endsWith(".glsl");
    }

    @Override
    protected void apply(Configs p_366597_, ResourceManager p_366533_, ProfilerFiller p_366866_) {
        CompilationCache shadermanager$compilationcache = new CompilationCache(p_366597_);
        HashMap<ShaderProgram, CompilationException> map = new HashMap<ShaderProgram, CompilationException>();
        for (ShaderProgram shaderprogram : CoreShaderManager.getProgramsToPreload()) {
            try {
                shadermanager$compilationcache.programs.put(shaderprogram, Optional.of(shadermanager$compilationcache.compileProgram(shaderprogram)));
            }
            catch (CompilationException shadermanager$compilationexception) {
                map.put(shaderprogram, shadermanager$compilationexception);
            }
        }
        if (!map.isEmpty()) {
            shadermanager$compilationcache.close();
            throw new RuntimeException("Failed to load required shader programs:\n" + map.entrySet().stream().map(p_366523_ -> " - " + String.valueOf(p_366523_.getKey()) + ": " + ((CompilationException)p_366523_.getValue()).getMessage()).collect(Collectors.joining("\n")));
        }
        this.compilationCache.close();
        this.compilationCache = shadermanager$compilationcache;
    }

    public String getName() {
        return "Shader Loader";
    }

    public void preloadForStartup(ResourceProvider p_366778_, ShaderProgram ... p_366598_) throws IOException, CompilationException {
        for (ShaderProgram shaderprogram : p_366598_) {
            Resource resource = p_366778_.getResourceOrThrow(PROGRAM_ID_CONVERTER.idToFile(shaderprogram.configId()));
            try (BufferedReader reader = resource.openAsReader();){
                JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                ShaderProgramConfig shaderprogramconfig = (ShaderProgramConfig)ShaderProgramConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonSyntaxException::new);
                ShaderDefines shaderdefines = shaderprogramconfig.defines().withOverrides(shaderprogram.defines());
                CompiledShader compiledshader = this.preloadShader(p_366778_, shaderprogramconfig.vertex(), CompiledShader.Type.VERTEX, shaderdefines);
                CompiledShader compiledshader1 = this.preloadShader(p_366778_, shaderprogramconfig.fragment(), CompiledShader.Type.FRAGMENT, shaderdefines);
                CompiledShaderProgram compiledshaderprogram = ShaderManager.linkProgram(shaderprogram, shaderprogramconfig, compiledshader, compiledshader1);
                this.compilationCache.programs.put(shaderprogram, Optional.of(compiledshaderprogram));
            }
        }
    }

    private CompiledShader preloadShader(ResourceProvider p_366664_, ResourceLocation p_366827_, CompiledShader.Type p_366782_, ShaderDefines p_366425_) throws IOException, CompilationException {
        CompiledShader compiledshader1;
        ResourceLocation resourcelocation = p_366782_.idConverter().idToFile(p_366827_);
        try (BufferedReader reader = p_366664_.getResourceOrThrow(resourcelocation).openAsReader();){
            String s = IOUtils.toString((Reader)reader);
            String s1 = GlslPreprocessor.injectDefines((String)s, (ShaderDefines)p_366425_);
            CompiledShader compiledshader = CompiledShader.compile((ResourceLocation)p_366827_, (CompiledShader.Type)p_366782_, (String)s1);
            this.compilationCache.shaders.put(new ShaderCompilationKey(p_366827_, p_366782_, p_366425_), compiledshader);
            compiledshader1 = compiledshader;
        }
        return compiledshader1;
    }

    @Nullable
    public CompiledShaderProgram getProgram(ShaderProgram p_366726_) {
        try {
            return this.compilationCache.getOrCompileProgram(p_366726_);
        }
        catch (CompilationException shadermanager$compilationexception) {
            LOGGER.error("Failed to load shader program: {}", (Object)p_366726_, (Object)shadermanager$compilationexception);
            this.compilationCache.programs.put(p_366726_, Optional.empty());
            this.recoveryHandler.accept(shadermanager$compilationexception);
            return null;
        }
    }

    public CompiledShaderProgram getProgramForLoading(ShaderProgram p_371850_) throws CompilationException {
        CompiledShaderProgram compiledshaderprogram = this.compilationCache.getOrCompileProgram(p_371850_);
        if (compiledshaderprogram == null) {
            throw new CompilationException("Shader '" + String.valueOf(p_371850_) + "' could not be found");
        }
        return compiledshaderprogram;
    }

    static CompiledShaderProgram linkProgram(ShaderProgram p_366640_, ShaderProgramConfig p_366864_, CompiledShader p_366716_, CompiledShader p_366871_) throws CompilationException {
        CompiledShaderProgram compiledshaderprogram = CompiledShaderProgram.link((CompiledShader)p_366716_, (CompiledShader)p_366871_, (VertexFormat)p_366640_.vertexFormat());
        compiledshaderprogram.setupUniforms(p_366864_.uniforms(), p_366864_.samplers());
        return compiledshaderprogram;
    }

    @Nullable
    public PostChain getPostChain(ResourceLocation p_366709_, Set<ResourceLocation> p_366652_) {
        try {
            return this.compilationCache.getOrLoadPostChain(p_366709_, p_366652_);
        }
        catch (CompilationException shadermanager$compilationexception) {
            LOGGER.error("Failed to load post chain: {}", (Object)p_366709_, (Object)shadermanager$compilationexception);
            this.compilationCache.postChains.put(p_366709_, Optional.empty());
            this.recoveryHandler.accept(shadermanager$compilationexception);
            return null;
        }
    }

    @Override
    public void close() {
        this.compilationCache.close();
    }

    @OnlyIn(value=Dist.CLIENT)
    class CompilationCache
    implements AutoCloseable {
        private final Configs configs;
        final Map<ShaderProgram, Optional<CompiledShaderProgram>> programs = new HashMap<ShaderProgram, Optional<CompiledShaderProgram>>();
        final Map<ShaderCompilationKey, CompiledShader> shaders = new HashMap<ShaderCompilationKey, CompiledShader>();
        final Map<ResourceLocation, Optional<PostChain>> postChains = new HashMap<ResourceLocation, Optional<PostChain>>();

        CompilationCache(Configs p_368510_) {
            this.configs = p_368510_;
        }

        @Nullable
        public CompiledShaderProgram getOrCompileProgram(ShaderProgram p_368706_) throws CompilationException {
            Optional<CompiledShaderProgram> optional = this.programs.get(p_368706_);
            if (optional != null) {
                return optional.orElse(null);
            }
            CompiledShaderProgram compiledshaderprogram = this.compileProgram(p_368706_);
            this.programs.put(p_368706_, Optional.of(compiledshaderprogram));
            return compiledshaderprogram;
        }

        CompiledShaderProgram compileProgram(ShaderProgram p_368538_) throws CompilationException {
            ShaderProgramConfig shaderprogramconfig = this.configs.programs.get(p_368538_.configId());
            if (shaderprogramconfig == null) {
                throw new CompilationException("Could not find program with id: " + String.valueOf(p_368538_.configId()));
            }
            ShaderDefines shaderdefines = shaderprogramconfig.defines().withOverrides(p_368538_.defines());
            CompiledShader compiledshader = this.getOrCompileShader(shaderprogramconfig.vertex(), CompiledShader.Type.VERTEX, shaderdefines);
            CompiledShader compiledshader1 = this.getOrCompileShader(shaderprogramconfig.fragment(), CompiledShader.Type.FRAGMENT, shaderdefines);
            return ShaderManager.linkProgram(p_368538_, shaderprogramconfig, compiledshader, compiledshader1);
        }

        private CompiledShader getOrCompileShader(ResourceLocation p_368708_, CompiledShader.Type p_368521_, ShaderDefines p_368640_) throws CompilationException {
            ShaderCompilationKey shadermanager$shadercompilationkey = new ShaderCompilationKey(p_368708_, p_368521_, p_368640_);
            CompiledShader compiledshader = this.shaders.get(shadermanager$shadercompilationkey);
            if (compiledshader == null) {
                compiledshader = this.compileShader(shadermanager$shadercompilationkey);
                this.shaders.put(shadermanager$shadercompilationkey, compiledshader);
            }
            return compiledshader;
        }

        private CompiledShader compileShader(ShaderCompilationKey p_368763_) throws CompilationException {
            String s = this.configs.shaderSources.get(new ShaderSourceKey(p_368763_.id, p_368763_.type));
            if (s == null) {
                throw new CompilationException("Could not find shader: " + String.valueOf(p_368763_));
            }
            String s1 = GlslPreprocessor.injectDefines((String)s, (ShaderDefines)p_368763_.defines);
            return CompiledShader.compile((ResourceLocation)p_368763_.id, (CompiledShader.Type)p_368763_.type, (String)s1);
        }

        @Nullable
        public PostChain getOrLoadPostChain(ResourceLocation p_368720_, Set<ResourceLocation> p_368722_) throws CompilationException {
            Optional<PostChain> optional = this.postChains.get(p_368720_);
            if (optional != null) {
                return optional.orElse(null);
            }
            PostChain postchain = this.loadPostChain(p_368720_, p_368722_);
            this.postChains.put(p_368720_, Optional.of(postchain));
            return postchain;
        }

        private PostChain loadPostChain(ResourceLocation p_368578_, Set<ResourceLocation> p_368581_) throws CompilationException {
            PostChainConfig postchainconfig = this.configs.postChains.get(p_368578_);
            if (postchainconfig == null) {
                throw new CompilationException("Could not find post chain with id: " + String.valueOf(p_368578_));
            }
            return PostChain.load((PostChainConfig)postchainconfig, (TextureManager)ShaderManager.this.textureManager, (ShaderManager)ShaderManager.this, p_368581_);
        }

        @Override
        public void close() {
            RenderSystem.assertOnRenderThread();
            this.programs.values().forEach(p_368606_ -> p_368606_.ifPresent(CompiledShaderProgram::close));
            this.shaders.values().forEach(CompiledShader::close);
            this.programs.clear();
            this.shaders.clear();
            this.postChains.clear();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Configs(Map<ResourceLocation, ShaderProgramConfig> programs, Map<ShaderSourceKey, String> shaderSources, Map<ResourceLocation, PostChainConfig> postChains) {
        public static final Configs EMPTY = new Configs(Map.of(), Map.of(), Map.of());
    }

    @OnlyIn(value=Dist.CLIENT)
    record ShaderSourceKey(ResourceLocation id, CompiledShader.Type type) {
        @Override
        public String toString() {
            return String.valueOf(this.id) + " (" + String.valueOf(this.type) + ")";
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompilationException
    extends Exception {
        public CompilationException(String p_366771_) {
            super(p_366771_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record ShaderCompilationKey(ResourceLocation id, CompiledShader.Type type, ShaderDefines defines) {
        @Override
        public String toString() {
            String s = String.valueOf(this.id) + " (" + String.valueOf(this.type) + ")";
            return !this.defines.isEmpty() ? s + " with " + String.valueOf(this.defines) : s;
        }
    }
}

