/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BakedOverrides {
    public static final BakedOverrides EMPTY = new BakedOverrides();
    public static final float NO_OVERRIDE = Float.NEGATIVE_INFINITY;
    private final BakedOverride[] overrides;
    private final ResourceLocation[] properties;

    protected BakedOverrides() {
        this.overrides = new BakedOverride[0];
        this.properties = new ResourceLocation[0];
    }

    @Deprecated
    public BakedOverrides(ModelBaker p_371950_, List<ItemOverride> p_371198_) {
        this(p_371950_, p_371198_, p_371950_.getModelTextureGetter());
    }

    public BakedOverrides(ModelBaker p_371950_, List<ItemOverride> p_371198_, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.properties = (ResourceLocation[])p_371198_.stream().flatMap(p_371945_ -> p_371945_.predicates().stream()).map(ItemOverride.Predicate::property).distinct().toArray(ResourceLocation[]::new);
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        for (int i = 0; i < this.properties.length; ++i) {
            object2intmap.put((Object)this.properties[i], i);
        }
        ArrayList list = Lists.newArrayList();
        for (int j = p_371198_.size() - 1; j >= 0; --j) {
            ItemOverride itemoverride = p_371198_.get(j);
            BakedModel bakedmodel = p_371950_.bake(itemoverride.model(), (ModelState)BlockModelRotation.X0_Y0, spriteGetter);
            PropertyMatcher[] abakedoverrides$propertymatcher = (PropertyMatcher[])itemoverride.predicates().stream().map(arg_0 -> BakedOverrides.lambda$new$2((Object2IntMap)object2intmap, arg_0)).toArray(PropertyMatcher[]::new);
            list.add(new BakedOverride(abakedoverrides$propertymatcher, bakedmodel));
        }
        this.overrides = list.toArray(new BakedOverride[0]);
    }

    @Nullable
    public BakedModel findOverride(ItemStack p_371537_, @Nullable ClientLevel p_371711_, @Nullable LivingEntity p_371558_, int p_371346_) {
        int i = this.properties.length;
        if (i != 0) {
            float[] afloat = new float[i];
            for (int j = 0; j < i; ++j) {
                ResourceLocation resourcelocation = this.properties[j];
                ItemPropertyFunction itempropertyfunction = ItemProperties.getProperty(p_371537_, resourcelocation);
                afloat[j] = itempropertyfunction != null ? itempropertyfunction.call(p_371537_, p_371711_, p_371558_, p_371346_) : Float.NEGATIVE_INFINITY;
            }
            for (BakedOverride bakedoverrides$bakedoverride : this.overrides) {
                if (!bakedoverrides$bakedoverride.test(afloat)) continue;
                return bakedoverrides$bakedoverride.model;
            }
        }
        return null;
    }

    public ImmutableList<BakedOverride> getOverrides() {
        return ImmutableList.copyOf((Object[])this.overrides);
    }

    private static /* synthetic */ PropertyMatcher lambda$new$2(Object2IntMap object2intmap, ItemOverride.Predicate p_371644_) {
        int k = object2intmap.getInt((Object)p_371644_.property());
        return new PropertyMatcher(k, p_371644_.value());
    }

    @OnlyIn(value=Dist.CLIENT)
    public record BakedOverride(PropertyMatcher[] matchers, @Nullable BakedModel model) {
        boolean test(float[] p_371249_) {
            for (PropertyMatcher bakedoverrides$propertymatcher : this.matchers) {
                float f = p_371249_[bakedoverrides$propertymatcher.index];
                if (!(f < bakedoverrides$propertymatcher.value)) continue;
                return false;
            }
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record PropertyMatcher(int index, float value) {
    }
}

