/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ItemModelGenerator {
    public static final List<String> LAYERS = Lists.newArrayList((Object[])new String[]{"layer0", "layer1", "layer2", "layer3", "layer4"});
    private static final float MIN_Z = 7.5f;
    private static final float MAX_Z = 8.5f;

    public BlockModel generateBlockModel(Function<Material, TextureAtlasSprite> p_111671_, BlockModel p_111672_) {
        String s;
        HashMap map = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < LAYERS.size() && p_111672_.hasTexture(s = LAYERS.get(i)); ++i) {
            Material material = p_111672_.getMaterial(s);
            map.put(s, Either.left((Object)material));
            TextureAtlasSprite sprite = p_111671_.apply(material);
            list.addAll(ClientHooks.fixItemModelSeams(this.processFrames(i, s, sprite.contents()), (TextureAtlasSprite)sprite));
        }
        map.put("particle", p_111672_.hasTexture("particle") ? Either.left((Object)p_111672_.getMaterial("particle")) : (Either)map.get("layer0"));
        BlockModel blockmodel = new BlockModel(null, list, map, false, p_111672_.getGuiLight(), p_111672_.getTransforms(), p_111672_.getOverrides());
        blockmodel.name = p_111672_.name;
        blockmodel.customData.copyFrom(p_111672_.customData);
        blockmodel.customData.setGui3d(false);
        return blockmodel;
    }

    public List<BlockElement> processFrames(int p_111639_, String p_111640_, SpriteContents p_251768_) {
        HashMap map = Maps.newHashMap();
        map.put(Direction.SOUTH, new BlockElementFace(null, p_111639_, p_111640_, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        map.put(Direction.NORTH, new BlockElementFace(null, p_111639_, p_111640_, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList list = Lists.newArrayList();
        list.add(new BlockElement(new Vector3f(0.0f, 0.0f, 7.5f), new Vector3f(16.0f, 16.0f, 8.5f), map));
        list.addAll(this.createSideElements(p_251768_, p_111640_, p_111639_));
        return list;
    }

    private List<BlockElement> createSideElements(SpriteContents p_248810_, String p_111663_, int p_111664_) {
        float f = p_248810_.width();
        float f1 = p_248810_.height();
        ArrayList list = Lists.newArrayList();
        for (Span itemmodelgenerator$span : this.getSpans(p_248810_)) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 16.0f / f;
            float f11 = 16.0f / f1;
            float f12 = itemmodelgenerator$span.getMin();
            float f13 = itemmodelgenerator$span.getMax();
            float f14 = itemmodelgenerator$span.getAnchor();
            SpanFacing itemmodelgenerator$spanfacing = itemmodelgenerator$span.getFacing();
            switch (itemmodelgenerator$spanfacing.ordinal()) {
                case 0: {
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f8 = f14;
                    f3 = f14;
                    f5 = f14;
                    f9 = f14 + 1.0f;
                    break;
                }
                case 1: {
                    f8 = f14;
                    f9 = f14 + 1.0f;
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f3 = f14 + 1.0f;
                    f5 = f14 + 1.0f;
                    break;
                }
                case 2: {
                    f6 = f14;
                    f2 = f14;
                    f4 = f14;
                    f7 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                    break;
                }
                case 3: {
                    f6 = f14;
                    f7 = f14 + 1.0f;
                    f2 = f14 + 1.0f;
                    f4 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                }
            }
            f2 *= f10;
            f4 *= f10;
            f3 *= f11;
            f5 *= f11;
            f3 = 16.0f - f3;
            f5 = 16.0f - f5;
            HashMap map = Maps.newHashMap();
            map.put(itemmodelgenerator$spanfacing.getDirection(), new BlockElementFace(null, p_111664_, p_111663_, new BlockFaceUV(new float[]{f6 *= f10, f8 *= f11, f7 *= f10, f9 *= f11}, 0)));
            switch (itemmodelgenerator$spanfacing.ordinal()) {
                case 0: {
                    list.add(new BlockElement(new Vector3f(f2, f3, 7.5f), new Vector3f(f4, f3, 8.5f), map));
                    break;
                }
                case 1: {
                    list.add(new BlockElement(new Vector3f(f2, f5, 7.5f), new Vector3f(f4, f5, 8.5f), map));
                    break;
                }
                case 2: {
                    list.add(new BlockElement(new Vector3f(f2, f3, 7.5f), new Vector3f(f2, f5, 8.5f), map));
                    break;
                }
                case 3: {
                    list.add(new BlockElement(new Vector3f(f4, f3, 7.5f), new Vector3f(f4, f5, 8.5f), map));
                }
            }
        }
        return list;
    }

    private List<Span> getSpans(SpriteContents p_250338_) {
        int i = p_250338_.width();
        int j = p_250338_.height();
        ArrayList list = Lists.newArrayList();
        p_250338_.getUniqueFrames().forEach(p_173444_ -> {
            for (int k = 0; k < j; ++k) {
                for (int l = 0; l < i; ++l) {
                    boolean flag = !this.isTransparent(p_250338_, p_173444_, l, k, i, j);
                    this.checkTransition(SpanFacing.UP, list, p_250338_, p_173444_, l, k, i, j, flag);
                    this.checkTransition(SpanFacing.DOWN, list, p_250338_, p_173444_, l, k, i, j, flag);
                    this.checkTransition(SpanFacing.LEFT, list, p_250338_, p_173444_, l, k, i, j, flag);
                    this.checkTransition(SpanFacing.RIGHT, list, p_250338_, p_173444_, l, k, i, j, flag);
                }
            }
        });
        return list;
    }

    private void checkTransition(SpanFacing p_251572_, List<Span> p_248882_, SpriteContents p_249847_, int p_250616_, int p_251416_, int p_249664_, int p_250174_, int p_250897_, boolean p_248773_) {
        boolean flag;
        boolean bl = flag = this.isTransparent(p_249847_, p_250616_, p_251416_ + p_251572_.getXOffset(), p_249664_ + p_251572_.getYOffset(), p_250174_, p_250897_) && p_248773_;
        if (flag) {
            this.createOrExpandSpan(p_248882_, p_251572_, p_251416_, p_249664_);
        }
    }

    private void createOrExpandSpan(List<Span> p_111666_, SpanFacing p_111667_, int p_111668_, int p_111669_) {
        int k;
        Span itemmodelgenerator$span = null;
        for (Span itemmodelgenerator$span1 : p_111666_) {
            int i;
            if (itemmodelgenerator$span1.getFacing() != p_111667_) continue;
            int n = i = p_111667_.isHorizontal() ? p_111669_ : p_111668_;
            if (itemmodelgenerator$span1.getAnchor() != i) continue;
            itemmodelgenerator$span = itemmodelgenerator$span1;
            break;
        }
        int j = p_111667_.isHorizontal() ? p_111669_ : p_111668_;
        int n = k = p_111667_.isHorizontal() ? p_111668_ : p_111669_;
        if (itemmodelgenerator$span == null) {
            p_111666_.add(new Span(p_111667_, k, j));
        } else {
            itemmodelgenerator$span.expand(k);
        }
    }

    private boolean isTransparent(SpriteContents p_249650_, int p_250692_, int p_251914_, int p_252343_, int p_250258_, int p_248997_) {
        return p_251914_ >= 0 && p_252343_ >= 0 && p_251914_ < p_250258_ && p_252343_ < p_248997_ ? p_249650_.isTransparent(p_250692_, p_251914_, p_252343_) : true;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Span {
        private final SpanFacing facing;
        private int min;
        private int max;
        private final int anchor;

        public Span(SpanFacing p_111680_, int p_111681_, int p_111682_) {
            this.facing = p_111680_;
            this.min = p_111681_;
            this.max = p_111681_;
            this.anchor = p_111682_;
        }

        public void expand(int p_111685_) {
            if (p_111685_ < this.min) {
                this.min = p_111685_;
            } else if (p_111685_ > this.max) {
                this.max = p_111685_;
            }
        }

        public SpanFacing getFacing() {
            return this.facing;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum SpanFacing {
        UP(Direction.UP, 0, -1),
        DOWN(Direction.DOWN, 0, 1),
        LEFT(Direction.EAST, -1, 0),
        RIGHT(Direction.WEST, 1, 0);

        private final Direction direction;
        private final int xOffset;
        private final int yOffset;

        private SpanFacing(Direction p_111701_, int p_111702_, int p_111703_) {
            this.direction = p_111701_;
            this.xOffset = p_111702_;
            this.yOffset = p_111703_;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        boolean isHorizontal() {
            return this == DOWN || this == UP;
        }
    }
}

