/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TheEndGatewayRenderer
extends TheEndPortalRenderer<TheEndGatewayBlockEntity> {
    private static final ResourceLocation BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/end_gateway_beam.png");

    public TheEndGatewayRenderer(BlockEntityRendererProvider.Context p_173683_) {
        super(p_173683_);
    }

    public void render(TheEndGatewayBlockEntity p_112613_, float p_112614_, PoseStack p_112615_, MultiBufferSource p_112616_, int p_112617_, int p_112618_) {
        if (p_112613_.isSpawning() || p_112613_.isCoolingDown()) {
            float f = p_112613_.isSpawning() ? p_112613_.getSpawnPercent(p_112614_) : p_112613_.getCooldownPercent(p_112614_);
            double d0 = p_112613_.isSpawning() ? (double)p_112613_.getLevel().getMaxY() : 50.0;
            f = Mth.sin((float)(f * (float)Math.PI));
            int i = Mth.floor((double)((double)f * d0));
            int j = p_112613_.isSpawning() ? DyeColor.MAGENTA.getTextureDiffuseColor() : DyeColor.PURPLE.getTextureDiffuseColor();
            long k = p_112613_.getLevel().getGameTime();
            BeaconRenderer.renderBeaconBeam(p_112615_, p_112616_, BEAM_LOCATION, p_112614_, f, k, -i, i * 2, j, 0.15f, 0.175f);
        }
        super.render((TheEndPortalBlockEntity)p_112613_, p_112614_, p_112615_, p_112616_, p_112617_, p_112618_);
    }

    protected float getOffsetUp() {
        return 1.0f;
    }

    protected float getOffsetDown() {
        return 0.0f;
    }

    protected RenderType renderType() {
        return RenderType.endGateway();
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(TheEndGatewayBlockEntity blockEntity) {
        return blockEntity.isSpawning() || blockEntity.isCoolingDown() ? AABB.INFINITE : super.getRenderBoundingBox((BlockEntity)((Object)blockEntity));
    }
}

