/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;

@OnlyIn(value=Dist.CLIENT)
public class RenderChunkRegion
implements BlockAndTintGetter {
    public static final int RADIUS = 1;
    public static final int SIZE = 3;
    private final int minChunkX;
    private final int minChunkZ;
    protected final RenderChunk[] chunks;
    protected final Level level;
    private final Long2ObjectFunction<ModelData> modelDataSnapshot;

    @Deprecated
    RenderChunkRegion(Level p_200456_, int p_200457_, int p_200458_, RenderChunk[] p_350680_) {
        this(p_200456_, p_200457_, p_200458_, p_350680_, (Long2ObjectFunction<ModelData>)ModelDataManager.EMPTY_SNAPSHOT);
    }

    RenderChunkRegion(Level p_200456_, int p_200457_, int p_200458_, RenderChunk[] p_350680_, Long2ObjectFunction<ModelData> modelDataSnapshot) {
        this.level = p_200456_;
        this.minChunkX = p_200457_;
        this.minChunkZ = p_200458_;
        this.chunks = p_350680_;
        this.modelDataSnapshot = modelDataSnapshot;
    }

    @Override
    public BlockState getBlockState(BlockPos p_112947_) {
        return this.getChunk(SectionPos.blockToSectionCoord((int)p_112947_.getX()), SectionPos.blockToSectionCoord((int)p_112947_.getZ())).getBlockState(p_112947_);
    }

    @Override
    public FluidState getFluidState(BlockPos p_112943_) {
        return this.getChunk(SectionPos.blockToSectionCoord((int)p_112943_.getX()), SectionPos.blockToSectionCoord((int)p_112943_.getZ())).getBlockState(p_112943_).getFluidState();
    }

    @Override
    public float getShade(Direction p_112940_, boolean p_112941_) {
        return this.level.getShade(p_112940_, p_112941_);
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_112945_) {
        return this.getChunk(SectionPos.blockToSectionCoord((int)p_112945_.getX()), SectionPos.blockToSectionCoord((int)p_112945_.getZ())).getBlockEntity(p_112945_);
    }

    private RenderChunk getChunk(int p_350795_, int p_350558_) {
        return this.chunks[RenderChunkRegion.index(this.minChunkX, this.minChunkZ, p_350795_, p_350558_)];
    }

    @Override
    public int getBlockTint(BlockPos p_112937_, ColorResolver p_112938_) {
        return this.level.getBlockTint(p_112937_, p_112938_);
    }

    public int getMinY() {
        return this.level.getMinY();
    }

    public int getHeight() {
        return this.level.getHeight();
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return this.level.getShade(normalX, normalY, normalZ, shade);
    }

    public ModelData getModelData(BlockPos pos) {
        return (ModelData)this.modelDataSnapshot.get(pos.asLong());
    }

    public AuxiliaryLightManager getAuxLightManager(ChunkPos pos) {
        return this.getChunk((int)pos.x, (int)pos.z).wrapped.getAuxLightManager(pos);
    }

    public static int index(int p_350911_, int p_350842_, int p_350891_, int p_350833_) {
        return p_350891_ - p_350911_ + (p_350833_ - p_350842_) * 3;
    }
}

