/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.TracingExecutor;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.SectionBufferBuilderPool;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompileTaskDynamicQueue;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.SectionCompiler;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;

@OnlyIn(value=Dist.CLIENT)
public class SectionRenderDispatcher {
    private final CompileTaskDynamicQueue compileQueue = new CompileTaskDynamicQueue();
    private final Queue<Runnable> toUpload = Queues.newConcurrentLinkedQueue();
    final SectionBufferBuilderPack fixedBuffers;
    private final SectionBufferBuilderPool bufferPool;
    private volatile int toBatchCount;
    private volatile boolean closed;
    private final ConsecutiveExecutor consecutiveExecutor;
    private final TracingExecutor executor;
    ClientLevel level;
    final LevelRenderer renderer;
    private Vec3 camera = Vec3.ZERO;
    final SectionCompiler sectionCompiler;

    public SectionRenderDispatcher(ClientLevel p_295274_, LevelRenderer p_295323_, TracingExecutor p_373128_, RenderBuffers p_307511_, BlockRenderDispatcher p_350514_, BlockEntityRenderDispatcher p_350550_) {
        this.level = p_295274_;
        this.renderer = p_295323_;
        this.fixedBuffers = p_307511_.fixedBufferPack();
        this.bufferPool = p_307511_.sectionBufferPool();
        this.executor = p_373128_;
        this.consecutiveExecutor = new ConsecutiveExecutor((Executor)p_373128_, "Section Renderer");
        this.consecutiveExecutor.schedule(this::runTask);
        this.sectionCompiler = new SectionCompiler(p_350514_, p_350550_);
    }

    public void setLevel(ClientLevel p_295112_) {
        this.level = p_295112_;
    }

    private void runTask() {
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask;
        if (!this.closed && !this.bufferPool.isEmpty() && (sectionrenderdispatcher$rendersection$compiletask = this.compileQueue.poll(this.getCameraPosition())) != null) {
            SectionBufferBuilderPack sectionbufferbuilderpack = Objects.requireNonNull(this.bufferPool.acquire());
            this.toBatchCount = this.compileQueue.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> sectionrenderdispatcher$rendersection$compiletask.doTask(sectionbufferbuilderpack), this.executor.forName(sectionrenderdispatcher$rendersection$compiletask.name())).thenCompose(p_296185_ -> p_296185_)).whenComplete((p_370310_, p_370311_) -> {
                if (p_370311_ != null) {
                    Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_370311_, "Batching sections"));
                } else {
                    sectionrenderdispatcher$rendersection$compiletask.isCompleted.set(true);
                    this.consecutiveExecutor.schedule(() -> {
                        if (p_370310_ == SectionTaskResult.SUCCESSFUL) {
                            sectionbufferbuilderpack.clearAll();
                        } else {
                            sectionbufferbuilderpack.discardAll();
                        }
                        this.bufferPool.release(sectionbufferbuilderpack);
                        this.runTask();
                    });
                }
            });
        }
    }

    public String getStats() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.toBatchCount, this.toUpload.size(), this.bufferPool.getFreeBufferCount());
    }

    public int getToBatchCount() {
        return this.toBatchCount;
    }

    public int getToUpload() {
        return this.toUpload.size();
    }

    public int getFreeBufferCount() {
        return this.bufferPool.getFreeBufferCount();
    }

    public void setCamera(Vec3 p_296331_) {
        this.camera = p_296331_;
    }

    public Vec3 getCameraPosition() {
        return this.camera;
    }

    public void uploadAllPendingUploads() {
        Runnable runnable;
        while ((runnable = this.toUpload.poll()) != null) {
            runnable.run();
        }
    }

    public void rebuildSectionSync(RenderSection p_296309_, RenderRegionCache p_294139_) {
        p_296309_.compileSync(p_294139_);
    }

    public void blockUntilClear() {
        this.clearBatchQueue();
    }

    public void schedule(RenderSection.CompileTask p_295825_) {
        if (!this.closed) {
            this.consecutiveExecutor.schedule(() -> {
                if (!this.closed) {
                    this.compileQueue.add(p_295825_);
                    this.toBatchCount = this.compileQueue.size();
                    this.runTask();
                }
            });
        }
    }

    public CompletableFuture<Void> uploadSectionLayer(MeshData p_350732_, VertexBuffer p_294163_) {
        return this.closed ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> {
            if (p_294163_.isInvalid()) {
                p_350732_.close();
            } else {
                try (Zone zone = Profiler.get().zone("Upload Section Layer");){
                    p_294163_.bind();
                    p_294163_.upload(p_350732_);
                    VertexBuffer.unbind();
                }
            }
        }, this.toUpload::add);
    }

    public CompletableFuture<Void> uploadSectionIndexBuffer(ByteBufferBuilder.Result p_350933_, VertexBuffer p_350643_) {
        return this.closed ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> {
            if (p_350643_.isInvalid()) {
                p_350933_.close();
            } else {
                try (Zone zone = Profiler.get().zone("Upload Section Indices");){
                    p_350643_.bind();
                    p_350643_.uploadIndexBuffer(p_350933_);
                    VertexBuffer.unbind();
                }
            }
        }, this.toUpload::add);
    }

    private void clearBatchQueue() {
        this.compileQueue.clear();
        this.toBatchCount = 0;
    }

    public boolean isQueueEmpty() {
        return this.toBatchCount == 0 && this.toUpload.isEmpty();
    }

    public void dispose() {
        this.closed = true;
        this.clearBatchQueue();
        this.uploadAllPendingUploads();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RenderSection {
        public static final int SIZE = 16;
        public final int index;
        public final AtomicReference<CompiledSection> compiled = new AtomicReference<CompiledSection>(CompiledSection.UNCOMPILED);
        public final AtomicReference<TranslucencyPointOfView> pointOfView = new AtomicReference<Object>(null);
        @Nullable
        private RebuildTask lastRebuildTask;
        @Nullable
        private ResortTransparencyTask lastResortTransparencyTask;
        private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> buffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(p_295245_ -> p_295245_, p_373684_ -> new VertexBuffer(BufferUsage.STATIC_WRITE)));
        private AABB bb;
        private boolean dirty = true;
        long sectionNode = SectionPos.asLong((int)-1, (int)-1, (int)-1);
        final BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos(-1, -1, -1);
        private boolean playerChanged;

        public RenderSection(int p_295197_, long p_366428_) {
            this.index = p_295197_;
            this.setSectionNode(p_366428_);
        }

        private boolean doesChunkExistAt(long p_366835_) {
            return SectionRenderDispatcher.this.level.getChunk(SectionPos.x((long)p_366835_), SectionPos.z((long)p_366835_), ChunkStatus.FULL, false) != null;
        }

        public boolean hasAllNeighbors() {
            int i = 24;
            return !(this.getDistToPlayerSqr() > 576.0) ? true : this.doesChunkExistAt(SectionPos.offset((long)this.sectionNode, (Direction)Direction.WEST)) && this.doesChunkExistAt(SectionPos.offset((long)this.sectionNode, (Direction)Direction.NORTH)) && this.doesChunkExistAt(SectionPos.offset((long)this.sectionNode, (Direction)Direction.EAST)) && this.doesChunkExistAt(SectionPos.offset((long)this.sectionNode, (Direction)Direction.SOUTH));
        }

        public AABB getBoundingBox() {
            return this.bb;
        }

        public VertexBuffer getBuffer(RenderType p_294497_) {
            return this.buffers.get((Object)p_294497_);
        }

        public void setSectionNode(long p_366482_) {
            this.reset();
            this.sectionNode = p_366482_;
            int i = SectionPos.sectionToBlockCoord((int)SectionPos.x((long)p_366482_));
            int j = SectionPos.sectionToBlockCoord((int)SectionPos.y((long)p_366482_));
            int k = SectionPos.sectionToBlockCoord((int)SectionPos.z((long)p_366482_));
            this.origin.set(i, j, k);
            this.bb = new AABB(i, j, k, i + 16, j + 16, k + 16);
        }

        protected double getDistToPlayerSqr() {
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            double d0 = this.bb.minX + 8.0 - camera.getPosition().x;
            double d1 = this.bb.minY + 8.0 - camera.getPosition().y;
            double d2 = this.bb.minZ + 8.0 - camera.getPosition().z;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        public CompiledSection getCompiled() {
            return this.compiled.get();
        }

        private void reset() {
            this.cancelTasks();
            this.compiled.set(CompiledSection.UNCOMPILED);
            this.pointOfView.set(null);
            this.dirty = true;
        }

        public void releaseBuffers() {
            this.reset();
            this.buffers.values().forEach(VertexBuffer::close);
        }

        public BlockPos getOrigin() {
            return this.origin;
        }

        public long getSectionNode() {
            return this.sectionNode;
        }

        public void setDirty(boolean p_295417_) {
            boolean flag = this.dirty;
            this.dirty = true;
            this.playerChanged = p_295417_ | (flag && this.playerChanged);
        }

        public void setNotDirty() {
            this.dirty = false;
            this.playerChanged = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean isDirtyFromPlayer() {
            return this.dirty && this.playerChanged;
        }

        public long getNeighborSectionNode(Direction p_366736_) {
            return SectionPos.offset((long)this.sectionNode, (Direction)p_366736_);
        }

        public void resortTransparency(SectionRenderDispatcher p_294363_) {
            this.lastResortTransparencyTask = new ResortTransparencyTask(this.getCompiled());
            p_294363_.schedule(this.lastResortTransparencyTask);
        }

        public boolean hasTranslucentGeometry() {
            return this.getCompiled().hasBlocks.contains((Object)RenderType.translucent());
        }

        public boolean transparencyResortingScheduled() {
            return this.lastResortTransparencyTask != null && !this.lastResortTransparencyTask.isCompleted.get();
        }

        protected void cancelTasks() {
            if (this.lastRebuildTask != null) {
                this.lastRebuildTask.cancel();
                this.lastRebuildTask = null;
            }
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
                this.lastResortTransparencyTask = null;
            }
        }

        public CompileTask createCompileTask(RenderRegionCache p_295324_) {
            this.cancelTasks();
            List additionalRenderers = ClientHooks.gatherAdditionalRenderers((BlockPos)this.origin, (Level)SectionRenderDispatcher.this.level);
            RenderChunkRegion renderchunkregion = p_295324_.createRegion(SectionRenderDispatcher.this.level, SectionPos.of((long)this.sectionNode), additionalRenderers.isEmpty());
            boolean flag = this.compiled.get() != CompiledSection.UNCOMPILED;
            this.lastRebuildTask = new RebuildTask(renderchunkregion, flag, additionalRenderers);
            return this.lastRebuildTask;
        }

        public void rebuildSectionAsync(SectionRenderDispatcher p_295901_, RenderRegionCache p_294660_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.createCompileTask(p_294660_);
            p_295901_.schedule(sectionrenderdispatcher$rendersection$compiletask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateGlobalBlockEntities(Collection<BlockEntity> p_296155_) {
            HashSet set1;
            HashSet set = Sets.newHashSet(p_296155_);
            Set<BlockEntity> set2 = this.globalBlockEntities;
            synchronized (set2) {
                set1 = Sets.newHashSet(this.globalBlockEntities);
                set.removeAll(this.globalBlockEntities);
                set1.removeAll(p_296155_);
                this.globalBlockEntities.clear();
                this.globalBlockEntities.addAll(p_296155_);
            }
            SectionRenderDispatcher.this.renderer.updateGlobalBlockEntities(set1, set);
        }

        public void compileSync(RenderRegionCache p_296018_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.createCompileTask(p_296018_);
            sectionrenderdispatcher$rendersection$compiletask.doTask(SectionRenderDispatcher.this.fixedBuffers);
        }

        void setCompiled(CompiledSection p_350692_) {
            this.compiled.set(p_350692_);
            SectionRenderDispatcher.this.renderer.addRecentlyCompiledSection(this);
        }

        VertexSorting createVertexSorting() {
            Vec3 vec3 = SectionRenderDispatcher.this.getCameraPosition();
            return VertexSorting.byDistance((float)((float)(vec3.x - (double)this.origin.getX())), (float)((float)(vec3.y - (double)this.origin.getY())), (float)((float)(vec3.z - (double)this.origin.getZ())));
        }

        @OnlyIn(value=Dist.CLIENT)
        class ResortTransparencyTask
        extends CompileTask {
            private final CompiledSection compiledSection;

            public ResortTransparencyTask(CompiledSection p_294601_) {
                super(true);
                this.compiledSection = p_294601_;
            }

            @Override
            protected String name() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_295160_) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                MeshData.SortState meshdata$sortstate = this.compiledSection.transparencyState;
                if (meshdata$sortstate != null && !this.compiledSection.isEmpty(RenderType.translucent())) {
                    VertexSorting vertexsorting = RenderSection.this.createVertexSorting();
                    TranslucencyPointOfView sectionrenderdispatcher$translucencypointofview = TranslucencyPointOfView.of(SectionRenderDispatcher.this.getCameraPosition(), RenderSection.this.sectionNode);
                    if (sectionrenderdispatcher$translucencypointofview.equals(RenderSection.this.pointOfView.get()) && !sectionrenderdispatcher$translucencypointofview.isAxisAligned()) {
                        return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                    }
                    ByteBufferBuilder.Result bytebufferbuilder$result = meshdata$sortstate.buildSortedIndexBuffer(p_295160_.buffer(RenderType.translucent()), vertexsorting);
                    if (bytebufferbuilder$result == null) {
                        return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                    }
                    if (this.isCancelled.get()) {
                        bytebufferbuilder$result.close();
                        return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = SectionRenderDispatcher.this.uploadSectionIndexBuffer(bytebufferbuilder$result, RenderSection.this.getBuffer(RenderType.translucent())).thenApply(p_294714_ -> SectionTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((p_370317_, p_370318_) -> {
                        if (p_370318_ != null && !(p_370318_ instanceof CancellationException) && !(p_370318_ instanceof InterruptedException)) {
                            Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_370318_, "Rendering section"));
                        }
                        if (this.isCancelled.get()) {
                            return SectionTaskResult.CANCELLED;
                        }
                        RenderSection.this.pointOfView.set(sectionrenderdispatcher$translucencypointofview);
                        return SectionTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }

            @Override
            public void cancel() {
                this.isCancelled.set(true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public abstract class CompileTask {
            protected final AtomicBoolean isCancelled = new AtomicBoolean(false);
            protected final AtomicBoolean isCompleted = new AtomicBoolean(false);
            protected final boolean isRecompile;

            public CompileTask(boolean p_295051_) {
                this.isRecompile = p_295051_;
            }

            public abstract CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack var1);

            public abstract void cancel();

            protected abstract String name();

            public boolean isRecompile() {
                return this.isRecompile;
            }

            public BlockPos getOrigin() {
                return RenderSection.this.origin;
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class RebuildTask
        extends CompileTask {
            @Nullable
            protected volatile RenderChunkRegion region;
            private final List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers;

            @Deprecated
            public RebuildTask(RenderChunkRegion p_294382_, boolean p_295207_) {
                this(p_294382_, p_295207_, List.of());
            }

            public RebuildTask(RenderChunkRegion p_294382_, boolean p_295207_, List<AddSectionGeometryEvent.AdditionalSectionRenderer> additionalRenderers) {
                super(p_295207_);
                this.region = p_294382_;
                this.additionalRenderers = additionalRenderers;
            }

            @Override
            protected String name() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_296138_) {
                SectionCompiler.Results sectioncompiler$results;
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.cancel();
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                RenderChunkRegion renderchunkregion = this.region;
                this.region = null;
                if (renderchunkregion == null) {
                    RenderSection.this.setCompiled(CompiledSection.EMPTY);
                    return CompletableFuture.completedFuture(SectionTaskResult.SUCCESSFUL);
                }
                SectionPos sectionpos = SectionPos.of((BlockPos)RenderSection.this.origin);
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                try (Zone zone = Profiler.get().zone("Compile Section");){
                    sectioncompiler$results = SectionRenderDispatcher.this.sectionCompiler.compile(sectionpos, renderchunkregion, RenderSection.this.createVertexSorting(), p_296138_, this.additionalRenderers);
                }
                TranslucencyPointOfView sectionrenderdispatcher$translucencypointofview = TranslucencyPointOfView.of(SectionRenderDispatcher.this.getCameraPosition(), RenderSection.this.sectionNode);
                RenderSection.this.updateGlobalBlockEntities(sectioncompiler$results.globalBlockEntities);
                if (this.isCancelled.get()) {
                    sectioncompiler$results.release();
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompiledSection sectionrenderdispatcher$compiledsection = new CompiledSection();
                sectionrenderdispatcher$compiledsection.visibilitySet = sectioncompiler$results.visibilitySet;
                sectionrenderdispatcher$compiledsection.renderableBlockEntities.addAll(sectioncompiler$results.blockEntities);
                sectionrenderdispatcher$compiledsection.transparencyState = sectioncompiler$results.transparencyState;
                ArrayList list = new ArrayList(sectioncompiler$results.renderedLayers.size());
                sectioncompiler$results.renderedLayers.forEach((p_349884_, p_349885_) -> {
                    list.add(SectionRenderDispatcher.this.uploadSectionLayer((MeshData)p_349885_, RenderSection.this.getBuffer((RenderType)((Object)p_349884_))));
                    sectionrenderdispatcher$compiledsection.hasBlocks.add((RenderType)((Object)p_349884_));
                });
                return Util.sequenceFailFast(list).handle((p_370314_, p_370315_) -> {
                    if (p_370315_ != null && !(p_370315_ instanceof CancellationException) && !(p_370315_ instanceof InterruptedException)) {
                        Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_370315_, "Rendering section"));
                    }
                    if (this.isCancelled.get()) {
                        return SectionTaskResult.CANCELLED;
                    }
                    RenderSection.this.setCompiled(sectionrenderdispatcher$compiledsection);
                    RenderSection.this.pointOfView.set(sectionrenderdispatcher$translucencypointofview);
                    return SectionTaskResult.SUCCESSFUL;
                });
            }

            @Override
            public void cancel() {
                this.region = null;
                if (this.isCancelled.compareAndSet(false, true)) {
                    RenderSection.this.setDirty(false);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum SectionTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class TranslucencyPointOfView {
        private int x;
        private int y;
        private int z;

        public static TranslucencyPointOfView of(Vec3 p_371341_, long p_371400_) {
            return new TranslucencyPointOfView().set(p_371341_, p_371400_);
        }

        public TranslucencyPointOfView set(Vec3 p_371567_, long p_371572_) {
            this.x = TranslucencyPointOfView.getCoordinate(p_371567_.x(), SectionPos.x((long)p_371572_));
            this.y = TranslucencyPointOfView.getCoordinate(p_371567_.y(), SectionPos.y((long)p_371572_));
            this.z = TranslucencyPointOfView.getCoordinate(p_371567_.z(), SectionPos.z((long)p_371572_));
            return this;
        }

        private static int getCoordinate(double p_371545_, int p_371464_) {
            int i = SectionPos.blockToSectionCoord((double)p_371545_) - p_371464_;
            return Mth.clamp((int)i, (int)-1, (int)1);
        }

        public boolean isAxisAligned() {
            return this.x == 0 || this.y == 0 || this.z == 0;
        }

        public boolean equals(Object p_371211_) {
            boolean bl;
            if (p_371211_ == this) {
                return true;
            }
            if (!(p_371211_ instanceof TranslucencyPointOfView)) {
                bl = false;
            } else {
                TranslucencyPointOfView sectionrenderdispatcher$translucencypointofview = (TranslucencyPointOfView)p_371211_;
                bl = this.x == sectionrenderdispatcher$translucencypointofview.x && this.y == sectionrenderdispatcher$translucencypointofview.y && this.z == sectionrenderdispatcher$translucencypointofview.z;
            }
            return bl;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompiledSection {
        public static final CompiledSection UNCOMPILED = new CompiledSection(){

            @Override
            public boolean facesCanSeeEachother(Direction p_296238_, Direction p_294727_) {
                return false;
            }
        };
        public static final CompiledSection EMPTY = new CompiledSection(){

            @Override
            public boolean facesCanSeeEachother(Direction p_351039_, Direction p_350415_) {
                return true;
            }
        };
        final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.chunkBufferLayers().size());
        final List<BlockEntity> renderableBlockEntities = Lists.newArrayList();
        VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        MeshData.SortState transparencyState;

        public boolean hasRenderableLayers() {
            return !this.hasBlocks.isEmpty();
        }

        public boolean isEmpty(RenderType p_296192_) {
            return !this.hasBlocks.contains((Object)p_296192_);
        }

        public List<BlockEntity> getRenderableBlockEntities() {
            return this.renderableBlockEntities;
        }

        public boolean facesCanSeeEachother(Direction p_295753_, Direction p_294424_) {
            return this.visibilitySet.visibilityBetween(p_295753_, p_294424_);
        }
    }
}

