/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class HumanoidMobRenderer<T extends Mob, S extends HumanoidRenderState, M extends HumanoidModel<S>>
extends AgeableMobRenderer<T, S, M> {
    public HumanoidMobRenderer(EntityRendererProvider.Context p_174169_, M p_174170_, float p_174171_) {
        this(p_174169_, p_174170_, p_174170_, p_174171_);
    }

    public HumanoidMobRenderer(EntityRendererProvider.Context p_174173_, M p_174174_, M p_364374_, float p_174175_) {
        this(p_174173_, p_174174_, p_364374_, p_174175_, CustomHeadLayer.Transforms.DEFAULT);
    }

    public HumanoidMobRenderer(EntityRendererProvider.Context p_361718_, M p_361903_, M p_360842_, float p_364257_, CustomHeadLayer.Transforms p_364599_) {
        super(p_361718_, p_361903_, p_360842_, p_364257_);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, p_361718_.getModelSet(), p_364599_, p_361718_.getItemRenderer()));
        this.addLayer((RenderLayer)new WingsLayer((RenderLayerParent)this, p_361718_.getModelSet(), p_361718_.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, p_361718_.getItemRenderer()));
    }

    public void extractRenderState(T p_365075_, S p_361774_, float p_363123_) {
        super.extractRenderState(p_365075_, p_361774_, p_363123_);
        HumanoidMobRenderer.extractHumanoidRenderState(p_365075_, p_361774_, p_363123_);
    }

    public static void extractHumanoidRenderState(LivingEntity p_365104_, HumanoidRenderState p_362998_, float p_363706_) {
        p_362998_.isCrouching = p_365104_.isCrouching();
        p_362998_.isFallFlying = p_365104_.isFallFlying();
        p_362998_.isVisuallySwimming = p_365104_.isVisuallySwimming();
        p_362998_.isPassenger = p_365104_.isPassenger() && p_365104_.getVehicle() != null && p_365104_.getVehicle().shouldRiderSit();
        p_362998_.speedValue = 1.0f;
        if (p_362998_.isFallFlying) {
            p_362998_.speedValue = (float)p_365104_.getDeltaMovement().lengthSqr();
            p_362998_.speedValue /= 0.2f;
            p_362998_.speedValue = p_362998_.speedValue * p_362998_.speedValue * p_362998_.speedValue;
        }
        if (p_362998_.speedValue < 1.0f) {
            p_362998_.speedValue = 1.0f;
        }
        p_362998_.attackTime = p_365104_.getAttackAnim(p_363706_);
        p_362998_.swimAmount = p_365104_.getSwimAmount(p_363706_);
        p_362998_.attackArm = HumanoidMobRenderer.getAttackArm(p_365104_);
        p_362998_.useItemHand = p_365104_.getUsedItemHand();
        p_362998_.maxCrossbowChargeDuration = CrossbowItem.getChargeDuration(p_365104_.getUseItem(), p_365104_);
        p_362998_.ticksUsingItem = p_365104_.getTicksUsingItem();
        p_362998_.isUsingItem = p_365104_.isUsingItem();
        p_362998_.elytraRotX = p_365104_.elytraAnimationState.getRotX(p_363706_);
        p_362998_.elytraRotY = p_365104_.elytraAnimationState.getRotY(p_363706_);
        p_362998_.elytraRotZ = p_365104_.elytraAnimationState.getRotZ(p_363706_);
        p_362998_.chestItem = p_365104_.getItemBySlot(EquipmentSlot.CHEST).copy();
        p_362998_.legsItem = p_365104_.getItemBySlot(EquipmentSlot.LEGS).copy();
        p_362998_.feetItem = p_365104_.getItemBySlot(EquipmentSlot.FEET).copy();
    }

    private static HumanoidArm getAttackArm(LivingEntity p_362737_) {
        HumanoidArm humanoidarm = p_362737_.getMainArm();
        return p_362737_.swingingArm == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.getOpposite();
    }
}

