/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@OnlyIn(value=Dist.CLIENT)
public class ItemEntityRenderer
extends EntityRenderer<ItemEntity, ItemEntityRenderState> {
    private static final float ITEM_BUNDLE_OFFSET_SCALE = 0.15f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_X = 0.0f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_Y = 0.0f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_Z = 0.09375f;
    private final ItemRenderer itemRenderer;
    private final RandomSource random = RandomSource.create();

    public ItemEntityRenderer(EntityRendererProvider.Context p_174198_) {
        super(p_174198_);
        this.itemRenderer = p_174198_.getItemRenderer();
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    public ItemEntityRenderState createRenderState() {
        return new ItemEntityRenderState();
    }

    @Override
    public void extractRenderState(ItemEntity p_362393_, ItemEntityRenderState p_361441_, float p_360849_) {
        super.extractRenderState(p_362393_, p_361441_, p_360849_);
        p_361441_.ageInTicks = (float)p_362393_.getAge() + p_360849_;
        p_361441_.bobOffset = p_362393_.bobOffs;
        ItemStack itemstack = p_362393_.getItem();
        p_361441_.item = itemstack.copy();
        p_361441_.itemModel = this.itemRenderer.getModel(itemstack, p_362393_.level(), null, p_362393_.getId());
    }

    @Override
    public void render(ItemEntityRenderState p_362172_, PoseStack p_115030_, MultiBufferSource p_115031_, int p_115032_) {
        BakedModel bakedmodel = p_362172_.itemModel;
        if (bakedmodel != null) {
            p_115030_.pushPose();
            ItemStack itemstack = p_362172_.item;
            this.random.setSeed((long)ItemEntityRenderer.getSeedForItemStack(itemstack));
            boolean flag = bakedmodel.isGui3d();
            float f = 0.25f;
            boolean shouldBob = IClientItemExtensions.of((ItemStack)itemstack).shouldBobAsEntity(itemstack);
            float f1 = shouldBob ? Mth.sin((float)(p_362172_.ageInTicks / 10.0f + p_362172_.bobOffset)) * 0.1f + 0.1f : 0.0f;
            float f2 = bakedmodel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
            p_115030_.translate(0.0f, f1 + 0.25f * f2, 0.0f);
            float f3 = ItemEntity.getSpin(p_362172_.ageInTicks, p_362172_.bobOffset);
            p_115030_.mulPose(Axis.YP.rotation(f3));
            ItemEntityRenderer.renderMultipleFromCount(this.itemRenderer, p_115030_, p_115031_, p_115032_, itemstack, bakedmodel, flag, this.random);
            p_115030_.popPose();
            super.render(p_362172_, p_115030_, p_115031_, p_115032_);
        }
    }

    public static int getSeedForItemStack(ItemStack p_324105_) {
        return p_324105_.isEmpty() ? 187 : Item.getId(p_324105_.getItem()) + p_324105_.getDamageValue();
    }

    @VisibleForTesting
    static int getRenderedAmount(int p_324603_) {
        if (p_324603_ <= 1) {
            return 1;
        }
        if (p_324603_ <= 16) {
            return 2;
        }
        if (p_324603_ <= 32) {
            return 3;
        }
        return p_324603_ <= 48 ? 4 : 5;
    }

    public static void renderMultipleFromCount(ItemRenderer p_323875_, PoseStack p_323763_, MultiBufferSource p_324606_, int p_323603_, ItemStack p_323969_, RandomSource p_324507_, Level p_323902_) {
        BakedModel bakedmodel = p_323875_.getModel(p_323969_, p_323902_, null, 0);
        ItemEntityRenderer.renderMultipleFromCount(p_323875_, p_323763_, p_324606_, p_323603_, p_323969_, bakedmodel, bakedmodel.isGui3d(), p_324507_);
    }

    public static void renderMultipleFromCount(ItemRenderer p_324541_, PoseStack p_323733_, MultiBufferSource p_324107_, int p_323740_, ItemStack p_323718_, BakedModel p_324183_, boolean p_324462_, RandomSource p_324565_) {
        int i = ItemEntityRenderer.getRenderedAmount(p_323718_.getCount());
        float f = p_324183_.getTransforms().ground.scale.x();
        float f1 = p_324183_.getTransforms().ground.scale.y();
        float f2 = p_324183_.getTransforms().ground.scale.z();
        if (!p_324462_) {
            float f3 = -0.0f * (float)(i - 1) * 0.5f * f;
            float f4 = -0.0f * (float)(i - 1) * 0.5f * f1;
            float f5 = -0.09375f * (float)(i - 1) * 0.5f * f2;
            p_323733_.translate(f3, f4, f5);
        }
        boolean shouldSpread = IClientItemExtensions.of((ItemStack)p_323718_).shouldSpreadAsEntity(p_323718_);
        for (int j = 0; j < i; ++j) {
            p_323733_.pushPose();
            if (j > 0 && shouldSpread) {
                if (p_324462_) {
                    float f7 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f9 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float f6 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    p_323733_.translate(f7, f9, f6);
                } else {
                    float f8 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float f10 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    p_323733_.translate(f8, f10, 0.0f);
                }
            }
            p_324541_.render(p_323718_, ItemDisplayContext.GROUND, false, p_323733_, p_324107_, p_323740_, OverlayTexture.NO_OVERLAY, p_324183_);
            p_323733_.popPose();
            if (p_324462_) continue;
            p_323733_.translate(0.0f * f, 0.0f * f1, 0.09375f * f2);
        }
    }
}

