/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.MatrixUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ItemRenderer
implements ResourceManagerReloadListener {
    public static final ResourceLocation ENCHANTED_GLINT_ENTITY = ResourceLocation.withDefaultNamespace("textures/misc/enchanted_glint_entity.png");
    public static final ResourceLocation ENCHANTED_GLINT_ITEM = ResourceLocation.withDefaultNamespace("textures/misc/enchanted_glint_item.png");
    public static final int GUI_SLOT_CENTER_X = 8;
    public static final int GUI_SLOT_CENTER_Y = 8;
    public static final int ITEM_DECORATION_BLIT_OFFSET = 200;
    public static final float COMPASS_FOIL_UI_SCALE = 0.5f;
    public static final float COMPASS_FOIL_FIRST_PERSON_SCALE = 0.75f;
    public static final float COMPASS_FOIL_TEXTURE_SCALE = 0.0078125f;
    public static final ModelResourceLocation TRIDENT_MODEL = ModelResourceLocation.inventory(ResourceLocation.withDefaultNamespace("trident"));
    public static final ModelResourceLocation SPYGLASS_MODEL = ModelResourceLocation.inventory(ResourceLocation.withDefaultNamespace("spyglass"));
    private final ModelManager modelManager;
    private final ItemModelShaper itemModelShaper;
    private final ItemColors itemColors;
    private final BlockEntityWithoutLevelRenderer blockEntityRenderer;

    public ItemRenderer(ModelManager p_266850_, ItemColors p_267016_, BlockEntityWithoutLevelRenderer p_267049_) {
        this.modelManager = p_266850_;
        this.itemModelShaper = new ItemModelShaper(p_266850_);
        this.blockEntityRenderer = p_267049_;
        this.itemColors = p_267016_;
    }

    public void renderModelLists(BakedModel p_115190_, ItemStack p_115191_, int p_115192_, int p_115193_, PoseStack p_115194_, VertexConsumer p_115195_) {
        RandomSource randomsource = RandomSource.create();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            randomsource.setSeed(42L);
            this.renderQuadList(p_115194_, p_115195_, p_115190_.getQuads(null, direction, randomsource), p_115191_, p_115192_, p_115193_);
        }
        randomsource.setSeed(42L);
        this.renderQuadList(p_115194_, p_115195_, p_115190_.getQuads(null, null, randomsource), p_115191_, p_115192_, p_115193_);
    }

    public void render(ItemStack p_115144_, ItemDisplayContext p_270188_, boolean p_115146_, PoseStack p_115147_, MultiBufferSource p_115148_, int p_115149_, int p_115150_, BakedModel p_115151_) {
        if (!p_115144_.isEmpty()) {
            this.renderSimpleItemModel(p_115144_, p_270188_, p_115146_, p_115147_, p_115148_, p_115149_, p_115150_, p_115151_, ItemRenderer.shouldRenderItemFlat(p_270188_));
        }
    }

    public void renderBundleItem(ItemStack p_373010_, ItemDisplayContext p_372950_, boolean p_372853_, PoseStack p_372830_, MultiBufferSource p_372949_, int p_372893_, int p_373061_, BakedModel p_372874_, @Nullable Level p_373067_, @Nullable LivingEntity p_373013_, int p_373103_) {
        Item item = p_373010_.getItem();
        if (item instanceof BundleItem) {
            BundleItem bundleitem = (BundleItem)item;
            if (BundleItem.hasSelectedItem(p_373010_)) {
                boolean flag = ItemRenderer.shouldRenderItemFlat(p_372950_);
                BakedModel bakedmodel = this.resolveModelOverride(this.itemModelShaper.getItemModel(bundleitem.openBackModel()), p_373010_, p_373067_, p_373013_, p_373103_);
                this.renderItemModelRaw(p_373010_, p_372950_, p_372853_, p_372830_, p_372949_, p_372893_, p_373061_, bakedmodel, flag, -1.5f);
                ItemStack itemstack = BundleItem.getSelectedItemStack(p_373010_);
                BakedModel bakedmodel1 = this.getModel(itemstack, p_373067_, p_373013_, p_373103_);
                this.renderSimpleItemModel(itemstack, p_372950_, p_372853_, p_372830_, p_372949_, p_372893_, p_373061_, bakedmodel1, flag);
                BakedModel bakedmodel2 = this.resolveModelOverride(this.itemModelShaper.getItemModel(bundleitem.openFrontModel()), p_373010_, p_373067_, p_373013_, p_373103_);
                this.renderItemModelRaw(p_373010_, p_372950_, p_372853_, p_372830_, p_372949_, p_372893_, p_373061_, bakedmodel2, flag, 0.5f);
            } else {
                this.render(p_373010_, p_372950_, p_372853_, p_372830_, p_372949_, p_372893_, p_373061_, p_372874_);
            }
        }
    }

    private void renderSimpleItemModel(ItemStack p_371881_, ItemDisplayContext p_371213_, boolean p_371746_, PoseStack p_371414_, MultiBufferSource p_371932_, int p_371370_, int p_371308_, BakedModel p_371488_, boolean p_371560_) {
        if (p_371560_) {
            if (p_371881_.is(Items.TRIDENT)) {
                p_371488_ = this.modelManager.getModel(TRIDENT_MODEL);
            } else if (p_371881_.is(Items.SPYGLASS)) {
                p_371488_ = this.modelManager.getModel(SPYGLASS_MODEL);
            }
        }
        this.renderItemModelRaw(p_371881_, p_371213_, p_371746_, p_371414_, p_371932_, p_371370_, p_371308_, p_371488_, p_371560_, -0.5f);
    }

    private void renderItemModelRaw(ItemStack p_371318_, ItemDisplayContext p_371250_, boolean p_371248_, PoseStack p_371635_, MultiBufferSource p_371946_, int p_371752_, int p_371508_, BakedModel p_371384_, boolean p_371718_, float p_371782_) {
        p_371635_.pushPose();
        p_371384_ = ClientHooks.handleCameraTransforms((PoseStack)p_371635_, (BakedModel)p_371384_, (ItemDisplayContext)p_371250_, (boolean)p_371248_);
        p_371635_.translate(-0.5f, -0.5f, p_371782_);
        this.renderItem(p_371318_, p_371250_, p_371635_, p_371946_, p_371752_, p_371508_, p_371384_, p_371718_);
        p_371635_.popPose();
    }

    private void renderItem(ItemStack p_361397_, ItemDisplayContext p_361627_, PoseStack p_360423_, MultiBufferSource p_360415_, int p_361265_, int p_364771_, BakedModel p_363970_, boolean p_364829_) {
        if (!(p_363970_.isCustomRenderer() || p_361397_.is(Items.TRIDENT) && !p_364829_)) {
            for (BakedModel model : p_363970_.getRenderPasses(p_361397_)) {
                for (RenderType rendertype : model.getRenderTypes(p_361397_)) {
                    VertexConsumer vertexconsumer;
                    if (ItemRenderer.hasAnimatedTexture(p_361397_) && p_361397_.hasFoil()) {
                        PoseStack.Pose posestack$pose = p_360423_.last().copy();
                        if (p_361627_ == ItemDisplayContext.GUI) {
                            MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.5f);
                        } else if (p_361627_.firstPerson()) {
                            MatrixUtil.mulComponentWise((Matrix4f)posestack$pose.pose(), (float)0.75f);
                        }
                        vertexconsumer = ItemRenderer.getCompassFoilBuffer(p_360415_, rendertype, posestack$pose);
                    } else {
                        vertexconsumer = ItemRenderer.getFoilBuffer(p_360415_, rendertype, true, p_361397_.hasFoil());
                    }
                    this.renderModelLists(model, p_361397_, p_361265_, p_364771_, p_360423_, vertexconsumer);
                }
            }
        } else {
            IClientItemExtensions.of((ItemStack)p_361397_).getCustomRenderer().renderByItem(p_361397_, p_361627_, p_360423_, p_360415_, p_361265_, p_364771_);
        }
    }

    private static boolean shouldRenderItemFlat(ItemDisplayContext p_372936_) {
        return p_372936_ == ItemDisplayContext.GUI || p_372936_ == ItemDisplayContext.GROUND || p_372936_ == ItemDisplayContext.FIXED;
    }

    private static boolean hasAnimatedTexture(ItemStack p_286353_) {
        return p_286353_.is(ItemTags.COMPASSES) || p_286353_.is(Items.CLOCK);
    }

    public static VertexConsumer getArmorFoilBuffer(MultiBufferSource p_115185_, RenderType p_115186_, boolean p_115187_) {
        return p_115187_ ? VertexMultiConsumer.create((VertexConsumer)p_115185_.getBuffer(RenderType.armorEntityGlint()), (VertexConsumer)p_115185_.getBuffer(p_115186_)) : p_115185_.getBuffer(p_115186_);
    }

    public static VertexConsumer getCompassFoilBuffer(MultiBufferSource p_115181_, RenderType p_115182_, PoseStack.Pose p_115183_) {
        return VertexMultiConsumer.create((VertexConsumer)new SheetedDecalTextureGenerator(p_115181_.getBuffer(RenderType.glint()), p_115183_, 0.0078125f), (VertexConsumer)p_115181_.getBuffer(p_115182_));
    }

    public static VertexConsumer getFoilBuffer(MultiBufferSource p_115212_, RenderType p_115213_, boolean p_115214_, boolean p_115215_) {
        if (p_115215_) {
            return Minecraft.useShaderTransparency() && p_115213_ == Sheets.translucentItemSheet() ? VertexMultiConsumer.create((VertexConsumer)p_115212_.getBuffer(RenderType.glintTranslucent()), (VertexConsumer)p_115212_.getBuffer(p_115213_)) : VertexMultiConsumer.create((VertexConsumer)p_115212_.getBuffer(p_115214_ ? RenderType.glint() : RenderType.entityGlint()), (VertexConsumer)p_115212_.getBuffer(p_115213_));
        }
        return p_115212_.getBuffer(p_115213_);
    }

    public void renderQuadList(PoseStack p_115163_, VertexConsumer p_115164_, List<BakedQuad> p_115165_, ItemStack p_115166_, int p_115167_, int p_115168_) {
        boolean flag = !p_115166_.isEmpty();
        PoseStack.Pose posestack$pose = p_115163_.last();
        for (BakedQuad bakedquad : p_115165_) {
            int i = -1;
            if (flag && bakedquad.isTinted()) {
                i = this.itemColors.getColor(p_115166_, bakedquad.getTintIndex());
            }
            float f = (float)ARGB.alpha((int)i) / 255.0f;
            float f1 = (float)ARGB.red((int)i) / 255.0f;
            float f2 = (float)ARGB.green((int)i) / 255.0f;
            float f3 = (float)ARGB.blue((int)i) / 255.0f;
            p_115164_.putBulkData(posestack$pose, bakedquad, f1, f2, f3, f, p_115167_, p_115168_, true);
        }
    }

    public BakedModel getModel(ItemStack p_174265_, @Nullable Level p_174266_, @Nullable LivingEntity p_174267_, int p_174268_) {
        BakedModel bakedmodel = this.itemModelShaper.getItemModel(p_174265_);
        return this.resolveModelOverride(bakedmodel, p_174265_, p_174266_, p_174267_, p_174268_);
    }

    public void renderStatic(ItemStack p_270761_, ItemDisplayContext p_270648_, int p_270410_, int p_270894_, PoseStack p_270430_, MultiBufferSource p_270457_, @Nullable Level p_270149_, int p_270509_) {
        this.renderStatic(null, p_270761_, p_270648_, false, p_270430_, p_270457_, p_270149_, p_270410_, p_270894_, p_270509_);
    }

    public void renderStatic(@Nullable LivingEntity p_270101_, ItemStack p_270637_, ItemDisplayContext p_270437_, boolean p_270434_, PoseStack p_270230_, MultiBufferSource p_270411_, @Nullable Level p_270641_, int p_270595_, int p_270927_, int p_270845_) {
        if (!p_270637_.isEmpty()) {
            BakedModel bakedmodel = this.getModel(p_270637_, p_270641_, p_270101_, p_270845_);
            this.render(p_270637_, p_270437_, p_270434_, p_270230_, p_270411_, p_270595_, p_270927_, bakedmodel);
        }
    }

    public void onResourceManagerReload(ResourceManager p_115105_) {
        this.itemModelShaper.invalidateCache();
    }

    @Nullable
    public BakedModel resolveItemModel(ItemStack p_365102_, LivingEntity p_360315_, ItemDisplayContext p_362422_) {
        return p_365102_.isEmpty() ? null : this.getModel(p_365102_, p_360315_.level(), p_360315_, p_360315_.getId() + p_362422_.ordinal());
    }

    private BakedModel resolveModelOverride(BakedModel p_373094_, ItemStack p_372923_, @Nullable Level p_372942_, @Nullable LivingEntity p_373099_, int p_372933_) {
        ClientLevel clientlevel = p_372942_ instanceof ClientLevel ? (ClientLevel)p_372942_ : null;
        BakedModel bakedmodel = p_373094_.overrides().findOverride(p_372923_, clientlevel, p_373099_, p_372933_);
        return bakedmodel == null ? p_373094_ : bakedmodel;
    }

    public BlockEntityWithoutLevelRenderer getBlockEntityRenderer() {
        return this.blockEntityRenderer;
    }
}

