/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentModelSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentModel;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

@OnlyIn(value=Dist.CLIENT)
public class EquipmentLayerRenderer {
    private static final int NO_LAYER_COLOR = 0;
    private final EquipmentModelSet equipmentModels;
    private final Function<LayerTextureKey, ResourceLocation> layerTextureLookup;
    private final Function<TrimSpriteKey, TextureAtlasSprite> trimSpriteLookup;

    public EquipmentLayerRenderer(EquipmentModelSet p_371468_, TextureAtlas p_371221_) {
        this.equipmentModels = p_371468_;
        this.layerTextureLookup = Util.memoize(p_371648_ -> p_371648_.layer.getTextureLocation(p_371648_.layerType));
        this.trimSpriteLookup = Util.memoize(p_371220_ -> {
            ResourceLocation resourcelocation = p_371220_.trim.getTexture(p_371220_.layerType, p_371220_.equipmentModelId);
            return p_371221_.getSprite(resourcelocation);
        });
    }

    public void renderLayers(EquipmentModel.LayerType p_371416_, ResourceLocation p_371630_, Model p_371498_, ItemStack p_371902_, PoseStack p_371937_, MultiBufferSource p_371457_, int p_371495_) {
        this.renderLayers(p_371416_, p_371630_, p_371498_, p_371902_, p_371937_, p_371457_, p_371495_, null);
    }

    public void renderLayers(EquipmentModel.LayerType p_371854_, ResourceLocation p_371639_, Model p_371731_, ItemStack p_371670_, PoseStack p_371767_, MultiBufferSource p_371286_, int p_371309_, @Nullable ResourceLocation p_371587_) {
        p_371731_ = this.getArmorModelHook(p_371670_, p_371854_, p_371731_);
        List list = this.equipmentModels.get(p_371639_).getLayers(p_371854_);
        if (!list.isEmpty()) {
            IClientItemExtensions extensions = IClientItemExtensions.of((ItemStack)p_371670_);
            int i = extensions.getDefaultDyeColor(p_371670_);
            boolean flag = p_371670_.hasFoil();
            int idx = 0;
            for (EquipmentModel.Layer equipmentmodel$layer : list) {
                int j = extensions.getArmorLayerTintColor(p_371670_, equipmentmodel$layer, idx, i);
                if (j != 0) {
                    ResourceLocation resourcelocation = equipmentmodel$layer.usePlayerTexture() && p_371587_ != null ? p_371587_ : this.layerTextureLookup.apply(new LayerTextureKey(p_371854_, equipmentmodel$layer));
                    resourcelocation = ClientHooks.getArmorTexture((ItemStack)p_371670_, (EquipmentModel.LayerType)p_371854_, (EquipmentModel.Layer)equipmentmodel$layer, (ResourceLocation)resourcelocation);
                    VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer(p_371286_, RenderType.armorCutoutNoCull(resourcelocation), flag);
                    p_371731_.renderToBuffer(p_371767_, vertexconsumer, p_371309_, OverlayTexture.NO_OVERLAY, j);
                    flag = false;
                }
                ++idx;
            }
            ArmorTrim armortrim = (ArmorTrim)p_371670_.get(DataComponents.TRIM);
            if (armortrim != null) {
                TextureAtlasSprite textureatlassprite = this.trimSpriteLookup.apply(new TrimSpriteKey(armortrim, p_371854_, p_371639_));
                VertexConsumer vertexconsumer1 = textureatlassprite.wrap(p_371286_.getBuffer(Sheets.armorTrimsSheet(((TrimPattern)armortrim.pattern().value()).decal())));
                p_371731_.renderToBuffer(p_371767_, vertexconsumer1, p_371309_, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    public static int getColorForLayer(EquipmentModel.Layer p_371840_, int p_371443_) {
        Optional optional = p_371840_.dyeable();
        if (optional.isPresent()) {
            int i = ((EquipmentModel.Dyeable)optional.get()).colorWhenUndyed().map(ARGB::opaque).orElse(0);
            return p_371443_ != 0 ? p_371443_ : i;
        }
        return -1;
    }

    protected Model getArmorModelHook(ItemStack itemStack, EquipmentModel.LayerType layerType, Model model) {
        return ClientHooks.getArmorModel((ItemStack)itemStack, (EquipmentModel.LayerType)layerType, (Model)model);
    }

    @OnlyIn(value=Dist.CLIENT)
    record LayerTextureKey(EquipmentModel.LayerType layerType, EquipmentModel.Layer layer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    record TrimSpriteKey(ArmorTrim trim, EquipmentModel.LayerType layerType, ResourceLocation equipmentModelId) {
    }
}

