/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.Deadmau5EarsLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
public class PlayerRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    public PlayerRenderer(EntityRendererProvider.Context p_174557_, boolean p_174558_) {
        super(p_174557_, new PlayerModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM : ModelLayers.PLAYER), p_174558_), 0.5f);
        this.addLayer(new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM_INNER_ARMOR : ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new HumanoidArmorModel(p_174557_.bakeLayer(p_174558_ ? ModelLayers.PLAYER_SLIM_OUTER_ARMOR : ModelLayers.PLAYER_OUTER_ARMOR)), p_174557_.getEquipmentRenderer()));
        this.addLayer(new PlayerItemInHandLayer((RenderLayerParent)this, p_174557_.getItemRenderer()));
        this.addLayer(new ArrowLayer((LivingEntityRenderer)this, p_174557_));
        this.addLayer(new Deadmau5EarsLayer((RenderLayerParent)this, p_174557_.getModelSet()));
        this.addLayer(new CapeLayer((RenderLayerParent)this, p_174557_.getModelSet(), p_174557_.getEquipmentModels()));
        this.addLayer(new CustomHeadLayer((RenderLayerParent)this, p_174557_.getModelSet(), p_174557_.getItemRenderer()));
        this.addLayer(new WingsLayer((RenderLayerParent)this, p_174557_.getModelSet(), p_174557_.getEquipmentRenderer()));
        this.addLayer(new ParrotOnShoulderLayer((RenderLayerParent)this, p_174557_.getModelSet()));
        this.addLayer(new SpinAttackEffectLayer((RenderLayerParent)this, p_174557_.getModelSet()));
        this.addLayer(new BeeStingerLayer((LivingEntityRenderer)this, p_174557_));
    }

    @Override
    protected boolean shouldRenderLayers(PlayerRenderState p_362188_) {
        return !p_362188_.isSpectator;
    }

    @Override
    public Vec3 getRenderOffset(PlayerRenderState p_360756_) {
        Vec3 vec3 = super.getRenderOffset(p_360756_);
        return p_360756_.isCrouching ? vec3.add(0.0, (double)(p_360756_.scale * -2.0f) / 16.0, 0.0) : vec3;
    }

    public static HumanoidModel.ArmPose getArmPose(PlayerRenderState p_372971_, HumanoidArm p_373044_) {
        HumanoidModel.ArmPose humanoidmodel$armpose = PlayerRenderer.getArmPose(p_372971_, p_372971_.mainHandState, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose humanoidmodel$armpose1 = PlayerRenderer.getArmPose(p_372971_, p_372971_.offhandState, InteractionHand.OFF_HAND);
        if (humanoidmodel$armpose.isTwoHanded()) {
            humanoidmodel$armpose1 = p_372971_.offhandState.isEmpty ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
        }
        return p_372971_.mainArm == p_373044_ ? humanoidmodel$armpose : humanoidmodel$armpose1;
    }

    private static HumanoidModel.ArmPose getArmPose(PlayerRenderState p_363098_, PlayerRenderState.HandState p_364742_, InteractionHand p_117796_) {
        if (p_364742_.isEmpty) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (p_363098_.useItemHand == p_117796_ && p_363098_.useItemRemainingTicks > 0) {
            ItemUseAnimation itemuseanimation = p_364742_.useAnimation;
            if (itemuseanimation == ItemUseAnimation.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (itemuseanimation == ItemUseAnimation.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (itemuseanimation == ItemUseAnimation.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (itemuseanimation == ItemUseAnimation.CROSSBOW) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (itemuseanimation == ItemUseAnimation.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (itemuseanimation == ItemUseAnimation.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if (itemuseanimation == ItemUseAnimation.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!p_363098_.swinging && p_364742_.holdsChargedCrossbow) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if (p_364742_.customArmPose != null) {
            return p_364742_.customArmPose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    @Override
    public ResourceLocation getTextureLocation(PlayerRenderState p_364673_) {
        return p_364673_.skin.texture();
    }

    @Override
    protected void scale(PlayerRenderState p_364943_, PoseStack p_117799_) {
        float f = 0.9375f;
        p_117799_.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Override
    public void render(PlayerRenderState p_361886_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        if (((RenderPlayerEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Pre(p_361886_, this, p_361886_.partialTick, p_115311_, p_115312_, p_115313_))).isCanceled()) {
            return;
        }
        super.render(p_361886_, p_115311_, p_115312_, p_115313_);
        NeoForge.EVENT_BUS.post((Event)new RenderPlayerEvent.Post(p_361886_, this, p_361886_.partialTick, p_115311_, p_115312_, p_115313_));
    }

    @Override
    protected void renderNameTag(PlayerRenderState p_363185_, Component p_117809_, PoseStack p_117810_, MultiBufferSource p_117811_, int p_117812_) {
        p_117810_.pushPose();
        if (p_363185_.scoreText != null) {
            super.renderNameTag(p_363185_, p_363185_.scoreText, p_117810_, p_117811_, p_117812_);
            p_117810_.translate(0.0f, 0.25875f, 0.0f);
        }
        super.renderNameTag(p_363185_, p_117809_, p_117810_, p_117811_, p_117812_);
        p_117810_.popPose();
    }

    @Override
    public PlayerRenderState createRenderState() {
        return new PlayerRenderState();
    }

    @Override
    public void extractRenderState(AbstractClientPlayer p_361478_, PlayerRenderState p_360583_, float p_364121_) {
        super.extractRenderState(p_361478_, p_360583_, p_364121_);
        HumanoidMobRenderer.extractHumanoidRenderState(p_361478_, p_360583_, p_364121_);
        p_360583_.skin = p_361478_.getSkin();
        p_360583_.arrowCount = p_361478_.getArrowCount();
        p_360583_.stingerCount = p_361478_.getStingerCount();
        p_360583_.useItemRemainingTicks = p_361478_.getUseItemRemainingTicks();
        p_360583_.swinging = p_361478_.swinging;
        p_360583_.isSpectator = p_361478_.isSpectator();
        p_360583_.showHat = p_361478_.isModelPartShown(PlayerModelPart.HAT);
        p_360583_.showJacket = p_361478_.isModelPartShown(PlayerModelPart.JACKET);
        p_360583_.showLeftPants = p_361478_.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
        p_360583_.showRightPants = p_361478_.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
        p_360583_.showLeftSleeve = p_361478_.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
        p_360583_.showRightSleeve = p_361478_.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
        p_360583_.showCape = p_361478_.isModelPartShown(PlayerModelPart.CAPE);
        PlayerRenderer.extractFlightData(p_361478_, p_360583_, p_364121_);
        this.extractHandState(p_361478_, p_360583_.mainHandState, InteractionHand.MAIN_HAND);
        this.extractHandState(p_361478_, p_360583_.offhandState, InteractionHand.OFF_HAND);
        PlayerRenderer.extractCapeState(p_361478_, p_360583_, p_364121_);
        if (p_360583_.distanceToCameraSq < 100.0) {
            Scoreboard scoreboard = p_361478_.getScoreboard();
            Objective objective = scoreboard.getDisplayObjective(DisplaySlot.BELOW_NAME);
            if (objective != null) {
                ReadOnlyScoreInfo readonlyscoreinfo = scoreboard.getPlayerScoreInfo((ScoreHolder)p_361478_, objective);
                MutableComponent component = ReadOnlyScoreInfo.safeFormatValue((ReadOnlyScoreInfo)readonlyscoreinfo, (NumberFormat)objective.numberFormatOrDefault((NumberFormat)StyledFormat.NO_STYLE));
                p_360583_.scoreText = Component.empty().append((Component)component).append(CommonComponents.SPACE).append(objective.getDisplayName());
            } else {
                p_360583_.scoreText = null;
            }
        } else {
            p_360583_.scoreText = null;
        }
        p_360583_.parrotOnLeftShoulder = PlayerRenderer.getParrotOnShoulder(p_361478_, true);
        p_360583_.parrotOnRightShoulder = PlayerRenderer.getParrotOnShoulder(p_361478_, false);
        p_360583_.id = p_361478_.getId();
        p_360583_.name = p_361478_.getGameProfile().getName();
    }

    private static void extractFlightData(AbstractClientPlayer p_361452_, PlayerRenderState p_363432_, float p_364796_) {
        p_363432_.fallFlyingTimeInTicks = (float)p_361452_.getFallFlyingTicks() + p_364796_;
        Vec3 vec3 = p_361452_.getViewVector(p_364796_);
        Vec3 vec31 = p_361452_.getDeltaMovementLerped(p_364796_);
        double d0 = vec31.horizontalDistanceSqr();
        double d1 = vec3.horizontalDistanceSqr();
        if (d0 > 0.0 && d1 > 0.0) {
            p_363432_.shouldApplyFlyingYRot = true;
            double d2 = (vec31.x * vec3.x + vec31.z * vec3.z) / Math.sqrt(d0 * d1);
            double d3 = vec31.x * vec3.z - vec31.z * vec3.x;
            p_363432_.flyingYRot = (float)(Math.signum(d3) * Math.acos(d2));
        } else {
            p_363432_.shouldApplyFlyingYRot = false;
            p_363432_.flyingYRot = 0.0f;
        }
    }

    private void extractHandState(AbstractClientPlayer p_364516_, PlayerRenderState.HandState p_360817_, InteractionHand p_364304_) {
        ItemStack itemstack = p_364516_.getItemInHand(p_364304_);
        p_360817_.isEmpty = itemstack.isEmpty();
        p_360817_.useAnimation = !itemstack.isEmpty() ? itemstack.getUseAnimation() : null;
        p_360817_.holdsChargedCrossbow = itemstack.getItem() instanceof CrossbowItem && CrossbowItem.isCharged(itemstack);
        p_360817_.customArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose((LivingEntity)p_364516_, p_364304_, itemstack);
    }

    private static void extractCapeState(AbstractClientPlayer p_364691_, PlayerRenderState p_360814_, float p_364460_) {
        double d0 = Mth.lerp((double)p_364460_, (double)p_364691_.xCloakO, (double)p_364691_.xCloak) - Mth.lerp((double)p_364460_, (double)p_364691_.xo, (double)p_364691_.getX());
        double d1 = Mth.lerp((double)p_364460_, (double)p_364691_.yCloakO, (double)p_364691_.yCloak) - Mth.lerp((double)p_364460_, (double)p_364691_.yo, (double)p_364691_.getY());
        double d2 = Mth.lerp((double)p_364460_, (double)p_364691_.zCloakO, (double)p_364691_.zCloak) - Mth.lerp((double)p_364460_, (double)p_364691_.zo, (double)p_364691_.getZ());
        float f = Mth.rotLerp((float)p_364460_, (float)p_364691_.yBodyRotO, (float)p_364691_.yBodyRot);
        double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
        p_360814_.capeFlap = (float)d1 * 10.0f;
        p_360814_.capeFlap = Mth.clamp((float)p_360814_.capeFlap, (float)-6.0f, (float)32.0f);
        p_360814_.capeLean = (float)(d0 * d3 + d2 * d4) * 100.0f;
        p_360814_.capeLean *= 1.0f - p_360814_.fallFlyingScale();
        p_360814_.capeLean = Mth.clamp((float)p_360814_.capeLean, (float)0.0f, (float)150.0f);
        p_360814_.capeLean2 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        p_360814_.capeLean2 = Mth.clamp((float)p_360814_.capeLean2, (float)-20.0f, (float)20.0f);
        float f1 = Mth.lerp((float)p_364460_, (float)p_364691_.oBob, (float)p_364691_.bob);
        float f2 = Mth.lerp((float)p_364460_, (float)p_364691_.walkDistO, (float)p_364691_.walkDist);
        p_360814_.capeFlap += Mth.sin((float)(f2 * 6.0f)) * 32.0f * f1;
    }

    @Nullable
    private static Parrot.Variant getParrotOnShoulder(AbstractClientPlayer p_363115_, boolean p_360551_) {
        CompoundTag compoundtag = p_360551_ ? p_363115_.getShoulderEntityLeft() : p_363115_.getShoulderEntityRight();
        return EntityType.byString(compoundtag.getString("id")).filter(p_362544_ -> p_362544_ == EntityType.PARROT).isPresent() ? Parrot.Variant.byId(compoundtag.getInt("Variant")) : null;
    }

    @Deprecated
    public void renderRightHand(PoseStack p_117771_, MultiBufferSource p_117772_, int p_117773_, ResourceLocation p_363694_, boolean p_366898_) {
        this.renderRightHand(p_117771_, p_117772_, p_117773_, p_363694_, p_366898_, Minecraft.getInstance().player);
    }

    public void renderRightHand(PoseStack p_117771_, MultiBufferSource p_117772_, int p_117773_, ResourceLocation p_363694_, boolean p_366898_, AbstractClientPlayer player) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)p_117771_, (MultiBufferSource)p_117772_, (int)p_117773_, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.RIGHT)) {
            this.renderHand(p_117771_, p_117772_, p_117773_, p_363694_, ((PlayerModel)this.model).rightArm, p_366898_);
        }
    }

    @Deprecated
    public void renderLeftHand(PoseStack p_117814_, MultiBufferSource p_117815_, int p_117816_, ResourceLocation p_361745_, boolean p_366730_) {
        this.renderLeftHand(p_117814_, p_117815_, p_117816_, p_361745_, p_366730_, Minecraft.getInstance().player);
    }

    public void renderLeftHand(PoseStack p_117814_, MultiBufferSource p_117815_, int p_117816_, ResourceLocation p_361745_, boolean p_366730_, AbstractClientPlayer player) {
        if (!ClientHooks.renderSpecificFirstPersonArm((PoseStack)p_117814_, (MultiBufferSource)p_117815_, (int)p_117816_, (AbstractClientPlayer)player, (HumanoidArm)HumanoidArm.LEFT)) {
            this.renderHand(p_117814_, p_117815_, p_117816_, p_361745_, ((PlayerModel)this.model).leftArm, p_366730_);
        }
    }

    private void renderHand(PoseStack p_117776_, MultiBufferSource p_117777_, int p_117778_, ResourceLocation p_360319_, ModelPart p_117780_, boolean p_366655_) {
        PlayerModel playermodel = (PlayerModel)this.getModel();
        p_117780_.resetPose();
        p_117780_.visible = true;
        playermodel.leftSleeve.visible = p_366655_;
        playermodel.rightSleeve.visible = p_366655_;
        playermodel.leftArm.zRot = -0.1f;
        playermodel.rightArm.zRot = 0.1f;
        p_117780_.render(p_117776_, p_117777_.getBuffer(RenderType.entityTranslucent(p_360319_)), p_117778_, OverlayTexture.NO_OVERLAY);
    }

    @Override
    protected void setupRotations(PlayerRenderState p_363355_, PoseStack p_117803_, float p_117804_, float p_117805_) {
        float f = p_363355_.swimAmount;
        float f1 = p_363355_.xRot;
        if (p_363355_.isFallFlying) {
            super.setupRotations(p_363355_, p_117803_, p_117804_, p_117805_);
            float f2 = p_363355_.fallFlyingScale();
            if (!p_363355_.isAutoSpinAttack) {
                p_117803_.mulPose(Axis.XP.rotationDegrees(f2 * (-90.0f - f1)));
            }
            if (p_363355_.shouldApplyFlyingYRot) {
                p_117803_.mulPose(Axis.YP.rotation(p_363355_.flyingYRot));
            }
        } else if (f > 0.0f) {
            super.setupRotations(p_363355_, p_117803_, p_117804_, p_117805_);
            float f4 = p_363355_.isInWater ? -90.0f - f1 : -90.0f;
            float f3 = Mth.lerp((float)f, (float)0.0f, (float)f4);
            p_117803_.mulPose(Axis.XP.rotationDegrees(f3));
            if (p_363355_.isVisuallySwimming) {
                p_117803_.translate(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.setupRotations(p_363355_, p_117803_, p_117804_, p_117805_);
        }
    }
}

