/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedOverrides;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.DelegateBakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemModel
implements UnbakedModel {
    private final ResourceLocation id;
    private List<ItemOverride> overrides = List.of();

    public ItemModel(ResourceLocation p_371764_) {
        this.id = p_371764_;
    }

    public void resolveDependencies(UnbakedModel.Resolver p_371360_) {
        UnbakedModel unbakedModel = p_371360_.resolve(this.id);
        if (unbakedModel instanceof BlockModel) {
            BlockModel blockmodel = (BlockModel)unbakedModel;
            this.overrides = blockmodel.getOverrides();
            this.overrides.forEach(p_371481_ -> p_371360_.resolve(p_371481_.model()));
        }
    }

    public BakedModel bake(ModelBaker p_371426_, Function<Material, TextureAtlasSprite> p_371750_, ModelState p_371674_) {
        BakedModel bakedmodel = p_371426_.bake(this.id, p_371674_, p_371750_);
        if (this.overrides.isEmpty()) {
            return bakedmodel;
        }
        BakedOverrides bakedoverrides = new BakedOverrides(p_371426_, this.overrides, p_371750_);
        return new BakedModelWithOverrides(bakedmodel, bakedoverrides);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BakedModelWithOverrides
    extends DelegateBakedModel {
        private final BakedOverrides overrides;

        public BakedModelWithOverrides(BakedModel p_371770_, BakedOverrides p_371662_) {
            super(p_371770_);
            this.overrides = p_371662_;
        }

        @Override
        public BakedOverrides overrides() {
            return this.overrides;
        }
    }
}

