/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SpecialModels;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    public static final Material FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_0"));
    public static final Material FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_1"));
    public static final Material LAVA_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/lava_flow"));
    public static final Material WATER_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_flow"));
    public static final Material WATER_OVERLAY = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_overlay"));
    public static final Material BANNER_BASE = new Material(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("entity/banner_base"));
    public static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base"));
    public static final Material NO_PATTERN_SHIELD = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base_nopattern"));
    public static final int DESTROY_STAGE_COUNT = 10;
    public static final List<ResourceLocation> DESTROY_STAGES = IntStream.range(0, 10).mapToObj(p_349912_ -> ResourceLocation.withDefaultNamespace("block/destroy_stage_" + p_349912_)).collect(Collectors.toList());
    public static final List<ResourceLocation> BREAKING_LOCATIONS = DESTROY_STAGES.stream().map(p_349910_ -> p_349910_.withPath(p_349911_ -> "textures/" + p_349911_ + ".png")).collect(Collectors.toList());
    public static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(RenderType::crumbling).collect(Collectors.toList());
    static final Logger LOGGER = LogUtils.getLogger();
    static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    final Map<BakedCacheKey, BakedModel> bakedCache = new HashMap<BakedCacheKey, BakedModel>();
    private final Map<ModelResourceLocation, BakedModel> bakedTopLevelModels = new HashMap<ModelResourceLocation, BakedModel>();
    private final Map<ModelResourceLocation, UnbakedModel> topModels;
    final Map<ResourceLocation, UnbakedModel> unbakedModels;
    final UnbakedModel missingModel;

    public ModelBakery(Map<ModelResourceLocation, UnbakedModel> p_251087_, Map<ResourceLocation, UnbakedModel> p_250416_, UnbakedModel p_360944_) {
        this.topModels = p_251087_;
        this.unbakedModels = p_250416_;
        this.missingModel = p_360944_;
    }

    public void bakeModels(TextureGetter p_352431_) {
        this.topModels.forEach((p_351687_, p_351688_) -> {
            BakedModel bakedmodel = null;
            try {
                bakedmodel = new ModelBakerImpl(p_352431_, (ModelResourceLocation)p_351687_).bakeUncached((UnbakedModel)p_351688_, (ModelState)BlockModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to bake model: '{}': {}", p_351687_, (Object)exception);
            }
            if (bakedmodel != null) {
                this.bakedTopLevelModels.put((ModelResourceLocation)p_351687_, bakedmodel);
            }
        });
    }

    public Map<ModelResourceLocation, BakedModel> getBakedTopLevelModels() {
        return this.bakedTopLevelModels;
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface TextureGetter {
        public TextureAtlasSprite get(ModelResourceLocation var1, Material var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    class ModelBakerImpl
    implements ModelBaker {
        private final Function<Material, TextureAtlasSprite> modelTextureGetter = p_351691_ -> p_352124_.get(p_352126_, (Material)p_351691_);

        ModelBakerImpl(TextureGetter p_352124_, ModelResourceLocation p_352126_) {
        }

        private UnbakedModel getModel(ResourceLocation p_248568_) {
            UnbakedModel unbakedmodel = ModelBakery.this.unbakedModels.get(p_248568_);
            if (unbakedmodel == null) {
                LOGGER.warn("Requested a model that was not discovered previously: {}", (Object)p_248568_);
                return ModelBakery.this.missingModel;
            }
            return unbakedmodel;
        }

        @Nullable
        public UnbakedModel getTopLevelModel(ModelResourceLocation location) {
            return ModelBakery.this.topModels.get(location);
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return this.modelTextureGetter;
        }

        @Override
        public BakedModel bake(ResourceLocation p_252176_, ModelState p_249765_) {
            return this.bake(p_252176_, p_249765_, this.modelTextureGetter);
        }

        public BakedModel bake(ResourceLocation p_252176_, ModelState p_249765_, Function<Material, TextureAtlasSprite> sprites) {
            BakedCacheKey modelbakery$bakedcachekey = new BakedCacheKey(p_252176_, p_249765_.getRotation(), p_249765_.isUvLocked());
            BakedModel bakedmodel = ModelBakery.this.bakedCache.get(modelbakery$bakedcachekey);
            if (bakedmodel != null) {
                return bakedmodel;
            }
            UnbakedModel unbakedmodel = this.getModel(p_252176_);
            BakedModel bakedmodel1 = this.bakeUncached(unbakedmodel, p_249765_, sprites);
            ModelBakery.this.bakedCache.put(modelbakery$bakedcachekey, bakedmodel1);
            return bakedmodel1;
        }

        BakedModel bakeUncached(UnbakedModel p_352386_, ModelState p_352194_) {
            return this.bakeUncached(p_352386_, p_352194_, this.modelTextureGetter);
        }

        public BakedModel bakeUncached(UnbakedModel p_352386_, ModelState p_352194_, Function<Material, TextureAtlasSprite> sprites) {
            BlockModel blockmodel;
            if (p_352386_ instanceof BlockModel && (blockmodel = (BlockModel)p_352386_).getRootModel() == SpecialModels.GENERATED_MARKER) {
                return ITEM_MODEL_GENERATOR.generateBlockModel(sprites, blockmodel).bake(sprites, p_352194_, false);
            }
            return p_352386_.bake((ModelBaker)this, sprites, p_352194_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record BakedCacheKey(ResourceLocation id, Transformation transformation, boolean isUvLocked) {
    }
}

