/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ItemModel;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.SpecialModels;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelDiscovery {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final String INVENTORY_MODEL_PREFIX = "item/";
    private final Map<ResourceLocation, UnbakedModel> inputModels;
    final UnbakedModel missingModel;
    private final Map<ModelResourceLocation, UnbakedModel> topModels = new HashMap<ModelResourceLocation, UnbakedModel>();
    private final Map<ResourceLocation, UnbakedModel> referencedModels = new HashMap<ResourceLocation, UnbakedModel>();

    public ModelDiscovery(Map<ResourceLocation, UnbakedModel> p_360750_, UnbakedModel p_365355_) {
        this.inputModels = p_360750_;
        this.missingModel = p_365355_;
        this.registerTopModel(MissingBlockModel.VARIANT, p_365355_);
        this.referencedModels.put(MissingBlockModel.LOCATION, p_365355_);
    }

    private static Set<ModelResourceLocation> listMandatoryModels() {
        HashSet<ModelResourceLocation> set = new HashSet<ModelResourceLocation>();
        BuiltInRegistries.ITEM.listElements().forEach(p_370358_ -> {
            Object patt0$temp;
            ResourceLocation resourcelocation = (ResourceLocation)((Item)p_370358_.value()).components().get(DataComponents.ITEM_MODEL);
            if (resourcelocation != null) {
                set.add(ModelResourceLocation.inventory(resourcelocation));
            }
            if ((patt0$temp = p_370358_.value()) instanceof BundleItem) {
                BundleItem bundleitem = (BundleItem)patt0$temp;
                set.add(ModelResourceLocation.inventory(bundleitem.openFrontModel()));
                set.add(ModelResourceLocation.inventory(bundleitem.openBackModel()));
            }
        });
        set.add(ItemRenderer.TRIDENT_MODEL);
        set.add(ItemRenderer.SPYGLASS_MODEL);
        ClientHooks.onRegisterAdditionalModels(set);
        return set;
    }

    private void registerTopModel(ModelResourceLocation p_364527_, UnbakedModel p_362402_) {
        this.topModels.put(p_364527_, p_362402_);
    }

    public void registerStandardModels(BlockStateModelLoader.LoadedModels p_363325_) {
        this.referencedModels.put(SpecialModels.BUILTIN_GENERATED, SpecialModels.GENERATED_MARKER);
        this.referencedModels.put(SpecialModels.BUILTIN_BLOCK_ENTITY, SpecialModels.BLOCK_ENTITY_MARKER);
        Set<ModelResourceLocation> set = ModelDiscovery.listMandatoryModels();
        p_363325_.models().forEach((p_370360_, p_370361_) -> {
            this.registerTopModel((ModelResourceLocation)p_370360_, p_370361_.model());
            set.remove(p_370360_);
        });
        this.inputModels.keySet().forEach(p_370363_ -> {
            if (p_370363_.getPath().startsWith(INVENTORY_MODEL_PREFIX)) {
                ModelResourceLocation modelresourcelocation = ModelResourceLocation.inventory(p_370363_.withPath(p_370356_ -> p_370356_.substring(INVENTORY_MODEL_PREFIX.length())));
                this.registerTopModel(modelresourcelocation, new ItemModel((ResourceLocation)p_370363_));
                set.remove(modelresourcelocation);
            }
        });
        Iterator<ModelResourceLocation> it = set.iterator();
        while (it.hasNext()) {
            ModelResourceLocation mrl = it.next();
            if (!mrl.getVariant().equals("standalone")) continue;
            this.registerTopModel(mrl, this.getBlockModel(mrl.id()));
            it.remove();
        }
        if (!set.isEmpty()) {
            LOGGER.warn("Missing mandatory models: {}", (Object)set.stream().map(p_370354_ -> "\n\t" + String.valueOf(p_370354_)).collect(Collectors.joining()));
        }
    }

    public void discoverDependencies() {
        this.topModels.values().forEach(p_370355_ -> p_370355_.resolveDependencies((UnbakedModel.Resolver)new ResolverImpl()));
    }

    public Map<ModelResourceLocation, UnbakedModel> getTopModels() {
        return this.topModels;
    }

    public Map<ResourceLocation, UnbakedModel> getReferencedModels() {
        return this.referencedModels;
    }

    UnbakedModel getBlockModel(ResourceLocation p_360328_) {
        return this.referencedModels.computeIfAbsent(p_360328_, this::loadBlockModel);
    }

    private UnbakedModel loadBlockModel(ResourceLocation p_361274_) {
        UnbakedModel unbakedmodel = this.inputModels.get(p_361274_);
        if (unbakedmodel == null) {
            LOGGER.warn("Missing block model: '{}'", (Object)p_361274_);
            return this.missingModel;
        }
        return unbakedmodel;
    }

    @OnlyIn(value=Dist.CLIENT)
    class ResolverImpl
    implements UnbakedModel.Resolver {
        private final List<ResourceLocation> stack = new ArrayList<ResourceLocation>();
        private final Set<ResourceLocation> resolvedModels = new HashSet<ResourceLocation>();

        ResolverImpl() {
        }

        public UnbakedModel resolve(ResourceLocation p_361784_) {
            if (this.stack.contains(p_361784_)) {
                LOGGER.warn("Detected model loading loop: {}->{}", (Object)this.stacktraceToString(), (Object)p_361784_);
                return ModelDiscovery.this.missingModel;
            }
            UnbakedModel unbakedmodel = ModelDiscovery.this.getBlockModel(p_361784_);
            if (this.resolvedModels.add(p_361784_)) {
                this.stack.add(p_361784_);
                unbakedmodel.resolveDependencies((UnbakedModel.Resolver)this);
                this.stack.remove(p_361784_);
            }
            return unbakedmodel;
        }

        private String stacktraceToString() {
            return this.stack.stream().map(ResourceLocation::toString).collect(Collectors.joining("->"));
        }
    }
}

