/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelGroupCollector;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.model.geometry.GeometryLoaderManager;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelManager
implements PreparableReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter BLOCKSTATE_LISTER = FileToIdConverter.json("blockstates");
    private static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json("models");
    private static final Map<ResourceLocation, ResourceLocation> VANILLA_ATLASES = Map.of(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("banner_patterns"), Sheets.BED_SHEET, ResourceLocation.withDefaultNamespace("beds"), Sheets.CHEST_SHEET, ResourceLocation.withDefaultNamespace("chests"), Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("shield_patterns"), Sheets.SIGN_SHEET, ResourceLocation.withDefaultNamespace("signs"), Sheets.SHULKER_SHEET, ResourceLocation.withDefaultNamespace("shulker_boxes"), Sheets.ARMOR_TRIMS_SHEET, ResourceLocation.withDefaultNamespace("armor_trims"), Sheets.DECORATED_POT_SHEET, ResourceLocation.withDefaultNamespace("decorated_pot"), TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("blocks"));
    private Map<ModelResourceLocation, BakedModel> bakedRegistry = new HashMap<ModelResourceLocation, BakedModel>();
    private final AtlasSet atlases;
    private final BlockModelShaper blockModelShaper;
    private final BlockColors blockColors;
    private int maxMipmapLevels;
    private BakedModel missingModel;
    private Object2IntMap<BlockState> modelGroups;
    private ModelBakery modelBakery;

    public ModelManager(TextureManager p_119406_, BlockColors p_119407_, int p_119408_) {
        this.blockColors = p_119407_;
        this.maxMipmapLevels = p_119408_;
        this.blockModelShaper = new BlockModelShaper(this);
        Map VANILLA_ATLASES = ClientHooks.gatherMaterialAtlases(ModelManager.VANILLA_ATLASES);
        this.atlases = new AtlasSet(VANILLA_ATLASES, p_119406_);
    }

    public BakedModel getModel(ModelResourceLocation p_119423_) {
        return this.bakedRegistry.getOrDefault(p_119423_, this.missingModel);
    }

    public BakedModel getMissingModel() {
        return this.missingModel;
    }

    public BlockModelShaper getBlockModelShaper() {
        return this.blockModelShaper;
    }

    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_249079_, ResourceManager p_251134_, Executor p_250550_, Executor p_249221_) {
        GeometryLoaderManager.init();
        UnbakedModel unbakedmodel = MissingBlockModel.missingModel();
        BlockStateModelLoader blockstatemodelloader = new BlockStateModelLoader(unbakedmodel);
        CompletableFuture<Map<ResourceLocation, UnbakedModel>> completablefuture = ModelManager.loadBlockModels(p_251134_, p_250550_);
        CompletableFuture<BlockStateModelLoader.LoadedModels> completablefuture1 = ModelManager.loadBlockStates(blockstatemodelloader, p_251134_, p_250550_);
        CompletionStage completablefuture2 = completablefuture1.thenCombineAsync(completablefuture, (p_359302_, p_359303_) -> this.discoverModelDependencies(unbakedmodel, (Map<ResourceLocation, UnbakedModel>)p_359303_, (BlockStateModelLoader.LoadedModels)p_359302_), p_250550_);
        CompletionStage completablefuture3 = completablefuture1.thenApplyAsync(p_359309_ -> ModelManager.buildModelGroups(this.blockColors, p_359309_), p_250550_);
        Map map = this.atlases.scheduleLoad(p_251134_, this.maxMipmapLevels, p_250550_);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.concat(map.values().stream(), Stream.of(completablefuture2, completablefuture3)).toArray(CompletableFuture[]::new)).thenApplyAsync(arg_0 -> this.lambda$reload$4(map, (CompletableFuture)completablefuture2, (CompletableFuture)completablefuture3, unbakedmodel, arg_0), p_250550_)).thenCompose(p_252255_ -> p_252255_.readyForUpload.thenApply(p_251581_ -> p_252255_))).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)p_249079_).wait(arg_0))).thenAcceptAsync(p_372566_ -> this.apply((ReloadState)p_372566_, Profiler.get()), p_249221_);
    }

    private static CompletableFuture<Map<ResourceLocation, UnbakedModel>> loadBlockModels(ResourceManager p_251361_, Executor p_252189_) {
        return CompletableFuture.supplyAsync(() -> MODEL_LISTER.listMatchingResources(p_251361_), p_252189_).thenCompose(p_250597_ -> {
            ArrayList<CompletableFuture<Pair>> list = new ArrayList<CompletableFuture<Pair>>(p_250597_.size());
            for (Map.Entry entry : p_250597_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation resourcelocation = MODEL_LISTER.fileToId((ResourceLocation)entry.getKey());
                    try {
                        Pair pair;
                        try (BufferedReader reader = ((Resource)entry.getValue()).openAsReader();){
                            BlockModel blockmodel = BlockModel.fromStream(reader);
                            blockmodel.name = resourcelocation.toString();
                            pair = Pair.of((Object)resourcelocation, (Object)blockmodel);
                        }
                        return pair;
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to load model {}", entry.getKey(), (Object)exception);
                        return null;
                    }
                }, p_252189_));
            }
            return Util.sequence(list).thenApply(p_250813_ -> p_250813_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private ModelDiscovery discoverModelDependencies(UnbakedModel p_360651_, Map<ResourceLocation, UnbakedModel> p_363228_, BlockStateModelLoader.LoadedModels p_361624_) {
        ModelDiscovery modeldiscovery = new ModelDiscovery(p_363228_, p_360651_);
        modeldiscovery.registerStandardModels(p_361624_);
        modeldiscovery.discoverDependencies();
        return modeldiscovery;
    }

    private static CompletableFuture<BlockStateModelLoader.LoadedModels> loadBlockStates(BlockStateModelLoader p_363530_, ResourceManager p_252084_, Executor p_249943_) {
        Function function = BlockStateModelLoader.definitionLocationToBlockMapper();
        return CompletableFuture.supplyAsync(() -> BLOCKSTATE_LISTER.listMatchingResourceStacks(p_252084_), p_249943_).thenCompose(p_359307_ -> {
            ArrayList<CompletableFuture<BlockStateModelLoader.LoadedModels>> list = new ArrayList<CompletableFuture<BlockStateModelLoader.LoadedModels>>(p_359307_.size());
            for (Map.Entry entry : p_359307_.entrySet()) {
                list.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation resourcelocation = BLOCKSTATE_LISTER.fileToId((ResourceLocation)entry.getKey());
                    StateDefinition statedefinition = (StateDefinition)function.apply(resourcelocation);
                    if (statedefinition == null) {
                        LOGGER.debug("Discovered unknown block state definition {}, ignoring", (Object)resourcelocation);
                        return null;
                    }
                    List list1 = (List)entry.getValue();
                    ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition> list2 = new ArrayList<BlockStateModelLoader.LoadedBlockModelDefinition>(list1.size());
                    for (Resource resource : list1) {
                        try {
                            BufferedReader reader = resource.openAsReader();
                            try {
                                JsonObject jsonobject = GsonHelper.parse((Reader)reader);
                                BlockModelDefinition blockmodeldefinition = BlockModelDefinition.fromJsonElement((JsonElement)jsonobject);
                                list2.add(new BlockStateModelLoader.LoadedBlockModelDefinition(resource.sourcePackId(), blockmodeldefinition));
                            }
                            finally {
                                if (reader == null) continue;
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception exception1) {
                            LOGGER.error("Failed to load blockstate definition {} from pack {}", new Object[]{resourcelocation, resource.sourcePackId(), exception1});
                        }
                    }
                    try {
                        return p_363530_.loadBlockStateDefinitionStack(resourcelocation, statedefinition, list2);
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to load blockstate definition {}", (Object)resourcelocation, (Object)exception);
                        return null;
                    }
                }, p_249943_));
            }
            return Util.sequence(list).thenApply(p_359308_ -> {
                HashMap map = new HashMap();
                for (BlockStateModelLoader.LoadedModels blockstatemodelloader$loadedmodels : p_359308_) {
                    if (blockstatemodelloader$loadedmodels == null) continue;
                    map.putAll(blockstatemodelloader$loadedmodels.models());
                }
                return new BlockStateModelLoader.LoadedModels(map);
            });
        });
    }

    private ReloadState loadModels(ProfilerFiller p_252136_, Map<ResourceLocation, AtlasSet.StitchResult> p_250646_, ModelBakery p_248945_, Object2IntMap<BlockState> p_363498_) {
        p_252136_.push("baking");
        HashMultimap multimap = HashMultimap.create();
        p_248945_.bakeModels((arg_0, arg_1) -> ModelManager.lambda$loadModels$16(p_250646_, (Multimap)multimap, arg_0, arg_1));
        multimap.asMap().forEach((p_352087_, p_252017_) -> LOGGER.warn("Missing textures in model {}:\n{}", p_352087_, (Object)p_252017_.stream().sorted(Material.COMPARATOR).map(p_339314_ -> "    " + String.valueOf(p_339314_.atlasLocation()) + ":" + String.valueOf(p_339314_.texture())).collect(Collectors.joining("\n"))));
        p_252136_.popPush("forge_modify_baking_result");
        ClientHooks.onModifyBakingResult(p_248945_.getBakedTopLevelModels(), p_250646_, (ModelBakery)p_248945_);
        p_252136_.popPush("dispatch");
        Map<ModelResourceLocation, BakedModel> map = p_248945_.getBakedTopLevelModels();
        BakedModel bakedmodel = map.get(MissingBlockModel.VARIANT);
        IdentityHashMap<BlockState, BakedModel> map1 = new IdentityHashMap<BlockState, BakedModel>();
        for (Block block : BuiltInRegistries.BLOCK) {
            block.getStateDefinition().getPossibleStates().forEach(p_250633_ -> {
                ResourceLocation resourcelocation = p_250633_.getBlock().builtInRegistryHolder().key().location();
                BakedModel bakedmodel1 = map.getOrDefault(BlockModelShaper.stateToModelLocation(resourcelocation, p_250633_), bakedmodel);
                map1.put((BlockState)((Object)p_250633_), bakedmodel1);
            });
        }
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf((CompletableFuture[])p_250646_.values().stream().map(AtlasSet.StitchResult::readyForUpload).toArray(CompletableFuture[]::new));
        p_252136_.pop();
        return new ReloadState(p_248945_, p_363498_, bakedmodel, map1, p_250646_, completablefuture);
    }

    private static Object2IntMap<BlockState> buildModelGroups(BlockColors p_362057_, BlockStateModelLoader.LoadedModels p_362559_) {
        return ModelGroupCollector.build((BlockColors)p_362057_, (BlockStateModelLoader.LoadedModels)p_362559_);
    }

    private void apply(ReloadState p_248996_, ProfilerFiller p_251960_) {
        p_251960_.push("upload");
        p_248996_.atlasPreparations.values().forEach(AtlasSet.StitchResult::upload);
        ModelBakery modelbakery = p_248996_.modelBakery;
        this.bakedRegistry = modelbakery.getBakedTopLevelModels();
        this.modelGroups = p_248996_.modelGroups;
        this.missingModel = p_248996_.missingModel;
        this.modelBakery = modelbakery;
        ClientHooks.onModelBake((ModelManager)this, this.bakedRegistry, (ModelBakery)modelbakery);
        p_251960_.popPush("cache");
        this.blockModelShaper.replaceCache(p_248996_.modelCache);
        p_251960_.pop();
    }

    public boolean requiresRender(BlockState p_119416_, BlockState p_119417_) {
        int j;
        if (p_119416_ == p_119417_) {
            return false;
        }
        int i = this.modelGroups.getInt((Object)p_119416_);
        if (i != -1 && i == (j = this.modelGroups.getInt((Object)p_119417_))) {
            FluidState fluidstate1;
            FluidState fluidstate = p_119416_.getFluidState();
            return fluidstate != (fluidstate1 = p_119417_.getFluidState());
        }
        return true;
    }

    public TextureAtlas getAtlas(ResourceLocation p_119429_) {
        if (this.atlases == null) {
            throw new RuntimeException("getAtlasTexture called too early!");
        }
        return this.atlases.getAtlas(p_119429_);
    }

    @Override
    public void close() {
        this.atlases.close();
    }

    public void updateMaxMipLevel(int p_119411_) {
        this.maxMipmapLevels = p_119411_;
    }

    public ModelBakery getModelBakery() {
        return (ModelBakery)Preconditions.checkNotNull((Object)this.modelBakery, (Object)"Attempted to query model bakery before it has been initialized.");
    }

    private static /* synthetic */ TextureAtlasSprite lambda$loadModels$16(Map p_250646_, Multimap multimap, ModelResourceLocation p_352403_, Material p_251262_) {
        AtlasSet.StitchResult atlasset$stitchresult = (AtlasSet.StitchResult)p_250646_.get(p_251262_.atlasLocation());
        TextureAtlasSprite textureatlassprite = atlasset$stitchresult.getSprite(p_251262_.texture());
        if (textureatlassprite != null) {
            return textureatlassprite;
        }
        multimap.put((Object)p_352403_, (Object)p_251262_);
        return atlasset$stitchresult.missing();
    }

    private /* synthetic */ ReloadState lambda$reload$4(Map map, CompletableFuture completablefuture2, CompletableFuture completablefuture3, UnbakedModel unbakedmodel, Void p_372565_) {
        Map<ResourceLocation, AtlasSet.StitchResult> map1 = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p_248988_ -> (AtlasSet.StitchResult)((CompletableFuture)p_248988_.getValue()).join()));
        ModelDiscovery modeldiscovery = (ModelDiscovery)completablefuture2.join();
        Object2IntMap object2intmap = (Object2IntMap)completablefuture3.join();
        return this.loadModels(Profiler.get(), map1, new ModelBakery(modeldiscovery.getTopModels(), modeldiscovery.getReferencedModels(), unbakedmodel), (Object2IntMap<BlockState>)object2intmap);
    }

    @OnlyIn(value=Dist.CLIENT)
    record ReloadState(ModelBakery modelBakery, Object2IntMap<BlockState> modelGroups, BakedModel missingModel, Map<BlockState, BakedModel> modelCache, Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations, CompletableFuture<Void> readyForUpload) {
    }
}

