/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record ModelResourceLocation(ResourceLocation id, String variant) {
    public static final String INVENTORY_VARIANT = "inventory";
    public static final String STANDALONE_VARIANT = "standalone";

    public ModelResourceLocation {
        variant = ModelResourceLocation.lowercaseVariant(variant);
    }

    public static ModelResourceLocation inventory(ResourceLocation p_352141_) {
        return new ModelResourceLocation(p_352141_, INVENTORY_VARIANT);
    }

    public static ModelResourceLocation standalone(ResourceLocation id) {
        return new ModelResourceLocation(id, STANDALONE_VARIANT);
    }

    private static String lowercaseVariant(String p_248567_) {
        return p_248567_.toLowerCase(Locale.ROOT);
    }

    public String getVariant() {
        return this.variant;
    }

    @Override
    public String toString() {
        return String.valueOf(this.id) + "#" + this.variant;
    }
}

