/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class SimpleBakedModel
implements BakedModel {
    protected final List<BakedQuad> unculledFaces;
    protected final Map<Direction, List<BakedQuad>> culledFaces;
    protected final boolean hasAmbientOcclusion;
    protected final boolean isGui3d;
    protected final boolean usesBlockLight;
    protected final TextureAtlasSprite particleIcon;
    protected final ItemTransforms transforms;
    @Nullable
    protected final ChunkRenderTypeSet blockRenderTypes;
    @Nullable
    protected final List<RenderType> itemRenderTypes;

    @Deprecated
    public SimpleBakedModel(List<BakedQuad> p_119489_, Map<Direction, List<BakedQuad>> p_119490_, boolean p_119491_, boolean p_119492_, boolean p_119493_, TextureAtlasSprite p_119494_, ItemTransforms p_119495_) {
        this(p_119489_, p_119490_, p_119491_, p_119492_, p_119493_, p_119494_, p_119495_, RenderTypeGroup.EMPTY);
    }

    public SimpleBakedModel(List<BakedQuad> p_119489_, Map<Direction, List<BakedQuad>> p_119490_, boolean p_119491_, boolean p_119492_, boolean p_119493_, TextureAtlasSprite p_119494_, ItemTransforms p_119495_, RenderTypeGroup renderTypes) {
        this.unculledFaces = p_119489_;
        this.culledFaces = p_119490_;
        this.hasAmbientOcclusion = p_119491_;
        this.isGui3d = p_119493_;
        this.usesBlockLight = p_119492_;
        this.particleIcon = p_119494_;
        this.transforms = p_119495_;
        this.blockRenderTypes = !renderTypes.isEmpty() ? ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderTypes.block()}) : null;
        this.itemRenderTypes = !renderTypes.isEmpty() ? List.of(renderTypes.entity()) : null;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState p_235054_, @Nullable Direction p_235055_, RandomSource p_235056_) {
        return p_235055_ == null ? this.unculledFaces : this.culledFaces.get(p_235055_);
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.hasAmbientOcclusion;
    }

    @Override
    public boolean isGui3d() {
        return this.isGui3d;
    }

    @Override
    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    @Override
    public boolean isCustomRenderer() {
        return false;
    }

    @Override
    public TextureAtlasSprite getParticleIcon() {
        return this.particleIcon;
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        if (this.blockRenderTypes != null) {
            return this.blockRenderTypes;
        }
        return BakedModel.super.getRenderTypes(state, rand, data);
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack) {
        if (this.itemRenderTypes != null) {
            return this.itemRenderTypes;
        }
        return BakedModel.super.getRenderTypes(itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final ImmutableList.Builder<BakedQuad> unculledFaces = ImmutableList.builder();
        private final EnumMap<Direction, ImmutableList.Builder<BakedQuad>> culledFaces = Maps.newEnumMap(Direction.class);
        private final boolean hasAmbientOcclusion;
        @Nullable
        private TextureAtlasSprite particleIcon;
        private final boolean usesBlockLight;
        private final boolean isGui3d;
        private final ItemTransforms transforms;

        public Builder(BlockModel p_371834_, boolean p_119521_) {
            this(p_371834_.hasAmbientOcclusion(), p_371834_.getGuiLight().lightLikeBlock(), p_119521_, p_371834_.getTransforms());
        }

        public Builder(boolean p_119519_, boolean p_371851_, boolean p_371825_, ItemTransforms p_371619_) {
            this.hasAmbientOcclusion = p_119519_;
            this.usesBlockLight = p_371851_;
            this.isGui3d = p_371825_;
            this.transforms = p_371619_;
            for (Direction direction : Direction.values()) {
                this.culledFaces.put(direction, (ImmutableList.Builder<BakedQuad>)ImmutableList.builder());
            }
        }

        public Builder addCulledFace(Direction p_119531_, BakedQuad p_119532_) {
            this.culledFaces.get(p_119531_).add((Object)p_119532_);
            return this;
        }

        public Builder addUnculledFace(BakedQuad p_119527_) {
            this.unculledFaces.add((Object)p_119527_);
            return this;
        }

        public Builder particle(TextureAtlasSprite p_119529_) {
            this.particleIcon = p_119529_;
            return this;
        }

        public Builder item() {
            return this;
        }

        @Deprecated
        public BakedModel build() {
            return this.build(RenderTypeGroup.EMPTY);
        }

        public BakedModel build(RenderTypeGroup renderTypes) {
            if (this.particleIcon == null) {
                throw new RuntimeException("Missing particle!");
            }
            Map map = Maps.transformValues(this.culledFaces, ImmutableList.Builder::build);
            return new SimpleBakedModel((List<BakedQuad>)this.unculledFaces.build(), new EnumMap<Direction, List<BakedQuad>>(map), this.hasAmbientOcclusion, this.usesBlockLight, this.isGui3d, this.particleIcon, this.transforms, renderTypes);
        }
    }
}

