/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class ResourceKeyArgument<T>
implements ArgumentType<ResourceKey<T>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_INVALID_FEATURE = new DynamicCommandExceptionType(p_304101_ -> Component.translatableEscape((String)"commands.place.feature.invalid", (Object[])new Object[]{p_304101_}));
    private static final DynamicCommandExceptionType ERROR_INVALID_STRUCTURE = new DynamicCommandExceptionType(p_304100_ -> Component.translatableEscape((String)"commands.place.structure.invalid", (Object[])new Object[]{p_304100_}));
    private static final DynamicCommandExceptionType ERROR_INVALID_TEMPLATE_POOL = new DynamicCommandExceptionType(p_304102_ -> Component.translatableEscape((String)"commands.place.jigsaw.invalid", (Object[])new Object[]{p_304102_}));
    private static final DynamicCommandExceptionType ERROR_INVALID_RECIPE = new DynamicCommandExceptionType(p_378839_ -> Component.translatableEscape((String)"recipe.notFound", (Object[])new Object[]{p_378839_}));
    private static final DynamicCommandExceptionType ERROR_INVALID_ADVANCEMENT = new DynamicCommandExceptionType(p_378835_ -> Component.translatableEscape((String)"advancement.advancementNotFound", (Object[])new Object[]{p_378835_}));
    private static final SimpleCommandExceptionType ERROR_NO_RECIPES_ON_CLIENT = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.neoforge.vanilla.resource_key.no_recipes_on_client"));
    final ResourceKey<? extends Registry<T>> registryKey;

    public ResourceKeyArgument(ResourceKey<? extends Registry<T>> p_212367_) {
        this.registryKey = p_212367_;
    }

    public static <T> ResourceKeyArgument<T> key(ResourceKey<? extends Registry<T>> p_212387_) {
        return new ResourceKeyArgument<T>(p_212387_);
    }

    private static <T> ResourceKey<T> getRegistryKey(CommandContext<CommandSourceStack> p_212374_, String p_212375_, ResourceKey<Registry<T>> p_212376_, DynamicCommandExceptionType p_212377_) throws CommandSyntaxException {
        ResourceKey resourcekey = (ResourceKey)p_212374_.getArgument(p_212375_, ResourceKey.class);
        Optional<ResourceKey<T>> optional = resourcekey.cast(p_212376_);
        return optional.orElseThrow(() -> p_212377_.create((Object)resourcekey.location()));
    }

    private static <T> Registry<T> getRegistry(CommandContext<CommandSourceStack> p_212379_, ResourceKey<? extends Registry<T>> p_212380_) {
        return ((CommandSourceStack)p_212379_.getSource()).getServer().registryAccess().lookupOrThrow(p_212380_);
    }

    private static <T> Holder.Reference<T> resolveKey(CommandContext<CommandSourceStack> p_248662_, String p_252172_, ResourceKey<Registry<T>> p_249701_, DynamicCommandExceptionType p_249790_) throws CommandSyntaxException {
        ResourceKey resourcekey = ResourceKeyArgument.getRegistryKey(p_248662_, p_252172_, p_249701_, p_249790_);
        return (Holder.Reference)ResourceKeyArgument.getRegistry(p_248662_, p_249701_).get(resourcekey).orElseThrow(() -> p_249790_.create((Object)resourcekey.location()));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> getConfiguredFeature(CommandContext<CommandSourceStack> p_249310_, String p_250729_) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(p_249310_, p_250729_, Registries.CONFIGURED_FEATURE, ERROR_INVALID_FEATURE);
    }

    public static Holder.Reference<Structure> getStructure(CommandContext<CommandSourceStack> p_248804_, String p_251331_) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(p_248804_, p_251331_, Registries.STRUCTURE, ERROR_INVALID_STRUCTURE);
    }

    public static Holder.Reference<StructureTemplatePool> getStructureTemplatePool(CommandContext<CommandSourceStack> p_252203_, String p_250407_) throws CommandSyntaxException {
        return ResourceKeyArgument.resolveKey(p_252203_, p_250407_, Registries.TEMPLATE_POOL, ERROR_INVALID_TEMPLATE_POOL);
    }

    public static RecipeHolder<?> getRecipe(CommandContext<CommandSourceStack> p_380134_, String p_379840_) throws CommandSyntaxException {
        if (((CommandSourceStack)p_380134_.getSource()).getUnsidedLevel().isClientSide()) {
            throw ERROR_NO_RECIPES_ON_CLIENT.create();
        }
        RecipeManager recipemanager = ((CommandSourceStack)p_380134_.getSource()).getServer().getRecipeManager();
        ResourceKey<Recipe<?>> resourcekey = ResourceKeyArgument.getRegistryKey(p_380134_, p_379840_, Registries.RECIPE, ERROR_INVALID_RECIPE);
        return recipemanager.byKey(resourcekey).orElseThrow(() -> ERROR_INVALID_RECIPE.create((Object)resourcekey.location()));
    }

    public static AdvancementHolder getAdvancement(CommandContext<CommandSourceStack> p_379729_, String p_379326_) throws CommandSyntaxException {
        ResourceKey resourcekey = ResourceKeyArgument.getRegistryKey(p_379729_, p_379326_, Registries.ADVANCEMENT, ERROR_INVALID_ADVANCEMENT);
        AdvancementHolder advancementholder = ((CommandSourceStack)p_379729_.getSource()).getAdvancement(resourcekey.location());
        if (advancementholder == null) {
            throw ERROR_INVALID_ADVANCEMENT.create((Object)resourcekey.location());
        }
        return advancementholder;
    }

    public ResourceKey<T> parse(StringReader p_212369_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocation.read(p_212369_);
        return ResourceKey.create(this.registryKey, resourcelocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_212399_, SuggestionsBuilder p_212400_) {
        CompletableFuture completableFuture;
        Object object = p_212399_.getSource();
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider sharedsuggestionprovider = (SharedSuggestionProvider)object;
            completableFuture = sharedsuggestionprovider.suggestRegistryElements(this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ELEMENTS, p_212400_, p_212399_);
        } else {
            completableFuture = p_212400_.buildFuture();
        }
        return completableFuture;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Info<T>
    implements ArgumentTypeInfo<ResourceKeyArgument<T>, Template> {
        public void serializeToNetwork(Template p_233278_, FriendlyByteBuf p_233279_) {
            p_233279_.writeResourceKey(p_233278_.registryKey);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf p_233289_) {
            return new Template(p_233289_.readRegistryKey());
        }

        public void serializeToJson(Template p_233275_, JsonObject p_233276_) {
            p_233276_.addProperty("registry", p_233275_.registryKey.location().toString());
        }

        public Template unpack(ResourceKeyArgument<T> p_233281_) {
            return new Template(p_233281_.registryKey);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ResourceKeyArgument<T>> {
            final ResourceKey<? extends Registry<T>> registryKey;

            Template(ResourceKey<? extends Registry<T>> p_233296_) {
                this.registryKey = p_233296_;
            }

            public ResourceKeyArgument<T> instantiate(CommandBuildContext p_233299_) {
                return new ResourceKeyArgument(this.registryKey);
            }

            public ArgumentTypeInfo<ResourceKeyArgument<T>, ?> type() {
                return Info.this;
            }
        }
    }
}

