/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestClassNameArgument;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.gametest.framework.TestFunctionFinder;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class TestCommand {
    public static final int STRUCTURE_BLOCK_NEARBY_SEARCH_RADIUS = 15;
    public static final int STRUCTURE_BLOCK_FULL_SEARCH_RADIUS = 200;
    public static final int VERIFY_TEST_GRID_AXIS_SIZE = 10;
    public static final int VERIFY_TEST_BATCH_SIZE = 100;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_CLEAR_RADIUS = 200;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int SHOW_POS_DURATION_MS = 10000;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;
    private static final String STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND = "Structure block entity could not be found";
    private static final TestFinder.Builder<Runner> testFinder = new TestFinder.Builder(Runner::new);

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> p_320965_, Function<CommandContext<CommandSourceStack>, Runner> p_320702_, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> p_320600_) {
        return p_320965_.executes(p_319508_ -> ((Runner)p_320702_.apply(p_319508_)).run()).then(((RequiredArgumentBuilder)Commands.argument("numberOfTimes", IntegerArgumentType.integer((int)0)).executes(p_319503_ -> ((Runner)p_320702_.apply(p_319503_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319503_, (String)"numberOfTimes"), false)))).then(p_320600_.apply(Commands.argument("untilFailed", BoolArgumentType.bool()).executes(p_319489_ -> ((Runner)p_320702_.apply(p_319489_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319489_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_319489_, (String)"untilFailed")))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> p_320397_, Function<CommandContext<CommandSourceStack>, Runner> p_320472_) {
        return TestCommand.runWithRetryOptions(p_320397_, p_320472_, p_319485_ -> p_319485_);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptionsAndBuildInfo(ArgumentBuilder<CommandSourceStack, ?> p_320872_, Function<CommandContext<CommandSourceStack>, Runner> p_320896_) {
        return TestCommand.runWithRetryOptions(p_320872_, p_320896_, p_319482_ -> p_319482_.then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(p_319487_ -> ((Runner)p_320896_.apply(p_319487_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319487_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_319487_, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)p_319487_, (String)"rotationSteps")))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes(p_319484_ -> ((Runner)p_320896_.apply(p_319484_)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)p_319484_, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)p_319484_, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)p_319484_, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)p_319484_, (String)"testsPerRow"))))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> p_127947_) {
        ArgumentBuilder<CommandSourceStack, ?> argumentbuilder = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("onlyRequiredTests", BoolArgumentType.bool()), p_319498_ -> (Runner)testFinder.failedTests(p_319498_, BoolArgumentType.getBool((CommandContext)p_319498_, (String)"onlyRequiredTests")));
        ArgumentBuilder<CommandSourceStack, ?> argumentbuilder1 = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("testClassName", TestClassNameArgument.testClassName()), p_319490_ -> (Runner)testFinder.allTestsInClass(p_319490_, TestClassNameArgument.getTestClassName((CommandContext)p_319490_, (String)"testClassName")));
        p_127947_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("test").then(Commands.literal("run").then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()), p_319494_ -> (Runner)testFinder.byArgument(p_319494_, "testName"))))).then(Commands.literal("runmultiple").then(((RequiredArgumentBuilder)Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes(p_329852_ -> ((Runner)testFinder.byArgument(p_329852_, "testName")).run())).then(Commands.argument("amount", IntegerArgumentType.integer()).executes(p_329853_ -> ((Runner)testFinder.createMultipleCopies(IntegerArgumentType.getInteger((CommandContext)p_329853_, (String)"amount")).byArgument(p_329853_, "testName")).run()))))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runall").then(argumentbuilder1), arg_0 -> testFinder.allTests(arg_0)))).then(TestCommand.runWithRetryOptions(Commands.literal("runthese"), arg_0 -> testFinder.allNearby(arg_0)))).then(TestCommand.runWithRetryOptions(Commands.literal("runclosest"), arg_0 -> testFinder.nearest(arg_0)))).then(TestCommand.runWithRetryOptions(Commands.literal("runthat"), arg_0 -> testFinder.lookedAt(arg_0)))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runfailed").then(argumentbuilder), arg_0 -> testFinder.failedTests(arg_0)))).then(Commands.literal("verify").then(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes(p_351716_ -> ((Runner)testFinder.byArgument(p_351716_, "testName")).verify())))).then(Commands.literal("verifyclass").then(Commands.argument("testClassName", TestClassNameArgument.testClassName()).executes(p_351715_ -> ((Runner)testFinder.allTestsInClass(p_351715_, TestClassNameArgument.getTestClassName((CommandContext)p_351715_, (String)"testClassName"))).verify())))).then(Commands.literal("locate").then(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes(p_340631_ -> ((Runner)testFinder.locateByName(p_340631_, "minecraft:" + TestFunctionArgument.getTestFunction((CommandContext)p_340631_, (String)"testName").structureName())).locate())))).then(Commands.literal("resetclosest").executes(p_319479_ -> ((Runner)testFinder.nearest(p_319479_)).reset()))).then(Commands.literal("resetthese").executes(p_319492_ -> ((Runner)testFinder.allNearby(p_319492_)).reset()))).then(Commands.literal("resetthat").executes(p_319478_ -> ((Runner)testFinder.lookedAt(p_319478_)).reset()))).then(Commands.literal("export").then(Commands.argument("testName", StringArgumentType.word()).executes(p_319491_ -> TestCommand.exportTestStructure((CommandSourceStack)p_319491_.getSource(), "minecraft:" + StringArgumentType.getString((CommandContext)p_319491_, (String)"testName")))))).then(Commands.literal("exportclosest").executes(p_319480_ -> ((Runner)testFinder.nearest(p_319480_)).export()))).then(Commands.literal("exportthese").executes(p_319505_ -> ((Runner)testFinder.allNearby(p_319505_)).export()))).then(Commands.literal("exportthat").executes(p_319514_ -> ((Runner)testFinder.lookedAt(p_319514_)).export()))).then(Commands.literal("clearthat").executes(p_319506_ -> ((Runner)testFinder.lookedAt(p_319506_)).clear()))).then(Commands.literal("clearthese").executes(p_319504_ -> ((Runner)testFinder.allNearby(p_319504_)).clear()))).then(((LiteralArgumentBuilder)Commands.literal("clearall").executes(p_319509_ -> ((Runner)testFinder.radius(p_319509_, 200)).clear())).then(Commands.argument("radius", IntegerArgumentType.integer()).executes(p_319493_ -> ((Runner)testFinder.radius(p_319493_, Mth.clamp((int)IntegerArgumentType.getInteger((CommandContext)p_319493_, (String)"radius"), (int)0, (int)1024))).clear())))).then(Commands.literal("import").then(Commands.argument("testName", StringArgumentType.word()).executes(p_128025_ -> TestCommand.importTestStructure((CommandSourceStack)p_128025_.getSource(), StringArgumentType.getString((CommandContext)p_128025_, (String)"testName")))))).then(Commands.literal("stop").executes(p_319497_ -> TestCommand.stopTests()))).then(((LiteralArgumentBuilder)Commands.literal("pos").executes(p_128023_ -> TestCommand.showPos((CommandSourceStack)p_128023_.getSource(), "pos"))).then(Commands.argument("var", StringArgumentType.word()).executes(p_128021_ -> TestCommand.showPos((CommandSourceStack)p_128021_.getSource(), StringArgumentType.getString((CommandContext)p_128021_, (String)"var")))))).then(Commands.literal("create").then(((RequiredArgumentBuilder)Commands.argument("testName", StringArgumentType.word()).suggests(TestFunctionArgument::suggestTestFunction).executes(p_128019_ -> TestCommand.createNewStructure((CommandSourceStack)p_128019_.getSource(), StringArgumentType.getString((CommandContext)p_128019_, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)Commands.argument("width", IntegerArgumentType.integer()).executes(p_128014_ -> TestCommand.createNewStructure((CommandSourceStack)p_128014_.getSource(), StringArgumentType.getString((CommandContext)p_128014_, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width")))).then(Commands.argument("height", IntegerArgumentType.integer()).then(Commands.argument("depth", IntegerArgumentType.integer()).executes(p_128007_ -> TestCommand.createNewStructure((CommandSourceStack)p_128007_.getSource(), StringArgumentType.getString((CommandContext)p_128007_, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"height"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"depth")))))))));
    }

    private static int resetGameTestInfo(GameTestInfo p_320507_) {
        p_320507_.getLevel().getEntities(null, p_320507_.getStructureBounds()).stream().forEach(p_326748_ -> p_326748_.remove(Entity.RemovalReason.DISCARDED));
        p_320507_.getStructureBlockEntity().placeStructure(p_320507_.getLevel());
        StructureUtils.removeBarriers((AABB)p_320507_.getStructureBounds(), (ServerLevel)p_320507_.getLevel());
        TestCommand.say(p_320507_.getLevel(), "Reset succeded for: " + p_320507_.getTestName(), ChatFormatting.GREEN);
        return 1;
    }

    static Stream<GameTestInfo> toGameTestInfos(CommandSourceStack p_320827_, RetryOptions p_320932_, StructureBlockPosFinder p_320543_) {
        return p_320543_.findStructureBlockPos().map(p_319501_ -> TestCommand.createGameTestInfo(p_319501_, p_320827_.getLevel(), p_320932_)).flatMap(Optional::stream);
    }

    static Stream<GameTestInfo> toGameTestInfo(CommandSourceStack p_320465_, RetryOptions p_320183_, TestFunctionFinder p_320598_, int p_320854_) {
        return p_320598_.findTestFunctions().filter(p_319496_ -> TestCommand.verifyStructureExists(p_320465_.getLevel(), p_319496_.structureName())).map(p_319513_ -> new GameTestInfo((TestFunction)p_319513_, StructureUtils.getRotationForRotationSteps((int)p_320854_), p_320465_.getLevel(), p_320183_));
    }

    private static Optional<GameTestInfo> createGameTestInfo(BlockPos p_320172_, ServerLevel p_320346_, RetryOptions p_320822_) {
        StructureBlockEntity structureblockentity = (StructureBlockEntity)p_320346_.getBlockEntity(p_320172_);
        if (structureblockentity == null) {
            TestCommand.say(p_320346_, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
            return Optional.empty();
        }
        String s = structureblockentity.getMetaData();
        Optional<TestFunction> optional = GameTestRegistry.findTestFunction(s);
        if (optional.isEmpty()) {
            TestCommand.say(p_320346_, "Test function for test " + s + " could not be found", ChatFormatting.RED);
            return Optional.empty();
        }
        TestFunction testfunction = optional.get();
        GameTestInfo gametestinfo = new GameTestInfo(testfunction, structureblockentity.getRotation(), p_320346_, p_320822_);
        gametestinfo.setStructureBlockPos(p_320172_);
        return !TestCommand.verifyStructureExists(p_320346_, gametestinfo.getStructureName()) ? Optional.empty() : Optional.of(gametestinfo);
    }

    private static int createNewStructure(CommandSourceStack p_127968_, String p_127969_, int p_127970_, int p_127971_, int p_127972_) {
        if (p_127970_ <= 48 && p_127971_ <= 48 && p_127972_ <= 48) {
            ServerLevel serverlevel = p_127968_.getLevel();
            BlockPos blockpos = TestCommand.createTestPositionAround(p_127968_).below();
            StructureUtils.createNewEmptyStructureBlock((String)p_127969_.toLowerCase(), (BlockPos)blockpos, (Vec3i)new Vec3i(p_127970_, p_127971_, p_127972_), (Rotation)Rotation.NONE, (ServerLevel)serverlevel);
            BlockPos blockpos1 = blockpos.above();
            BlockPos blockpos2 = blockpos1.offset(p_127970_ - 1, 0, p_127972_ - 1);
            BlockPos.betweenClosedStream((BlockPos)blockpos1, (BlockPos)blockpos2).forEach(p_326747_ -> serverlevel.setBlockAndUpdate((BlockPos)p_326747_, Blocks.BEDROCK.defaultBlockState()));
            StructureUtils.addCommandBlockAndButtonToStartTest((BlockPos)blockpos, (BlockPos)new BlockPos(1, 0, -1), (Rotation)Rotation.NONE, (ServerLevel)serverlevel);
            return 0;
        }
        throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
    }

    private static int showPos(CommandSourceStack p_127960_, String p_127961_) throws CommandSyntaxException {
        ServerLevel serverlevel;
        BlockHitResult blockhitresult = (BlockHitResult)p_127960_.getPlayerOrException().pick(10.0, 1.0f, false);
        BlockPos blockpos = blockhitresult.getBlockPos();
        Optional optional = StructureUtils.findStructureBlockContainingPos((BlockPos)blockpos, (int)15, (ServerLevel)(serverlevel = p_127960_.getLevel()));
        if (optional.isEmpty()) {
            optional = StructureUtils.findStructureBlockContainingPos((BlockPos)blockpos, (int)200, (ServerLevel)serverlevel);
        }
        if (optional.isEmpty()) {
            p_127960_.sendFailure((Component)Component.literal((String)("Can't find a structure block that contains the targeted pos " + String.valueOf(blockpos))));
            return 0;
        }
        StructureBlockEntity structureblockentity = (StructureBlockEntity)serverlevel.getBlockEntity((BlockPos)optional.get());
        if (structureblockentity == null) {
            TestCommand.say(serverlevel, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
            return 0;
        }
        BlockPos blockpos1 = blockpos.subtract((Vec3i)optional.get());
        String s = blockpos1.getX() + ", " + blockpos1.getY() + ", " + blockpos1.getZ();
        String s1 = structureblockentity.getMetaData().isBlank() ? structureblockentity.getStructureName() : structureblockentity.getMetaData();
        MutableComponent component = Component.literal((String)s).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy to clipboard"))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, "final BlockPos " + p_127961_ + " = new BlockPos(" + s + ");")));
        p_127960_.sendSuccess(() -> TestCommand.lambda$showPos$38(s1, (Component)component), false);
        DebugPackets.sendGameTestAddMarker((ServerLevel)serverlevel, (BlockPos)new BlockPos((Vec3i)blockpos), (String)s, (int)-2147418368, (int)10000);
        return 1;
    }

    static int stopTests() {
        GameTestTicker.SINGLETON.clear();
        return 1;
    }

    static int trackAndStartRunner(CommandSourceStack p_320627_, ServerLevel p_320564_, GameTestRunner p_320295_) {
        p_320295_.addListener((GameTestBatchListener)new TestBatchSummaryDisplayer(p_320627_));
        MultipleTestTracker multipletesttracker = new MultipleTestTracker((Collection)p_320295_.getTestInfos());
        multipletesttracker.addListener((GameTestListener)new TestSummaryDisplayer(p_320564_, multipletesttracker));
        multipletesttracker.addFailureListener(p_127992_ -> GameTestRegistry.rememberFailedTest(p_127992_.getTestFunction()));
        p_320295_.start();
        return 1;
    }

    static int saveAndExportTestStructure(CommandSourceStack p_309558_, StructureBlockEntity p_309587_) {
        String s = p_309587_.getStructureName();
        if (!p_309587_.saveStructure(true)) {
            TestCommand.say(p_309558_, "Failed to save structure " + s);
        }
        return TestCommand.exportTestStructure(p_309558_, s);
    }

    private static int exportTestStructure(CommandSourceStack p_128011_, String p_128012_) {
        Path path = Paths.get(StructureUtils.testStructuresDir, new String[0]);
        ResourceLocation resourcelocation = ResourceLocation.parse(p_128012_);
        Path path1 = p_128011_.getLevel().getStructureManager().createAndValidatePathToGeneratedStructure(resourcelocation, ".nbt");
        Path path2 = NbtToSnbt.convertStructure((CachedOutput)CachedOutput.NO_CACHE, (Path)path1, (String)resourcelocation.getPath(), (Path)path);
        if (path2 == null) {
            TestCommand.say(p_128011_, "Failed to export " + String.valueOf(path1));
            return 1;
        }
        try {
            FileUtil.createDirectoriesSafe(path2.getParent());
        }
        catch (IOException ioexception) {
            TestCommand.say(p_128011_, "Could not create folder " + String.valueOf(path2.getParent()));
            LOGGER.error("Could not create export folder", (Throwable)ioexception);
            return 1;
        }
        TestCommand.say(p_128011_, "Exported " + p_128012_ + " to " + String.valueOf(path2.toAbsolutePath()));
        return 0;
    }

    private static boolean verifyStructureExists(ServerLevel p_309700_, String p_320698_) {
        if (p_309700_.getStructureManager().get(ResourceLocation.parse(p_320698_)).isEmpty()) {
            TestCommand.say(p_309700_, "Test structure " + p_320698_ + " could not be found", ChatFormatting.RED);
            return false;
        }
        return true;
    }

    static BlockPos createTestPositionAround(CommandSourceStack p_308921_) {
        BlockPos blockpos = BlockPos.containing((Position)p_308921_.getPosition());
        int i = p_308921_.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, blockpos).getY();
        return new BlockPos(blockpos.getX(), i + 1, blockpos.getZ() + 3);
    }

    static void say(CommandSourceStack p_128004_, String p_128005_) {
        p_128004_.sendSuccess(() -> Component.literal((String)p_128005_), false);
    }

    private static int importTestStructure(CommandSourceStack p_128016_, String p_128017_) {
        Path path = Paths.get(StructureUtils.testStructuresDir, p_128017_ + ".snbt");
        ResourceLocation resourcelocation = ResourceLocation.withDefaultNamespace(p_128017_);
        Path path1 = p_128016_.getLevel().getStructureManager().createAndValidatePathToGeneratedStructure(resourcelocation, ".nbt");
        try {
            BufferedReader bufferedreader = Files.newBufferedReader(path);
            String s = IOUtils.toString((Reader)bufferedreader);
            Files.createDirectories(path1.getParent(), new FileAttribute[0]);
            try (OutputStream outputstream = Files.newOutputStream(path1, new OpenOption[0]);){
                NbtIo.writeCompressed(NbtUtils.snbtToStructure((String)s), outputstream);
            }
            p_128016_.getLevel().getStructureManager().remove(resourcelocation);
            TestCommand.say(p_128016_, "Imported to " + String.valueOf(path1.toAbsolutePath()));
            return 0;
        }
        catch (CommandSyntaxException | IOException ioexception) {
            LOGGER.error("Failed to load structure {}", (Object)p_128017_, (Object)ioexception);
            return 1;
        }
    }

    static void say(ServerLevel p_127934_, String p_127935_, ChatFormatting p_127936_) {
        p_127934_.getPlayers(p_127945_ -> true).forEach(p_313469_ -> p_313469_.sendSystemMessage((Component)Component.literal((String)p_127935_).withStyle(p_127936_)));
    }

    private static /* synthetic */ Component lambda$showPos$38(String s1, Component component) {
        return Component.literal((String)("Position relative to " + s1 + ": ")).append(component);
    }

    record TestBatchSummaryDisplayer(CommandSourceStack source) implements GameTestBatchListener
    {
        public void testBatchStarting(GameTestBatch p_319827_) {
            TestCommand.say(this.source, "Starting batch: " + p_319827_.name());
        }

        public void testBatchFinished(GameTestBatch p_320779_) {
        }
    }

    public record TestSummaryDisplayer(ServerLevel level, MultipleTestTracker tracker) implements GameTestListener
    {
        public void testStructureLoaded(GameTestInfo p_128064_) {
        }

        public void testPassed(GameTestInfo p_177797_, GameTestRunner p_320726_) {
            TestSummaryDisplayer.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        public void testFailed(GameTestInfo p_128066_, GameTestRunner p_320567_) {
            TestSummaryDisplayer.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        public void testAddedForRerun(GameTestInfo p_319856_, GameTestInfo p_320528_, GameTestRunner p_319832_) {
            this.tracker.addTestToTrack(p_320528_);
        }

        private static void showTestSummaryIfAllDone(ServerLevel p_319899_, MultipleTestTracker p_320682_) {
            if (p_320682_.isDone()) {
                TestCommand.say(p_319899_, "GameTest done! " + p_320682_.getTotalCount() + " tests were run", ChatFormatting.WHITE);
                if (p_320682_.hasFailedRequired()) {
                    TestCommand.say(p_319899_, p_320682_.getFailedRequiredCount() + " required tests failed :(", ChatFormatting.RED);
                } else {
                    TestCommand.say(p_319899_, "All required tests passed :)", ChatFormatting.GREEN);
                }
                if (p_320682_.hasFailedOptional()) {
                    TestCommand.say(p_319899_, p_320682_.getFailedOptionalCount() + " optional tests failed", ChatFormatting.GRAY);
                }
            }
        }
    }

    public static class Runner {
        private final TestFinder<Runner> finder;

        public Runner(TestFinder<Runner> p_320723_) {
            this.finder = p_320723_;
        }

        public int reset() {
            TestCommand.stopTests();
            return TestCommand.toGameTestInfos(this.finder.source(), RetryOptions.noRetries(), this.finder).map(TestCommand::resetGameTestInfo).toList().isEmpty() ? 0 : 1;
        }

        private <T> void logAndRun(Stream<T> p_320016_, ToIntFunction<T> p_319791_, Runnable p_320766_, Consumer<Integer> p_320345_) {
            int i = p_320016_.mapToInt(p_319791_).sum();
            if (i == 0) {
                p_320766_.run();
            } else {
                p_320345_.accept(i);
            }
        }

        public int clear() {
            TestCommand.stopTests();
            CommandSourceStack commandsourcestack = this.finder.source();
            ServerLevel serverlevel = commandsourcestack.getLevel();
            GameTestRunner.clearMarkers((ServerLevel)serverlevel);
            this.logAndRun(this.finder.findStructureBlockPos(), p_320518_ -> {
                StructureBlockEntity structureblockentity = (StructureBlockEntity)serverlevel.getBlockEntity((BlockPos)p_320518_);
                if (structureblockentity == null) {
                    return 0;
                }
                BoundingBox boundingbox = StructureUtils.getStructureBoundingBox((StructureBlockEntity)structureblockentity);
                StructureUtils.clearSpaceForStructure((BoundingBox)boundingbox, (ServerLevel)serverlevel);
                return 1;
            }, () -> TestCommand.say(serverlevel, "Could not find any structures to clear", ChatFormatting.RED), p_320503_ -> TestCommand.say(commandsourcestack, "Cleared " + p_320503_ + " structures"));
            return 1;
        }

        public int export() {
            MutableBoolean mutableboolean = new MutableBoolean(true);
            CommandSourceStack commandsourcestack = this.finder.source();
            ServerLevel serverlevel = commandsourcestack.getLevel();
            this.logAndRun(this.finder.findStructureBlockPos(), p_320242_ -> {
                StructureBlockEntity structureblockentity = (StructureBlockEntity)serverlevel.getBlockEntity((BlockPos)p_320242_);
                if (structureblockentity == null) {
                    TestCommand.say(serverlevel, TestCommand.STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
                    mutableboolean.setFalse();
                    return 0;
                }
                if (TestCommand.saveAndExportTestStructure(commandsourcestack, structureblockentity) != 0) {
                    mutableboolean.setFalse();
                }
                return 1;
            }, () -> TestCommand.say(serverlevel, "Could not find any structures to export", ChatFormatting.RED), p_320666_ -> TestCommand.say(commandsourcestack, "Exported " + p_320666_ + " structures"));
            return mutableboolean.getValue() != false ? 0 : 1;
        }

        int verify() {
            TestCommand.stopTests();
            CommandSourceStack commandsourcestack = this.finder.source();
            ServerLevel serverlevel = commandsourcestack.getLevel();
            BlockPos blockpos = TestCommand.createTestPositionAround(commandsourcestack);
            List<GameTestInfo> collection = Stream.concat(TestCommand.toGameTestInfos(commandsourcestack, RetryOptions.noRetries(), this.finder), TestCommand.toGameTestInfo(commandsourcestack, RetryOptions.noRetries(), this.finder, 0)).toList();
            GameTestRunner.clearMarkers((ServerLevel)serverlevel);
            GameTestRegistry.forgetFailedTests();
            ArrayList<GameTestBatch> collection1 = new ArrayList<GameTestBatch>();
            for (GameTestInfo gametestinfo : collection) {
                for (Rotation rotation : Rotation.values()) {
                    ArrayList<GameTestInfo> collection2 = new ArrayList<GameTestInfo>();
                    for (int i = 0; i < 100; ++i) {
                        GameTestInfo gametestinfo1 = new GameTestInfo(gametestinfo.getTestFunction(), rotation, serverlevel, new RetryOptions(1, true));
                        collection2.add(gametestinfo1);
                    }
                    GameTestBatch gametestbatch = GameTestBatchFactory.toGameTestBatch(collection2, (String)gametestinfo.getTestFunction().batchName(), (long)rotation.ordinal());
                    collection1.add(gametestbatch);
                }
            }
            StructureGridSpawner structuregridspawner = new StructureGridSpawner(blockpos, 10, true);
            GameTestRunner gametestrunner = GameTestRunner.Builder.fromBatches(collection1, (ServerLevel)serverlevel).batcher(GameTestBatchFactory.fromGameTestInfo((int)100)).newStructureSpawner((GameTestRunner.StructureSpawner)structuregridspawner).existingStructureSpawner(structuregridspawner).haltOnError(true).build();
            return TestCommand.trackAndStartRunner(commandsourcestack, serverlevel, gametestrunner);
        }

        public int run(RetryOptions p_320091_, int p_320456_, int p_320467_) {
            TestCommand.stopTests();
            CommandSourceStack commandsourcestack = this.finder.source();
            ServerLevel serverlevel = commandsourcestack.getLevel();
            BlockPos blockpos = TestCommand.createTestPositionAround(commandsourcestack);
            List<GameTestInfo> collection = Stream.concat(TestCommand.toGameTestInfos(commandsourcestack, p_320091_, this.finder), TestCommand.toGameTestInfo(commandsourcestack, p_320091_, this.finder, p_320456_)).toList();
            if (collection.isEmpty()) {
                TestCommand.say(commandsourcestack, "No tests found");
                return 0;
            }
            GameTestRunner.clearMarkers((ServerLevel)serverlevel);
            GameTestRegistry.forgetFailedTests();
            TestCommand.say(commandsourcestack, "Running " + collection.size() + " tests...");
            GameTestRunner gametestrunner = GameTestRunner.Builder.fromInfo(collection, (ServerLevel)serverlevel).newStructureSpawner((GameTestRunner.StructureSpawner)new StructureGridSpawner(blockpos, p_320467_, false)).build();
            return TestCommand.trackAndStartRunner(commandsourcestack, serverlevel, gametestrunner);
        }

        public int run(int p_320306_, int p_320333_) {
            return this.run(RetryOptions.noRetries(), p_320306_, p_320333_);
        }

        public int run(int p_319859_) {
            return this.run(RetryOptions.noRetries(), p_319859_, 8);
        }

        public int run(RetryOptions p_320906_, int p_320419_) {
            return this.run(p_320906_, p_320419_, 8);
        }

        public int run(RetryOptions p_320034_) {
            return this.run(p_320034_, 0, 8);
        }

        public int run() {
            return this.run(RetryOptions.noRetries());
        }

        public int locate() {
            TestCommand.say(this.finder.source(), "Started locating test structures, this might take a while..");
            MutableInt mutableint = new MutableInt(0);
            BlockPos blockpos = BlockPos.containing((Position)this.finder.source().getPosition());
            this.finder.findStructureBlockPos().forEach(p_340637_ -> {
                StructureBlockEntity structureblockentity = (StructureBlockEntity)this.finder.source().getLevel().getBlockEntity((BlockPos)p_340637_);
                if (structureblockentity != null) {
                    Direction direction = structureblockentity.getRotation().rotate(Direction.NORTH);
                    BlockPos blockpos1 = structureblockentity.getBlockPos().relative(direction, 2);
                    int j = (int)direction.getOpposite().toYRot();
                    String s = String.format("/tp @s %d %d %d %d 0", blockpos1.getX(), blockpos1.getY(), blockpos1.getZ(), j);
                    int k = blockpos.getX() - p_340637_.getX();
                    int l = blockpos.getZ() - p_340637_.getZ();
                    int i1 = Mth.floor((float)Mth.sqrt((float)(k * k + l * l)));
                    MutableComponent component = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{p_340637_.getX(), p_340637_.getY(), p_340637_.getZ()})).withStyle(p_340633_ -> p_340633_.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, s)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
                    MutableComponent component1 = Component.literal((String)"Found structure at: ").append((Component)component).append(" (distance: " + i1 + ")");
                    this.finder.source().sendSuccess(() -> Runner.lambda$locate$7((Component)component1), false);
                    mutableint.increment();
                }
            });
            int i = mutableint.intValue();
            if (i == 0) {
                TestCommand.say(this.finder.source().getLevel(), "No such test structure found", ChatFormatting.RED);
                return 0;
            }
            TestCommand.say(this.finder.source().getLevel(), "Finished locating, found " + i + " structure(s)", ChatFormatting.GREEN);
            return 1;
        }

        private static /* synthetic */ Component lambda$locate$7(Component component1) {
            return component1;
        }
    }
}

