/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.server.DebugLoggedPrintStream;
import net.minecraft.server.LoggedPrintStream;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.GameData;
import org.slf4j.Logger;

public class Bootstrap {
    public static final PrintStream STDOUT = System.out;
    private static volatile boolean isBootstrapped;
    private static final Logger LOGGER;
    public static final AtomicLong bootstrapDuration;

    public static void bootStrap() {
        if (!isBootstrapped) {
            isBootstrapped = true;
            Instant instant = Instant.now();
            if (BuiltInRegistries.REGISTRY.keySet().isEmpty()) {
                throw new IllegalStateException("Unable to load registries");
            }
            FireBlock.bootStrap();
            ComposterBlock.bootStrap();
            if (EntityType.getKey(EntityType.PLAYER) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            EntitySelectorOptions.bootStrap();
            DispenseItemBehavior.bootStrap();
            CauldronInteraction.bootStrap();
            BuiltInRegistries.bootStrap();
            CreativeModeTabs.validate();
            GameData.vanillaSnapshot();
            bootstrapDuration.set(Duration.between(instant, Instant.now()).toMillis());
        }
    }

    private static <T> void checkTranslations(Iterable<T> p_135872_, Function<T, String> p_135873_, Set<String> p_135874_) {
        Language language = Language.getInstance();
        p_135872_.forEach(p_135883_ -> {
            String s = (String)p_135873_.apply(p_135883_);
            if (!language.has(s)) {
                p_135874_.add(s);
            }
        });
    }

    private static void checkGameruleTranslations(final Set<String> p_135878_) {
        final Language language = Language.getInstance();
        GameRules gamerules = new GameRules(FeatureFlags.REGISTRY.allFlags());
        gamerules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> p_135897_, GameRules.Type<T> p_135898_) {
                if (!language.has(p_135897_.getDescriptionId())) {
                    p_135878_.add(p_135897_.getId());
                }
            }
        });
    }

    public static Set<String> getMissingTranslations() {
        TreeSet<String> set = new TreeSet<String>();
        Bootstrap.checkTranslations(BuiltInRegistries.ATTRIBUTE, Attribute::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.ENTITY_TYPE, EntityType::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.MOB_EFFECT, MobEffect::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.ITEM, Item::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.BLOCK, BlockBehaviour::getDescriptionId, set);
        Bootstrap.checkTranslations(BuiltInRegistries.CUSTOM_STAT, p_135885_ -> "stat." + p_135885_.toString().replace(':', '.'), set);
        Bootstrap.checkGameruleTranslations(set);
        return set;
    }

    public static void checkBootstrapCalled(Supplier<String> p_179913_) {
        if (!isBootstrapped) {
            throw Bootstrap.createBootstrapException(p_179913_);
        }
    }

    private static RuntimeException createBootstrapException(Supplier<String> p_179917_) {
        try {
            String s = p_179917_.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + s + ")");
        }
        catch (Exception exception) {
            IllegalArgumentException runtimeexception = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            runtimeexception.addSuppressed(exception);
            return runtimeexception;
        }
    }

    public static void validate() {
        Bootstrap.checkBootstrapCalled(() -> "validate");
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            Bootstrap.getMissingTranslations().forEach(p_179915_ -> LOGGER.error("Missing translations: {}", p_179915_));
            Commands.validate();
        }
    }

    private static void wrapStreams() {
        if (LOGGER.isDebugEnabled()) {
            System.setErr((PrintStream)new DebugLoggedPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new DebugLoggedPrintStream("STDOUT", (OutputStream)STDOUT));
        } else {
            System.setErr((PrintStream)new LoggedPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new LoggedPrintStream("STDOUT", (OutputStream)STDOUT));
        }
    }

    public static void realStdoutPrintln(String p_135876_) {
        STDOUT.println(p_135876_);
    }

    static {
        LOGGER = LogUtils.getLogger();
        bootstrapDuration = new AtomicLong(-1L);
    }
}

