/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.neoforged.neoforge.gametest.BlockPosValueConverter;
import net.neoforged.neoforge.gametest.GameTestHooks;
import net.neoforged.neoforge.server.loading.ServerModLoader;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @DontObfuscate
    public static void main(String[] p_129699_) throws Exception {
        SharedConstants.tryDetectVersion();
        OptionParser optionparser = new OptionParser();
        OptionSpecBuilder optionspec = optionparser.accepts("nogui");
        OptionSpecBuilder optionspec1 = optionparser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder optionspec2 = optionparser.accepts("demo");
        OptionSpecBuilder optionspec3 = optionparser.accepts("bonusChest");
        OptionSpecBuilder optionspec4 = optionparser.accepts("forceUpgrade");
        OptionSpecBuilder optionspec5 = optionparser.accepts("eraseCache");
        OptionSpecBuilder optionspec6 = optionparser.accepts("recreateRegionFiles");
        OptionSpecBuilder optionspec7 = optionparser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec optionspec8 = optionparser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("serverId").withRequiredArg();
        OptionSpecBuilder optionspec13 = optionparser.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec optionspec14 = optionparser.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec optionspec15 = optionparser.nonOptions();
        optionparser.accepts("allowUpdates").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)Boolean.TRUE, (Object[])new Boolean[0]);
        optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        boolean gametestEnabled = Boolean.getBoolean("neoforge.gameTestServer");
        ArgumentAcceptingOptionSpec spawnPosOpt = gametestEnabled ? optionparser.accepts("spawnPos").withRequiredArg().withValuesConvertedBy((ValueConverter)new BlockPosValueConverter()).defaultsTo((Object)new BlockPos(0, 60, 0), (Object[])new BlockPos[0]) : null;
        try {
            WorldStem worldstem;
            Dynamic<?> dynamic;
            OptionSet optionset = optionparser.parse(p_129699_);
            if (optionset.has((OptionSpec)optionspec8)) {
                optionparser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path path2 = Paths.get("eula.txt", new String[0]);
            Eula eula = new Eula(path2);
            if (!eula.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            Path path = (Path)optionset.valueOf((OptionSpec)optionspec14);
            if (path != null) {
                Main.writePidFile(path);
            }
            CrashReport.preload();
            if (optionset.has((OptionSpec)optionspec13)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            Bootstrap.bootStrap();
            Bootstrap.validate();
            Util.startTimerHackThread();
            Path path1 = Paths.get("server.properties", new String[0]);
            if (!optionset.has((OptionSpec)optionspec1)) {
                ServerModLoader.load();
            }
            DedicatedServerSettings dedicatedserversettings = new DedicatedServerSettings(path1);
            dedicatedserversettings.forceSave();
            RegionFileVersion.configure((String)dedicatedserversettings.getProperties().regionFileComression);
            if (optionset.has((OptionSpec)optionspec1)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)path1.toAbsolutePath(), (Object)path2.toAbsolutePath());
                return;
            }
            File file1 = new File((String)optionset.valueOf((OptionSpec)optionspec9));
            Services services = Services.create((YggdrasilAuthenticationService)new YggdrasilAuthenticationService(Proxy.NO_PROXY), (File)file1);
            String s = Optional.ofNullable((String)optionset.valueOf((OptionSpec)optionspec10)).orElse(dedicatedserversettings.getProperties().levelName);
            if (s == null || s.isEmpty() || new File(file1, s).getAbsolutePath().equals(new File(s).getAbsolutePath())) {
                LOGGER.error("Invalid world directory specified, must not be null, empty or the same directory as your universe! " + s);
                return;
            }
            LevelStorageSource levelstoragesource = LevelStorageSource.createDefault(file1.toPath());
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.validateAndCreateAccess(s);
            if (levelstoragesource$levelstorageaccess.hasWorldData()) {
                LevelSummary levelsummary;
                try {
                    dynamic = levelstoragesource$levelstorageaccess.getDataTag();
                    levelsummary = levelstoragesource$levelstorageaccess.getSummary(dynamic);
                    levelstoragesource$levelstorageaccess.readAdditionalLevelSaveData(false);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception1) {
                    LevelStorageSource.LevelDirectory levelstoragesource$leveldirectory = levelstoragesource$levelstorageaccess.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)levelstoragesource$leveldirectory.dataFile(), (Object)ioexception1);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        dynamic = levelstoragesource$levelstorageaccess.getDataTagFallback();
                        levelsummary = levelstoragesource$levelstorageaccess.getSummary(dynamic);
                        levelstoragesource$levelstorageaccess.readAdditionalLevelSaveData(true);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception) {
                        LOGGER.error("Failed to load world data from {}", (Object)levelstoragesource$leveldirectory.oldDataFile(), (Object)ioexception);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelstoragesource$leveldirectory.dataFile(), (Object)levelstoragesource$leveldirectory.oldDataFile());
                        return;
                    }
                    levelstoragesource$levelstorageaccess.restoreLevelDataFromOld();
                }
                if (levelsummary.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!levelsummary.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            Dynamic<?> dynamic1 = dynamic;
            boolean flag = optionset.has((OptionSpec)optionspec7);
            if (flag) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository packrepository = ServerPacksSource.createPackRepository(levelstoragesource$levelstorageaccess);
            if (gametestEnabled) {
                GameTestHooks.registerGametests();
                BlockPos spawnPos = (BlockPos)optionset.valueOf((OptionSpec)spawnPosOpt);
                MinecraftServer.spin(thread -> GameTestServer.create(thread, levelstoragesource$levelstorageaccess, packrepository, GameTestRegistry.getAllTestFunctions(), spawnPos));
                return;
            }
            try {
                WorldLoader.InitConfig worldloader$initconfig = Main.loadOrCreateConfig(dedicatedserversettings.getProperties(), dynamic1, flag, packrepository);
                worldstem = (WorldStem)Util.blockUntilDone(arg_0 -> Main.lambda$main$3(worldloader$initconfig, dynamic1, optionset, (OptionSpec)optionspec2, dedicatedserversettings, (OptionSpec)optionspec3, arg_0)).get();
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                return;
            }
            RegistryAccess.Frozen registryaccess$frozen = worldstem.registries().compositeAccess();
            boolean flag1 = optionset.has((OptionSpec)optionspec6);
            if (optionset.has((OptionSpec)optionspec4) || flag1) {
                Main.forceUpgrade(levelstoragesource$levelstorageaccess, DataFixers.getDataFixer(), optionset.has((OptionSpec)optionspec5), () -> true, (RegistryAccess)registryaccess$frozen, flag1);
            }
            WorldData worlddata = worldstem.worldData();
            levelstoragesource$levelstorageaccess.saveDataTag((RegistryAccess)registryaccess$frozen, worlddata);
            final DedicatedServer dedicatedserver = MinecraftServer.spin(arg_0 -> Main.lambda$main$5(levelstoragesource$levelstorageaccess, packrepository, worldstem, dedicatedserversettings, services, optionset, (OptionSpec)optionspec11, (OptionSpec)optionspec2, (OptionSpec)optionspec12, (OptionSpec)optionspec, (OptionSpec)optionspec15, arg_0));
            Thread thread2 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    dedicatedserver.halt(true);
                    LogManager.shutdown();
                }
            };
            thread2.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook(thread2);
        }
        catch (Exception exception1) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static void writePidFile(Path p_270192_) {
        try {
            long i = ProcessHandle.current().pid();
            Files.writeString(p_270192_, (CharSequence)Long.toString(i), new OpenOption[0]);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    private static WorldLoader.InitConfig loadOrCreateConfig(DedicatedServerProperties p_248563_, @Nullable Dynamic<?> p_307444_, boolean p_249093_, PackRepository p_251069_) {
        WorldDataConfiguration worlddataconfiguration;
        boolean flag;
        if (p_307444_ != null) {
            WorldDataConfiguration worlddataconfiguration1 = LevelStorageSource.readDataConfig(p_307444_);
            flag = false;
            worlddataconfiguration = worlddataconfiguration1;
        } else {
            flag = true;
            worlddataconfiguration = new WorldDataConfiguration(p_248563_.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(p_251069_, worlddataconfiguration, p_249093_, flag);
        return new WorldLoader.InitConfig(worldloader$packconfig, Commands.CommandSelection.DEDICATED, p_248563_.functionPermissionLevel);
    }

    private static void forceUpgrade(LevelStorageSource.LevelStorageAccess p_195489_, DataFixer p_195490_, boolean p_195491_, BooleanSupplier p_195492_, RegistryAccess p_323503_, boolean p_321704_) {
        LOGGER.info("Forcing world upgrade!");
        try (WorldUpgrader worldupgrader = new WorldUpgrader(p_195489_, p_195490_, p_323503_, p_195491_, p_321704_);){
            Component component = null;
            while (!worldupgrader.isFinished()) {
                int i;
                Component component1 = worldupgrader.getStatus();
                if (component != component1) {
                    component = component1;
                    LOGGER.info(worldupgrader.getStatus().getString());
                }
                if ((i = worldupgrader.getTotalChunks()) > 0) {
                    int j = worldupgrader.getConverted() + worldupgrader.getSkipped();
                    LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.floor((float)((float)j / (float)i * 100.0f)), j, i});
                }
                if (!p_195492_.getAsBoolean()) {
                    worldupgrader.cancel();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static /* synthetic */ DedicatedServer lambda$main$5(LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess, PackRepository packrepository, WorldStem worldstem, DedicatedServerSettings dedicatedserversettings, Services services, OptionSet optionset, OptionSpec optionspec11, OptionSpec optionspec2, OptionSpec optionspec12, OptionSpec optionspec, OptionSpec optionspec15, Thread p_293760_) {
        boolean flag2;
        DedicatedServer dedicatedserver1 = new DedicatedServer(p_293760_, levelstoragesource$levelstorageaccess, packrepository, worldstem, dedicatedserversettings, DataFixers.getDataFixer(), services, LoggerChunkProgressListener::createFromGameruleRadius);
        dedicatedserver1.setPort((Integer)optionset.valueOf(optionspec11));
        dedicatedserver1.setDemo(optionset.has(optionspec2));
        dedicatedserver1.setId((String)optionset.valueOf(optionspec12));
        boolean bl = flag2 = !optionset.has(optionspec) && !optionset.valuesOf(optionspec15).contains("nogui");
        if (flag2 && !GraphicsEnvironment.isHeadless()) {
            dedicatedserver1.showGui();
        }
        return dedicatedserver1;
    }

    private static /* synthetic */ CompletableFuture lambda$main$3(WorldLoader.InitConfig worldloader$initconfig, Dynamic dynamic1, OptionSet optionset, OptionSpec optionspec2, DedicatedServerSettings dedicatedserversettings, OptionSpec optionspec3, Executor p_372648_) {
        return WorldLoader.load(worldloader$initconfig, p_359487_ -> {
            WorldDimensions worlddimensions;
            WorldOptions worldoptions;
            LevelSettings levelsettings;
            Registry registry = p_359487_.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM);
            if (dynamic1 != null) {
                LevelDataAndDimensions leveldataanddimensions = LevelStorageSource.getLevelDataAndDimensions(dynamic1, p_359487_.dataConfiguration(), registry, p_359487_.datapackWorldgen());
                return new WorldLoader.DataLoadOutput<WorldData>(leveldataanddimensions.worldData(), leveldataanddimensions.dimensions().dimensionsRegistryAccess());
            }
            LOGGER.info("No existing world data, creating new world");
            if (optionset.has(optionspec2)) {
                levelsettings = MinecraftServer.DEMO_SETTINGS;
                worldoptions = WorldOptions.DEMO_OPTIONS;
                worlddimensions = WorldPresets.createNormalWorldDimensions((HolderLookup.Provider)p_359487_.datapackWorldgen());
            } else {
                DedicatedServerProperties dedicatedserverproperties = dedicatedserversettings.getProperties();
                levelsettings = new LevelSettings(dedicatedserverproperties.levelName, dedicatedserverproperties.gamemode, dedicatedserverproperties.hardcore, dedicatedserverproperties.difficulty, false, new GameRules(p_359487_.dataConfiguration().enabledFeatures()), p_359487_.dataConfiguration());
                worldoptions = optionset.has(optionspec3) ? dedicatedserverproperties.worldOptions.withBonusChest(true) : dedicatedserverproperties.worldOptions;
                worlddimensions = dedicatedserverproperties.createDimensions(p_359487_.datapackWorldgen());
            }
            RegistryOps registryOps = RegistryOps.create(NbtOps.INSTANCE, p_359487_.datapackWorldgen());
            worlddimensions = WorldDimensions.CODEC.encoder().encodeStart(registryOps, (Object)worlddimensions).flatMap(writtenPayloadWithModdedDimensions -> WorldDimensions.CODEC.decoder().parse((DynamicOps)registryOps, writtenPayloadWithModdedDimensions)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(worlddimensions);
            WorldDimensions.Complete worlddimensions$complete = worlddimensions.bake(registry);
            Lifecycle lifecycle = worlddimensions$complete.lifecycle().add(p_359487_.datapackWorldgen().allRegistriesLifecycle());
            return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData(levelsettings, worldoptions, worlddimensions$complete.specialWorldProperty(), lifecycle), worlddimensions$complete.dimensionsRegistryAccess());
        }, WorldStem::new, (Executor)Util.backgroundExecutor(), p_372648_);
    }
}

