/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.world.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;

public class Cat
extends TamableAnimal
implements VariantHolder<Holder<CatVariant>> {
    public static final double TEMPT_SPEED_MOD = 0.6;
    public static final double WALK_SPEED_MOD = 0.8;
    public static final double SPRINT_SPEED_MOD = 1.33;
    private static final EntityDataAccessor<Holder<CatVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Cat.class, EntityDataSerializers.CAT_VARIANT);
    private static final EntityDataAccessor<Boolean> IS_LYING = SynchedEntityData.defineId(Cat.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RELAX_STATE_ONE = SynchedEntityData.defineId(Cat.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(Cat.class, EntityDataSerializers.INT);
    private static final ResourceKey<CatVariant> DEFAULT_VARIANT = CatVariant.BLACK;
    @Nullable
    private CatAvoidEntityGoal<Player> avoidPlayersGoal;
    @Nullable
    private TemptGoal temptGoal;
    private float lieDownAmount;
    private float lieDownAmountO;
    private float lieDownAmountTail;
    private float lieDownAmountOTail;
    private boolean isLyingOnTopOfSleepingPlayer;
    private float relaxStateOneAmount;
    private float relaxStateOneAmountO;

    public Cat(EntityType<? extends Cat> p_28114_, Level p_28115_) {
        super((EntityType<? extends TamableAnimal>)p_28114_, p_28115_);
        this.reassessTameGoals();
    }

    protected void registerGoals() {
        this.temptGoal = new CatTemptGoal(this, 0.6, p_335255_ -> p_335255_.is(ItemTags.CAT_FOOD), true);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)((Object)this)));
        this.goalSelector.addGoal(1, (Goal)new TamableAnimal.TamableAnimalPanicGoal(1.5));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new CatRelaxOnOwnerGoal(this));
        this.goalSelector.addGoal(4, (Goal)this.temptGoal);
        this.goalSelector.addGoal(5, (Goal)new CatLieOnBedGoal(this, 1.1, 8));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f));
        this.goalSelector.addGoal(7, (Goal)new CatSitOnBlockGoal(this, 0.8));
        this.goalSelector.addGoal(8, (Goal)new LeapAtTargetGoal((Mob)((Object)this), 0.3f));
        this.goalSelector.addGoal(9, (Goal)new OcelotAttackGoal((Mob)((Object)this)));
        this.goalSelector.addGoal(10, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
        this.goalSelector.addGoal(12, (Goal)new LookAtPlayerGoal((Mob)((Object)this), Player.class, 10.0f));
        this.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Rabbit.class, false, null));
        this.targetSelector.addGoal(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
    }

    public Holder<CatVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<CatVariant> p_335581_) {
        this.entityData.set(DATA_VARIANT_ID, p_335581_);
    }

    public void setLying(boolean p_28182_) {
        this.entityData.set(IS_LYING, p_28182_);
    }

    public boolean isLying() {
        return this.entityData.get(IS_LYING);
    }

    void setRelaxStateOne(boolean p_28186_) {
        this.entityData.set(RELAX_STATE_ONE, p_28186_);
    }

    boolean isRelaxStateOne() {
        return this.entityData.get(RELAX_STATE_ONE);
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    private void setCollarColor(DyeColor p_28132_) {
        this.entityData.set(DATA_COLLAR_COLOR, p_28132_.getId());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_325925_) {
        super.defineSynchedData(p_325925_);
        p_325925_.define(DATA_VARIANT_ID, BuiltInRegistries.CAT_VARIANT.getOrThrow(DEFAULT_VARIANT));
        p_325925_.define(IS_LYING, false);
        p_325925_.define(RELAX_STATE_ONE, false);
        p_325925_.define(DATA_COLLAR_COLOR, DyeColor.RED.getId());
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_28156_) {
        super.addAdditionalSaveData(p_28156_);
        p_28156_.putString("variant", this.getVariant().unwrapKey().orElse(DEFAULT_VARIANT).location().toString());
        p_28156_.putByte("CollarColor", (byte)this.getCollarColor().getId());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_28142_) {
        super.readAdditionalSaveData(p_28142_);
        Optional.ofNullable(ResourceLocation.tryParse(p_28142_.getString("variant"))).map(p_335254_ -> ResourceKey.create(Registries.CAT_VARIANT, p_335254_)).flatMap(arg_0 -> BuiltInRegistries.CAT_VARIANT.get(arg_0)).ifPresent(this::setVariant);
        if (p_28142_.contains("CollarColor", 99)) {
            this.setCollarColor(DyeColor.byId(p_28142_.getInt("CollarColor")));
        }
    }

    @Override
    public void customServerAiStep(ServerLevel p_376290_) {
        if (this.getMoveControl().hasWanted()) {
            double d0 = this.getMoveControl().getSpeedModifier();
            if (d0 == 0.6) {
                this.setPose(Pose.CROUCHING);
                this.setSprinting(false);
            } else if (d0 == 1.33) {
                this.setPose(Pose.STANDING);
                this.setSprinting(true);
            } else {
                this.setPose(Pose.STANDING);
                this.setSprinting(false);
            }
        } else {
            this.setPose(Pose.STANDING);
            this.setSprinting(false);
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.isTame()) {
            if (this.isInLove()) {
                return SoundEvents.CAT_PURR;
            }
            return this.random.nextInt(4) == 0 ? SoundEvents.CAT_PURREOW : SoundEvents.CAT_AMBIENT;
        }
        return SoundEvents.CAT_STRAY_AMBIENT;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 120;
    }

    public void hiss() {
        this.makeSound(SoundEvents.CAT_HISS);
    }

    protected SoundEvent getHurtSound(DamageSource p_28160_) {
        return SoundEvents.CAT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CAT_DEATH;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.3f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    @Override
    protected void playEatingSound() {
        this.playSound(SoundEvents.CAT_EAT, 1.0f, 1.0f);
    }

    public void tick() {
        super.tick();
        if (this.temptGoal != null && this.temptGoal.isRunning() && !this.isTame() && this.tickCount % 100 == 0) {
            this.playSound(SoundEvents.CAT_BEG_FOR_FOOD, 1.0f, 1.0f);
        }
        this.handleLieDown();
    }

    private void handleLieDown() {
        if ((this.isLying() || this.isRelaxStateOne()) && this.tickCount % 5 == 0) {
            this.playSound(SoundEvents.CAT_PURR, 0.6f + 0.4f * (this.random.nextFloat() - this.random.nextFloat()), 1.0f);
        }
        this.updateLieDownAmount();
        this.updateRelaxStateOneAmount();
        this.isLyingOnTopOfSleepingPlayer = false;
        if (this.isLying()) {
            BlockPos blockpos = this.blockPosition();
            for (Player player : this.level().getEntitiesOfClass(Player.class, new AABB(blockpos).inflate(2.0, 2.0, 2.0))) {
                if (!player.isSleeping()) continue;
                this.isLyingOnTopOfSleepingPlayer = true;
                break;
            }
        }
    }

    public boolean isLyingOnTopOfSleepingPlayer() {
        return this.isLyingOnTopOfSleepingPlayer;
    }

    private void updateLieDownAmount() {
        this.lieDownAmountO = this.lieDownAmount;
        this.lieDownAmountOTail = this.lieDownAmountTail;
        if (this.isLying()) {
            this.lieDownAmount = Math.min(1.0f, this.lieDownAmount + 0.15f);
            this.lieDownAmountTail = Math.min(1.0f, this.lieDownAmountTail + 0.08f);
        } else {
            this.lieDownAmount = Math.max(0.0f, this.lieDownAmount - 0.22f);
            this.lieDownAmountTail = Math.max(0.0f, this.lieDownAmountTail - 0.13f);
        }
    }

    private void updateRelaxStateOneAmount() {
        this.relaxStateOneAmountO = this.relaxStateOneAmount;
        this.relaxStateOneAmount = this.isRelaxStateOne() ? Math.min(1.0f, this.relaxStateOneAmount + 0.1f) : Math.max(0.0f, this.relaxStateOneAmount - 0.13f);
    }

    public float getLieDownAmount(float p_28184_) {
        return Mth.lerp((float)p_28184_, (float)this.lieDownAmountO, (float)this.lieDownAmount);
    }

    public float getLieDownAmountTail(float p_28188_) {
        return Mth.lerp((float)p_28188_, (float)this.lieDownAmountOTail, (float)this.lieDownAmountTail);
    }

    public float getRelaxStateOneAmount(float p_28117_) {
        return Mth.lerp((float)p_28117_, (float)this.relaxStateOneAmountO, (float)this.relaxStateOneAmount);
    }

    @Nullable
    public Cat getBreedOffspring(ServerLevel p_148870_, AgeableMob p_148871_) {
        Cat cat = EntityType.CAT.create(p_148870_, EntitySpawnReason.BREEDING);
        if (cat != null && p_148871_ instanceof Cat) {
            Cat cat1 = (Cat)p_148871_;
            if (this.random.nextBoolean()) {
                cat.setVariant((Holder<CatVariant>)this.getVariant());
            } else {
                cat.setVariant((Holder<CatVariant>)cat1.getVariant());
            }
            if (this.isTame()) {
                cat.setOwnerUUID(this.getOwnerUUID());
                cat.setTame(true, true);
                if (this.random.nextBoolean()) {
                    cat.setCollarColor(this.getCollarColor());
                } else {
                    cat.setCollarColor(cat1.getCollarColor());
                }
            }
        }
        return cat;
    }

    @Override
    public boolean canMate(Animal p_28127_) {
        boolean bl;
        if (!this.isTame()) {
            return false;
        }
        if (!(p_28127_ instanceof Cat)) {
            bl = false;
        } else {
            Cat cat = (Cat)p_28127_;
            bl = cat.isTame() && super.canMate(p_28127_);
        }
        return bl;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_28134_, DifficultyInstance p_28135_, EntitySpawnReason p_362361_, @Nullable SpawnGroupData p_28137_) {
        p_28137_ = super.finalizeSpawn(p_28134_, p_28135_, p_362361_, p_28137_);
        boolean flag = p_28134_.getMoonBrightness() > 0.9f;
        TagKey tagkey = flag ? CatVariantTags.FULL_MOON_SPAWNS : CatVariantTags.DEFAULT_SPAWNS;
        BuiltInRegistries.CAT_VARIANT.getRandomElementOf((TagKey<CatVariant>)tagkey, p_28134_.getRandom()).ifPresent(this::setVariant);
        ServerLevel serverlevel = p_28134_.getLevel();
        if (serverlevel.structureManager().getStructureWithPieceAt(this.blockPosition(), StructureTags.CATS_SPAWN_AS_BLACK).isValid()) {
            this.setVariant(BuiltInRegistries.CAT_VARIANT.getOrThrow(CatVariant.ALL_BLACK));
            this.setPersistenceRequired();
        }
        return p_28137_;
    }

    @Override
    public InteractionResult mobInteract(Player p_28153_, InteractionHand p_28154_) {
        InteractionResult interactionresult1;
        ItemStack itemstack = p_28153_.getItemInHand(p_28154_);
        Item item = itemstack.getItem();
        if (this.isTame()) {
            if (this.isOwnedBy(p_28153_)) {
                InteractionResult interactionresult;
                if (item instanceof DyeItem) {
                    DyeItem dyeitem = (DyeItem)item;
                    DyeColor dyecolor = dyeitem.getDyeColor();
                    if (dyecolor != this.getCollarColor()) {
                        if (!this.level().isClientSide()) {
                            this.setCollarColor(dyecolor);
                            itemstack.consume(1, p_28153_);
                            this.setPersistenceRequired();
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    if (!this.level().isClientSide()) {
                        FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                        this.heal(foodproperties != null ? (float)foodproperties.nutrition() : 1.0f);
                        this.usePlayerItem(p_28153_, p_28154_, itemstack);
                        this.playEatingSound();
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!(interactionresult = super.mobInteract(p_28153_, p_28154_)).consumesAction()) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (this.isFood(itemstack)) {
            if (!this.level().isClientSide()) {
                this.usePlayerItem(p_28153_, p_28154_, itemstack);
                this.tryToTame(p_28153_);
                this.setPersistenceRequired();
                this.playEatingSound();
            }
            return InteractionResult.SUCCESS;
        }
        if ((interactionresult1 = super.mobInteract(p_28153_, p_28154_)).consumesAction()) {
            this.setPersistenceRequired();
        }
        return interactionresult1;
    }

    @Override
    public boolean isFood(ItemStack p_28177_) {
        return p_28177_.is(ItemTags.CAT_FOOD);
    }

    @Override
    public boolean removeWhenFarAway(double p_28174_) {
        return !this.isTame() && this.tickCount > 2400;
    }

    @Override
    public void setTame(boolean p_325911_, boolean p_326459_) {
        super.setTame(p_325911_, p_326459_);
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new CatAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.goalSelector.removeGoal(this.avoidPlayersGoal);
        if (!this.isTame()) {
            this.goalSelector.addGoal(4, this.avoidPlayersGoal);
        }
    }

    private void tryToTame(Player p_333858_) {
        if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)p_333858_)) {
            this.tame(p_333858_);
            this.setOrderedToSit(true);
            this.level().broadcastEntityEvent((Entity)((Object)this), (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)((Object)this), (byte)6);
        }
    }

    public boolean isSteppingCarefully() {
        return this.isCrouching() || super.isSteppingCarefully();
    }

    static class CatTemptGoal
    extends TemptGoal {
        @Nullable
        private Player selectedPlayer;
        private final Cat cat;

        public CatTemptGoal(Cat p_28219_, double p_28220_, Predicate<ItemStack> p_335450_, boolean p_28222_) {
            super((PathfinderMob)p_28219_, p_28220_, p_335450_, p_28222_);
            this.cat = p_28219_;
        }

        public void tick() {
            super.tick();
            if (this.selectedPlayer == null && this.mob.getRandom().nextInt(this.adjustedTickDelay(600)) == 0) {
                this.selectedPlayer = this.player;
            } else if (this.mob.getRandom().nextInt(this.adjustedTickDelay(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean canScare() {
            return this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.player) ? false : super.canScare();
        }

        public boolean canUse() {
            return super.canUse() && !this.cat.isTame();
        }
    }

    static class CatRelaxOnOwnerGoal
    extends Goal {
        private final Cat cat;
        @Nullable
        private Player ownerPlayer;
        @Nullable
        private BlockPos goalPos;
        private int onBedTicks;

        public CatRelaxOnOwnerGoal(Cat p_28203_) {
            this.cat = p_28203_;
        }

        public boolean canUse() {
            if (!this.cat.isTame()) {
                return false;
            }
            if (this.cat.isOrderedToSit()) {
                return false;
            }
            LivingEntity livingentity = this.cat.getOwner();
            if (livingentity instanceof Player) {
                this.ownerPlayer = (Player)livingentity;
                if (!livingentity.isSleeping()) {
                    return false;
                }
                if (this.cat.distanceToSqr(this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.ownerPlayer.blockPosition();
                BlockState blockstate = this.cat.level().getBlockState(blockpos);
                if (blockstate.is(BlockTags.BEDS)) {
                    this.goalPos = blockstate.getOptionalValue((Property)BedBlock.FACING).map(p_28209_ -> blockpos.relative(p_28209_.getOpposite())).orElseGet(() -> new BlockPos((Vec3i)blockpos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            for (Cat cat : this.cat.level().getEntitiesOfClass(Cat.class, new AABB(this.goalPos).inflate(2.0))) {
                if (cat == this.cat || !cat.isLying() && !cat.isRelaxStateOne()) continue;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.cat.isTame() && !this.cat.isOrderedToSit() && this.ownerPlayer != null && this.ownerPlayer.isSleeping() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void start() {
            if (this.goalPos != null) {
                this.cat.setInSittingPose(false);
                this.cat.getNavigation().moveTo(this.goalPos.getX(), this.goalPos.getY(), this.goalPos.getZ(), 1.1f);
            }
        }

        public void stop() {
            this.cat.setLying(false);
            float f = this.cat.level().getTimeOfDay(1.0f);
            if (this.ownerPlayer.getSleepTimer() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.cat.level().getRandom().nextFloat() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.cat.setRelaxStateOne(false);
            this.cat.getNavigation().stop();
        }

        private void giveMorningGift() {
            RandomSource randomsource = this.cat.getRandom();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockpos$mutableblockpos.set((Vec3i)(this.cat.isLeashed() ? this.cat.getLeashHolder().blockPosition() : this.cat.blockPosition()));
            this.cat.randomTeleport(blockpos$mutableblockpos.getX() + randomsource.nextInt(11) - 5, blockpos$mutableblockpos.getY() + randomsource.nextInt(5) - 2, blockpos$mutableblockpos.getZ() + randomsource.nextInt(11) - 5, false);
            blockpos$mutableblockpos.set((Vec3i)this.cat.blockPosition());
            this.cat.dropFromGiftLootTable(CatRelaxOnOwnerGoal.getServerLevel((Entity)((Object)this.cat)), BuiltInLootTables.CAT_MORNING_GIFT, (p_375797_, p_375798_) -> p_375797_.addFreshEntity(new ItemEntity((Level)p_375797_, (double)blockpos$mutableblockpos.getX() - (double)Mth.sin((float)(this.cat.yBodyRot * ((float)Math.PI / 180))), blockpos$mutableblockpos.getY(), (double)blockpos$mutableblockpos.getZ() + (double)Mth.cos((float)(this.cat.yBodyRot * ((float)Math.PI / 180))), (ItemStack)p_375798_)));
        }

        public void tick() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.cat.setInSittingPose(false);
                this.cat.getNavigation().moveTo(this.goalPos.getX(), this.goalPos.getY(), this.goalPos.getZ(), 1.1f);
                if (this.cat.distanceToSqr(this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.adjustedTickDelay(16)) {
                        this.cat.setLying(true);
                        this.cat.setRelaxStateOne(false);
                    } else {
                        this.cat.lookAt(this.ownerPlayer, 45.0f, 45.0f);
                        this.cat.setRelaxStateOne(true);
                    }
                } else {
                    this.cat.setLying(false);
                }
            }
        }
    }

    static class CatAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Cat cat;

        public CatAvoidEntityGoal(Cat p_28191_, Class<T> p_28192_, float p_28193_, double p_28194_, double p_28195_) {
            super((PathfinderMob)p_28191_, p_28192_, p_28193_, p_28194_, p_28195_, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test);
            this.cat = p_28191_;
        }

        public boolean canUse() {
            return !this.cat.isTame() && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.cat.isTame() && super.canContinueToUse();
        }
    }
}

